/*
 * Decompiled with CFR 0.152.
 */
package inferno.io;

import inferno.io.InfernoOIS;
import inferno.io.InfernoOOS;
import inferno.sim.Engine;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class SnapshotWriter
implements Serializable {
    static final long serialVersionUID = 1L;
    private String d_filename;

    public SnapshotWriter(String filename) throws FileNotFoundException {
        this.d_filename = filename;
        try {
            Path path = Paths.get(filename, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getLocalizedMessage());
        }
    }

    public String getFilename() {
        return this.d_filename;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_filename = InfernoOIS.adjustOutputPath(in, this.d_filename);
    }

    public void write(Engine engine) throws IOException {
        try (RandomAccessFile ras = new RandomAccessFile(this.d_filename, "rw");
             BufferedOutputStream bas = new BufferedOutputStream(Channels.newOutputStream(ras.getChannel()));){
            FileChannel channel = ras.getChannel();
            channel.position(channel.size());
            long begin = channel.position();
            DataOutputStream dos = new DataOutputStream(bas);
            dos.writeLong(-1L);
            dos.writeDouble(Double.NaN);
            dos.flush();
            long dataBegin = channel.position();
            InfernoOOS oos = new InfernoOOS(bas);
            oos.writeSnapshot(engine);
            oos.flush();
            long end = channel.position();
            channel.position(begin);
            dos.writeLong(end - dataBegin);
            dos.writeDouble(engine.t());
            dos.flush();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }
}

