/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Plane3d
implements Serializable {
    static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Plane3d() {
    }

    public Plane3d(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Plane3d(Vector3d normal, Point3d pointOnPlane) {
        this.set(normal, pointOnPlane);
    }

    public Plane3d(Point3d p0, Point3d p1, Point3d p2) {
        this.set(p0, p1, p2);
    }

    public void set(Point3d p0, Point3d p1, Point3d p2) {
        Vector3d v1 = new Vector3d();
        v1.sub(p1, p0);
        Vector3d v2 = new Vector3d();
        v2.sub(p2, p0);
        Vector3d normal = new Vector3d();
        normal.cross(v1, v2);
        normal.normalize();
        this.x = normal.x;
        this.y = normal.y;
        this.z = normal.z;
        this.w = Plane3d.calcD(normal, p0);
    }

    public void set(Vector3d normal, Point3d pointOnPlane) {
        this.x = normal.x;
        this.y = normal.y;
        this.z = normal.z;
        this.w = Plane3d.calcD(normal, pointOnPlane);
    }

    public Vector3d getNormal() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public static double calcD(Vector3d normal, Point3d pointOnPlane) {
        return -normal.x * pointOnPlane.x - normal.y * pointOnPlane.y - normal.z * pointOnPlane.z;
    }

    public double distance(Point3d p) {
        double m = Math.abs(this.x * p.x + this.y * p.y + this.z * p.z + this.w);
        double n = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return m / n;
    }

    public Point3d project(Point3d p) {
        Point3d result = new Point3d();
        this.project(result, p);
        return result;
    }

    public void project(Point3d result, Point3d p) {
        double dot = this.dot(p);
        result.set(p.x - this.x * dot, p.y - this.y * dot, p.z - this.z * dot);
    }

    public double dot(Point3d p) {
        return this.x * p.x + this.y * p.y + this.z * p.z + this.w;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public double distanceLInf(Plane3d p) {
        double max = Math.abs(this.x - p.x);
        max = Math.max(max, Math.abs(this.y - p.y));
        max = Math.max(max, Math.abs(this.z - p.z));
        max = Math.max(max, Math.abs(this.w - p.w));
        return max;
    }

    public boolean epsilonEquals(Plane3d p, double tol) {
        return this.distanceLInf(p) <= tol;
    }
}

