/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.geom.Inter;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Inter2D {
    public static Point3d lineLine(Point3d a1, Point3d a2, Point3d b1, Point3d b2) {
        double ula = Inter.det(a1.x, a1.y, a2.x, a2.y);
        double ulb = Inter.det(b1.x, b1.y, b2.x, b2.y);
        double urax = a1.x - a2.x;
        double urbx = b1.x - b2.x;
        double uray = a1.y - a2.y;
        double urby = b1.y - b2.y;
        double upperx = Inter.det(ula, urax, ulb, urbx);
        double uppery = Inter.det(ula, uray, ulb, urby);
        double lower = Inter.det(a1.x - a2.x, a1.y - a2.y, b1.x - b2.x, b1.y - b2.y);
        if (lower == 0.0) {
            return null;
        }
        double x = upperx / lower;
        double y = uppery / lower;
        return new Point3d(x, y, 0.0);
    }

    public static boolean ptTri(Point3d pt, Point3d a, Point3d b, Point3d c) {
        return Inter2D.pointInPoly(pt, new Point3d[]{a, b, c});
    }

    private static boolean pointInPoly(Point3d pt, Point3d[] poly) {
        boolean c = false;
        int i = 0;
        int j = poly.length - 1;
        while (i < poly.length) {
            if ((poly[i].y <= pt.y && pt.y < poly[j].y || poly[j].y <= pt.y && pt.y < poly[i].y) && pt.x < (poly[j].x - poly[i].x) * (pt.y - poly[i].y) / (poly[j].y - poly[i].y) + poly[i].x) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public static Point3d segSeg(Point3d a1, Point3d a2, Point3d b1, Point3d b2) {
        boolean onB;
        Point3d pt = Inter2D.lineLine(a1, a2, b1, b2);
        if (pt == null) {
            return null;
        }
        double TOL = 1.0E-10;
        double minxa = Math.min(a1.x, a2.x);
        double minya = Math.min(a1.y, a2.y);
        double maxxa = Math.max(a1.x, a2.x);
        double maxya = Math.max(a1.y, a2.y);
        double minxb = Math.min(b1.x, b2.x);
        double minyb = Math.min(b1.y, b2.y);
        double maxxb = Math.max(b1.x, b2.x);
        double maxyb = Math.max(b1.y, b2.y);
        boolean onA = minxa - pt.x < 1.0E-10 && pt.x - maxxa < 1.0E-10 && minya - pt.y < 1.0E-10 && pt.y - maxya < 1.0E-10;
        boolean bl = onB = minxb - pt.x < 1.0E-10 && pt.x - maxxb < 1.0E-10 && minyb - pt.y < 1.0E-10 && pt.y - maxyb < 1.0E-10;
        if (onA && onB) {
            return pt;
        }
        return null;
    }

    public static Point3d closestPointOnLine(Point3d point, Point3d l1, Point3d l2) {
        Vector3d dir = new Vector3d();
        dir.sub(l2, l1);
        dir.normalize();
        return Inter2D.closestPointOnLine(point, l1, dir);
    }

    public static Point3d closestPointOnLine(Point3d point, Point3d pOnLine, Vector3d lineDirNorm) {
        Vector3d pvec = new Vector3d();
        pvec.sub(point, pOnLine);
        Vector3d dir = new Vector3d(lineDirNorm);
        double dot = dir.dot(pvec);
        dir.scale(dot);
        Point3d p = new Point3d();
        p.add(pOnLine, dir);
        return p;
    }
}

