/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.ANode;
import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.geom.IValueField;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathFilters;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;

public class DistanceField
implements Serializable,
IValueField<Double> {
    private Map<Integer, Double> d_values;

    public DistanceField(Mesh m, ANode n, WingedEdge goal) {
        assert (n != null);
        if (n == null) {
            return;
        }
        System.out.printf("creating distance field for n=%s -> goal=%s%n", n.name, goal.data.node.name);
        this.d_values = new HashMap<Integer, Double>();
        Predicate<PathChange> pathFilter = PathFilters.filterTriangles(true, TriFilters.filterNodes(Filters.accept(n)));
        long avgA = 0L;
        long avgB = 0L;
        int nverts = 0;
        for (Tri t : n.getMesh()) {
            for (Vertex v : t.v) {
                if (this.d_values.containsKey(v.id)) continue;
                if (v == goal.base.n1 || v == goal.base.n2) {
                    this.d_values.put(v.id, 0.0);
                }
                long nanos = System.nanoTime();
                PathGen.EdgeGoal pathGoal = new PathGen.EdgeGoal(goal);
                PathGen.IAStarResult astar = PathGen.getPathAStarDetailed(m, t, null, v, v.p, pathGoal, 0.0, Double.MAX_VALUE, pathFilter);
                long tA = System.nanoTime() - nanos;
                long tB = 0L;
                if (astar instanceof PathGen.AStarFailure) {
                    this.d_values.put(v.id, Double.POSITIVE_INFINITY);
                } else {
                    nanos = System.nanoTime();
                    PathGen.AStarSuccess astarSuccess = (PathGen.AStarSuccess)astar;
                    ArrayList<TriEdge> pathEdges = PathGen.getPathEdgePoints(astarSuccess.node);
                    List<TriPoint> pts = PathGen.stringPullSlidingEndPoints(m, pathEdges, pathGoal, astarSuccess.goalReached, 0.0, Double.MAX_VALUE);
                    assert (pts != null && !pts.isEmpty());
                    this.d_values.put(v.id, PathGen.getPathLength(pts));
                    tB = System.nanoTime() - nanos;
                }
                avgA += tA;
                avgB += tB;
                ++nverts;
            }
        }
        System.out.printf("done TIME(%.2f ms) VERTS(%d) AVG(%.2f us) AVG-A(%.2f us) AVG-B(%.2f us)%n", (double)(avgA + avgB) / 1000000.0, nverts, (double)((avgA + avgB) / (long)nverts) / 1000.0, (double)(avgA / (long)nverts) / 1000.0, (double)(avgB / (long)nverts) / 1000.0);
    }

    @Override
    public Double getValue(TriPoint tp) {
        Vertex[] v = tp.tri.v;
        return Util3D.interpolateTriValues(v[0].p, v[1].p, v[2].p, this.d_values.get(v[0].id), this.d_values.get(v[1].id), this.d_values.get(v[2].id), tp.p);
    }
}

