/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IWaitUntilSrc;
import inferno.data2.ai.WaitGoalInstance;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;

public class WaitUntilGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private static final long s_delaySeed = 11242279853998L;
    public final IWaitUntilSrc waitSrc;

    public WaitUntilGoal(IWaitUntilSrc waitSrc) {
        this.waitSrc = waitSrc;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitUntilGoal && ((WaitUntilGoal)obj).waitSrc.equals(this.waitSrc);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.waitSrc.hashCode();
        return hash;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        double simTime = kb.getCurrentSimTime();
        double waitUntilTime = this.waitSrc.getWaitTime(simTime, WaitUntilGoal.genRandomSeed(agent, simTime));
        return new WaitGoalInstance(this, waitUntilTime);
    }

    private static long genRandomSeed(OccAgent oa, double currTime) {
        return oa.getOcc().rseed ^ 0xA398C18DFAEL ^ (long)currTime;
    }
}

