/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ANode;
import inferno.data2.QServicePoint;
import inferno.data2.QSubUnit;
import inferno.data2.TriPoint;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathGen;
import inferno.sim.steering.IPathPlanner;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.RegroupPlanner;
import inferno.sim.steering.Shortest;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ISeekCalc;
import inferno.sim.steering.inverse.Seek;
import inferno.sim.steering.inverse.Wander;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SubUnitGoal
implements ISeekGoal,
Serializable {
    public final QSubUnit subSrc;
    private boolean useShortestPlanner = false;

    public SubUnitGoal(QSubUnit subSrc) {
        this.subSrc = subSrc;
    }

    public boolean equals(Object obj) {
        return false;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this, agent);
    }

    public static class Instance
    implements ISeekGoalInstance {
        private SubUnitGoal subUnitGoal;
        private boolean idling = false;
        TriPoint storedDest = null;
        private transient IProgressNote d_progress;

        public Instance(SubUnitGoal subUnitGoal, OccAgent occ) {
            this.subUnitGoal = subUnitGoal;
            subUnitGoal.subSrc.AddUnprocessedOccupant(occ);
        }

        @Override
        public ISeekGoal getGoal() {
            return this.subUnitGoal;
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            TriPoint thisDest = this.subUnitGoal.subSrc.GetOccupantTriPoint(occ);
            if (thisDest == null) {
                return false;
            }
            if (this.storedDest != thisDest) {
                this.storedDest = thisDest;
                return true;
            }
            double dist = occ.getLoc().p.distanceSquared(this.subUnitGoal.subSrc.GetOccupantTriPoint((OccAgent)occ).p);
            this.subUnitGoal.subSrc.UpdateOccDist(occ, dist);
            if (dist < 0.04000000000000001 && !kb.getMesh().isPathObstructed(occ.getLoc(), this.subUnitGoal.subSrc.GetOccupantTriPoint(occ), 0.0, EdgeFilters.acceptAll())) {
                this.subUnitGoal.subSrc.RemoveOccupantPending(occ);
                occ.d_belongsToSubUnit = true;
                if (this.subUnitGoal.subSrc.TryIncrementOccTriPoint(occ)) {
                    if (this.idling) {
                        this.idling = false;
                        return true;
                    }
                    return true;
                }
                if (this.idling) {
                    return false;
                }
                this.idling = true;
                return true;
            }
            if (this.idling) {
                this.idling = false;
                return true;
            }
            return false;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            IPathPlanner pathPlanner;
            TriPoint tp = this.subUnitGoal.subSrc.GetOccupantTriPoint(occ);
            if (this.idling) {
                QServicePoint sp = this.subUnitGoal.subSrc.TryGetOccService(occ);
                if (sp != null) {
                    sp.ArriveOccupant();
                }
                return SteerUtil.newIdleSteer(kb, occ, () -> new Wander(), () -> new ITpSource.ConstTpSource(occ.getLoc()));
            }
            if (tp == null) {
                return SteerUtil.newIdleSteer(kb, occ, () -> new Wander(), () -> new ITpSource.ConstTpSource(occ.getLoc()));
            }
            if (this.subUnitGoal.useShortestPlanner) {
                PathGen.PointGoal pg = new PathGen.PointGoal(new ITpSource.ConstTpSource(tp));
                pathPlanner = new Shortest(pg);
            } else {
                pathPlanner = new LocallyQuickest(occ, new LocalTimeEstimate.QueueSizes(), new PointTarget(new ITpSource.ConstTpSource(tp)));
            }
            return SteerUtil.newSeekSteer(kb, occ, pathPlanner);
        }

        @Override
        public void end(KB kb, OccAgent occ) {
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (this.subUnitGoal.subSrc.GetOccupantReady(occ)) {
                occ.d_belongsToSubUnit = false;
                return true;
            }
            return false;
        }

        @Override
        public ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
            PathGen.PointGoal pg = new PathGen.PointGoal(this.getSeekPoint(kb, occ));
            Shortest planner = new Shortest(Arrays.asList(pg));
            if (occ.getOcc().occupantGroup != null) {
                RegroupPlanner regroupPlanner = RegroupPlanner.createRegroupPlanner(occ, kb, planner);
                return new Seek(kb, occ, regroupPlanner, 0.2);
            }
            return new Seek(kb, occ, planner, 0.2);
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            this.d_progress = GoalUtil.getSeekProgress(kb, occ, this.d_progress);
            return this.d_progress;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public boolean contains(KB kb, OccAgent occ, TriPoint p) {
            TriPoint tp = this.subUnitGoal.subSrc.GetOccupantTriPoint(occ);
            return p.p.distanceSquared(tp.p) <= 0.04000000000000001;
        }

        @Override
        public TriPoint getSeekPoint(KB kb, OccAgent occ) {
            return this.subUnitGoal.subSrc.GetOccupantTriPoint(occ);
        }

        @Override
        public boolean isUrgent(KB kb, OccAgent occ) {
            return false;
        }

        @Override
        public Collection<ANode> getDestinationRooms() {
            return Collections.emptySet();
        }

        @Override
        public boolean shouldFillRoomOnDetach(KB kb, OccAgent agent) {
            return false;
        }
    }
}

