/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.WingedEdge;
import inferno.data2.ai.IProgressNote;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.util.function.Function;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.util.Pair;

public class SeekProgressNote
implements IProgressNote {
    private final WingedEdge d_nextDoorInPath;
    private final boolean d_makingProgress;
    private final double d_minDistToGoal;

    public SeekProgressNote(KB kb, OccAgent src, WingedEdge nextDoorInPath, double distToGoal, IProgressNote prevProgress) {
        this.d_nextDoorInPath = nextDoorInPath;
        Pair<Boolean, Double> progress = SeekProgressNote.isMakingProgress(kb, src, prevProgress, nextDoorInPath, distToGoal);
        this.d_makingProgress = (Boolean)progress.v1;
        this.d_minDistToGoal = (Double)progress.v2;
    }

    private static Pair<Boolean, Double> isMakingProgress(KB kb, OccAgent agent, IProgressNote prevProgress, WingedEdge currDoor, double currGoalDist) {
        double openTime;
        if (!(prevProgress instanceof SeekProgressNote)) {
            return new Pair<Boolean, Double>(true, currGoalDist);
        }
        SeekProgressNote prevSeek = (SeekProgressNote)prevProgress;
        if (currDoor != prevSeek.d_nextDoorInPath) {
            return new Pair<Boolean, Double>(true, currGoalDist);
        }
        if (currGoalDist < prevSeek.d_minDistToGoal) {
            return new Pair<Boolean, Double>(true, currGoalDist);
        }
        currGoalDist = prevSeek.d_minDistToGoal;
        Function<Double, Pair> getProgressCloseToDoor = goalDist -> {
            double distToDoor = Math.sqrt(Inter3D.distSqToNearestPtOnLineSeg(wingedEdge.base.n1.p, wingedEdge.base.n2.p, agent.getPos()));
            return distToDoor < agent.getGeometryRadius() * 2.0 ? new Pair<Boolean, Double>(true, (Double)goalDist) : new Pair<Boolean, Double>(false, (Double)goalDist);
        };
        if (currDoor != null && currDoor.data.node.isClosed(kb, agent) && !Double.isInfinite(openTime = currDoor.data.node.getNextOpenTime(kb, agent))) {
            if (currDoor.isTransportDoor() && agent.getOcc().curNode.isTransportNode()) {
                return new Pair<Boolean, Double>(true, currGoalDist);
            }
            return getProgressCloseToDoor.apply(currGoalDist);
        }
        if (currDoor != null && currDoor.getDoorQueue().isQueueable(kb, null) && currDoor.getDoorQueue().contains(agent)) {
            return getProgressCloseToDoor.apply(currGoalDist);
        }
        return new Pair<Boolean, Double>(false, currGoalDist);
    }

    @Override
    public boolean isMakingProgress(KB kb, Object src, IProgressNote prevProgress) {
        return this.d_makingProgress;
    }
}

