/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.AssistOccupantsGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.inverse.PassiveModeSteering;
import java.io.Serializable;

public class PassiveModeGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    private OccAgent activeAgent;

    public PassiveModeGoal(OccAgent activeAgent, KB kb) {
        this.activeAgent = activeAgent;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new PassiveModeGoalInstance(this, new PassiveModeSteering(this.activeAgent), this.activeAgent, kb);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public static class PassiveModeGoalInstance
    implements IIdleGoalInstance {
        static final long serialVersionUID = 1L;
        private final PassiveModeGoal goal;
        private PassiveModeSteering passiveModeSteering;
        private final OccAgent activeAgent;
        private final AssistedEvacClientAgent clientAgent;

        public PassiveModeGoalInstance(PassiveModeGoal goal, PassiveModeSteering passiveModeSteering, OccAgent activeAgent, KB kb) {
            this.goal = goal;
            this.passiveModeSteering = passiveModeSteering;
            this.activeAgent = activeAgent;
            this.clientAgent = activeAgent.getAssistedEvacClientModule().get();
        }

        @Override
        public IIdleGoal getGoal() {
            return this.goal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            return this.passiveModeSteering;
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            return true;
        }

        @Override
        public void end(KB kb, OccAgent occ) {
            occ.getOcc().isPassive = false;
            occ.getOcc().formationLeader = null;
            this.clientAgent.detachAgent(occ);
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            if (!this.clientAgent.isAttached(occ)) {
                return true;
            }
            IGoalInstance ginst = occ.getCurrentGoalInstance(kb);
            if (ginst instanceof AssistOccupantsGoal.Instance) {
                return ((AssistOccupantsGoal.Instance)ginst).shouldDetach(this.activeAgent);
            }
            assert (false);
            return true;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public void preMove(KB kb, OccAgent agent, double dt) {
            this.passiveModeSteering.preMove(kb, agent, dt);
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }
    }
}

