/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.jscience.physics.units.SI;
import thunderheadeng.util.stat.ICurve;

public interface IWaitUntilSrc {
    public static final String SIMPLETYPE = "IWaitUntilSrc.SIMPLE";
    public static final String CYCLESRCTYPE = "IWaitUntilSrc.CYCLE";
    public static final String LISTSRCTYPE = "IWaitUntilSrc.LIST";

    public String getType();

    public double getWaitTime(double var1, long var3);

    public static class ListedWaitUntilSrc
    implements IWaitUntilSrc,
    Serializable {
        static final long serialVersionUID = 1L;
        public final List<ICurve> d_goTimes;
        private transient double[] d_maxTimes;

        public ListedWaitUntilSrc(List<ICurve> goTimes) {
            this.d_goTimes = Collections.unmodifiableList(goTimes);
        }

        private synchronized double[] getMaxTimes() {
            if (this.d_maxTimes != null) {
                return this.d_maxTimes;
            }
            double[] times = new double[this.d_goTimes.size()];
            for (int m = 0; m < this.d_goTimes.size(); ++m) {
                times[m] = this.d_goTimes.get(m).getMax().get(SI.SECOND);
            }
            this.d_maxTimes = times;
            return this.d_maxTimes;
        }

        @Override
        public double getWaitTime(double simTime, long delaySeed) {
            double[] asTimes = this.getMaxTimes();
            int ix = Arrays.binarySearch(asTimes, simTime);
            if (ix < 0) {
                ix = -ix - 1;
            }
            if (ix >= this.d_goTimes.size()) {
                ix = this.d_goTimes.size() - 1;
            }
            ICurve currentCurve = this.d_goTimes.get(ix);
            Random r = new Random(delaySeed);
            return currentCurve.getValue(r).getValue(SI.SECOND);
        }

        @Override
        public String getType() {
            return IWaitUntilSrc.LISTSRCTYPE;
        }
    }

    public static class CycledWaitUntilSrc
    implements IWaitUntilSrc,
    Serializable {
        static final long serialVersionUID = 1L;
        public final ICurve d_initialTime;
        public final ICurve d_intervalTime;

        public CycledWaitUntilSrc(ICurve initTime, ICurve intervalTime) {
            this.d_initialTime = initTime;
            this.d_intervalTime = intervalTime;
        }

        @Override
        public double getWaitTime(double simTime, long delaySeed) {
            Random r = new Random(delaySeed);
            double delay = this.d_initialTime.getValue(r).get(SI.SECOND);
            if (simTime < delay) {
                return delay;
            }
            double interval = this.d_intervalTime.getValue(r).get(SI.SECOND);
            double numIntervals = Math.ceil((simTime - delay) / interval);
            return delay + numIntervals * interval;
        }

        @Override
        public String getType() {
            return IWaitUntilSrc.CYCLESRCTYPE;
        }
    }

    public static class SimpleWaitUntilSrc
    implements IWaitUntilSrc,
    Serializable {
        static final long serialVersionUID = 1059401209432914162L;
        public final ICurve d_waitTime;

        public SimpleWaitUntilSrc(ICurve waitTime) {
            this.d_waitTime = waitTime;
        }

        @Override
        public double getWaitTime(double simTime, long delaySeed) {
            Random r = new Random(delaySeed);
            return this.d_waitTime.getValue(r).get(SI.SECOND);
        }

        @Override
        public String getType() {
            return IWaitUntilSrc.SIMPLETYPE;
        }
    }
}

