/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AiUtil;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.inverse.ISeekCalc;
import java.io.Serializable;

public interface IIdleGoalInstance
extends IGoalInstance,
Serializable {
    public static final long serialVersionUID = 1L;

    @Override
    public IIdleGoal getGoal();

    @Override
    default public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
        return SteerUtil.newIdleSteer(kb, agent, () -> this.getPreviousIdleSeek(kb, agent), () -> {
            ISeekGoalInstance seekGoal = AiUtil.getCurrentSeek(agent);
            return new ITpSource.ConstTpSource(seekGoal.getSeekPoint(kb, agent));
        });
    }

    @Override
    default public void end(KB kb, OccAgent occ) {
    }

    @Override
    default public boolean isSeeking(KB kb, OccAgent agent) {
        return false;
    }

    default public ISeekCalc getPreviousIdleSeek(KB kb, OccAgent occ) {
        IGoalInstance prevGoal = AiUtil.getPreviousGoal(occ, this);
        if (prevGoal == null) {
            prevGoal = AiUtil.getCurrentSeek(occ);
        }
        return prevGoal.getIdleSeek(kb, occ);
    }

    @Override
    default public ISeekCalc getIdleSeek(KB kb, OccAgent occ) {
        return this.getPreviousIdleSeek(kb, occ);
    }

    @Override
    default public IProgressNote getProgress(KB kb, OccAgent occ) {
        return IProgressNote.PROGRESSING;
    }

    public double getEndTime(KB var1);
}

