/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import java.io.Serializable;
import thunderheadeng.util.theUtil;

public class SpeedModifier
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final double CUTOFF_FACTOR = 0.01;
    public static final SpeedModifier IDENTITY = new SpeedModifier(Type.FACTOR, 1.0);
    public final Type type;
    public final double value;

    public SpeedModifier(Type type, double value) {
        this.type = type;
        this.value = value;
    }

    public int hashCode() {
        return 0x523F33FA ^ this.type.hashCode() + theUtil.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SpeedModifier && ((SpeedModifier)obj).type == this.type && ((SpeedModifier)obj).value == this.value;
    }

    public double getAbsoluteSpeed(double occSpeed, boolean walkOnMovingTerrain) {
        return this.getRelativeSpeed(occSpeed, walkOnMovingTerrain) + this.getTerrainSpeed();
    }

    public double getRelativeSpeed(double occSpeed, boolean walkOnMovingTerrain) {
        switch (this.type) {
            case CONSTANT: {
                return walkOnMovingTerrain || this.value == 0.0 ? occSpeed : 0.0;
            }
        }
        return this.value * occSpeed;
    }

    public double getTerrainSpeed() {
        return this.type == Type.CONSTANT ? this.value : 0.0;
    }

    public boolean allowsMovement(boolean walkOnMovingTerrain) {
        if (this.type == Type.CONSTANT) {
            return true;
        }
        return theUtil.gt0(this.value, 0.01);
    }

    public static enum Type {
        CONSTANT,
        FACTOR;

    }
}

