/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.QOccLineQueue;
import inferno.data2.QServicePoint;
import inferno.data2.QSuperUnit;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;

public class QSubUnit
extends QSuperUnit {
    KB d_kb;
    ArrayList<QServicePoint> d_services = new ArrayList();
    Hashtable<OccAgent, QServicePoint> d_occServices = new Hashtable();
    ArrayList<OccAgent> d_serviceOccupants = new ArrayList();
    ArrayList<QOccLineQueue> d_queues = new ArrayList();
    ArrayList<QOccLineQueue> d_lowerQueues = new ArrayList();
    Hashtable<OccAgent, QOccLineQueue> d_occQueuesMap = new Hashtable();
    Hashtable<OccAgent, Stack<TriPoint>> OccDestinations = new Hashtable();
    Hashtable<OccAgent, Boolean> OccReady = new Hashtable();
    Hashtable<OccAgent, Double> OccDistances = new Hashtable();
    CopyOnWriteArrayList<OccAgent> UnprocessedOccupants = new CopyOnWriteArrayList();

    public QSubUnit(QSuperUnit parent, QSuperUnit.QBalancingType bType) {
        super(parent, bType);
    }

    public QSubUnit(KB kb, ArrayList<QServicePoint> services, ArrayList<QOccLineQueue> queues, QSuperUnit parent, QSuperUnit.QBalancingType bType) {
        super(parent, bType);
        this.d_services = services;
        this.d_queues = queues;
        for (QServicePoint service : this.d_services) {
            service.d_parent = this;
        }
        for (QOccLineQueue queue : this.d_queues) {
            queue.d_parent = this;
        }
    }

    public boolean GetOccupantReady(OccAgent occ) {
        return this.OccReady.get(occ);
    }

    public TriPoint GetOccupantTriPoint(OccAgent occ) {
        if (!this.UnprocessedOccupants.contains(occ) && this.OccDestinations.get(occ) != null) {
            return this.OccDestinations.get(occ).peek();
        }
        if (this.d_occQueuesMap.get(occ) != null) {
            return this.d_occQueuesMap.get(occ).GetOccupantTriPoint(occ);
        }
        return null;
    }

    public void RemoveOccupantPending(OccAgent occ) {
        if (this.d_occQueuesMap.get(occ) != null) {
            this.d_occQueuesMap.get(occ).RemoveOccupantPending(occ);
        }
    }

    public QServicePoint TryGetOccService(OccAgent occ) {
        return this.d_occServices.get(occ);
    }

    public boolean TryIncrementOccTriPoint(OccAgent occ) {
        if (this.OccDestinations.get(occ) != null) {
            if (this.OccDestinations.get(occ).size() == 1) {
                return false;
            }
            this.OccDestinations.get(occ).pop();
            return true;
        }
        if (this.d_occQueuesMap.get(occ) != null) {
            return this.d_occQueuesMap.get(occ).TryIncrementOccTriPoint(occ);
        }
        return false;
    }

    @Override
    public void AddUnprocessedOccupant(OccAgent occ) {
        this.UnprocessedOccupants.add(occ);
        this.OccReady.put(occ, false);
    }

    boolean ProcessOccupant(KB kb, OccAgent occ) {
        if (this.d_queues.isEmpty()) {
            return this.TryServiceAccept(occ, null);
        }
        if (this.TryServiceAccept(occ, null)) {
            return true;
        }
        occ = this.PushIntoPendingOccs(occ);
        switch (this.d_balancingType) {
            case SELF_BALANCING: {
                int qIndex = 0;
                int lowest = 999;
                for (int i = 0; i < this.d_queues.size(); ++i) {
                    if (this.d_queues.get((int)i).d_occupants.size() >= lowest) continue;
                    qIndex = i;
                    lowest = this.d_queues.get((int)i).d_occupants.size();
                }
                QOccLineQueue asdf = this.d_queues.get(qIndex);
                asdf.EnqueueOccupant(kb, occ);
                this.d_occQueuesMap.put(occ, asdf);
                this.OccReady.put(occ, false);
                return true;
            }
            case PROBABILITY: {
                break;
            }
        }
        return false;
    }

    private OccAgent PushIntoPendingOccs(OccAgent occ) {
        if (occ == null) {
            return null;
        }
        double closestDist = 999.0;
        OccAgent replacedOcc = null;
        for (OccAgent otherOcc : this.d_serviceOccupants) {
            double distToThatOccsGoal = occ.getLoc().p.distanceSquared(this.d_occServices.get((Object)otherOcc).d_location.p);
            if (!(this.OccDistances.get(otherOcc) > distToThatOccsGoal)) continue;
            replacedOcc = otherOcc;
            closestDist = distToThatOccsGoal;
        }
        if (replacedOcc != null) {
            this.OccDestinations.put(occ, this.OccDestinations.get(replacedOcc));
            this.OccDistances.put(occ, closestDist);
            this.OccReady.put(occ, false);
            this.d_occServices.put(occ, this.d_occServices.get(replacedOcc));
            this.d_serviceOccupants.add(occ);
            this.d_occServices.get((Object)occ).d_curOcc = occ;
            this.OccDestinations.remove(replacedOcc);
            this.OccDistances.remove(replacedOcc);
            this.OccReady.remove(replacedOcc);
            this.d_occServices.remove(replacedOcc);
            this.d_serviceOccupants.remove(replacedOcc);
            return this.PushIntoPendingOccs(replacedOcc);
        }
        return occ;
    }

    public boolean TryServiceAccept(OccAgent occ, QOccLineQueue q) {
        for (QServicePoint service : this.d_services) {
            TriPoint dest;
            if (!service.d_ready || (dest = service.AcceptOccupant(occ)) == null) continue;
            Stack<TriPoint> singleStack = new Stack<TriPoint>();
            singleStack.add(dest);
            this.OccDestinations.put(occ, singleStack);
            this.OccDistances.put(occ, occ.getLoc().p.distanceSquared(this.d_services.get((int)0).d_location.p));
            this.OccReady.put(occ, false);
            this.d_occServices.put(occ, service);
            this.d_serviceOccupants.add(occ);
            this.d_occServices.get((Object)occ).d_curOcc = occ;
            if (this.d_occQueuesMap.containsKey(occ)) {
                this.d_occQueuesMap.remove(occ);
            }
            service.d_ready = false;
            if (q != null) {
                this.d_lowerQueues.add(q);
            }
            return true;
        }
        return false;
    }

    boolean TryDischargeOccupant(OccAgent occ) {
        if (this.d_next != null) {
            return false;
        }
        this.OccReady.put(occ, true);
        this.OccDestinations.remove(occ);
        this.OccDistances.remove(occ);
        this.d_occServices.remove(occ);
        this.d_serviceOccupants.remove(occ);
        return true;
    }

    public void update(KB kb, double dt) {
        while (!this.UnprocessedOccupants.isEmpty()) {
            OccAgent occ = this.UnprocessedOccupants.get(this.UnprocessedOccupants.size() - 1);
            this.ProcessOccupant(kb, occ);
            this.UnprocessedOccupants.remove(occ);
        }
        for (QServicePoint sp : this.d_services) {
            sp.update(kb, dt);
        }
        for (QOccLineQueue olq : this.d_queues) {
            olq.update(kb);
        }
        for (QOccLineQueue olq : this.d_lowerQueues) {
            this.d_queues.remove(olq);
            this.d_queues.add(olq);
        }
        this.d_lowerQueues.clear();
    }

    public void UpdateOccDist(OccAgent occ, double dist) {
        this.OccDistances.put(occ, dist);
    }
}

