/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.QSubUnit;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;

public class QServicePoint
implements Serializable {
    public OccAgent d_curOcc;
    public TriPoint d_location;
    QSubUnit d_parent;
    public boolean d_ready = true;
    boolean d_serviceWaiting = false;
    double d_waitTime = 5.0;
    double d_timer = 0.0;

    public QServicePoint(TriPoint loc) {
        this.d_location = loc;
        this.d_ready = true;
    }

    void DischargeOccupant() {
        if (this.d_parent.TryDischargeOccupant(this.d_curOcc)) {
            this.d_timer = 0.0;
            this.d_serviceWaiting = false;
            this.d_ready = true;
        }
    }

    public void ArriveOccupant() {
        this.d_serviceWaiting = true;
    }

    TriPoint AcceptOccupant(OccAgent occ) {
        return this.d_location;
    }

    public void update(KB kb, double dt) {
        if (this.d_serviceWaiting) {
            if (this.d_timer < this.d_waitTime) {
                this.d_timer += dt;
            } else {
                this.DischargeOccupant();
            }
        }
    }
}

