/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.GenPointResult;
import inferno.data2.QSubUnit;
import inferno.data2.TriPoint;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class QOccLineQueue
implements Serializable {
    QSubUnit d_parent;
    LinkedList<OccAgent> d_occupants = new LinkedList();
    Hashtable<OccAgent, LinkedList<TriPoint>> d_occupantPaths = new Hashtable();
    private LinkedList<TriPoint> d_occPoints = new LinkedList();
    private Hashtable<Point3d, Integer> d_occPointsAs = new Hashtable();
    private ArrayList<TriPoint> d_queuePoints = new ArrayList();
    public TriPoint d_queueHead;
    Hashtable<OccAgent, Double> d_occDistances = new Hashtable();
    LinkedList<OccAgent> d_pendingOccupants = new LinkedList();
    private float d_occDistance;
    private boolean d_followPath = false;
    private boolean d_occLimit = false;
    private int d_maxOccupants = 0;

    public ArrayList<TriPoint> getPoints() {
        return this.d_queuePoints;
    }

    public void SetFollowPath(boolean follow) {
        this.d_followPath = follow;
    }

    public QOccLineQueue(KB kb, ArrayList<Point3d> p) {
        for (Point3d point : p) {
            this.d_queuePoints.add(new TriPoint(kb.getMesh().getTri(point), point));
        }
        this.d_queueHead = this.d_queuePoints.get(0);
    }

    public LinkedList<TriPoint> GeneratePath(KB kb) {
        LinkedList<TriPoint> triPoints;
        if (this.d_occPoints.isEmpty()) {
            this.d_occPoints.add(this.d_queueHead);
            this.d_occPointsAs.put(this.d_queueHead.p, 0);
            TriPoint generatedPoint = this.d_queueHead;
            triPoints = this.CreatePathFromHead(generatedPoint, 0);
        } else {
            GenPointResult result = this.GeneratePoint(kb);
            TriPoint generatedPoint = result.point;
            this.d_occPoints.add(generatedPoint);
            this.d_occPointsAs.put(generatedPoint.p, result.forePoint);
            triPoints = this.CreatePathFromHead(generatedPoint, result.forePoint);
        }
        return triPoints;
    }

    private LinkedList<TriPoint> CreatePathFromHead(TriPoint generatedPoint, int forePoint) {
        LinkedList<TriPoint> triPoints = new LinkedList<TriPoint>();
        triPoints.add(generatedPoint);
        if (this.d_followPath) {
            for (int i = forePoint + 1; i < this.d_queuePoints.size(); ++i) {
                triPoints.push(this.d_queuePoints.get(i));
            }
        }
        return triPoints;
    }

    private void UpdatePath(OccAgent occ) {
        if (!this.d_followPath || this.d_pendingOccupants.indexOf(occ) != -1) {
            LinkedList<TriPoint> newPath = this.CreatePathFromHead(this.d_occPoints.get(this.d_occupants.indexOf(occ)), this.d_occPointsAs.get(this.d_occPoints.get((int)this.d_occupants.indexOf((Object)occ)).p));
            this.d_occupantPaths.put(occ, newPath);
        } else {
            LinkedList<TriPoint> oldPath = this.d_occupantPaths.get(occ);
            oldPath.removeFirst();
            oldPath.addFirst(this.d_occPoints.get(this.d_occupants.indexOf(occ)));
            this.d_occupantPaths.put(occ, oldPath);
        }
    }

    private GenPointResult GeneratePoint(KB kb) {
        if (this.d_occPoints.getLast().p == this.d_queuePoints.get((int)(this.d_queuePoints.size() - 1)).p) {
            return new GenPointResult(this.d_queuePoints.get(this.d_queuePoints.size() - 1), this.d_queuePoints.size() - 1);
        }
        int AIndex = this.d_occPointsAs.get(this.d_occPoints.getLast().p);
        Point3d pA = this.d_occPoints.getLast().p;
        Point3d pB = this.d_queuePoints.get((int)(AIndex + 1)).p;
        Vector3d v1 = new Vector3d(pB.x - pA.x, pB.y - pA.y, pB.z - pA.z);
        v1.normalize();
        double dist = 0.9;
        Point3d guessPoint = new Point3d(v1.x * dist + pA.x, v1.y * dist + pA.y, v1.z * dist + pA.z);
        double lenZ = pB.distance(this.d_occPoints.getLast().p);
        if (guessPoint.distance(this.d_occPoints.getLast().p) > lenZ) {
            if (this.d_queuePoints.size() > AIndex + 2) {
                Point3d pC = this.d_queuePoints.get((int)(AIndex + 2)).p;
                Vector3d v2 = new Vector3d(pC.x - pB.x, pC.y - pB.y, pC.z - pB.z);
                double angY = v1.angle(v2);
                double lenX = lenZ * Math.cos(angY) + Math.sqrt(Math.pow(dist, 2.0) - Math.pow(lenZ, 2.0) * Math.pow(Math.sin(angY), 2.0));
                v2.normalize();
                Point3d newPoint = new Point3d(v2.x * lenX + pB.x, v2.y * lenX + pB.y, v2.z * lenX + pB.z);
                return new GenPointResult(new TriPoint(kb.getMesh().getTri(newPoint), newPoint), AIndex + 1);
            }
            return new GenPointResult(this.d_queuePoints.get(this.d_queuePoints.size() - 1), this.d_queuePoints.size() - 1);
        }
        if (guessPoint.distance(this.d_occPoints.getLast().p) == lenZ) {
            return new GenPointResult(new TriPoint(kb.getMesh().getTri(guessPoint), guessPoint), AIndex + 1);
        }
        return new GenPointResult(new TriPoint(kb.getMesh().getTri(guessPoint), guessPoint), this.d_occPointsAs.get(this.d_occPoints.getLast().p));
    }

    public LinkedList<TriPoint> EnqueueOccupant(KB kb, OccAgent occ) {
        occ = this.AddToPendingOccupants(occ);
        LinkedList<TriPoint> path = this.GeneratePath(kb);
        this.d_occupantPaths.put(occ, path);
        return path;
    }

    private OccAgent AddToPendingOccupants(OccAgent occ) {
        Point3d targetP = this.d_followPath ? this.d_queuePoints.get((int)(this.d_queuePoints.size() - 1)).p : this.d_queueHead.p;
        this.d_occDistances.put(occ, occ.getLoc().p.distanceSquared(targetP));
        if (!this.d_pendingOccupants.isEmpty()) {
            for (int i = 0; i < this.d_pendingOccupants.size(); ++i) {
                if (!(this.d_occDistances.get(this.d_pendingOccupants.get(i)) > this.d_occDistances.get(occ))) continue;
                this.d_pendingOccupants.add(i + 1, occ);
                this.d_occupants.add(i + 1, occ);
                for (int j = i + 1; j < this.d_pendingOccupants.size() - 1; ++j) {
                    int pIndex = this.d_occPoints.size() + 1 - (this.d_pendingOccupants.size() - j);
                    LinkedList<TriPoint> newPath = this.CreatePathFromHead(this.d_occPoints.get(pIndex), this.d_occPointsAs.get(this.d_occPoints.get((int)pIndex).p));
                    this.d_occupantPaths.put(this.d_pendingOccupants.get(j), newPath);
                }
                return this.d_pendingOccupants.getLast();
            }
        }
        this.d_pendingOccupants.add(occ);
        this.d_occupants.add(occ);
        return occ;
    }

    void DequeueOccupant() {
        OccAgent removedOcc = this.d_occupants.remove();
        if (this.d_pendingOccupants.indexOf(removedOcc) != -1) {
            this.d_pendingOccupants.remove(removedOcc);
        }
        for (OccAgent occ : this.d_occupants) {
            this.UpdatePath(occ);
        }
    }

    public void update(KB kb) {
        if (this.d_occupants.size() > 0 && this.d_parent.TryServiceAccept(this.d_occupants.peek(), this)) {
            this.DequeueOccupant();
        }
    }

    public TriPoint GetOccupantTriPoint(OccAgent occ) {
        return this.d_occupantPaths.get(occ).peek();
    }

    public boolean TryIncrementOccTriPoint(OccAgent occ) {
        if (this.d_occupantPaths.get(occ).size() == 1) {
            return false;
        }
        this.d_occupantPaths.get(occ).removeLast();
        return true;
    }

    public void RemoveOccupantPending(OccAgent occ) {
        if (this.d_pendingOccupants.indexOf(occ) != -1) {
            this.d_pendingOccupants.remove(occ);
        }
    }
}

