/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import common.data.EscalatorPreference;
import inferno.data2.ANode;
import inferno.data2.CylinderShape;
import inferno.data2.DoorDir;
import inferno.data2.IAgentBodyShape;
import inferno.data2.IIdentifiable;
import inferno.data2.OccAnim;
import inferno.data2.OccPriority;
import inferno.data2.SlopeSpeed;
import inferno.data2.Tri;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.data2.value.IFunction1d;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.IFormationLeaderAgent;
import inferno.sim.KnownFuncs;
import inferno.sim.OccGroup;
import inferno.sim.OccProfileSim;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.function.Predicate;
import javax.vecmath.Color3b;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;

public class Occupant
implements Serializable,
IIdentifiable {
    static final long serialVersionUID = 1L;
    public static final Color3b DEF_COLOR = new Color3b(-52, -52, -1);
    public transient Map<String, Serializable> dbgProps = null;
    public int id;
    public long rseed;
    public long orientSeed;
    public String name;
    public String avatar;
    public float boundaryLayer;
    @Steering
    public float mass;
    public float accelFactor;
    public float decelFactor;
    public float radialAccelFactor;
    public Color3b visColor;
    public final TriPoint initLoc;
    public Tri tri;
    public Point3d loc;
    public TriPoint displayLoc;
    public Matrix4d xform;
    public OccAnim anim;
    public float terrainSpeed;
    public BehaviorSim behavior;
    public Deque<BehaviorSim.BehaviorInProgress> behaviorStack;
    public Vector3d vel;
    public Vector3d orient;
    public Vector3d displayOrient;
    public ANode curNode;
    public Pair<DoorQueue, DoorDir> doorQueue;
    public ANode prevNode;
    public boolean waiting;
    private boolean d_finished;
    public boolean removeWhenFinished;
    @Steering
    public float squeezeFactor;
    @Steering
    public float minSqueezeFactor;
    public float nodeSqueezeFactor;
    @Steering
    public float reacTime;
    @Steering
    public float collisionResponseTime;
    @Steering
    public float comfortDist;
    @Steering
    public float socialDist;
    public double priority;
    @Steering
    public float persistTime;
    @Steering
    public float slowFactor;
    public boolean reqAssistedBy;
    public boolean obeyOnewayDoors;
    public EscalatorPreference movingTerrainPref;
    public double localQueueTimeFactor;
    public double localTravelTimeFactor;
    public double tailTimeFactor;
    public double currDoorFactor;
    public double distTravelledFactor;
    public int outputTimeHistory;
    public double tFinished;
    public double tStarted;
    public double totalDistanceMeters;
    public Pair<WingedEdge, DoorDir> targetDoor;
    public IAgentBodyShape bodyShape;
    public float maxVel;
    public IFunction1d fundamental;
    public SlopeSpeed stairSpeed;
    public SlopeSpeed rampSpeed;
    public IFunction1d visReduction;
    public boolean isPassive = false;
    public IFormationLeaderAgent formationLeader = null;
    public OccProfileSim parentProfile;
    public boolean canMove = true;
    public boolean requiresAssistance = false;
    public boolean isGroupLeader = false;
    public OccGroup occupantGroup;
    public OccProfileSim.CompRestrictions compRestrictions;
    public OccProfileSim.DynamicCompRestrictions dynamicCompRestrictions;
    public OccProfileSim.ElevatorWaitTime elevatorWaitTime;

    public Occupant(int id, String name, long seed, long orientSeed, OccProfileSim profile, BehaviorSim goal, Tri initTri, Point3d loc, double currTime) {
        this.id = id;
        this.name = name;
        this.avatar = "";
        this.curNode = null;
        this.prevNode = null;
        this.behavior = goal;
        this.behaviorStack = new ArrayDeque<BehaviorSim.BehaviorInProgress>();
        this.behaviorStack.push(new BehaviorSim.BehaviorInProgress(goal));
        this.parentProfile = profile;
        this.tri = initTri;
        this.loc = new Point3d(loc);
        this.displayLoc = new TriPoint(initTri, new Point3d(loc));
        this.anim = OccAnim.STANDIDLE;
        this.terrainSpeed = 0.0f;
        this.xform = null;
        this.initLoc = new TriPoint(initTri, this.loc);
        this.minSqueezeFactor = 0.6f;
        this.squeezeFactor = 1.0f;
        this.nodeSqueezeFactor = 1.0f;
        this.mass = 67.5f;
        this.maxVel = 1.24f;
        this.stairSpeed = KnownFuncs.SFPE_STAIR_SPEED;
        this.rampSpeed = KnownFuncs.SFPE_RAMP_SPEED;
        this.accelFactor = 0.9090909f;
        this.decelFactor = 2.0f;
        this.radialAccelFactor = 1.5f;
        this.displayOrient = this.orient = new Vector3d(0.0, 1.0, 0.0);
        this.vel = new Vector3d();
        this.bodyShape = new CylinderShape(loc, Util.inchesToMeters(9.0), Util.inchesToMeters(9.0), 1.8288, this.orient, id);
        this.boundaryLayer = 0.15f;
        this.visColor = DEF_COLOR;
        this.waiting = false;
        this.reacTime = 0.0f;
        this.priority = OccPriority.init(0, 0.0);
        this.persistTime = 1.0f;
        this.collisionResponseTime = 1.5f;
        this.comfortDist = (float)Util.feetToMeters(1.0);
        this.socialDist = Float.NaN;
        this.slowFactor = 0.1f;
        this.reqAssistedBy = false;
        this.obeyOnewayDoors = true;
        this.movingTerrainPref = EscalatorPreference.STAND_ANYWHERE;
        this.targetDoor = null;
        this.fundamental = KnownFuncs.SFPE_FUNDAMENTAL_DIAGRAM;
        this.localQueueTimeFactor = 1.0;
        this.localTravelTimeFactor = 1.0;
        this.tailTimeFactor = 1.0;
        this.currDoorFactor = 0.65;
        this.distTravelledFactor = Math.log(2.0) / 35.0;
        this.outputTimeHistory = 0;
        this.tFinished = Double.NaN;
        this.tStarted = currTime;
        this.totalDistanceMeters = 0.0;
        this.removeWhenFinished = true;
        this.elevatorWaitTime = new OccProfileSim.ElevatorWaitTime(0.0);
        this.rseed = seed;
        this.orientSeed = orientSeed;
        this.d_finished = false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String toString() {
        String wait = this.waiting ? ":waiting" : "";
        return "[Occupant" + wait + "] " + this.name + " " + this.loc;
    }

    public AABox getBoundingBox(boolean collision) {
        return this.getBoundingBox(this.loc, collision);
    }

    public AABox getBoundingBox(Point3d loc, boolean collision) {
        IAgentBodyShape shape = this.bodyShape;
        shape = collision ? shape.adjust(loc, this.getCollisionFactor()) : shape.moveTo(loc);
        return shape.getAABox3D();
    }

    public double getCollisionFactor() {
        return this.squeezeFactor * this.nodeSqueezeFactor;
    }

    public double getCollisionFactor(double squeezeFactor) {
        return squeezeFactor * (double)this.nodeSqueezeFactor;
    }

    public void finish(double t) {
        assert (this.curNode == null);
        this.d_finished = true;
        this.tFinished = t;
    }

    public void finishNoExit() {
        this.d_finished = true;
        assert (Double.isNaN(this.tFinished));
    }

    public boolean isDone() {
        return this.d_finished;
    }

    public Point3d getDisplayLoc() {
        return this.xform != null ? Util3D.xform(this.xform, this.displayLoc.p) : this.displayLoc.p;
    }

    public long getSeed(IPropertySet.Prop<?> prop) {
        return prop == OccProfileSim.PROP_INIT_ORIENT ? this.orientSeed : this.rseed;
    }

    public Predicate<WingedEdge> getRestrictedDoorsFilter() {
        OccProfileSim.CompRestrictions componentRestrictions;
        Predicate<WingedEdge> filter = Filters.acceptAll();
        OccProfileSim.CompRestrictions compRestrictions = componentRestrictions = this.occupantGroup != null ? this.occupantGroup.componentRestrictions : this.compRestrictions;
        if (componentRestrictions != null) {
            filter = componentRestrictions.getRestrictedDoorsFilter();
        }
        if (this.dynamicCompRestrictions != null) {
            filter = Predicates.and(filter, this.dynamicCompRestrictions.getRestrictedDoorsFilter());
        }
        return filter;
    }

    static @interface SFPE {
    }

    static @interface Steering {
    }
}

