/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.Edge;
import inferno.data2.EdgeData;
import inferno.data2.Mesh;
import inferno.data2.Tri;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.geom.Util;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Global;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.theUtil;

public class MeshBuilder {
    private final List<Vertex> d_verts;
    private final Map<MEdge, EdgeData> d_edgeData = new LinkedHashMap<MEdge, EdgeData>();
    private final Map<MEdge, Edge> d_edges = new HashMap<MEdge, Edge>();
    private final SortedMap<MTri, TriInfo> d_triInfo = new TreeMap<MTri, TriInfo>();
    private List<Tri> d_tris;
    private final Map<WEdgeKey, WingedEdge> d_wingedEdges = new LinkedHashMap<WEdgeKey, WingedEdge>();
    private final Map<Integer, List<Tri>> d_vertTriAdj = new LinkedHashMap<Integer, List<Tri>>();
    private final Map<MEdge, List<Tri>> d_edgeTriAdj = new LinkedHashMap<MEdge, List<Tri>>();
    private final EdgeData d_internalED = new EdgeData(null, 0);
    private final EdgeData d_boundaryED = new EdgeData(null, 4);
    private transient MTri[] t_orderedMTris = null;
    private static final double PI2 = Math.PI * 2;

    private static int compare(Point3d p1, Point3d p2) {
        int comp = Double.compare(p1.x, p2.x);
        if (comp != 0) {
            return comp;
        }
        comp = Double.compare(p1.y, p2.y);
        if (comp != 0) {
            return comp;
        }
        return Double.compare(p1.z, p2.z);
    }

    private static int compare(int i1, int i2, List<Vertex> verts) {
        return MeshBuilder.compare(verts.get((int)i1).p, verts.get((int)i2).p);
    }

    public MeshBuilder(List<Point3d> points) {
        this.d_verts = new ArrayList<Vertex>(points.size());
        for (Point3d p : points) {
            this.d_verts.add(new Vertex(this.d_verts.size(), p));
        }
    }

    public MEdge addBoundaryEdge(int i1, int i2) {
        return this.addSpecialEdge(this.d_boundaryED, i1, i2);
    }

    public MEdge addDoorEdge(ANode doorNode, int i1, int i2) {
        EdgeData data = new EdgeData(doorNode, 1);
        return this.addSpecialEdge(data, i1, i2);
    }

    public MEdge addExitDoorEdge(ANode doorNode, int i1, int i2) {
        EdgeData data = new EdgeData(doorNode, 3);
        return this.addSpecialEdge(data, i1, i2);
    }

    private MEdge addSpecialEdge(EdgeData data, int i1, int i2) {
        if (i1 < 0 || i1 >= this.d_verts.size() || i2 < 0 || i2 >= this.d_verts.size() || i1 == i2) {
            return null;
        }
        MEdge me = new MEdge(this.d_verts, i1, i2);
        this.d_edgeData.put(me, data);
        return me;
    }

    public EdgeData getEdgeData(MEdge medge) {
        return this.d_edgeData.get(medge);
    }

    public MTri addTri(ANode node, Tri.Terrain terrain, int i1, int i2, int i3) {
        if (node == null || !this.checkRange(i1, i2, i3) || i1 == i2 || i1 == i3 || i2 == i3) {
            return null;
        }
        MTri t = new MTri(this.d_verts, i1, i2, i3);
        if (this.d_triInfo.containsKey(t)) {
            return null;
        }
        TriInfo ti = new TriInfo(node, terrain);
        this.d_triInfo.put(t, ti);
        return t;
    }

    public int indexOf(MTri mt) {
        SortedMap<MTri, TriInfo> trisBefore = this.d_triInfo.headMap(mt);
        return trisBefore.size();
    }

    private boolean checkRange(int ... ixes) {
        for (int ix : ixes) {
            if (ix >= 0 && ix < this.d_verts.size()) continue;
            return false;
        }
        return true;
    }

    public List<Vertex> getVerts() {
        return this.d_verts;
    }

    public Mesh finish(List<Error> errors, IUnitSrc lenUnit) {
        this.validateEdgeData(errors, lenUnit);
        this.buildTris();
        this.buildEdges();
        this.buildAdjacencyMaps();
        this.setAdjacency();
        this.validateEdgeAdjacency(errors, lenUnit);
        return new Mesh(this.d_wingedEdges.values(), this.d_tris);
    }

    private void validateEdgeAdjacency(List<Error> errors, IUnitSrc lenUnit) {
        for (MEdge me : this.d_edgeTriAdj.keySet()) {
            List<Tri> adjTris = this.d_edgeTriAdj.get(me);
            if (adjTris.size() <= 2) continue;
            String msg = String.format(Intl.intl("Edge is adjacent to more than 2 triangles.\nLocation: %s - %s"), MeshBuilder.formatPoint3d(this.d_verts.get((int)me.i1).p, "0.0#", lenUnit), MeshBuilder.formatPoint3d(this.d_verts.get((int)me.i2).p, "0.0#", lenUnit));
            String fix = Intl.intl("Check for overlapping doors/stairways and stairway clearance.");
            errors.add(new Error(ErrorLevel.MODERATE, msg, fix, me));
        }
    }

    public List<MTri> getAdjTris(MEdge edge) {
        if (this.t_orderedMTris == null) {
            this.t_orderedMTris = this.d_triInfo.keySet().toArray(new MTri[this.d_triInfo.size()]);
        }
        List<Tri> tris = this.d_edgeTriAdj.get(edge);
        ArrayList<MTri> adjTris = new ArrayList<MTri>(tris.size());
        for (Tri tri : tris) {
            adjTris.add(this.t_orderedMTris[tri.id]);
        }
        return adjTris;
    }

    private void buildTris() {
        this.d_tris = new ArrayList<Tri>(this.d_triInfo.size());
        for (Map.Entry<MTri, TriInfo> entry : this.d_triInfo.entrySet()) {
            MTri mtri = entry.getKey();
            TriInfo ti = entry.getValue();
            Vertex v1 = this.d_verts.get(mtri.v[0]);
            Vertex v2 = this.d_verts.get(mtri.v[1]);
            Vertex v3 = this.d_verts.get(mtri.v[2]);
            Tri tri = new Tri(this.d_tris.size(), ti.node, ti.terrain, v1, v2, v3);
            this.d_tris.add(tri);
        }
    }

    private void buildEdges() {
        for (MTri t : this.d_triInfo.keySet()) {
            for (int m = 0; m < 3; ++m) {
                int ia = t.v[m];
                int ib = t.v[(m + 1) % 3];
                MEdge edge = new MEdge(this.d_verts, ia, ib);
                this.d_edges.put(edge, new Edge(this.d_verts.get(edge.i1), this.d_verts.get(edge.i2)));
            }
        }
    }

    private void buildAdjacencyMaps() {
        this.buildVertTriAdjMap();
        this.buildEdgeTriAdjMap();
    }

    private void buildVertTriAdjMap() {
        for (int m = 0; m < this.d_verts.size(); ++m) {
            this.d_vertTriAdj.put(m, new ArrayList());
        }
        int triix = 0;
        for (MTri tri : this.d_triInfo.keySet()) {
            for (int m = 0; m < 3; ++m) {
                int ix = tri.v[m];
                List<Tri> adjTris = this.d_vertTriAdj.get(ix);
                adjTris.add(this.d_tris.get(triix));
            }
            ++triix;
        }
    }

    private void buildEdgeTriAdjMap() {
        int triix = 0;
        for (MTri mtri : this.d_triInfo.keySet()) {
            Tri tri = this.d_tris.get(triix);
            for (int m = 0; m < 3; ++m) {
                MEdge me = new MEdge(this.d_verts, mtri.v[m], mtri.v[(m + 1) % 3]);
                List<Tri> adjTris = this.d_edgeTriAdj.get(me);
                if (adjTris == null) {
                    adjTris = new ArrayList<Tri>(2);
                    this.d_edgeTriAdj.put(me, adjTris);
                }
                adjTris.add(tri);
            }
            ++triix;
        }
    }

    private WingedEdge getWingedEdge(Tri tri, int i1, int i2) {
        WingedEdge flap;
        WEdgeKey key;
        WingedEdge existing;
        MEdge medge = new MEdge(this.d_verts, i1, i2);
        Edge edge = this.d_edges.get(medge);
        Vertex v1 = this.d_verts.get(i1);
        Vertex v2 = this.d_verts.get(i2);
        EdgeData data = this.d_edgeData.get(medge);
        Tri adjTri = this.findAdjacentTri(tri, medge, v1, v2);
        if (adjTri == null) {
            if (data == null || data.type == 1 || data.type == 0) {
                data = this.d_boundaryED;
            }
        } else if (data == null) {
            data = this.d_internalED;
        }
        if (v1 != edge.n1) {
            Tri temp = tri;
            tri = adjTri;
            adjTri = temp;
        }
        if ((existing = this.d_wingedEdges.get(key = new WEdgeKey(flap = new WingedEdge(this.d_wingedEdges.size(), data, edge, tri, adjTri)))) == null) {
            this.d_wingedEdges.put(key, flap);
            existing = flap;
        }
        return existing;
    }

    private Tri findAdjacentTri(Tri tri, MEdge medge, Vertex v1, Vertex v2) {
        Vector3d edir = Util3D.vectorN(v1.p, v2.p);
        Vector3d tangent = this.getTangent(tri, edir);
        double zAngle = MeshBuilder.getZAngle(tri, edir, edir);
        Tri closestTri = null;
        double closestAngle = Double.MAX_VALUE;
        Vector3d closestEdgeDir = null;
        List<Tri> adjTris = this.d_edgeTriAdj.get(medge);
        for (Tri adjTri : adjTris) {
            if (adjTri == tri) continue;
            Vertex[] adjEdge = this.findAdjEdge(v1, v2, adjTri);
            assert (adjEdge != null);
            Vector3d edir2 = Util3D.vectorN(adjEdge[0].p, adjEdge[1].p);
            Vector3d tan2 = this.getTangent(adjTri, edir2);
            double angle = Util3D.angle0To2PI(tangent, tan2, edir);
            if (!(angle < closestAngle)) continue;
            closestAngle = angle;
            closestTri = adjTri;
            closestEdgeDir = edir2;
        }
        if (closestTri == null) {
            return null;
        }
        double zAngle2 = MeshBuilder.getZAngle(closestTri, edir, closestEdgeDir);
        if (!MeshBuilder.areAdjacentTris(zAngle, zAngle2)) {
            return null;
        }
        return closestTri;
    }

    private static double getZAngle(Tri tri, Vector3d baseEDir, Vector3d edir) {
        if (theUtil.eq0(tri.normal.z, 1.0E-9) || theUtil.eq0(edir.x, 1.0E-9) && theUtil.eq0(edir.y, 1.0E-9)) {
            return 0.0;
        }
        Vector3d tangent = new Vector3d(-edir.y, edir.x, 0.0);
        Util.projectAlongZ(tangent, tri.plane, tangent, false);
        if (theUtil.eq0(tangent.dot(tangent), 1.0E-9)) {
            return 0.0;
        }
        Vector3d axis = new Vector3d(baseEDir.x, baseEDir.y, 0.0);
        return Util3D.angle0To2PI(GeomConstants.VEC3D_ZPOS, tangent, axis);
    }

    private static boolean areAdjacentTris(double zAngle1, double zAngle2) {
        return theUtil.eq0(zAngle1, 1.0E-9) || theUtil.eq0(zAngle2, 1.0E-9) || theUtil.eq(zAngle1, Math.PI * 2, 1.0E-9) || theUtil.eq(zAngle2, Math.PI * 2, 1.0E-9) || theUtil.eq(zAngle1, Math.PI, 1.0E-9) || theUtil.eq(zAngle2, Math.PI, 1.0E-9) || zAngle1 < Math.PI && zAngle2 > Math.PI || zAngle1 > Math.PI && zAngle2 < Math.PI;
    }

    private Vertex[] findAdjEdge(Vertex v1, Vertex v2, Tri tri) {
        if (tri.v[0] == v1 && tri.v[1] == v2 || tri.v[0] == v2 && tri.v[1] == v1) {
            return new Vertex[]{tri.v[0], tri.v[1]};
        }
        if (tri.v[1] == v1 && tri.v[2] == v2 || tri.v[1] == v2 && tri.v[2] == v1) {
            return new Vertex[]{tri.v[1], tri.v[2]};
        }
        if (tri.v[2] == v1 && tri.v[0] == v2 || tri.v[2] == v2 && tri.v[0] == v1) {
            return new Vertex[]{tri.v[2], tri.v[0]};
        }
        return null;
    }

    private Vector3d getTangent(Tri tri, Vector3d edir) {
        return Util3D.cross(tri.normal, edir);
    }

    private void setAdjacency() {
        this.setVertAdjacency();
        this.setTriAdjacency();
        this.setNodeDoorAdj();
    }

    private void setVertAdjacency() {
        for (Map.Entry<Integer, List<Tri>> entry : this.d_vertTriAdj.entrySet()) {
            List<Tri> adjTris = entry.getValue();
            Vertex v = this.d_verts.get(entry.getKey());
            v.setAdjacency(adjTris.toArray(new Tri[adjTris.size()]));
        }
    }

    private void validateEdgeData(List<Error> errors, IUnitSrc lenUnit) {
        LinkedIdentityHashMap<ANode, ArrayList<MEdge>> doorEdges = new LinkedIdentityHashMap<ANode, ArrayList<MEdge>>();
        for (Map.Entry<MEdge, EdgeData> entry : this.d_edgeData.entrySet()) {
            EdgeData ed = entry.getValue();
            MEdge edge = entry.getKey();
            if (ed.type != 1 && ed.type != 3) continue;
            ArrayList<MEdge> edges = (ArrayList<MEdge>)doorEdges.get(ed.node);
            if (edges == null) {
                edges = new ArrayList<MEdge>(1);
                doorEdges.put(ed.node, edges);
            }
            edges.add(edge);
        }
        for (Map.Entry<MEdge, EdgeData> entry : doorEdges.entrySet()) {
            List edges = (List)((Object)entry.getValue());
            if (edges.size() <= 1) continue;
            double totLen = 0.0;
            double longestLen = 0.0;
            MEdge longestEdge = null;
            for (MEdge edge : edges) {
                Vertex v1 = this.d_verts.get(edge.i1);
                Vertex v2 = this.d_verts.get(edge.i2);
                double dist2d = Math.sqrt(MeshBuilder.dist2dSq(v1.p, v2.p));
                totLen += dist2d;
                if (longestEdge != null && !(dist2d > longestLen)) continue;
                longestEdge = edge;
                longestLen = dist2d;
            }
            for (MEdge edge : edges) {
                if (edge == longestEdge) continue;
                this.d_edgeData.put(edge, this.d_boundaryED);
            }
            double lostLen = totLen - longestLen;
            String msg = String.format(Intl.intl("Door, \"%s\", was split into multiple edges."), ((ANode)((Object)entry.getKey())).name);
            String fix = String.format(Intl.intl("Only keeping longest edge for door. Lost length = %s."), MeshBuilder.format(lostLen, SI.METER, lenUnit));
            errors.add(new Error(ErrorLevel.LIGHT, msg, fix, longestEdge));
        }
    }

    private static double dist2dSq(Point3d p1, Point3d p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        return dx * dx + dy * dy;
    }

    private void setTriAdjacency() {
        int triix = 0;
        for (MTri mtri : this.d_triInfo.keySet()) {
            Tri tri = this.d_tris.get(triix);
            WingedEdge flap1 = this.getWingedEdge(tri, mtri.v[0], mtri.v[1]);
            WingedEdge flap2 = this.getWingedEdge(tri, mtri.v[1], mtri.v[2]);
            WingedEdge flap3 = this.getWingedEdge(tri, mtri.v[2], mtri.v[0]);
            tri.setAdjacency(flap1, flap2, flap3);
            ++triix;
        }
    }

    private void setNodeDoorAdj() {
        for (WingedEdge flap : this.d_wingedEdges.values()) {
            EdgeData ed = flap.data;
            if ((ed.type & 1) <= 0) continue;
            ed.node.addDoorEdge(flap);
            for (Tri adjTri : flap.getAdjTris()) {
                if (ed.node != adjTri.node && !ed.node.isAdjacent(adjTri.node)) continue;
                adjTri.node.addDoorEdge(flap);
            }
        }
    }

    private static String formatPoint3d(Point3d pt, String pattern, IUnitSrc lenType) {
        UnitPoint3D cvtPt = MeshBuilder.getUPoint3D(pt, lenType);
        String uStr = cvtPt.getUnit().toString();
        DecimalFormat fmt = new DecimalFormat(pattern);
        return String.format("(%s %s, %s %s, %s %s)", fmt.format(cvtPt.x()), uStr, fmt.format(cvtPt.y()), uStr, fmt.format(cvtPt.z()), uStr);
    }

    private static UnitPoint3D getUPoint3D(Point3d p, IUnitSrc lenType) {
        Unit curlu = lenType.getUnit();
        return UnitPoint3D.convert(p, SI.METER, curlu);
    }

    private static String format(double v, Unit srcUnit, IUnitSrc dstUnit) {
        double v2 = UnitDouble.convert(v, srcUnit, dstUnit.getUnit());
        return Global.format(v2, dstUnit.getUnit());
    }

    public static enum ErrorLevel {
        LIGHT,
        MODERATE,
        CRITICAL;

    }

    public static class Error {
        public ErrorLevel level;
        public final String msg;
        public final String fix;
        public final Collection<? extends MObj> offendingObjs;

        public Error(ErrorLevel level, String msg, String fix, MObj ... offendingObjs) {
            this(level, msg, fix, Arrays.asList(offendingObjs));
        }

        public Error(ErrorLevel level, String msg, String fix, Collection<? extends MObj> offendingObjs) {
            this.level = level;
            this.msg = msg;
            this.fix = fix;
            this.offendingObjs = offendingObjs;
        }
    }

    public static interface MObj {
    }

    private static class WEdgeKey {
        public final WingedEdge wedge;

        public WEdgeKey(WingedEdge wedge) {
            this.wedge = wedge;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WEdgeKey)) {
                return false;
            }
            WEdgeKey edge = (WEdgeKey)obj;
            return this.wedge.base == edge.wedge.base && this.wedge.data.equals(edge.wedge.data) && (this.wedge.t1 == edge.wedge.t1 && this.wedge.t2 == edge.wedge.t2 || this.wedge.t1 == edge.wedge.t2 && this.wedge.t2 == edge.wedge.t1);
        }

        public int hashCode() {
            return this.wedge.base.hashCode() + this.wedge.data.hashCode() + theUtil.hashCode(this.wedge.t1) + theUtil.hashCode(this.wedge.t2);
        }
    }

    public static class MTri
    implements Comparable<MTri>,
    MObj {
        private final List<Vertex> d_verts;
        public final int[] v;

        public MTri(List<Vertex> verts, int i1, int i2, int i3) {
            int min;
            this.d_verts = verts;
            int n = min = MeshBuilder.compare(i1, i2, verts) <= 0 ? i1 : i2;
            if (MeshBuilder.compare(i3, min, verts) < 0) {
                min = i3;
            }
            this.v = min == i1 ? new int[]{i1, i2, i3} : (min == i2 ? new int[]{i2, i3, i1} : new int[]{i3, i1, i2});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MTri tri = (MTri)obj;
            return this.v[0] == tri.v[0] && this.v[1] == tri.v[1] && this.v[2] == tri.v[2];
        }

        public int hashCode() {
            return Arrays.hashCode(this.v);
        }

        @Override
        public int compareTo(MTri o) {
            if (this.equals(o)) {
                return 0;
            }
            int comp = MeshBuilder.compare(this.v[0], o.v[0], this.d_verts);
            if (comp != 0) {
                return comp;
            }
            comp = MeshBuilder.compare(this.v[1], o.v[1], this.d_verts);
            if (comp != 0) {
                return comp;
            }
            return MeshBuilder.compare(this.v[2], o.v[2], this.d_verts);
        }
    }

    public static class MEdge
    implements MObj {
        public final int i1;
        public final int i2;

        public MEdge(List<Vertex> verts, int i1, int i2) {
            int comp = MeshBuilder.compare(i1, i2, verts);
            if (comp < 0) {
                this.i1 = i1;
                this.i2 = i2;
            } else {
                this.i1 = i2;
                this.i2 = i1;
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MEdge edge = (MEdge)obj;
            return this.i1 == edge.i1 && this.i2 == edge.i2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }
    }

    private static class TriInfo {
        public final ANode node;
        public final Tri.Terrain terrain;

        public TriInfo(ANode node, Tri.Terrain terrain) {
            this.node = node;
            this.terrain = terrain;
        }
    }
}

