/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Vertex;
import java.io.Serializable;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Util3D;

public class Edge
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Vertex n1;
    public final Vertex n2;

    public Edge(Vertex n1, Vertex n2) {
        this.n1 = n1;
        this.n2 = n2;
    }

    public Point3d midpoint() {
        return Util3D.getMidPoint(this.n1.p, this.n2.p);
    }

    public Point3d get(double t) {
        return Util3D.linesegPoint(this.n1.p, this.n2.p, t);
    }

    public double get(Point3d p) {
        return Util3D.tOnLineSeg(this.n1.p, this.n2.p, p);
    }

    public double length() {
        return this.n1.p.distance(this.n2.p);
    }

    public String toString() {
        return "EDGE[" + this.n1.p + " -> " + this.n2.p + "]";
    }
}

