/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import java.util.List;

public final class DoorDir
extends Enum<DoorDir> {
    public static final /* enum */ DoorDir POSITIVE = new DoorDir();
    public static final /* enum */ DoorDir NEGATIVE = new DoorDir();
    private static final /* synthetic */ DoorDir[] $VALUES;

    public static DoorDir[] values() {
        return (DoorDir[])$VALUES.clone();
    }

    public static DoorDir valueOf(String name) {
        return Enum.valueOf(DoorDir.class, name);
    }

    public DoorDir opposite() {
        switch (this) {
            case POSITIVE: {
                return NEGATIVE;
            }
            case NEGATIVE: {
                return POSITIVE;
            }
        }
        throw new IllegalArgumentException("Unknown direction.");
    }

    public static DoorDir getExitDir(ANode door) {
        assert (door.isExitDoor());
        assert (door.doorQueue.getR1() == null || door.doorQueue.getR2() == null);
        return door.doorQueue.getR1() == null ? POSITIVE : NEGATIVE;
    }

    public static DoorDir get(ANode door, Tri enterTri) {
        if (door.doorQueue.getR1() != door.doorQueue.getR2()) {
            ANode dstNode;
            ANode aNode = dstNode = enterTri != null ? enterTri.node : null;
            if (dstNode == door.doorQueue.getR1()) {
                return POSITIVE;
            }
            if (dstNode == door.doorQueue.getR2()) {
                return NEGATIVE;
            }
            assert (false);
            return POSITIVE;
        }
        List<WingedEdge> edges = door.getDoorEdges();
        for (WingedEdge we : edges) {
            if (we.t1 == enterTri) {
                return POSITIVE;
            }
            if (we.t2 != enterTri) continue;
            return NEGATIVE;
        }
        assert (false);
        return POSITIVE;
    }

    static {
        $VALUES = new DoorDir[]{POSITIVE, NEGATIVE};
    }
}

