/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.JToolBar;
import results.Intl;
import results.api.Events;
import results.nativebuffered.mv.SceneMode;
import results.nativebuffered.session.Session;
import results.nativebuffered.session.SessionMediator;
import thunderheadeng.geometry.AABox;
import thunderheadeng.gui.Mediator;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.DragFunc;
import thunderheadeng.scene3d.navtools.ISelectionLogic;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.navtools.NavtoolUtil;
import thunderheadeng.scene3d.navtools.OrbitFunc;
import thunderheadeng.scene3d.navtools.RoamFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.ZoomBoxFunc;
import thunderheadeng.scene3d.navtools.ZoomFunc;
import thunderheadeng.util.IBindable;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;

public class MVTools
implements IEventObserver,
IBindable {
    private final Mediator d_mediator;
    private final Session d_session;
    private final Supplier<AABox> d_sceneBounds;
    public final ToolManager mgr;
    public final SelectionFunc selFunc;
    public final CursorTool selectionTool3D;
    public final CursorTool selectionTool2D;
    public final CursorTool compositeViewTool3d;
    public final CursorTool orbitTool;
    public final CursorTool modGameRoamTool;
    public final CursorTool dragTool;
    public final CursorTool zoomTool;
    public final CursorTool zoomBoxTool;
    private guiToolBar d_navToolbar;
    private final Map<SceneMode, ModeInfo> d_modeInfo;
    private final View d_view;

    public MVTools(SessionMediator mediator, Component component, IRenderSurface renderComp, ISelectionLogic selLogic, IToolController controller, Supplier<AABox> sceneBounds) {
        this.d_mediator = mediator;
        this.d_session = mediator.getSession();
        this.d_sceneBounds = sceneBounds;
        this.d_view = new View(renderComp, () -> this.d_session.get(Session.CAMERA));
        this.mgr = new ToolManager(component);
        this.selFunc = new SelectionFunc(controller.getSnapper(), selLogic);
        OrbitFunc orbitFunc = new OrbitFunc();
        DragFunc dragFunc = new DragFunc();
        MultiFunc generalSelFunc3d = new MultiFunc(null, this.selFunc, orbitFunc, dragFunc);
        this.selectionTool3D = new CursorTool(controller, generalSelFunc3d);
        this.mgr.addTool(this.selectionTool3D, Intl.intl("Select/Edit"), Intl.intl("Select/Edit Objects"), guiUtil.loadTeciIcon("pointer16.gif"));
        MultiFunc generalSelFunc2d = new MultiFunc(null, this.selFunc, dragFunc, dragFunc);
        this.selectionTool2D = new CursorTool(controller, generalSelFunc2d);
        this.mgr.addTool(this.selectionTool2D, Intl.intl("Select/Edit"), Intl.intl("Select/Edit Objects"), guiUtil.loadTeciIcon("pointer16.gif"));
        this.orbitTool = new CursorTool(controller, orbitFunc);
        this.mgr.addTool(this.orbitTool, Intl.intl("Rotate"), Intl.intl("Rotate View"), OrbitFunc.ICON);
        this.modGameRoamTool = new CursorTool(controller, new RoamFunc<CursorTool>(this.selFunc));
        this.mgr.addTool(this.modGameRoamTool, Intl.intl("Roam"), Intl.intl("Roam"), RoamFunc.ICON);
        this.dragTool = new CursorTool(controller, dragFunc);
        this.mgr.addTool(this.dragTool, Intl.intl("Drag"), Intl.intl("Pan View"), DragFunc.ICON);
        ZoomFunc zoomFunc = new ZoomFunc();
        this.zoomTool = new CursorTool(controller, zoomFunc);
        this.mgr.addTool(this.zoomTool, Intl.intl("Zoom"), Intl.intl("Zoom"), ZoomFunc.ICON);
        ZoomBoxFunc zoomBoxFunc = new ZoomBoxFunc();
        this.zoomBoxTool = new CursorTool(controller, zoomBoxFunc);
        this.mgr.addTool(this.zoomBoxTool, Intl.intl("Zoom Box"), Intl.intl("Zoom Box"), ZoomBoxFunc.ICON);
        this.compositeViewTool3d = new CursorTool(controller, NavtoolUtil.newCompositeNav3DTool(this.orbitTool.getFunction(), this.zoomTool.getFunction(), this.dragTool.getFunction(), this.selFunc));
        this.mgr.addTool(this.compositeViewTool3d, Intl.intl("3D Orbit Navigation"), Intl.intl("3D Orbit Navigation"), OrbitFunc.ICON);
        this.d_modeInfo = new HashMap<SceneMode, ModeInfo>();
        this.d_modeInfo.put(SceneMode.MODE2D, new ModeInfo(this.selectionTool2D));
        this.d_modeInfo.put(SceneMode.MODE3D, new ModeInfo(this.compositeViewTool3d));
        this.mgr.addToolChangeListener((oldTool, newTool) -> {
            CursorTool ctool = (CursorTool)newTool;
            ctool.setView(this.d_view);
            this.d_modeInfo.get((Object)((Object)((Object)SceneMode.get((Session)this.d_session)))).tool = ctool;
            this.updateNavToolSpeed();
        });
        this.sync();
        this.updateNavToolSpeed();
    }

    @Override
    public void connect() {
        this.d_mediator.getEvents().addObserver(this);
    }

    @Override
    public void disconnect() {
        this.d_mediator.getEvents().removeObserver(this);
    }

    private void sync() {
        this.syncMode();
    }

    private void syncMode() {
        SceneMode newMode = SceneMode.get(this.d_session);
        this.syncNavToolbar(this.d_navToolbar, newMode);
        this.syncCurrTool(newMode);
    }

    private void syncNavToolbar(JToolBar tb, SceneMode mode) {
        if (tb == null) {
            return;
        }
        tb.removeAll();
        if (mode == SceneMode.MODE2D) {
            tb.add(this.mgr.getToolbarButton(this.selectionTool2D));
        } else {
            tb.add(this.mgr.getToolbarButton(this.selectionTool3D));
            tb.add(this.mgr.getToolbarButton(this.compositeViewTool3d));
            tb.add(this.mgr.getToolbarButton(this.modGameRoamTool));
        }
        tb.add(this.mgr.getToolbarButton(this.dragTool));
        tb.add(this.mgr.getToolbarButton(this.zoomTool));
        tb.add(this.mgr.getToolbarButton(this.zoomBoxTool));
    }

    private void syncCurrTool(SceneMode mode) {
        ModeInfo mi = this.d_modeInfo.get((Object)mode);
        this.mgr.setCurrentTool(mi.tool);
    }

    public guiToolBar createNavToolbar() {
        if (this.d_navToolbar == null) {
            this.d_navToolbar = new guiToolBar();
            this.syncNavToolbar(this.d_navToolbar, SceneMode.get(this.d_session));
        }
        return this.d_navToolbar;
    }

    @Override
    public void update(thunderheadeng.util.Events events) {
        Session session;
        IEventRecord<Session> sevts = events.getEvents(Session.class, new Class[0]);
        if (sevts.isChanged(session = this.d_session, (Object)Events.PATHFINDER_RESULTS_ATTACHED) || sevts.isChanged(session, (Object)Events.PATHFINDER_RESULTS_DETACHED)) {
            this.sync();
            this.updateNavToolSpeed();
        } else {
            if (SceneMode.isChanged(this.d_session, events)) {
                this.syncMode();
            }
            if (sevts.isChanged(this.d_session, Session.CAMERA) || sevts.isChanged(this.d_session, (Object)Events.CAMERA_RESET)) {
                this.updateNavToolSpeed();
            }
        }
    }

    private void updateNavToolSpeed() {
        CursorTool currTool = (CursorTool)this.mgr.getCurrentTool();
        if (currTool == this.modGameRoamTool) {
            AABox modelBounds = this.d_sceneBounds.get();
            ((RoamFunc)this.modGameRoamTool.getFunction()).setModelBounds(modelBounds);
        }
    }

    private static class ModeInfo {
        public CursorTool tool;

        public ModeInfo(CursorTool tool) {
            this.tool = tool;
        }
    }
}

