/*
 * Decompiled with CFR 0.152.
 */
package results.nativebuffered.mv;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import thunderheadeng.gui.WaitCursorMgr;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiUtil;

class MVAction
extends guiAction {
    private int d_mnemonicKey = -1;

    public MVAction(String name, Icon icon, Consumer<ActionInfo> listener) {
        super(name, icon, MVAction.wrap(listener));
        this.initFromName(name);
    }

    private static ActionListener wrap(Consumer<ActionInfo> listener) {
        return e -> {
            ActionInfo ai = new ActionInfo(e);
            ai.waitCursor.beginWaitCursor(true);
            try {
                listener.accept(ai);
            }
            finally {
                ai.waitCursor.endWaitCursor();
            }
        };
    }

    private void initFromName(String name) {
        MVAction act = this;
        String[] toks = name.split(",");
        for (int i = 0; i < toks.length; ++i) {
            toks[i] = toks[i].trim();
        }
        String title = toks[0];
        int ixAmp = title.indexOf(38);
        if (ixAmp >= 0) {
            char mnemonicChar = title.charAt(ixAmp + 1);
            title = title.replaceFirst("&", "");
            this.d_mnemonicKey = Character.toUpperCase(mnemonicChar);
        }
        act.putValue("Name", title);
        if (toks.length >= 2 && !toks[1].equals("-")) {
            char keyCode = Character.toUpperCase(toks[1].charAt(0));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)keyCode, 2));
        }
        if (toks.length >= 3 && !toks[2].equals("-")) {
            this.putValue("ShortDescription", toks[2]);
            this.putValue("LongDescription", toks[2]);
        }
        if (toks.length >= 4 && !toks[2].equals("-")) {
            this.putValue("LongDescription", toks[3]);
        }
    }

    public static class ActionInfo {
        public final WaitCursorMgr waitCursor;
        public final ActionEvent event;
        public final Window parentWindow;
        public final Component srcComp;

        public ActionInfo(ActionEvent e) {
            this.event = e;
            if (e.getSource() instanceof Component) {
                this.srcComp = (Component)e.getSource();
                this.parentWindow = this.srcComp instanceof Window ? (Window)this.srcComp : SwingUtilities.getWindowAncestor(this.srcComp);
                this.waitCursor = guiUtil.getWaitMgr(this.parentWindow);
            } else {
                this.waitCursor = new WaitCursorMgr(new Component[0]);
                this.srcComp = null;
                this.parentWindow = null;
            }
        }

        public void beginWaitCursor() {
            this.waitCursor.beginWaitCursor(true);
        }

        public void endWaitCursor() {
            this.waitCursor.endWaitCursor();
        }
    }
}

