/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import merlin.actions.OccGenerator;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.OccLocation;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class CreateCases {
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";
    private static final String INCLUDE_PROPS = "include_props";
    private static final String EXCLUDE_PROPS = "exclude_props";
    private static final String INCLUDE_POS = "include_pos";
    private static final String EXCLUDE_POS = "exclude_pos";
    private static final String OCCUPANTS = "Occupants";
    private static final String UNIFORM_DIST = "uniform_dist";
    private static final String ANY_ROOM = "any_room";
    private static boolean d_uniform_distribution = false;
    private static boolean d_any_room = false;

    public static void main(String[] args) throws Exception {
        MerlinData original;
        if (args.length < 2) {
            System.err.println(Arrays.toString(args));
            System.err.println("Parameters missing: <pthfile> <n>");
            return;
        }
        String fn = args[0];
        String fnWithoutExt = fn.replaceFirst("[.][^.]+$", "");
        int n = Integer.parseInt(args[1]);
        String baseName = fnWithoutExt + "_variations";
        File outputRootFile = new File(new File(fn).getParentFile(), baseName);
        int autonum = 1;
        while (outputRootFile.exists()) {
            outputRootFile = new File(new File(fn).getParentFile(), baseName + autonum);
            ++autonum;
        }
        HashMap<String, String> addlParams = new HashMap<String, String>();
        if (!CreateCases.processAdditionalParameters(args, addlParams)) {
            return;
        }
        if (!outputRootFile.mkdir()) {
            System.err.println("Unable to create output folder: " + outputRootFile.getPath());
            return;
        }
        try (MerlinOIS ois = new MerlinOIS(new BufferedInputStream(new FileInputStream(fn)), tp -> {});){
            MerlinOIS.DecisionMaker decisions = new MerlinOIS.DecisionMaker();
            decisions.pre104UseNewDefaults = () -> false;
            original = ois.readModel(decisions);
        }
        MerlinData md = new MerlinData(false);
        md.loadFrom(original);
        ArrayList<Pair<String, EgressAgent>> allAgents = new ArrayList<Pair<String, EgressAgent>>();
        ArrayList<Pair<String, Composite>> search = new ArrayList<Pair<String, Composite>>();
        search.add(new Pair<String, EgressAgentComp>(OCCUPANTS, md.agents));
        while (!search.isEmpty()) {
            Pair group = (Pair)search.remove(0);
            Collection<EgressAgent> groupAgents = ((Composite)group.v2).getMembers(EgressAgent.class);
            for (EgressAgent obj : groupAgents) {
                allAgents.add(new Pair<String, EgressAgent>((String)group.v1 + "/" + obj.getName(), obj));
            }
            Collection comps = ((Composite)group.v2).getComposites();
            for (Composite comp : comps) {
                search.add(new Pair((String)group.v1 + "/" + comp.getName(), comp));
            }
        }
        List<Pair<String, EgressAgent>> filtered_agents = new ArrayList<Pair<String, EgressAgent>>(allAgents);
        if (addlParams.containsKey(INCLUDE)) {
            filtered_agents = CreateCases.filterAgentList(filtered_agents, addlParams.get(INCLUDE), INCLUDE);
        }
        if (addlParams.containsKey(EXCLUDE)) {
            filtered_agents = CreateCases.filterAgentList(filtered_agents, addlParams.get(EXCLUDE), EXCLUDE);
        }
        List<Pair<String, EgressAgent>> pos_filtered_agents = new ArrayList<Pair<String, EgressAgent>>(filtered_agents);
        if (addlParams.containsKey(INCLUDE_POS)) {
            pos_filtered_agents = CreateCases.filterAgentList(pos_filtered_agents, addlParams.get(INCLUDE_POS), INCLUDE_POS);
        }
        if (addlParams.containsKey(EXCLUDE_POS)) {
            pos_filtered_agents = CreateCases.filterAgentList(pos_filtered_agents, addlParams.get(EXCLUDE_POS), EXCLUDE_POS);
        }
        List<Pair<String, EgressAgent>> props_filtered_agents = new ArrayList<Pair<String, EgressAgent>>(filtered_agents);
        if (addlParams.containsKey(INCLUDE_PROPS)) {
            props_filtered_agents = CreateCases.filterAgentList(props_filtered_agents, addlParams.get(INCLUDE_PROPS), INCLUDE_PROPS);
        }
        if (addlParams.containsKey(EXCLUDE_PROPS)) {
            props_filtered_agents = CreateCases.filterAgentList(props_filtered_agents, addlParams.get(EXCLUDE_PROPS), EXCLUDE_PROPS);
        }
        if (d_any_room) {
            System.out.print("\n\nOccupant positions will be distributed between all rooms.\n");
        }
        if (d_uniform_distribution) {
            System.out.print("\n\nOccupant position distribution will be uniform.\n");
        }
        CreateCases.printOccupantFilterResult(allAgents, filtered_agents, pos_filtered_agents, props_filtered_agents);
        Random rng = new Random(0L);
        ArrayList<String> cases = new ArrayList<String>();
        for (int id = 1; id <= n; ++id) {
            MerlinData newMD = CreateCases.randomizeAgentPosition(md, rng, pos_filtered_agents.stream().map(pair -> (EgressAgent)pair.v2).collect(Collectors.toSet()));
            newMD = CreateCases.randomizeAgentProfileData(newMD, rng, props_filtered_agents.stream().map(pair -> (EgressAgent)pair.v2).collect(Collectors.toList()));
            File caseFile = new File(outputRootFile, fnWithoutExt + "_" + id + ".pth");
            cases.add(caseFile.getName());
            MerlinIO.writeModel(caseFile.getPath(), newMD);
        }
        CreateCases.writeRunnerScript(outputRootFile + File.separator + "_run.bat", cases);
        CreateCases.writeResultsScript(outputRootFile + File.separator + "_make_plots.bat", cases);
    }

    private static boolean processAdditionalParameters(String[] args, HashMap<String, String> addlArgs) {
        if (args.length < 3) {
            return true;
        }
        for (int i = 2; i < args.length; ++i) {
            String[] param = args[i].split("=");
            param[0] = param[0].replace("-", "");
            if (param[0].startsWith(ANY_ROOM)) {
                d_any_room = true;
                continue;
            }
            if (param[0].startsWith(UNIFORM_DIST)) {
                d_uniform_distribution = true;
                continue;
            }
            if (param[0].startsWith(INCLUDE_PROPS)) {
                addlArgs.put(INCLUDE_PROPS, param[1]);
                continue;
            }
            if (param[0].startsWith(EXCLUDE_PROPS)) {
                addlArgs.put(EXCLUDE_PROPS, param[1]);
                continue;
            }
            if (param[0].startsWith(INCLUDE_POS)) {
                addlArgs.put(INCLUDE_POS, param[1]);
                continue;
            }
            if (param[0].startsWith(EXCLUDE_POS)) {
                addlArgs.put(EXCLUDE_POS, param[1]);
                continue;
            }
            if (param[0].startsWith(INCLUDE)) {
                addlArgs.put(INCLUDE, param[1]);
                continue;
            }
            if (param[0].startsWith(EXCLUDE)) {
                addlArgs.put(EXCLUDE, param[1]);
                continue;
            }
            System.err.println("Parameter Format Error: " + args[i]);
            return false;
        }
        return true;
    }

    private static void writeRunnerScript(String fn, List<String> cases) throws Exception {
        StringBuilder data = new StringBuilder();
        InputStream instrm = CreateCases.class.getResourceAsStream("runner.bat.template");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(instrm));){
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        String installFolder = CreateCases.findInstallFolder();
        String jreFolder = CreateCases.findJreFolder(installFolder);
        String casesStr = cases.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(" "));
        String content = data.toString();
        content = content.replace("{INSTALL_FOLDER}", installFolder);
        content = content.replace("{JAVA_FOLDER}", jreFolder);
        content = content.replace("{CASES}", casesStr);
        Files.write(Paths.get(fn, new String[0]), content.getBytes(), new OpenOption[0]);
    }

    private static void writeResultsScript(String fn, List<String> cases) throws Exception {
        StringBuilder data = new StringBuilder();
        InputStream instrm = CreateCases.class.getResourceAsStream("results.bat.template");
        BufferedReader reader = new BufferedReader(new InputStreamReader(instrm));
        Object object = null;
        try {
            String line = reader.readLine();
            while (line != null) {
                data.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (Throwable line) {
            object = line;
            throw line;
        }
        finally {
            if (reader != null) {
                if (object != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line) {
                        ((Throwable)object).addSuppressed(line);
                    }
                } else {
                    reader.close();
                }
            }
        }
        ArrayList<String> casesBetter = new ArrayList<String>();
        for (String caseName : cases) {
            casesBetter.add(String.format("\"%s\"", "%ROOT%\\" + caseName));
        }
        String installFolder = CreateCases.findInstallFolder();
        String jreFolder = CreateCases.findJreFolder(installFolder);
        String casesStr = String.join((CharSequence)" ", casesBetter);
        String content = data.toString();
        content = content.replace("{INSTALL_FOLDER}", installFolder);
        content = content.replace("{JAVA_FOLDER}", jreFolder);
        content = content.replace("{CASES}", casesStr);
        Files.write(Paths.get(fn, new String[0]), content.getBytes(), new OpenOption[0]);
    }

    private static String findJreFolder(String installFolder) {
        File root = new File(installFolder);
        File jreFolder = new File(root, "jre");
        if (jreFolder.exists()) {
            return jreFolder.getPath();
        }
        for (File f : root.listFiles()) {
            if (!f.isDirectory() || !f.getName().startsWith("jre")) continue;
            return f.getPath();
        }
        return jreFolder.getPath();
    }

    private static String findInstallFolder() {
        String applicationDir = CreateCases.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            applicationDir = URLDecoder.decode(applicationDir, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (applicationDir.endsWith(".jar")) {
            applicationDir = new File(applicationDir).getParent();
        } else {
            applicationDir = applicationDir + CreateCases.class.getName().replace('.', '/');
            applicationDir = new File(applicationDir).getParent();
        }
        for (File currentDir = new File(applicationDir); currentDir != null; currentDir = currentDir.getParentFile()) {
            File test = new File(currentDir, "testsim.bat");
            if (!test.exists()) continue;
            return currentDir.getPath();
        }
        return null;
    }

    private static List<Pair<String, EgressAgent>> filterAgentList(List<Pair<String, EgressAgent>> agentList, String filter, String filterType) {
        if (filterType.equals(INCLUDE) || filterType.equals(INCLUDE_POS) || filterType.equals(INCLUDE_PROPS)) {
            return agentList.stream().filter(agent -> ((String)agent.v1).contains(filter)).collect(Collectors.toList());
        }
        if (filterType.equals(EXCLUDE) || filterType.equals(EXCLUDE_POS) || filterType.equals(EXCLUDE_PROPS)) {
            return agentList.stream().filter(agent -> !((String)agent.v1).contains(filter)).collect(Collectors.toList());
        }
        return agentList;
    }

    private static MerlinData randomizeAgentProfileData(MerlinData original, Random rng, Collection<EgressAgent> occsToRandomize) {
        if (occsToRandomize.isEmpty()) {
            return original;
        }
        MerlinData md = new MerlinData(false);
        md.loadFrom(original);
        Collection<EgressAgent> allAgents = md.agents.getDeepMembers(EgressAgent.class);
        for (EgressAgent ea : allAgents) {
            if (!occsToRandomize.contains(ea)) continue;
            ea.newProfileSeed();
        }
        return md;
    }

    private static MerlinData randomizeAgentPosition(MerlinData original, Random rng, Set<EgressAgent> occsToRandomize) {
        if (occsToRandomize.isEmpty()) {
            return original;
        }
        MerlinData md = new MerlinData(false);
        md.loadFrom(original);
        LinkedHashSet<OccProfile> profiles = new LinkedHashSet<OccProfile>();
        LinkedHashMap<EgressAgent, OccLocation> locMap = new LinkedHashMap<EgressAgent, OccLocation>();
        LinkedHashMap<EgressAgent, Long> orientSeedMap = new LinkedHashMap<EgressAgent, Long>();
        for (EgressAgent egressAgent : occsToRandomize) {
            profiles.add(egressAgent.getProfile().getProfParent());
            locMap.put(egressAgent, egressAgent.getLocInfo());
            orientSeedMap.put(egressAgent, egressAgent.getOrientSeed());
        }
        HashSet<IEgressOccupiable> rooms = new HashSet<IEgressOccupiable>();
        for (EgressAgent ea : occsToRandomize) {
            IEgressOccupiable m = ea.getRoom();
            if (rooms.contains(m)) continue;
            rooms.add(m);
        }
        BiFunction<Set, Set, Boolean> biFunction = (comps, occs) -> {
            OccGenerator occGenerator = new OccGenerator(md, rng, OccGenerator.getModels(comps), OccGenerator.getMaxDiam(profiles), new UnitDouble(0.125, SI.SECOND), 400, null, null);
            boolean success = false;
            success = d_uniform_distribution ? occGenerator.generate(occs.size(), 0, 2, (Collection<EgressAgent>)occs) : occGenerator.generate(occs.size(), 1, 2, (Collection<EgressAgent>)occs);
            return success;
        };
        boolean successful = true;
        if (d_any_room) {
            successful &= biFunction.apply(new HashSet(rooms), new HashSet<EgressAgent>(occsToRandomize)).booleanValue();
        } else {
            Set<Object> occs2 = new HashSet();
            for (IEgressOccupiable room : rooms) {
                occs2 = CreateCases.getOccsToRandomizeByRoom(room.getOccupants(), occsToRandomize);
                if (successful &= biFunction.apply(Collections.singleton(room), occs2).booleanValue()) continue;
                break;
            }
        }
        if (!successful) {
            System.out.println("Pathfinder was unable to randomize occupants' positions without overlap.");
            System.out.println("Occupant positions reverted.");
            for (EgressAgent occ : occsToRandomize) {
                occ.setLocation((OccLocation)locMap.get(occ));
                occ.setOrientSeed((Long)orientSeedMap.get(occ));
            }
        }
        return md;
    }

    private static Set<EgressAgent> getOccsToRandomizeByRoom(Set<EgressAgent> roomOccs, Set<EgressAgent> allOccsToRandomize) {
        HashSet<EgressAgent> roomOccsToRandomize = new HashSet<EgressAgent>();
        for (EgressAgent occ : roomOccs) {
            if (!allOccsToRandomize.contains(occ)) continue;
            roomOccsToRandomize.add(occ);
        }
        return roomOccsToRandomize;
    }

    private static void printOccupantFilterResult(List<Pair<String, EgressAgent>> masterList, List<Pair<String, EgressAgent>> filteredList, List<Pair<String, EgressAgent>> posFilteredList, List<Pair<String, EgressAgent>> propsFilteredList) {
        System.out.printf("%n%-50s %-10s %-10s %-10s %n", "Id", "Include", "Rng Pos", "Rng Props");
        for (Pair<String, EgressAgent> nextPair : masterList) {
            System.out.printf("%-50s %-10s %-10s %-10s %n", nextPair.v1, filteredList.contains(nextPair) ? "yes" : "no", posFilteredList.contains(nextPair) ? "yes" : "no", propsFilteredList.contains(nextPair) ? "yes" : "no");
        }
    }
}

