/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import merlin.MerlinApp;
import merlin.data.egress.agents.IOccArea;
import merlin.unitsystem.UnitSystem;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;

public class OccAreaListCellRenderer
extends DefaultListCellRenderer {
    public static String getOccAreaString(IOccArea oArea, UnitSystem uSys) {
        String str = "";
        if (oArea != null) {
            str = oArea.getName();
            UnitDouble area = oArea.getArea();
            Unit merArea = uSys.getUnit(4);
            double areaCurr = area.getValue(merArea);
            UnitDouble dens = new UnitDouble(areaCurr, uSys.getOccDensity());
            DecimalFormat fmt = new DecimalFormat("0.0#");
            str = oArea.getName();
            if (!Double.isInfinite(areaCurr)) {
                str = str + " - " + fmt.format(dens.getValueNoUnit()) + " " + dens.getUnit().toString();
            }
        }
        return str;
    }

    public static class RendWithPreview
    extends DefaultListCellRenderer {
        private MerlinApp d_app;

        public RendWithPreview(MerlinApp app) {
            this.d_app = app;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            IOccArea oArea = (IOccArea)value;
            String str = OccAreaListCellRenderer.getOccAreaString(oArea, this.d_app.getUnitSystem());
            return super.getListCellRendererComponent(list, str, index, isSelected, cellHasFocus);
        }
    }

    public static class RendNoPreview
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            IOccArea oArea = (IOccArea)value;
            return super.getListCellRendererComponent(list, oArea.getName(), index, isSelected, cellHasFocus);
        }
    }
}

