/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Collection;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.tools.IPointPickListener;
import merlin.util.MerlinUtil;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;

public class PointPicker
extends AToolFunction<CursorTool> {
    private final Component d_renderComp;
    private final MerlinData d_data;
    private IPointPickListener d_listener;

    public PointPicker(MerlinData data, Component renderComp) {
        this.d_data = data;
        this.d_renderComp = renderComp;
    }

    public void setListener(IPointPickListener listener) {
        this.d_listener = listener;
    }

    @Override
    public Cursor getCursor(CursorTool tool) {
        return null;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
        return this.d_listener != null ? this.d_listener.getSnapInfo(tool) : new Pair<SnapMode, IIsectFilter>(SnapMode.NONE, null);
    }

    @Override
    public boolean showDragGuides(CursorTool tool) {
        return false;
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
        if (tool.getP0() == null || this.d_listener == null) {
            return;
        }
        if (e.getButton() != 1) {
            this.d_listener.stopPicking();
            return;
        }
        Collection<IsectInfo> isects = tool.getP1().snaps;
        if (isects.isEmpty()) {
            return;
        }
        IsectInfo isect = isects.iterator().next();
        UnitPoint3D pickedPoint = MerlinUtil.getUPoint3D(isect.isectPoint);
        this.d_listener.pointPicked((IMerlinGeomSrc)isect.obj, pickedPoint);
    }

    public void cancel() {
        if (this.d_listener != null) {
            this.d_listener.stopPicking();
        }
    }

    @Override
    public String getStatusMessage(CursorTool tool) {
        CursorTool.SnapInfo snap = tool.getP1();
        if (snap == null || snap.constrained.isEmpty()) {
            snap = tool.getP0();
        }
        if (snap == null || snap.constrained.isEmpty()) {
            return super.getStatusMessage(tool);
        }
        return String.format(Intl.intl("Pick Location: %s"), tool.toString(snap.constrained.getLast()));
    }
}

