/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.builders.PolyBuilder;
import merlin.mv.ModelView;
import merlin.mv.tools.NewPlanarGeomTool;

public class NewPolyTool
extends NewPlanarGeomTool<PolyBuilder> {
    public NewPolyTool(ModelView mv) {
        super(mv, new Func());
        this.setCancelOnRightClick(false);
    }

    private void addPoint(Point2d p) {
        if (p == null) {
            return;
        }
        ((PolyBuilder)this.props()).addPoint(p);
    }

    private void addTestPoint(Point2d p) {
        if (p == null) {
            return;
        }
        ((PolyBuilder)this.props()).addTestPoint(p);
    }

    @Override
    public void cancel() {
        ((PolyBuilder)this.props()).cancel();
        super.cancel();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        switch (e.getKeyCode()) {
            case 10: {
                ((PolyBuilder)this.props()).closePoly(e.getComponent());
            }
        }
    }

    @Override
    protected String getShapeName() {
        return Intl.intl("Polygon");
    }

    @Override
    protected String getStatusMessage() {
        List<Point2d> points = ((PolyBuilder)this.props()).getPoints();
        int num = points.size();
        Point3d nextPoint = points.isEmpty() ? this.getAddLoc() : this.getLoc(points.get(points.size() - 1));
        return String.format(Intl.intl("Polygon - Point %d: %s"), num, this.toString(nextPoint));
    }

    protected static class Func
    extends NewPlanarGeomTool.Func<PolyBuilder, NewPolyTool> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(NewPolyTool tool) {
            return null;
        }

        @Override
        public void mouseExited(NewPolyTool tool, MouseEvent e) {
            ((PolyBuilder)tool.props()).cancelTestPoint();
        }

        @Override
        public void mouseMoved(NewPolyTool tool, MouseEvent e) {
            if (((PolyBuilder)tool.props()).isComplete()) {
                return;
            }
            ((PolyBuilder)tool.props()).pause();
            Point2d addLoc = tool.getPlanarAddLoc();
            if (addLoc != null) {
                ((PolyBuilder)tool.props()).cancelTestPoint();
                tool.addTestPoint(addLoc);
            }
            ((PolyBuilder)tool.props()).resume();
        }

        @Override
        public void mouseReleased(NewPolyTool tool, MouseEvent e) {
            switch (e.getButton()) {
                case 1: {
                    Point2d addPoint = tool.getPlanarAddLoc();
                    if (addPoint == null) break;
                    ((PolyBuilder)tool.props()).addPoint(addPoint);
                    break;
                }
                case 3: {
                    if (((PolyBuilder)tool.props()).canClosePoly()) {
                        ((PolyBuilder)tool.props()).closePoly(e.getComponent());
                        tool.finish();
                        break;
                    }
                    ((PolyBuilder)tool.props()).cancel();
                    tool.cancel();
                }
            }
        }
    }
}

