/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.builders.PlanarGeomBuilder;
import merlin.geom.Geometry;
import merlin.mv.ModelView;
import merlin.mv.tools.MerlinTool;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;

public abstract class NewPlanarGeomTool<T extends PlanarGeomBuilder>
extends MerlinTool<T> {
    public NewPlanarGeomTool(ModelView mv, Func<? extends T, ? extends NewPlanarGeomTool<T>> func) {
        super(mv, func);
    }

    @Override
    public void cancel() {
        ((PlanarGeomBuilder)this.props()).cancel();
        super.cancel();
    }

    protected Point3d getLoc(Point2d p2d) {
        if (p2d == null) {
            return null;
        }
        return new Point3d(p2d.x, p2d.y, ((PlanarGeomBuilder)this.props()).getZLoc().getValue(Geometry.LENGTH_UNIT));
    }

    protected Point3d getAddLoc() {
        CursorTool.Ray pickRay = this.getPickRay();
        if (pickRay.begin.z == ((PlanarGeomBuilder)this.props()).getZLoc().getValue(Geometry.LENGTH_UNIT)) {
            return pickRay.begin;
        }
        if (this.isOrthoView()) {
            return new Point3d(pickRay.begin.x, pickRay.begin.y, ((PlanarGeomBuilder)this.props()).getZLoc().getValue(Geometry.LENGTH_UNIT));
        }
        Point3d intersection = new Point3d();
        if (!Inter3D.lineZPlaneIntersection(intersection, pickRay.begin, pickRay.dir, ((PlanarGeomBuilder)this.props()).getZLoc().getValue(Geometry.LENGTH_UNIT), 1.0E-9)) {
            return null;
        }
        return intersection;
    }

    protected Point2d getPlanarAddLoc() {
        Point3d loc = this.getAddLoc();
        if (loc == null) {
            return null;
        }
        return new Point2d(loc.x, loc.y);
    }

    protected abstract String getShapeName();

    @Override
    protected String getStatusMessage() {
        return this.getShapeName() + ": " + this.toString(this.getAddLoc());
    }

    protected static class Func<PropT extends PlanarGeomBuilder, ToolT extends NewPlanarGeomTool<PropT>>
    extends AToolFunction<ToolT> {
        protected Func() {
        }

        @Override
        public Cursor getCursor(ToolT tool) {
            return null;
        }

        @Override
        public void mousePressed(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseReleased(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(ToolT tool, MouseEvent e) {
        }

        @Override
        public void mouseDragged(ToolT tool, MouseEvent e) {
            ((CursorTool)tool).mouseMoved(e);
        }
    }
}

