/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.awt.Color;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.geom.Geometry;
import merlin.manip.MirrorManip;
import merlin.mv.ModelView;
import merlin.mv.tools.ATransformTool;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class MirrorTool
extends ATransformTool<MirrorManip> {
    private UnitPoint3D d_p1;
    private UnitPoint3D d_p2;
    private boolean d_p1Committed;
    private boolean d_p2Committed;
    private Vector3d d_planeVec;
    private final MirrorDisp d_display = new MirrorDisp();

    public MirrorTool(ModelView mv) {
        super(mv, new Func());
        this.reset();
    }

    public IDisplayable getDisplay() {
        return this.d_display;
    }

    private void setPlaneVec(Vector3d vec) {
        this.d_planeVec.set(vec);
        this.d_planeVec.normalize();
        this.d_display.update();
    }

    private void setPoint(int ix, UnitPoint3D point, boolean commit) {
        if (ix == 0) {
            this.d_p1 = point;
            this.d_p1Committed = commit;
        } else {
            this.d_p2 = point;
            this.d_p2Committed = commit;
            ((MirrorManip)this.props()).setPlane(this.getMirrorPlane());
        }
        this.d_display.update();
    }

    private Vector3d getPlaneVec2() {
        return Util3D.vectorN(this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT), this.d_p2.getPoint3dValue(Geometry.LENGTH_UNIT));
    }

    @Override
    public void reset() {
        this.d_planeVec = new Vector3d(0.0, 0.0, 1.0);
        this.d_p1 = null;
        this.d_p2 = null;
        this.d_p2Committed = false;
        this.d_p1Committed = false;
        this.d_display.update();
    }

    private Plane3d getMirrorPlane() {
        if (this.d_p1 == null || this.d_p2 == null || this.d_p1.equals(this.d_p2)) {
            return null;
        }
        Vector3d planeVec2 = this.getPlaneVec2();
        double dot = planeVec2.dot(this.d_planeVec);
        if (theUtil.eq(Math.abs(dot), 1.0, 1.0E-6)) {
            return null;
        }
        Vector3d normal = new Vector3d();
        normal.cross(this.d_planeVec, planeVec2);
        return new Plane3d(normal, this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT));
    }

    @Override
    public void activate() {
        super.activate();
        Camera cam = this.getView().getCamera();
        Vector3d planeVec = cam.getViewVector();
        planeVec.normalize();
        this.setPlaneVec(planeVec);
    }

    protected static class Func
    extends ATransformTool.Func<MirrorManip, MirrorTool> {
        protected Func() {
        }

        @Override
        public void mouseExited(MirrorTool tool, MouseEvent e) {
            if (!tool.d_p1Committed) {
                tool.setPoint(0, null, false);
            }
        }

        @Override
        public void mouseMoved(MirrorTool tool, MouseEvent e) {
            if (!tool.d_p1Committed) {
                tool.setPoint(0, tool.getFirstPoint(false), false);
            } else {
                UnitPoint3D nextPoint = tool.getNextPoint(tool.d_p1, tool.getP1().referenceSnap, tool.getP1().isSnapped());
                tool.setPoint(1, nextPoint, false);
            }
        }

        @Override
        public void mousePressed(MirrorTool tool, MouseEvent e) {
            if (e.getButton() == 1) {
                if (!tool.d_p1Committed) {
                    tool.setPoint(0, tool.getFirstPoint(true), true);
                } else {
                    UnitPoint3D nextPoint = tool.getNextPoint(tool.d_p1, tool.getP0().referenceSnap, tool.getP0().isSnapped());
                    tool.setPoint(1, nextPoint, true);
                }
            }
        }

        @Override
        public void mouseReleased(MirrorTool tool, MouseEvent e) {
            int pressedButton = e.getButton();
            if (pressedButton == 1) {
                ((MirrorManip)tool.props()).pause();
                if (tool.dragAboveTolerance(0)) {
                    UnitPoint3D nextPoint = tool.getNextPoint(tool.d_p1, tool.getP1().referenceSnap, tool.getP1().isSnapped());
                    tool.setPoint(1, nextPoint, true);
                }
                if (((MirrorManip)tool.props()).canTransform()) {
                    ((MirrorManip)tool.props()).transform(e.getComponent());
                }
                ((MirrorManip)tool.props()).resume();
            }
        }
    }

    private class MirrorDisp
    extends GenericActor {
        public MirrorDisp() {
            this.setPointSize(10.0);
            this.setLineWidth(2.0);
        }

        public void update() {
            this.resetData();
            if (MirrorTool.this.d_p1 != null) {
                Point3d p1 = MirrorTool.this.d_p1.getPoint3dValue(Geometry.LENGTH_UNIT);
                this.addPoint(p1, Color.RED);
                if (MirrorTool.this.d_p2 != null) {
                    Point3d p2 = MirrorTool.this.d_p2.getPoint3dValue(Geometry.LENGTH_UNIT);
                    this.addPoint(p2, Color.RED);
                    this.addLine(p1, p2, Color.RED);
                }
            }
            this.finalizeData();
            MirrorTool.this.repaintSurface();
        }
    }
}

