/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.manip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.FloorSortActions;
import merlin.actions.SubtractAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.gui.IPropEditor;
import merlin.gui.PropPanel;
import merlin.mv.ModelView;
import merlin.mv.displays.HandleDispMgr;
import merlin.mv.gui.HandleManipPanel;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.manip.IManipListener;
import thunderheadeng.scene3d.manip.ManipEvent;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;

public class ManipListener
implements IManipListener,
IEventObserver {
    private final MerlinData d_domain;
    private final ModelView d_mv;
    private final ManipMgr d_manipMgr;
    private final HandleDispMgr d_dispMgr;
    private HandleSearcher d_handleSearcher;
    private IPropEditor d_nullPanel;
    private final HandleManipPanel d_handleManipPanel;

    public ManipListener(MerlinData domain, ModelView mv, ManipMgr mgr, ModelScene handleScene) {
        this.d_domain = domain;
        this.d_mv = mv;
        this.d_manipMgr = mgr;
        this.d_handleManipPanel = new HandleManipPanel(mgr, this.d_mv.getRenderComp());
        this.d_dispMgr = new HandleDispMgr(domain, handleScene);
        this.d_handleSearcher = null;
        domain.getEvents().addObserver(this);
    }

    @Override
    public void update(Events events) {
        IMutableGeomSrc source;
        IEventRecord<?> sevents;
        IEventRecord<MerlinData> merlinEvts = events.getEvents(MerlinData.class, new Class[0]);
        IEventRecord<IMutableGeomSrc> pevts = events.getEvents(IMutableGeomSrc.class, new Class[0]);
        if (merlinEvts.containsChange(MerlinData.MODEL_RESET) || merlinEvts.containsChange(MerlinData.MODEL_LOADED) || pevts.hasAddedObjs() || pevts.hasRemovedObjs() || pevts.containsChange(MerlinData.SELECTION_CHANGED)) {
            IMutableGeomSrc selObj;
            IMutableGeomSrc newSrc = null;
            Set selGeoms = this.d_domain.selection.getSelected(IMutableGeomSrc.class);
            if (selGeoms.size() == 1 && ManipMgr.canManipulate(selObj = (IMutableGeomSrc)selGeoms.iterator().next())) {
                newSrc = selObj;
            }
            this.d_manipMgr.setSource(newSrc);
        }
        if (this.d_manipMgr.getCurrentManipObj() != null && (sevents = events.getEvents((source = this.d_manipMgr.getCurrentManipObj()).getClass(), new Class[0])).isChanged(source)) {
            this.d_manipMgr.updateSource(source);
        }
    }

    @Override
    public void manipChanged(ManipEvent evt) {
        ManipEvent.Type type = evt.getType();
        switch (type) {
            case MANIP_STARTED: {
                this.begin();
                break;
            }
            case HANDLES_MODIFIED: {
                this.updateHandles();
                break;
            }
            case ACTIVE_HANDLE_CHANGED: {
                this.updateActiveHandle(evt.getOldHandle());
                break;
            }
            case MANIP_ENDED: {
                this.end();
                if (!evt.isCommitted()) break;
                this.commit(this.d_manipMgr.getCurrentManipObj(), evt.getNewNode());
            }
        }
    }

    protected void updateHandles() {
        Collection<IHandle> handles;
        if (this.d_handleSearcher != null) {
            this.d_dispMgr.removeDisplays(this.d_handleSearcher.d_handles);
            this.d_domain.geomLocation.remove(this.d_handleSearcher);
            this.d_handleSearcher = null;
        }
        if (!(handles = this.d_manipMgr.getCurrentHandles()).isEmpty()) {
            this.d_handleSearcher = new HandleSearcher(handles);
            this.d_domain.geomLocation.add(this.d_handleSearcher);
            this.d_dispMgr.addDisplays(handles);
            this.updateActiveHandle(null);
        }
        if (this.d_manipMgr.isManipulating()) {
            this.d_handleManipPanel.update();
        }
    }

    protected void updateActiveHandle(IHandle oldHandle) {
        IHandle handle = this.d_manipMgr.getSelectedHandle();
        if (oldHandle != null) {
            this.d_dispMgr.updateSelected(oldHandle, false);
        }
        if (handle != null) {
            this.d_dispMgr.updateSelected(handle, true);
        }
    }

    protected void begin() {
        PropPanel toolPropsPanel = this.d_mv.getToolPropsPanel();
        this.d_nullPanel = toolPropsPanel.getEditor();
        this.d_handleManipPanel.update();
        toolPropsPanel.setEditor(this.d_handleManipPanel);
    }

    protected void end() {
        PropPanel toolPropsPanel = this.d_mv.getToolPropsPanel();
        toolPropsPanel.setEditor(this.d_nullPanel);
    }

    protected void commit(IMutableGeomSrc src, IGeomNode newNode) {
        UIHook.run(null, "ManipListener.commit", new CommitTask(src, newNode), 2);
    }

    protected static class HandleSearcher
    implements IDisplayableGeomSrc,
    IPickable {
        private final List<IHandle> d_handles;
        private final AABox d_bounds;

        public HandleSearcher(Collection<? extends IHandle> handles) {
            this.d_handles = new ArrayList<IHandle>(handles);
            this.d_bounds = new AABox();
            for (IHandle handle : this.d_handles) {
                handle.getGeom().getBoundingBox(this.d_bounds);
            }
        }

        @Override
        public AABox getBounds() {
            return this.d_bounds;
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps props) {
            return DisplayGeom.EMPTY;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean visible) {
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            if (!filter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle handle : this.d_handles) {
                if (!filter.acceptPickObject(handle)) continue;
                handle.getGeom().pickPoints(IPickable.convertCollector(isects, DEF_PROPS), filter, handle, rayBegin, rayEnd, rayDirN, tester);
            }
        }

        @Override
        public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
            if (!filter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle handle : this.d_handles) {
                if (!filter.acceptPickObject(handle)) continue;
                try {
                    handle.getGeom().pickBox(handle, filter, region, IPickable.convertCollector(result, DEF_PROPS));
                }
                catch (CancelledException cancelledException) {}
            }
        }

        @Override
        public void getAll(Consumer<Object> result, IIsectFilter filter) {
            if (!filter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle handle : this.d_handles) {
                if (!filter.acceptPickObject(handle)) continue;
                result.accept(handle);
            }
        }
    }

    private static class CommitTask
    extends AMerlinOp {
        private final IMutableGeomSrc d_src;
        private final IGeomNode d_newNode;

        public CommitTask(IMutableGeomSrc src, IGeomNode newNode) {
            this.d_src = src;
            this.d_newNode = newNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(MerlinApp app, MerlinData md) {
            md.beginWrite();
            try {
                Undo.begin(Intl.intl("Edit"));
                if (this.d_src instanceof IRestorable) {
                    Undo.insertUndoEntry_restore(md, (IRestorable)((Object)this.d_src));
                } else {
                    Undo.insertEntry_breakChain(md);
                }
                this.d_src.setGeom(this.d_newNode);
                ArrayList toClean = new ArrayList();
                if (this.d_src instanceof EgressRoom) {
                    SubtractAction.subtract(app, md, 0, toClean::add, (EgressRoom)this.d_src);
                }
                if (this.d_src instanceof IEgressComp) {
                    FloorSortActions.updateComponentFloors(md, Arrays.asList((IEgressComp)this.d_src));
                }
                EgressRoom.cleanup(md, toClean);
                Undo.end(md);
            }
            finally {
                md.endWrite();
            }
        }
    }
}

