/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.CompElementActions;
import merlin.actions.CreateElevator;
import merlin.actions.NewGroup;
import merlin.actions.RenameAction;
import merlin.actions.SetWorkingGroup;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.Visibility;
import merlin.actions.floorextract.GenerateModelFromBIM;
import merlin.data.AssistedEvacTeam;
import merlin.data.Composite;
import merlin.data.GeomComposite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.IOpacity;
import merlin.data.IRestorable;
import merlin.data.ImportType;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.NamedMerlinObj;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.Opacity;
import merlin.data.Proxy;
import merlin.data.SimParams;
import merlin.data.camera.Camera;
import merlin.data.egress.Floor;
import merlin.data.egress.FloorComposite;
import merlin.data.egress.FloorSort;
import merlin.data.egress.agents.ConstOccCount;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.EgressAgentComp;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.agents.IOccCount;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ITimingModel;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.DoorUtil;
import merlin.data.egress.geom.EgressBlockage;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.EgressStair;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfile;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IWaitUntilSrc;
import merlin.data.egress.scripting.JoinOccGroup;
import merlin.data.egress.scripting.RefugeFilter;
import merlin.data.egress.scripting.Wait;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.egress.scripting.WaitUntil;
import merlin.data.material.Material;
import merlin.data.material.TexMappers;
import merlin.data.value.IFunction1d;
import merlin.data.value.IVariant;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.AETeamsChooser;
import merlin.gui.APropEditPanel;
import merlin.gui.BasicFloorComboBox;
import merlin.gui.DistributionEditor;
import merlin.gui.ElevatorChooser;
import merlin.gui.ElevatorLevelDlg;
import merlin.gui.ExitChooser;
import merlin.gui.MaterialBtn;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.MerlinValueFields;
import merlin.gui.NewElevatorDlg;
import merlin.gui.NodeComboBox;
import merlin.gui.NodeComboModel;
import merlin.gui.OccGroupsPanel;
import merlin.gui.OccupancyPanel;
import merlin.gui.PriorityChooser;
import merlin.gui.RoomChooser;
import merlin.gui.SetChooser;
import merlin.gui.UnitUpdator;
import merlin.gui.guiUtil;
import merlin.gui.stat.CompactCurvePnl;
import merlin.gui.value.AValEditor;
import merlin.gui.value.DiscreteVarEditor;
import merlin.gui.value.IValEditor;
import merlin.gui.value.IVariantEditor;
import merlin.gui.value.UDVarEditor;
import merlin.mv.gui.OccEditorPanel;
import merlin.mv.gui.OccSourcePanel;
import merlin.mv.gui.behaviors.WaitUntilSrcPnl;
import merlin.unitsystem.SIUS;
import merlin.unitsystem.UnitSystem;
import merlin.unitsystem.UnitUpdatableComponent;
import merlin.util.Dependencies;
import merlin.util.MerlinProps;
import merlin.util.MerlinUtil;
import merlin.util.OccAreaListCellRenderer;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiDoubleField;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theUtil;

public class SelectionEditorPanel
extends APropEditPanel<MerlinProps>
implements IEventObserver {
    public static final IPropertySet.Prop<Boolean> PROP_BEHAVIOR_ACTION_TERMINAL = new IPropertySet.Prop<Boolean>("BEHAVIOR_TOOL", false);
    private MerlinData d_md;
    private List<EditorPanel> d_activePanels;
    private OccEditorPanel d_occSect;
    private EditorPanel d_floorSect;
    private EditorPanel d_occCountSect;
    private EditorPanel d_roomInfoSect;
    private EditorPanel d_roomPropSect;
    private EditorPanel d_doorSect1;
    private EditorPanel d_doorSect2;
    private EditorPanel d_corrSect;
    private EditorPanel d_stairSect;
    private EditorPanel d_rampSect;
    private EditorPanel d_extraCorrInfoSect1;
    private EditorPanel d_extraCorrInfoSect2;
    private EditorPanel d_behaviorSect;
    private EditorPanel d_behaviorPropSect;
    private EditorPanel d_behaviorActSect;
    private EditorPanel d_gotoWaypointSect;
    private EditorPanel d_gotoElevatorsSect;
    private EditorPanel d_gotoRoomsSect;
    private EditorPanel d_gotoExitsSect;
    private EditorPanel d_waitForAssistSect;
    private EditorPanel d_assistSect;
    private EditorPanel d_joinOccGroupSect;
    private EditorPanel d_elevatorPropSect;
    private EditorPanel d_elevatorLevelSect;
    private EditorPanel d_elevatorExtraSect;
    private EditorPanel d_waitSect;
    private EditorPanel d_waitUntilSect;
    private BoundsSect d_boundsSect;
    private EditorPanel d_blockageSect;
    private EditorPanel d_blockageVisSect;
    private EditorPanel d_cameraControlSect;
    private EditorPanel d_cameraOrientSect;
    private EditorPanel d_cameraLimitsSect;
    private EditorPanel d_sceneGeomSect;
    private OccGroupPnl d_occGroupSect;
    private ChangeBehaviorSect d_changeBehaviorSect;
    private ChangeProfileSect d_changeProfileSect;
    private final NewCompGroupPnl d_newCompGroupPnl;
    private final FloorSortPnl d_floorSortPnl;
    private final EditorPanel d_generateModelFromBIM;
    private final EditorPanel d_generateModelFromBIMSel;
    private OccSourcePanel d_occSourcePanel;
    private EditorPanel d_profileFilterSect;
    private static final guiLabel s_dmyLbl = new guiLabel("blah");

    public SelectionEditorPanel(MerlinData md, guiAction ... newBehaviorActionActions) {
        super(new Object[0]);
        this.d_md = md;
        this.d_activePanels = Collections.EMPTY_LIST;
        this.d_md.getEvents().addObserver(this);
        this.d_newCompGroupPnl = new NewCompGroupPnl(md);
        this.d_floorSortPnl = new FloorSortPnl(md);
        this.d_generateModelFromBIM = new GenerateModelSect(true);
        this.d_generateModelFromBIMSel = new GenerateModelSect(false);
        this.d_floorSect = new FloorSect();
        this.d_occCountSect = new OccCountSect(md);
        this.d_roomInfoSect = new RoomInfoSect();
        this.d_roomPropSect = new RoomPropSect();
        this.d_occSect = new OccEditorPanel(md);
        this.d_doorSect1 = new DoorSect1();
        this.d_doorSect2 = new DoorSect2();
        this.d_corrSect = new CorridorSect();
        this.d_extraCorrInfoSect1 = new CorridorExtraPnl1();
        this.d_extraCorrInfoSect2 = new CorridorExtraPnl2();
        this.d_stairSect = new StairSect();
        this.d_rampSect = new RampSect();
        this.d_boundsSect = new BoundsSect();
        this.d_blockageSect = new BlockageSect();
        this.d_blockageVisSect = new BlockageVisSect();
        this.d_cameraControlSect = new CameraControlSect();
        this.d_cameraOrientSect = new CameraOrientSect();
        this.d_cameraLimitsSect = new CameraLimitsSect();
        this.d_sceneGeomSect = new SceneGeomPnl();
        this.d_behaviorSect = new BehaviorSect();
        this.d_behaviorPropSect = new BehaviorPropSect();
        this.d_behaviorActSect = new BehaviorActionSect(newBehaviorActionActions);
        this.d_waitSect = new WaitSect();
        this.d_waitUntilSect = new WaitUntilSect();
        this.d_gotoWaypointSect = new GotoWaypointSect();
        this.d_gotoElevatorsSect = new GotoElevatorsSect();
        this.d_gotoExitsSect = new GotoExitsSect();
        this.d_gotoRoomsSect = new GotoRoomsSect();
        this.d_waitForAssistSect = new WaitForAssistanceSect();
        this.d_assistSect = new AssistSect();
        this.d_joinOccGroupSect = new JoinOccGroupSect();
        this.d_elevatorPropSect = new ElevatorDataPnl();
        this.d_elevatorLevelSect = new ElevatorLevelPnl();
        this.d_elevatorExtraSect = new ElevatorExtraPnl();
        this.d_profileFilterSect = new ProfileFilterPnl(md);
        this.d_occSourcePanel = new OccSourcePanel(md);
        this.d_occGroupSect = new OccGroupPnl(md);
        this.d_changeBehaviorSect = new ChangeBehaviorSect(md);
        this.d_changeProfileSect = new ChangeProfileSect(md);
        this.updatePanels();
        this.updateLayout();
    }

    @Override
    public void commit() {
        for (EditorPanel panel : this.d_activePanels) {
            panel.commit();
        }
    }

    private static boolean containsType(Set<?> objs, Class<?> type) {
        for (Object obj : objs) {
            if (!type.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    private List<EditorPanel> getActivePanels(Set<ICompElement> objs) {
        ArrayList<EditorPanel> activePanels = new ArrayList<EditorPanel>();
        MerlinSelectionModel sel = this.d_md.selection;
        if (objs.isEmpty()) {
            activePanels.add(this.d_floorSortPnl);
            activePanels.add(this.d_newCompGroupPnl);
            activePanels.add(this.d_generateModelFromBIM);
            return activePanels;
        }
        if (sel.isExclusive(Behavior.class, IBehaviorAction.class)) {
            activePanels.add(this.d_behaviorSect);
            if (sel.isExclusive(Behavior.class)) {
                activePanels.add(this.d_behaviorPropSect);
            } else if (sel.isExclusive(GotoWaypoint.class)) {
                activePanels.add(this.d_gotoWaypointSect);
            } else if (sel.isExclusive(GotoExits.class)) {
                activePanels.add(this.d_gotoExitsSect);
            } else if (sel.isExclusive(GotoElevators.class)) {
                activePanels.add(this.d_gotoElevatorsSect);
            } else if (sel.isExclusive(GotoRooms.class)) {
                activePanels.add(this.d_gotoRoomsSect);
            } else if (sel.isExclusive(Wait.class)) {
                activePanels.add(this.d_waitSect);
            } else if (sel.isExclusive(WaitUntil.class)) {
                activePanels.add(this.d_waitUntilSect);
            } else if (sel.isExclusive(WaitForAssistance.class)) {
                activePanels.add(this.d_waitForAssistSect);
            } else if (sel.isExclusive(AssistOccupants.class)) {
                activePanels.add(this.d_assistSect);
            } else if (sel.isExclusive(JoinOccGroup.class)) {
                activePanels.add(this.d_joinOccGroupSect);
            } else if (sel.isExclusive(ChangeBehavior.class)) {
                activePanels.add(this.d_changeBehaviorSect);
            } else if (sel.isExclusive(ChangeProfile.class)) {
                activePanels.add(this.d_changeProfileSect);
            }
            IFilteredCollection<IBehaviorAction> terminalActions = sel.get(IBehaviorAction.class, IBehaviorAction::isTerminal);
            if (terminalActions.isEmpty()) {
                activePanels.add(this.d_behaviorActSect);
            }
            return activePanels;
        }
        Set<Object> propTypes = Composite.getPropTypes(2, objs);
        Set<Object> unshared = Composite.getPropTypes(0, objs);
        GridBagHelper propgb = new GridBagHelper(new EditorPanel());
        propgb.d_rowSpace = 1;
        if (propTypes.contains(NamedMerlinObj.NAME)) {
            propgb = SelectionEditorPanel.prepareNewPropRow(propgb, activePanels, 1);
            guiTextField fldName = new guiTextField();
            Dimension d = fldName.getPreferredSize();
            fldName.setPreferredSize(new Dimension((int)(1.5 * (double)d.width), d.height));
            fldName.setToolTipText(Intl.intl("Name"));
            ((EditorPanel)propgb.getPanel()).addConnection(new NamePropConnection(fldName));
            propgb.addRow(fldName);
        }
        if (propTypes.contains(MerlinData.VISIBILITY)) {
            propgb = SelectionEditorPanel.prepareNewPropRow(propgb, activePanels, 1);
            guiMultiStateCheckBox ckVisible = new guiMultiStateCheckBox(Intl.intl("Visible"));
            ((EditorPanel)propgb.getPanel()).addConnection(new VisPropConnection(ckVisible));
            propgb.addRow(ckVisible, 0);
        }
        int colorCount = 0;
        if (propTypes.contains(MerlinData.COLOR)) {
            ++colorCount;
        }
        if (propTypes.contains(MerlinData.OPACITY)) {
            ++colorCount;
        }
        propgb = SelectionEditorPanel.prepareNewPropRow(propgb, activePanels, colorCount);
        if (propTypes.contains(ImportedGeom.PROP_MATERIAL)) {
            MaterialBtn btn = new MaterialBtn(true);
            ((EditorPanel)propgb.getPanel()).addConnection(new MaterialConn(btn));
            propgb.addRow(Intl.intl("Material:"), btn, 1.0, 0);
        }
        if (propTypes.contains(MerlinData.COLOR)) {
            JComponent lblComp;
            ColorButton cb = SelectionEditorPanel.newColorButton();
            ((EditorPanel)propgb.getPanel()).addConnection(new ColorConn(cb));
            if (sel.isDeepEmpty(ImportedGeom.class)) {
                guiMultiStateCheckBox colorCB = new guiMultiStateCheckBox(Intl.intl("Color:"));
                LinkStatus.link((AbstractButton)colorCB, cb);
                ((EditorPanel)propgb.getPanel()).addConnection(new BoolPropConnection(new ColorDefProp(), colorCB));
                lblComp = colorCB;
            } else {
                lblComp = new guiLabel(Intl.intl("Color:"));
            }
            propgb.addRow(lblComp, cb, 1.0, 0);
        }
        if (propTypes.contains(MerlinData.OPACITY)) {
            MerlinUDF opacityFld = new MerlinUDF(NonSI.PERCENT);
            ((EditorPanel)propgb.getPanel()).addConnection(new OpacityConn(opacityFld));
            propgb.addRow(Intl.intl("Opacity:"), opacityFld, 1.0);
        }
        SelectionEditorPanel.finalizePropPnl(propgb, activePanels);
        for (ICompElement ice : objs) {
            if (!(ice instanceof IMerlinGeomSrc)) continue;
            activePanels.add(this.d_boundsSect);
            break;
        }
        if (propTypes.contains(Floor.WORKING_Z) && propTypes.contains(Floor.ZMIN_FILTER) && propTypes.contains(Floor.ZMAX_FILTER)) {
            activePanels.add(this.d_floorSect);
        }
        if (sel.isExclusive(EgressAgentComp.class)) {
            activePanels.add(this.d_occCountSect);
        }
        if (propTypes.contains(EgressAgent.PROFILE) && propTypes.contains(EgressAgent.BEHAVIOR)) {
            activePanels.addAll(this.d_occSect.getPanels());
        }
        if (sel.isExclusive(OccSourceObj.class)) {
            activePanels.addAll(this.d_occSourcePanel.getPanels());
        }
        if (propTypes.contains(EgressDoor.WIDTH)) {
            activePanels.add(this.d_doorSect1);
            activePanels.add(this.d_doorSect2);
        }
        boolean includeRoom = false;
        if (propTypes.contains(EgressStair.TREAD_RISE) && propTypes.contains(EgressStair.TREAD_RUN)) {
            activePanels.add(this.d_stairSect);
            includeRoom = true;
        }
        if (propTypes.contains(EgressCorridor.SLOPE) && !propTypes.contains(EgressStair.TREAD_RISE)) {
            activePanels.add(this.d_rampSect);
            includeRoom = true;
        }
        if (propTypes.contains(EgressCorridor.BOTTOM_DOOR) && propTypes.contains(EgressCorridor.TOP_DOOR) && propTypes.contains(EgressCorridor.LENGTH) && propTypes.contains(EgressCorridor.WIDTH)) {
            activePanels.remove(this.d_boundsSect);
            activePanels.add(this.d_corrSect);
            activePanels.add(this.d_extraCorrInfoSect1);
            activePanels.add(this.d_extraCorrInfoSect2);
            includeRoom = false;
        }
        if (sel.isExclusive(EgressBlockage.class)) {
            activePanels.add(this.d_blockageSect);
            activePanels.add(this.d_blockageVisSect);
        }
        if (includeRoom || unshared.contains(IEgressOccupiable.AREA) && unshared.contains(IEgressOccupiable.OCC_COUNT)) {
            activePanels.add(this.d_roomInfoSect);
        }
        if (propTypes.contains(IEgressOccupiable.SPEED_MODIFIER) && !sel.isDeepEmpty(EgressRoom.class)) {
            activePanels.add(this.d_roomPropSect);
        }
        if (unshared.contains(Elevator.PROP_OPEN_DELAY)) {
            activePanels.add(this.d_elevatorPropSect);
        }
        if (unshared.contains(Elevator.PROP_DISCHARGE_FLOOR)) {
            activePanels.add(this.d_elevatorLevelSect);
            activePanels.add(this.d_elevatorExtraSect);
        }
        if (MerlinApp.isFP() && propTypes.contains(Camera.PROP_SECURITY)) {
            activePanels.add(this.d_cameraControlSect);
            activePanels.add(this.d_cameraOrientSect);
            activePanels.add(this.d_cameraLimitsSect);
        }
        if (propTypes.contains(OccGroupObj.PROP_NAME) && !sel.contains(OccGroupTypeObj.class)) {
            activePanels.addAll(this.d_occGroupSect.getPanels());
        }
        if (OccProfile.CompRestrictions.allAcceptableTypes(sel)) {
            activePanels.add(this.d_profileFilterSect);
        }
        if (propTypes.contains(ImportedGeom.PROP_OBJECT_TYPE) && propTypes.contains(ImportedGeom.PROP_IMPORTED_TYPE)) {
            activePanels.add(this.d_sceneGeomSect);
            activePanels.add(this.d_generateModelFromBIMSel);
        }
        return activePanels;
    }

    private static ColorButton newColorButton() {
        ColorButton cb = new ColorButton(1);
        cb.setText(Intl.intl("<multiple>"));
        Insets margin = cb.getMargin();
        cb.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        return cb;
    }

    private static GridBagHelper prepareNewPropRow(GridBagHelper gb, List<EditorPanel> panels, int rowsToAdd) {
        if (gb.getCurrentRow() + rowsToAdd > 3) {
            panels.add((EditorPanel)gb.getPanel());
            EditorPanel panel = new EditorPanel();
            gb = new GridBagHelper(panel);
            gb.d_rowSpace = 1;
        }
        return gb;
    }

    private static void finalizePropPnl(GridBagHelper gb, List<EditorPanel> panels) {
        if (gb.getCurrentRow() > 0) {
            panels.add((EditorPanel)gb.getPanel());
        }
    }

    public void updatePanels() {
        MerlinSelectionModel sel = this.d_md.selection;
        for (EditorPanel panel : this.d_activePanels) {
            panel.release();
        }
        Set<ICompElement> objs = sel.getSelected(ICompElement.class);
        this.d_activePanels = this.getActivePanels(objs);
        for (EditorPanel pp : this.d_activePanels) {
            pp.bind(objs);
        }
    }

    private void updateLayout() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectionEditorPanel.this.removeAll();
                for (EditorPanel panel : SelectionEditorPanel.this.d_activePanels) {
                    SelectionEditorPanel.this.addSeparator();
                    SelectionEditorPanel.this.addSection(panel);
                }
                SelectionEditorPanel.this.revalidate();
                SelectionEditorPanel.this.repaint();
            }
        });
    }

    @Override
    public void update(Events events) {
        for (EventChannel channel : events.getChannels()) {
            if (!channel.containsChange(MerlinData.SELECTION_CHANGED) && !channel.containsChange(MerlinData.CHILD_ADDED) && !channel.containsChange(MerlinData.CHILD_REMOVED)) continue;
            this.updatePanels();
            this.updateLayout();
            break;
        }
        for (EditorPanel panel : this.d_activePanels) {
            panel.update(events);
        }
    }

    private static String format(IEgressFlowrate value, guiUnitDoubleField flowFld) {
        if (value == null) {
            return "";
        }
        if (value instanceof IEgressFlowrate.FromDensity) {
            return Intl.intl("<from density>");
        }
        IEgressFlowrate.Limited limited = (IEgressFlowrate.Limited)value;
        if (Double.isInfinite(limited.maxVal.getValueNoUnit())) {
            return Intl.intl("<unlimited>");
        }
        flowFld.setValue(limited.maxVal);
        return flowFld.getText();
    }

    private static UnitDouble getDoorWidth(ICompElement obj) {
        Object width = obj.getProperty(EgressDoor.WIDTH);
        if (width instanceof Double) {
            return new UnitDouble((Double)width, SI.METER);
        }
        if (width instanceof UnitDouble) {
            return (UnitDouble)width;
        }
        return new UnitDouble(0.0, SI.METER);
    }

    private static void addFlowrate(EditorPanel panel, GridBagHelper gb) {
        final MerlinUDF tempFld = new MerlinUDF(13);
        final UnitDouble UD_UNLIMITED = SIUS.newud(Double.POSITIVE_INFINITY, 13);
        final UnitDouble UD_FROM_DENSITY = SIUS.newud(0.0, 13);
        guiComboBox<IEgressFlowrate> flowrateCB = new guiComboBox<IEgressFlowrate>(new IEgressFlowrate[]{IEgressFlowrate.UNLIMITED}){

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                Validateable v;
                Component c;
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                if (!this.isEnabled()) {
                    return true;
                }
                return !this.isEditable() || !((c = this.getEditor().getEditorComponent()) instanceof Validateable) || (v = (Validateable)((Object)c)).validateData(showWarn, allowModify);
            }
        };
        flowrateCB.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText(SelectionEditorPanel.format((IEgressFlowrate)value, tempFld));
                return this;
            }
        });
        flowrateCB.setEditable(true);
        flowrateCB.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                MerlinUDF flowFld = new MerlinUDF(13);
                flowFld.setBorder(null);
                flowFld.aliasValue(null, "");
                flowFld.aliasValue(UD_UNLIMITED, SelectionEditorPanel.format(IEgressFlowrate.UNLIMITED, tempFld));
                flowFld.aliasValue(UD_FROM_DENSITY, SelectionEditorPanel.format(IEgressFlowrate.FROM_DENSITY, tempFld));
                return flowFld;
            }

            @Override
            public Object getItem() {
                guiUnitDoubleField flowFld = this.getField();
                if (!this.getField().validateData(true, true)) {
                    return null;
                }
                UnitDouble val = (UnitDouble)flowFld.getValue();
                if (val == null) {
                    return null;
                }
                if (val == UD_UNLIMITED) {
                    return IEgressFlowrate.UNLIMITED;
                }
                if (val == UD_FROM_DENSITY) {
                    return IEgressFlowrate.FROM_DENSITY;
                }
                return new IEgressFlowrate.Limited(val);
            }

            @Override
            public void setItem(Object anObject) {
                guiUnitDoubleField flowFld = this.getField();
                UnitDouble val = anObject == null ? null : (anObject instanceof IEgressFlowrate.FromDensity ? UD_FROM_DENSITY : ((IEgressFlowrate.Limited)anObject).maxVal);
                flowFld.setValue(val);
            }

            private guiUnitDoubleField getField() {
                return (guiUnitDoubleField)this.getEditorComponent();
            }
        });
        final ComboPropConn<IEgressFlowrate> comboProp = new ComboPropConn<IEgressFlowrate>(new FlowrateProp(), flowrateCB);
        panel.addConnection(comboProp);
        guiMultiStateCheckBox overrideParentCB = new guiMultiStateCheckBox(Intl.intl("Flow Rate:"));
        String overrideTT = "<html>" + Intl.intl("If checked, sets a custom flow rate limit for selected doors.<br>If unchecked, uses the default flow rate limit set in the <b>Simulation Parameters</b>.") + "</html>";
        overrideParentCB.setToolTipText(overrideTT);
        panel.addConnection(new BoolPropConnection(new FlowrateOverrideProp(), overrideParentCB){

            @Override
            public void apply(CompElementActions.IObjectProp<ICompElement, Boolean> prop, Collection<? extends ICompElement> objs, Boolean val) {
                super.apply(prop, objs, val);
                comboProp.initFromProp();
            }
        });
        LinkStatus.link((AbstractButton)overrideParentCB, flowrateCB);
        gb.addRow(overrideParentCB, flowrateCB, 0, 1.0);
    }

    private static void addTagCheckBox(EditorPanel panel, GridBagHelper gb, IPropertySet.Prop<Set<String>> tagProp, final String tag) {
        guiMultiStateCheckBox refugeCB = new guiMultiStateCheckBox(Intl.intl("Refuge Area"));
        refugeCB.setToolTipText(Intl.intl("Specifies whether the component is considered a refuge area."));
        CompElementActions.DefProp<ICompElement, Boolean> prop = new CompElementActions.DefProp<ICompElement, Boolean>(tagProp){

            @Override
            protected Object get(MerlinData md, Object prop, ICompElement obj) {
                Object val = obj.getProperty(prop);
                if (val instanceof Set) {
                    return ((Set)val).contains(tag);
                }
                return val;
            }

            @Override
            public void set(MerlinData md, Collection<? extends ICompElement> objs, Boolean newVal) {
                if (newVal != null && !newVal.booleanValue()) {
                    Collection<IEgressOccupiable> rooms = MerlinUtil.flatten(objs, IEgressOccupiable.class);
                    Set<Object> roomsSet = rooms instanceof Set ? (Set<Object>)rooms : new IdentityHashSet<IEgressOccupiable>(rooms);
                    LinkedIdentityHashSet gotoRooms = new LinkedIdentityHashSet();
                    Dependencies.getObjReferences(md, IEgressOccupiable.class, Filters.accept(roomsSet, ICompElement.class), (obj, target) -> {
                        if (obj instanceof GotoRooms && ((GotoRooms)obj).getFilter().equals(RefugeFilter.INSTANCE)) {
                            gotoRooms.add((GotoRooms)obj);
                        }
                    });
                    if (!gotoRooms.isEmpty()) {
                        Undo.insertUndoEntry_propRestore(md, gotoRooms, GotoRooms.PROP_ROOMS);
                        for (GotoRooms gr : gotoRooms) {
                            LinkedIdentityHashSet<IEgressOccupiable> grrooms = new LinkedIdentityHashSet<IEgressOccupiable>((Collection<IEgressOccupiable>)gr.getRooms());
                            grrooms.removeAll(roomsSet);
                            gr.setRooms(grrooms);
                        }
                    }
                }
                super.set(md, objs, newVal);
            }

            @Override
            protected void set(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
                Object val = obj.getProperty(prop);
                if (newVal != null && val instanceof Set) {
                    HashSet<String> tags = (HashSet<String>)val;
                    if (newVal.booleanValue() && !tags.contains(tag)) {
                        tags = new HashSet<String>(tags);
                        tags.add(tag);
                    } else if (!newVal.booleanValue() && tags.contains(tag)) {
                        tags = new HashSet(tags);
                        tags.remove(tag);
                    }
                    obj.setProperty(prop, tags);
                }
            }
        };
        panel.addConnection(new BoolPropConnection((CompElementActions.IObjectProp<ICompElement, Boolean>)prop, refugeCB));
        gb.addRow(refugeCB, 0);
    }

    private static void addSpeedModifier(EditorPanel panel, GridBagHelper gb) {
        HTMLBtn velBtn = new HTMLBtn("");
        ValueField<UnitDouble> velFld = MerlinValueFields.udFld(5);
        UDVarEditor velEditor = new UDVarEditor(velFld);
        panel.addConnection(new VariantProp<UnitDouble>(Intl.intl("Constant Speed"), new SpeedModifierValProp(SpeedModifier.Type.CONSTANT), velBtn, velEditor));
        HTMLBtn factorBtn = new HTMLBtn("");
        ValueField<UnitDouble> factorFld = MerlinValueFields.udFld(11);
        UDVarEditor factorEditor = new UDVarEditor(factorFld);
        panel.addConnection(new VariantProp<UnitDouble>(Intl.intl("Speed Modifier"), new SpeedModifierValProp(SpeedModifier.Type.FACTOR), factorBtn, factorEditor));
        final CardLayout cardLayout = new CardLayout();
        final guiPanel cardPnl = new guiPanel(cardLayout);
        String VEL_CARD = "VEL";
        String FACTOR_CARD = "FACTOR";
        cardPnl.add((Component)velBtn, "VEL");
        cardPnl.add((Component)factorBtn, "FACTOR");
        final guiComboBox<SpeedModifier.Type> typesCB = new guiComboBox<SpeedModifier.Type>(SpeedModifier.Type.values());
        typesCB.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SpeedModifier.Type) {
                    SpeedModifier.Type mod = (SpeedModifier.Type)((Object)value);
                    this.setText(mod.name);
                    list.setToolTipText(mod.shortDesc);
                    typesCB.setToolTipText(mod.shortDesc);
                }
                return this;
            }
        });
        ComboPropConn<SpeedModifier.Type> typeConn = new ComboPropConn<SpeedModifier.Type>((CompElementActions.IObjectProp)new SpeedModifierTypeProp(), typesCB){

            @Override
            public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<SpeedModifier.Type> comp) {
                super.initFromProp(prop, objs, comp);
                SpeedModifier.Type newSel = comp.getSelectedItem();
                if (newSel != null) {
                    cardPnl.setEnabled(true);
                    switch (newSel) {
                        case CONSTANT: {
                            cardLayout.show(cardPnl, "VEL");
                            break;
                        }
                        default: {
                            cardLayout.show(cardPnl, "FACTOR");
                            break;
                        }
                    }
                } else {
                    cardPnl.setEnabled(false);
                }
                boolean constantEnabled = false;
                objs = MerlinUtil.flatten(objs, ICompElement.class);
                IFilteredCollection<EgressCorridor> corridors = theUtil.filter(objs, EgressCorridor.class);
                if (corridors.isExclusive()) {
                    constantEnabled = true;
                    for (EgressCorridor corr : corridors) {
                        if (corr.getDirection() != EgressDoorDir.ALL) continue;
                        constantEnabled = false;
                        break;
                    }
                }
                comp.setEnabled(constantEnabled);
            }
        };
        panel.addConnection(typeConn);
        gb.addRow(typesCB, cardPnl);
    }

    private static void addCapacityEditor(EditorPanel panel, GridBagHelper gb) {
        CapacityEditor editor = new CapacityEditor();
        CompElementActions.DefProp<ICompElement, IFunction1d> prop = new CompElementActions.DefProp<ICompElement, IFunction1d>(AEgressComp.PROP_CAPACITY);
        final ValEditorConn connection = new ValEditorConn(prop, editor);
        panel.addConnection(connection);
        editor.addConnection(connection);
        guiMultiStateCheckBox enableCapacityCb = new guiMultiStateCheckBox(Intl.intl("Capacity:"));
        String enableCapacityTT = "<html>" + Intl.intl("If checked, sets a custom capacity limit for selected components.<br>If unchecked, no capacity limit is used for selected components.") + "</html>";
        enableCapacityCb.setToolTipText(enableCapacityTT);
        panel.addConnection(new BoolPropConnection(new CompElementActions.DefProp(AEgressComp.PROP_CAPACITY_ENABLED), enableCapacityCb){

            @Override
            public void apply(CompElementActions.IObjectProp<ICompElement, Boolean> prop, Collection<? extends ICompElement> objs, Boolean val) {
                super.apply(prop, objs, val);
                connection.initFromProp();
            }
        });
        LinkStatus.link((AbstractButton)enableCapacityCb, editor);
        gb.addRow(enableCapacityCb, editor, 0, 1.0);
    }

    private static void addCorridorDoorState(EditorPanel pnl, GridBagHelper gb) {
        HTMLBtn stateBtn = new HTMLBtn("");
        DiscreteVarEditor varEditor = new DiscreteVarEditor(true, Intl.intl("Open"), false, Intl.intl("Closed"));
        pnl.addConnection(new VariantProp(Intl.intl("Door State"), new CompElementActions.DefProp(IEgressConnector.STATE), stateBtn, varEditor));
        gb.addRow(Intl.intl("State:"), stateBtn, 1.0, 0);
    }

    private static void addConnectorState(EditorPanel pnl, GridBagHelper gb) {
        HTMLBtn stateBtn = new HTMLBtn("");
        DiscreteVarEditor<EgressDoorDir> varEditor = new DiscreteVarEditor<EgressDoorDir>(EgressDoorDir.getMap(Predicates.alwaysTrue()));
        pnl.addConnection(new VariantProp<EgressDoorDir>(Intl.intl("Door State"), new CompElementActions.DefProp(IEgressConnector.STATE), stateBtn, varEditor));
        gb.addRow(Intl.intl("State:"), stateBtn, 1.0, 0);
    }

    private static void adjustHeight(JComponent comp) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, SelectionEditorPanel.s_dmyLbl.getPreferredSize().height - 2));
    }

    private static Set<Elevator> getElevators(Collection<? extends ICompElement> objs) {
        LinkedIdentityHashSet<Elevator> elevators = new LinkedIdentityHashSet<Elevator>();
        for (ICompElement iCompElement : objs) {
            if (iCompElement instanceof Elevator) {
                elevators.add((Elevator)iCompElement);
                continue;
            }
            if (!(iCompElement instanceof Composite)) continue;
            elevators.addAll(((Composite)iCompElement).getDeepMembers(Elevator.class));
        }
        return elevators;
    }

    private static <T> Collection<T> filter(Collection<?> objs, Class<T> clazz) {
        return theUtil.filter(objs, clazz);
    }

    public static <ObjT extends ICompElement, PropT> void setPropRecursive(String actionName, CompElementActions.IObjectProp<ObjT, PropT> prop, Collection<? extends ObjT> objs, PropT newVal) {
        Undo.begin(actionName);
        MerlinData md = MerlinApp.getApp().getData();
        prop.set(md, objs, newVal);
        Undo.end(MerlinApp.getApp().getData());
    }

    public static class EditorPanel
    extends guiPanel
    implements IPropConnection {
        private List<IPropConnection> d_conns = new LinkedList<IPropConnection>();
        private Collection<ICompElement> d_objs = Collections.EMPTY_LIST;

        @Override
        public void update(Events events) {
            for (IPropConnection conn : this.d_conns) {
                conn.update(events);
            }
        }

        @Override
        public void commit() {
            for (IPropConnection conn : this.d_conns) {
                conn.commit();
            }
        }

        protected void addConnection(IPropConnection conn) {
            this.d_conns.add(conn);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = objs;
            for (IPropConnection conn : this.d_conns) {
                conn.bind(objs);
            }
        }

        @Override
        public void release() {
            for (IPropConnection conn : this.d_conns) {
                conn.release();
            }
            this.d_objs = Collections.EMPTY_LIST;
        }

        public Collection<ICompElement> getObjects() {
            return this.d_objs;
        }
    }

    private static class VisPropConnection
    extends BoolPropConnection {
        public VisPropConnection(guiMultiStateCheckBox control) {
            super((CompElementActions.IObjectProp<ICompElement, Boolean>)new CompElementActions.DefProp<ICompElement, Boolean>(MerlinData.VISIBILITY){

                @Override
                public void set(MerlinData md, Collection<? extends ICompElement> objs, Boolean newVal) {
                    Collection<Object> toShow = Collections.EMPTY_LIST;
                    Collection<Object> toHide = Collections.EMPTY_LIST;
                    if (newVal.booleanValue()) {
                        toShow = objs;
                    } else {
                        toHide = objs;
                    }
                    Visibility.setVisibility(MerlinApp.getApp().getData(), toShow, toHide, true);
                }
            }, control);
        }
    }

    public static class BoolPropConnection
    extends APropConnection<guiMultiStateCheckBox> {
        public BoolPropConnection(CompElementActions.IObjectProp<ICompElement, Boolean> prop, guiMultiStateCheckBox control) {
            super(prop, control);
            control.addItemListener(this);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            if (comp.getState() != 2) {
                Boolean newval = comp.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                this.apply((CompElementActions.IObjectProp)prop, objs, newval);
            }
        }

        public void apply(CompElementActions.IObjectProp<ICompElement, Boolean> prop, Collection<? extends ICompElement> objs, Boolean val) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof Boolean) {
                comp.setMode(0);
                Boolean b = (Boolean)val;
                if (b.booleanValue()) {
                    comp.setSelected(true);
                } else {
                    comp.setSelected(false);
                }
            } else {
                comp.setMode(1);
                comp.setState(2);
                ItemEvent evt = new ItemEvent(comp.getModel(), 2000, comp.getModel(), 2);
                for (ItemListener il : comp.getItemListeners()) {
                    il.itemStateChanged(evt);
                }
            }
            comp.setModified(false);
        }
    }

    public static class DistributionConn<T>
    extends APropConnection<AValEditor<IUrn<T>>> {
        private final String setPropMsg;

        public DistributionConn(Object prop, AValEditor<IUrn<T>> comp, String setPropMsg) {
            super(prop, comp);
            this.setPropMsg = setPropMsg;
            comp.addValueListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, AValEditor<IUrn<T>> comp) {
            IUrn<T> dist = comp.getValue();
            SelectionEditorPanel.setPropRecursive(this.setPropMsg, (CompElementActions.IObjectProp)prop, objs, dist);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, AValEditor<IUrn<T>> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof IUrn) {
                comp.setValue((IUrn)val);
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }
    }

    public static class NamePropConnection
    extends TextPropConnection {
        public NamePropConnection(guiTextField control) {
            super(NamedMerlinObj.NAME, control);
        }

        protected void setProp(MerlinData md, Object prop, Collection<ICompElement> objs, String newText) {
            RenameAction.rename(md, objs, newText);
        }
    }

    public static class TextPropConnection
    extends APropConnection<guiTextField> {
        public TextPropConnection(Object prop, guiTextField control) {
            super(prop, control);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiTextField comp) {
            Object val = Composite.getProperty(prop, objs);
            if (val instanceof String) {
                String s = (String)val;
                comp.setValue(s);
                comp.setCaretPosition(0);
            } else {
                comp.setText("");
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiTextField comp) {
            if (!comp.getText().isEmpty() && comp.isModified() && comp.validateData(false, true)) {
                MerlinData md = MerlinApp.getApp().getData();
                assert (md != null);
                this.setProp(prop, objs, comp.getValue());
                comp.setModified(false);
            }
            comp.selectAll();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object newText) {
            MerlinData md = MerlinApp.getApp().getData();
            Undo.begin(Intl.intl("Set Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, newText, objs);
            Undo.end(md);
        }
    }

    public static class NumberPropConn<NT>
    extends APropConnection<guiValueField<NT>> {
        private final Class<NT> d_type;

        public NumberPropConn(CompElementActions.IObjectProp<ICompElement, NT> prop, guiValueField<NT> control, Class<NT> type) {
            super(prop, control);
            this.d_type = type;
            control.setEmptyAllowed(true);
            control.addFocusListener(this);
            control.addKeyListener(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiValueField<NT> comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            this.initFromVal(val, comp);
        }

        public void initFromVal(Object val, guiValueField<NT> comp) {
            if (this.d_type.isInstance(val)) {
                comp.setValue(this.d_type.cast(val));
            } else {
                comp.setValue(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiValueField<NT> comp) {
            if (comp.validateData(false, true)) {
                if (comp.getValue() != null) {
                    this.apply((CompElementActions.IObjectProp)prop, objs, comp.getValue());
                    this.initFromProp(prop, objs, comp);
                }
            } else {
                comp.setValue(comp.getValue());
            }
            comp.selectAll();
        }

        protected void apply(CompElementActions.IObjectProp<ICompElement, NT> prop, Collection<? extends ICompElement> objs, NT val) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Property"), prop, objs, val);
        }
    }

    public static class IntPropConn
    extends NumberPropConn<Integer> {
        public IntPropConn(CompElementActions.IObjectProp<ICompElement, Integer> prop, guiIntField control) {
            super(prop, control, Integer.class);
        }
    }

    public static class DoublePropConn
    extends NumberPropConn<Double> {
        public DoublePropConn(CompElementActions.IObjectProp<ICompElement, Double> prop, guiDoubleField control) {
            super(prop, control, Double.class);
        }
    }

    public static class UDPropConnection
    extends NumberPropConn<UnitDouble> {
        public UDPropConnection(CompElementActions.IObjectProp<ICompElement, UnitDouble> prop, guiUnitDoubleField control) {
            super(prop, control, UnitDouble.class);
        }
    }

    private static class DToUDProp<ObjT>
    implements CompElementActions.IObjectProp<ObjT, UnitDouble> {
        private final Unit d_storageUnit;
        private final CompElementActions.IObjectProp<ObjT, Double> d_dProp;

        public DToUDProp(Unit storageUnit, CompElementActions.IObjectProp<ObjT, Double> dProp) {
            this.d_storageUnit = storageUnit;
            this.d_dProp = dProp;
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ObjT> objs) {
            Object v = this.d_dProp.get(md, objs);
            return v instanceof Double ? new UnitDouble((Double)v, this.d_storageUnit) : v;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ObjT> objs, UnitDouble newVal) {
            this.d_dProp.set(md, objs, newVal.getValue(this.d_storageUnit));
        }
    }

    private static class MaterialProp
    extends CompElementActions.DefProp<ICompElement, IMaterial> {
        private static final IElemSource<Point2d> DEFUV = TexMappers.newPlanarCoordMapper(new Point3d(0.0, 0.0, 0.0));

        public MaterialProp() {
            super(ImportedGeom.PROP_MATERIAL);
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
            return super.get(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs));
        }

        private IMaterial[] getMats(MerlinData md, Object prop, ICompElement obj) {
            IMaterial[] mats = (IMaterial[])obj.getProperty(prop);
            if (mats.length > 1 && MerlinUtil.isUniform(mats)) {
                mats = new IMaterial[]{mats[0]};
            }
            return mats;
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            IMaterial[] mats = this.getMats(md, prop, obj);
            if (mats.length == 0) {
                return null;
            }
            if (mats.length == 1) {
                return mats[0];
            }
            return ICompElement.NON_UNIFORM;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, IMaterial newVal) {
            super.set(md, CompElementActions.flattenToLocallyDefined(this.getProp(), objs), newVal);
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, IMaterial newVal) {
            IMaterial[] oldMats = this.getMats(md, prop, obj);
            if (oldMats.length == 1 && oldMats[0] == newVal) {
                return;
            }
            IGeomNode newGeom = (IGeomNode)obj.getProperty(ImportedGeom.PROP_GEOM);
            if (!MaterialProp.needsTexCoords(newVal)) {
                newGeom = newGeom.applyUniformProp(Elements.UV, Collections.emptyMap());
            } else {
                Set<String> uvSets = newVal.getAttributes().getUVSets();
                if (oldMats.length == 1) {
                    ListMap<String, IElemSource<Point2d>> newUV = new ListMap<String, IElemSource<Point2d>>();
                    for (String set : uvSets) {
                        newUV.put(set, DEFUV);
                    }
                    newGeom = newGeom.applyUniformProp(Elements.UV, newUV);
                } else {
                    for (String uvSet : uvSets) {
                        newGeom = newGeom.applyUVElements(uvSet, (m, oldUV) -> {
                            IMaterial oldMat = oldMats[m];
                            return oldMat != newVal ? DEFUV : oldUV;
                        });
                    }
                }
            }
            obj.setProperty(ImportedGeom.PROP_GEOM, newGeom);
            obj.setProperty(prop, new IMaterial[]{newVal});
        }

        private static boolean needsTexCoords(IMaterial mat) {
            if (mat == null) {
                return false;
            }
            for (MatChannel chnl : MatChannel.values()) {
                if (mat.getAttributes().getTexture(chnl) == null) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, IMaterial newVal) {
            Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_DISPLAY_PROPS);
            Undo.insertUndoEntry_propRestore(md, objs, ImportedGeom.PROP_GEOM);
        }
    }

    public static abstract class APropConnection<T extends JComponent>
    extends APropEditorListener
    implements IPropConnection {
        private static final int TYPE_DELAY = 200;
        private Object d_prop;
        private T d_control;
        private Collection<ICompElement> d_data;
        private Action d_listenerAction;
        private Semaphore d_lock;
        private boolean d_live;

        public APropConnection(Object prop, T control) {
            this.d_prop = prop;
            this.d_control = control;
            this.d_live = true;
            this.d_lock = new Semaphore(1);
            this.d_listenerAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.onControlChanged();
                }
            };
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            ((JComponent)this.d_control).getInputMap().put(enter, "enter");
            ((JComponent)this.d_control).getActionMap().put("enter", this.d_listenerAction);
        }

        protected Object getProp() {
            return this.d_prop;
        }

        public T getControl() {
            return this.d_control;
        }

        public void setUpdateLock(Semaphore lock) {
            this.d_lock = lock;
        }

        public Semaphore getUpdateLock() {
            return this.d_lock;
        }

        protected boolean isLocked() {
            return this.d_lock.availablePermits() == 0;
        }

        public Collection<ICompElement> getObjs() {
            return this.d_data;
        }

        protected boolean isDataEmpty() {
            return this.d_data == null || this.d_data.isEmpty();
        }

        protected boolean isModified(T comp) {
            return !(this.d_control instanceof Modifiable) || ((Modifiable)this.d_control).isModified();
        }

        protected void setModified(T comp, boolean modified) {
            if (comp instanceof Modifiable) {
                ((Modifiable)comp).setModified(modified);
            }
        }

        public abstract void setProp(Object var1, Collection<? extends ICompElement> var2, T var3);

        public abstract void initFromProp(Object var1, Collection<? extends ICompElement> var2, T var3);

        @Override
        public void keyPressed(KeyEvent evt) {
        }

        public void setLive(boolean live) {
            this.d_live = live;
        }

        public boolean isLive() {
            return this.d_live;
        }

        @Override
        public void onControlChanged() {
            if (this.d_live) {
                this.commit();
            }
        }

        @Override
        public void commit() {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty() || !this.isModified(this.d_control)) {
                    return;
                }
                MerlinData md = MerlinApp.getApp().getData();
                md.pauseUpdates();
                this.setProp(this.d_prop, this.d_data, this.d_control);
                md.resumeUpdates();
                this.setModified(this.d_control, false);
            }
            finally {
                this.d_lock.release();
            }
        }

        @Override
        public void update(Events events) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (this.isDataEmpty()) {
                    return;
                }
                this.initFromProp();
            }
            finally {
                this.d_lock.release();
            }
        }

        protected void initFromProp() {
            this.initFromProp(this.d_prop, this.d_data, this.d_control);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_data = objs;
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!d_lock.tryAcquire()) {
                        return;
                    }
                    try {
                        if (this.isDataEmpty()) {
                            return;
                        }
                        this.initFromProp();
                    }
                    finally {
                        d_lock.release();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }

        @Override
        public void release() {
            this.d_data = Collections.EMPTY_LIST;
        }
    }

    public static abstract class APropEditorListener
    implements ItemListener,
    FocusListener,
    KeyListener,
    ActionListener,
    IEventObserver {
        public abstract void onControlChanged();

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.onControlChanged();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                this.onControlChanged();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.onControlChanged();
        }
    }

    public static interface IPropConnection
    extends IEventObserver {
        public void bind(Collection<ICompElement> var1);

        public void release();

        public void commit();
    }

    private static class OccGroupPnl
    extends EditorPanel {
        private EditorPanel panel1;
        private EditorPanel panel2;

        public OccGroupPnl(MerlinData md) {
            String followLeaderLbl = Intl.intl("Follow Leader:");
            guiMultiStateCheckBox cbFollowLeader = new guiMultiStateCheckBox(followLeaderLbl);
            cbFollowLeader.setToolTipText(Intl.intl("Whether the group should follow a leader."));
            guiMultiStateCheckBox cbRespectSocialDist = new guiMultiStateCheckBox((String)OccGroupsPanel.SOCIAL_DIST_IN_GROUP_LBL.v1);
            cbRespectSocialDist.setToolTipText((String)OccGroupsPanel.SOCIAL_DIST_IN_GROUP_LBL.v2);
            MerlinComboBox<EgressAgent> leaderCb = new MerlinComboBox<EgressAgent>(md, EgressAgent.class);
            LinkStatus.link2((AbstractButton)cbFollowLeader, leaderCb);
            MerlinUDF maxDistanceFld = new MerlinUDF(0, DoubleVR.above(0.0, true));
            MerlinUDF slowdownTimeFld = new MerlinUDF((Unit)SI.SECOND, UnitDoubleVR.above(0.0, SI.SECOND, true));
            guiLabel lMaxDist = new guiLabel((String)OccGroupsPanel.MAX_DIST_LBL.v1);
            lMaxDist.setToolTipText((String)OccGroupsPanel.MAX_DIST_LBL.v2);
            ColorButton colorBtn = SelectionEditorPanel.newColorButton();
            int height = (int)colorBtn.getPreferredSize().getHeight();
            colorBtn.setPreferredSize(new Dimension(70, height));
            this.panel1 = new EditorPanel();
            this.panel2 = new EditorPanel();
            GridBagHelper gb = new GridBagHelper(this.panel1);
            gb.d_rowSpace = 2;
            gb.addRow(lMaxDist, maxDistanceFld, 1.0, GridBagHelper.REMAINING);
            guiLabel lSlowDown = new guiLabel(Intl.intl("Slowdown Time:"));
            lSlowDown.setToolTipText(Intl.intl("Time interval during which the group will keep slowing down after it is disconnected."));
            gb.addRow(lSlowDown, slowdownTimeFld, 1.0, GridBagHelper.REMAINING);
            gb.addRow(cbFollowLeader, leaderCb, 1.0, GridBagHelper.REMAINING);
            gb = new GridBagHelper(this.panel2);
            gb.d_rowSpace = 2;
            gb.addRow(cbRespectSocialDist, 1.0, GridBagHelper.REMAINING);
            gb.addRow(Intl.intl("Movement Group Color:"), colorBtn);
            gb.finalizeRows();
            CompElementActions.DefProp<ICompElement, EgressAgent> leaderProp = new CompElementActions.DefProp<ICompElement, EgressAgent>(OccGroupObj.PROP_GROUP_LEADER);
            this.panel1.addConnection(new FollowGroupLeaderPropConn(new CompElementActions.DefProp<ICompElement, Boolean>(OccGroupObj.PROP_REQUIRES_GROUP_LEADER), leaderProp, cbFollowLeader, md));
            this.panel1.addConnection(new GroupLeaderPropConn<EgressAgent>(leaderProp, leaderCb));
            this.panel1.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(OccGroupObj.PROP_MAX_DISTANCE), maxDistanceFld));
            this.panel1.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(OccGroupObj.PROP_SLOWDOWN_TIME), slowdownTimeFld));
            this.panel2.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP), cbRespectSocialDist));
            this.panel2.addConnection(new ColorConn(colorBtn, OccGroupObj.PROP_COLOR));
        }

        public List<EditorPanel> getPanels() {
            return Arrays.asList(this.panel1, this.panel2);
        }
    }

    private static class FloorSortPnl
    extends EditorPanel {
        private final MerlinData d_md;
        private final guiMultiStateCheckBox d_autoCreateFloorsCB;
        private final guiUnitDoubleField d_autoFloorDistFld;
        private final guiMultiStateCheckBox d_autoSortCompsCB;

        public FloorSortPnl(MerlinData md) {
            this.d_md = md;
            this.d_autoCreateFloorsCB = new guiMultiStateCheckBox(Intl.intl("Automatically create floors"));
            guiUtil.setLongTooltip(this.d_autoCreateFloorsCB, Intl.intl("Automatically create new floors when adding/modifying egress\ncomponents if they are outside the <b>Floor height</b> of the previous floor."));
            guiLabel distLbl = new guiLabel(Intl.intl("Floor height:"));
            distLbl.setToolTipText(Intl.intl("The minimum distance between floors to automatically create a new floor."));
            this.d_autoFloorDistFld = new MerlinUDF(0, DoubleVR.above(0.0, false));
            this.d_autoSortCompsCB = new guiMultiStateCheckBox(Intl.intl("Auto sort egress components"));
            guiUtil.setLongTooltip(this.d_autoSortCompsCB, Intl.intl("Automatically sort new and modified egress components (rooms, doors, etc.)\ninto appropriate floors."));
            this.d_autoFloorDistFld.setPreferredSize(new Dimension(this.d_autoFloorDistFld.getPreferredSize().width, this.d_autoCreateFloorsCB.getPreferredSize().height - 2));
            LinkStatus.link2((AbstractButton)this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            LinkStatus.link2((AbstractButton)this.d_autoSortCompsCB, this.d_autoCreateFloorsCB, distLbl, this.d_autoFloorDistFld);
            this.addConnection(new BoolConn(FloorSort.AUTO_SELECT_FLOOR, this.d_autoSortCompsCB));
            this.addConnection(new UDConn(FloorSort.MIN_AUTO_FLOOR_DIST, this.d_autoFloorDistFld));
            this.addConnection(new BoolConn(FloorSort.AUTO_CREATE_FLOOR, this.d_autoCreateFloorsCB));
            guiLabel title = new guiLabel(Intl.intl("Floor Creation/Sorting"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(title, 2);
            gb.indent();
            gb.addRow(this.d_autoSortCompsCB, GridBagHelper.REMAINING);
            gb.addRow(this.d_autoCreateFloorsCB, GridBagHelper.REMAINING);
            gb.indent();
            gb.addRow(distLbl, this.d_autoFloorDistFld);
            gb.finalizeRows();
        }

        @Override
        public void update(Events events) {
            if (!events.isAffected(FloorSort.class)) {
                return;
            }
            super.update(events);
        }

        private class BoolConn
        extends BoolPropConnection {
            public BoolConn(FloorSort.Prop<Boolean> prop, guiMultiStateCheckBox cb) {
                super(new FloorProp<Boolean>(prop), cb);
            }

            @Override
            protected boolean isDataEmpty() {
                return false;
            }
        }

        private class UDConn
        extends UDPropConnection {
            public UDConn(FloorSort.Prop<UnitDouble> prop, guiUnitDoubleField fld) {
                super(new FloorProp<UnitDouble>(prop), fld);
            }

            @Override
            protected boolean isDataEmpty() {
                return false;
            }
        }

        private static class FloorProp<ValT>
        implements CompElementActions.IObjectProp<ICompElement, ValT> {
            private final FloorSort.Prop<ValT> d_floorProp;

            public FloorProp(FloorSort.Prop<ValT> floorProp) {
                this.d_floorProp = floorProp;
            }

            @Override
            public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
                return md.floorSortOptions.get(this.d_floorProp);
            }

            @Override
            public void set(MerlinData md, Collection<? extends ICompElement> objs, ValT newVal) {
                Undo.begin(Intl.intl("Set Property"));
                Undo.insertUndoEntry_restore(md, md.floorSortOptions);
                md.floorSortOptions.set(this.d_floorProp, newVal);
                Undo.end(md);
            }
        }
    }

    public static class GroupLeaderPropConn<T extends ICompElement>
    extends ComboPropConn<T> {
        public GroupLeaderPropConn(CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            super(Intl.intl("Set Movement Group Leader"), prop, control);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            ICompElement obj;
            comp.setItems(new ICompElement[0]);
            if (objs.size() == 1 && (obj = objs.iterator().next()) instanceof OccGroupObj) {
                Collection<Proxy> proxies = ((OccGroupObj)obj).flatten(Proxy.class);
                for (Proxy p : proxies) {
                    comp.add((ICompElement)p.getObj());
                }
                super.initFromProp(prop, objs, comp);
            }
        }
    }

    public static class FollowGroupLeaderPropConn
    extends BoolPropConnection {
        private CompElementActions.IObjectProp<ICompElement, EgressAgent> leaderProp;
        private MerlinData md;

        public FollowGroupLeaderPropConn(CompElementActions.IObjectProp<ICompElement, Boolean> prop, CompElementActions.IObjectProp<ICompElement, EgressAgent> leaderProp, guiMultiStateCheckBox control, MerlinData md) {
            super(prop, control);
            this.leaderProp = leaderProp;
            this.md = md;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiMultiStateCheckBox comp) {
            if (comp.getState() != 2) {
                Boolean newval;
                Boolean bl = newval = comp.isSelected() ? Boolean.TRUE : Boolean.FALSE;
                if (!newval.booleanValue()) {
                    Undo.begin(Intl.intl("Set Follow Movement Group Leader"));
                    SelectionEditorPanel.setPropRecursive(Intl.intl("Set Movement Group Leader"), this.leaderProp, objs, null);
                    super.setProp(prop, objs, comp);
                    Undo.end(this.md);
                } else {
                    super.setProp(prop, objs, comp);
                }
            }
        }
    }

    public static class ComboPropConn<T>
    extends APropConnection<guiComboBox<T>> {
        private final String d_actionName;

        public ComboPropConn(CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            this(Intl.intl("Set Property"), prop, control);
        }

        public ComboPropConn(String actionName, CompElementActions.IObjectProp<ICompElement, T> prop, guiComboBox<T> control) {
            super(prop, control);
            this.d_actionName = actionName;
            control.addItemListener(this);
            if (control instanceof MerlinComboBox) {
                this.setUpdateLock(((MerlinComboBox)control).getUpdateLock());
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.isLocked()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.onControlChanged();
                    }
                });
            }
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            IListenerStripper ls = guiUtil.stripListeners(comp);
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                comp.setSelectedItem(null);
            } else {
                comp.setSelectedItem(val);
            }
            comp.setModified(false);
            ls.restore();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<T> comp) {
            if (!comp.isEditable() && comp.getSelectedIndex() < 0) {
                return;
            }
            SelectionEditorPanel.setPropRecursive(this.d_actionName, (CompElementActions.IObjectProp)prop, objs, comp.getSelectedItem());
            this.initFromProp(prop, objs, comp);
        }
    }

    private static class OnewayProp
    extends CompElementActions.DefProp<ICompElement, EgressDoorDir> {
        public OnewayProp() {
            super(IEgressConnector.TRAVEL_DIR);
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, EgressDoorDir dir) {
            super.set(md, objs, dir);
            if (dir == EgressDoorDir.ALL) {
                Collection<EgressCorridor> corridors = MerlinUtil.flatten(objs, EgressCorridor.class);
                ArrayList<EgressCorridor> escalators = new ArrayList<EgressCorridor>();
                for (EgressCorridor corridor : corridors) {
                    SpeedModifier mod = corridor.getSpeedModifier();
                    if (mod.type != SpeedModifier.Type.CONSTANT) continue;
                    escalators.add(corridor);
                }
                if (!escalators.isEmpty()) {
                    SpeedModifier newMod = SpeedModifier.DEFAULT;
                    Undo.insertUndoEntry_propRestore(md, escalators, IEgressOccupiable.SPEED_MODIFIER);
                    Composite.setProperty(IEgressOccupiable.SPEED_MODIFIER, newMod, escalators);
                }
            }
        }
    }

    private static class OnewayComboBox
    extends guiComboBox<EgressDoorDir> {
        public OnewayComboBox() {
            super(EgressDoorDir.ALL, EgressDoorDir.EAST, EgressDoorDir.WEST, EgressDoorDir.NORTH, EgressDoorDir.SOUTH);
            this.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String name = "";
                    if (value != null) {
                        switch ((EgressDoorDir)((Object)value)) {
                            case EAST: {
                                name = Intl.intl("+X");
                                break;
                            }
                            case WEST: {
                                name = Intl.intl("-X");
                                break;
                            }
                            case NORTH: {
                                name = Intl.intl("+Y");
                                break;
                            }
                            case SOUTH: {
                                name = Intl.intl("-Y");
                                break;
                            }
                            default: {
                                name = Intl.intl("<disabled>");
                            }
                        }
                    }
                    this.setText(name);
                    return c;
                }
            });
        }
    }

    private static class ElevatorPriorityConn
    extends APropConnection<PriorityChooser<Floor>> {
        public ElevatorPriorityConn(Object prop, PriorityChooser<Floor> chooser) {
            super(prop, chooser);
            ((PriorityChooser)this.getControl()).getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.onControlChanged();
                }
            });
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            Object availFloorsObj = Composite.getProperty(Elevator.PROP_SERVABLE_FLOORS, this.getObjs());
            final Set availFloors = availFloorsObj instanceof Set ? (Set)availFloorsObj : Collections.EMPTY_SET;
            comp.setFilter(new Predicate<Floor>(){

                @Override
                public boolean test(Floor o) {
                    return availFloors.contains(o);
                }
            });
            Object priority = Composite.getProperty(prop, objs);
            comp.setPriority(priority instanceof List ? (List)priority : null);
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, PriorityChooser<Floor> comp) {
            List floorPriority = comp.getPriority();
            if (floorPriority == null) {
                return;
            }
            int defaultIndex = 0;
            for (int m = 0; m < floorPriority.size() - 1; ++m) {
                Floor f1 = floorPriority.get(m);
                Floor f2 = (Floor)floorPriority.get(m + 1);
                if (f1.getWorkingZ().compareTo(f2.getWorkingZ()) >= 0) continue;
                defaultIndex = m + 1;
            }
            if (defaultIndex == 0) {
                floorPriority = Collections.EMPTY_LIST;
            } else if (defaultIndex < floorPriority.size() - 1) {
                floorPriority = floorPriority.subList(0, defaultIndex);
            }
            this.setProp(prop, objs, floorPriority);
            this.initFromProp(prop, objs, comp);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            List floorPriority = (List)val;
            MerlinData md = MerlinApp.getApp().getData();
            Undo.begin(Intl.intl("Edit Floor Priority"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            Composite.setProperty(prop, floorPriority, objs);
            Undo.end(md);
        }
    }

    private static class ElevatorFloorConn
    extends ComboPropConn<Floor> {
        private final boolean isDischargeConn;
        private Component[] sameWidthComps;

        public ElevatorFloorConn(CompElementActions.IObjectProp<ICompElement, Floor> prop, guiComboBox<Floor> control, boolean isDischargeConn, Component ... sameWidthComps) {
            super(prop, control);
            this.isDischargeConn = isDischargeConn;
            this.sameWidthComps = sameWidthComps;
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Floor> comp) {
            IdentityHashSet<Floor> allServableFloors = null;
            for (Elevator elevator : SelectionEditorPanel.getElevators(objs)) {
                Collection<Floor> serveFloors = elevator.getServableFloors();
                if (allServableFloors == null) {
                    allServableFloors = new IdentityHashSet<Floor>(serveFloors);
                    continue;
                }
                allServableFloors.retainAll(serveFloors);
            }
            final IdentityHashSet<Floor> availFloors = allServableFloors;
            IListenerStripper ls = guiUtil.stripListeners(comp);
            ((MerlinComboBox)comp).setFilter(new Predicate<Floor>(){

                @Override
                public boolean test(Floor o) {
                    return availFloors.contains(o);
                }
            });
            ls.restore();
            int cbWdith = comp.getPreferredSize().width;
            for (Component c : this.sameWidthComps) {
                Dimension d = c.getPreferredSize();
                c.setPreferredSize(new Dimension(cbWdith, d.height));
            }
            super.initFromProp(prop, objs, comp);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, guiComboBox<Floor> comp) {
            if (comp.getSelectedIndex() < 0) {
                return;
            }
            if (!this.isDischargeConn) {
                super.setProp(prop, objs, comp);
                return;
            }
            MerlinData md = MerlinApp.getApp().getData();
            ITimingModel newTimingModel = null;
            try {
                int option = JOptionPane.showConfirmDialog(MerlinApp.getApp().getActiveFrame(), Intl.intl("Would you like to re-calculate the floor pickup/discharge times?"), Intl.intl("Re-calculate Floor Timing?"), 1);
                if (option == 0) {
                    guiDialog timingDlg = new guiDialog((Window)MerlinApp.getApp().getActiveFrame(), Intl.intl("Elevator Timing"), 9);
                    NewElevatorDlg.TimingPnl timingPnl = new NewElevatorDlg.TimingPnl();
                    timingDlg.getDialogPane().add(timingPnl);
                    timingPnl.load(CreateElevator.getLastTimingModel());
                    if (timingDlg.doModal() != 1) {
                        throw new CancellationException();
                    }
                    newTimingModel = timingPnl.save();
                } else if (option != 1) {
                    throw new CancellationException();
                }
            }
            catch (CancellationException e) {
                this.initFromProp(prop, objs, comp);
                return;
            }
            Undo.begin(Intl.intl("Set Discharge Floor"));
            ((CompElementActions.IObjectProp)prop).set(md, objs, comp.getSelectedItem());
            if (newTimingModel != null) {
                for (Elevator elevator : SelectionEditorPanel.filter(objs, Elevator.class)) {
                    CreateElevator.distributeFloorTimes(md, elevator, newTimingModel);
                }
            }
            this.initFromProp(prop, objs, comp);
            Undo.end(md);
        }
    }

    private static class ProfileFilterConn
    extends APropConnection<SetChooser<OccProfile>> {
        private MerlinData md;

        public ProfileFilterConn(Object prop, SetChooser<OccProfile> control, MerlinData md) {
            super(prop, control);
            this.md = md;
            control.addObserver((o, arg) -> this.commit());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<OccProfile> comp) {
            OccProfile.CompRestrictions restrictedComps;
            Set<OccProfile> selectedProfiles = comp.getObjs();
            Set<OccProfile> unSelectedProfiles = comp.getUnselectedObjs();
            Undo.begin(Intl.intl("Edit Restricted Profiles"));
            Undo.insertUndoEntry_propRestore(this.md, this.md.profiles.flatten(OccProfile.class), OccProfile.PROP_RESTRICTED_COMPONENTS);
            for (OccProfile prof : selectedProfiles) {
                restrictedComps = prof.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS).clone();
                for (ICompElement iCompElement : objs) {
                    if (!OccProfile.CompRestrictions.isAcceptableType(iCompElement.getClass())) continue;
                    restrictedComps.accept(iCompElement);
                }
                prof.setProperty(OccProfile.PROP_RESTRICTED_COMPONENTS, restrictedComps);
            }
            for (OccProfile prof : unSelectedProfiles) {
                restrictedComps = prof.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS).clone();
                for (ICompElement iCompElement : objs) {
                    if (!OccProfile.CompRestrictions.isAcceptableType(iCompElement.getClass())) continue;
                    restrictedComps.reject(iCompElement);
                }
                prof.setProperty(OccProfile.PROP_RESTRICTED_COMPONENTS, restrictedComps);
            }
            Undo.end(this.md);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<OccProfile> comp) {
            LinkedHashSet<OccProfile> selectedProfs = new LinkedHashSet<OccProfile>();
            boolean firstObj = true;
            for (ICompElement iCompElement : objs) {
                for (OccProfile prof : MerlinApp.getApp().getData().profiles.flatten(OccProfile.class)) {
                    OccProfile.CompRestrictions restrictedComps = prof.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
                    if (firstObj && restrictedComps.isAccepted(iCompElement)) {
                        selectedProfs.add(prof);
                    }
                    if (firstObj || (!restrictedComps.isAccepted(iCompElement) || selectedProfs.contains(prof)) && (restrictedComps.isAccepted(iCompElement) || !selectedProfs.contains(prof))) continue;
                    comp.setObjs(null);
                    return;
                }
                firstObj = false;
            }
            comp.setObjs(selectedProfs);
        }
    }

    private static class SceneGeomPnl
    extends EditorPanel {
        public SceneGeomPnl() {
            guiTextField objType = new guiTextField();
            this.addConnection(new TextPropConnection((Object)ImportedGeom.PROP_OBJECT_TYPE, objType));
            objType.setEnabled(false);
            guiComboBox<ImportType> importTypes = guiUtil.newCombo(type -> {
                if (type == null) {
                    return new Pair<String, Object>("", null);
                }
                return new Pair<String, String>(type.name, type.desc);
            }, Stream.of(ImportType.values()).sorted((t1, t2) -> {
                if (t1 == t2) {
                    return 0;
                }
                if (t1 == ImportType.IGNORED) {
                    return -1;
                }
                if (t2 == ImportType.IGNORED) {
                    return 1;
                }
                return t1.name.compareToIgnoreCase(t2.name);
            }).collect(Collectors.toList()));
            this.addConnection(new ComboPropConn<ImportType>(new CompElementActions.DefProp(ImportedGeom.PROP_IMPORTED_TYPE), importTypes));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 3;
            guiLabel typelbl = new guiLabel(Intl.intl("Object Type:"));
            typelbl.setToolTipText(Intl.intl("The object type as specified in the imported file."));
            guiLabel itypelbl = new guiLabel(Intl.intl("Import Type:"));
            itypelbl.setToolTipText("<html>" + Intl.intl("The object type used when generating model elements.<br>This is determined automatically if imported from an IFC file."));
            gb.addRow(typelbl, objType, 1.0, 0);
            gb.addRow(itypelbl, importTypes, 1.0, 0);
        }
    }

    private static class ProfileFilterPnl
    extends EditorPanel {
        public ProfileFilterPnl(MerlinData md) {
            SetChooser<OccProfile> profileChooser = new SetChooser<OccProfile>(md, Intl.intl("Accepted Profiles"), Intl.intl("none"), false, false, md.profiles, OccProfile.class, Predicates.alwaysTrue());
            this.addConnection(new ProfileFilterConn(new CompElementActions.DefProp(OccProfile.PROP_RESTRICTED_COMPONENTS), profileChooser, md));
            GridBagHelper gb = new GridBagHelper(this);
            gb.add(Intl.intl("Accepted Profiles:"), profileChooser);
        }
    }

    private static class ElevatorExtraPnl
    extends ElevatorPnl {
        public ElevatorExtraPnl() {
            BasicFloorComboBox initFloorCB = new BasicFloorComboBox(MerlinApp.getApp().getData());
            MerlinUDF callDistFld = new MerlinUDF(0, DoubleVR.above(0.0, true));
            callDistFld.setToolTipText(Intl.intl("The distance away from the elevator door at which an occupant can call the elevator."));
            this.addConnection(new ElevatorFloorConn(new CompElementActions.DefProp<ICompElement, Floor>(Elevator.PROP_INIT_FLOOR), initFloorCB, false, callDistFld));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_CALL_DISTANCE), callDistFld));
            guiMultiStateCheckBox doubleDeckCb = new guiMultiStateCheckBox(Intl.intl("Double-Deck"), false);
            doubleDeckCb.setToolTipText(String.format("<html>" + Intl.intl("If checked, the elevator will use two decks to transport occupants.<br>Additionally to the discharge level, the level on top of the discharge level will also be used for discharge.") + "</html>", new Object[0]));
            this.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Elevator.PROP_DOUBLE_DECK), doubleDeckCb));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Initial Floor:"), initFloorCB);
            gb.addRow(Intl.intl("Call Distance:"), callDistFld);
            gb.addRow(doubleDeckCb);
        }
    }

    private static class ElevatorLevelPnl
    extends ElevatorPnl {
        private Set<Elevator> d_objs;

        public ElevatorLevelPnl() {
            BasicFloorComboBox dischargeCB = new BasicFloorComboBox(MerlinApp.getApp().getData());
            this.addConnection(new ElevatorFloorConn(new CompElementActions.DefProp<ICompElement, Floor>(Elevator.PROP_DISCHARGE_FLOOR), dischargeCB, true, new Component[0]));
            HTMLBtn levelBtn = new HTMLBtn(Intl.intl("Edit"));
            levelBtn.addActionListener(new LevelActionListener());
            MerlinData md = MerlinApp.getApp().getData();
            PriorityChooser<Floor> priorityChooser = new PriorityChooser<Floor>(md, Intl.intl("Floor Priority"), Intl.intl("top-down"), md.floors, Floor.class, null);
            priorityChooser.setSorter(new Comparator<Floor>(){

                @Override
                public int compare(Floor o1, Floor o2) {
                    return o2.getWorkingZ().compareTo(o1.getWorkingZ());
                }
            });
            this.addConnection(new ElevatorPriorityConn(Elevator.PROP_FLOOR_PRIORITY, priorityChooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Discharge Floor:"), dischargeCB);
            gb.addRow(Intl.intl("Floor Priority:"), priorityChooser);
            gb.addRow(Intl.intl("Level Data:"), levelBtn);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = SelectionEditorPanel.getElevators(objs);
            super.bind(objs);
        }

        @Override
        public void release() {
            this.d_objs = Collections.EMPTY_SET;
            super.release();
        }

        private class LevelActionListener
        implements ActionListener {
            private LevelActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MerlinData md = MerlinApp.getApp().getData();
                IdentityHashMap<Floor, Elevator.LevelData> levelData = new IdentityHashMap<Floor, Elevator.LevelData>();
                Elevator toPass = null;
                boolean uniqueDischarge = false;
                for (Elevator elevator : ElevatorLevelPnl.this.d_objs) {
                    if (!uniqueDischarge) {
                        toPass = elevator;
                        uniqueDischarge = true;
                    } else if (uniqueDischarge) {
                        toPass = null;
                    }
                    Map<Floor, Elevator.LevelData> eLevelData = elevator.getLevelData();
                    for (Map.Entry<Floor, Elevator.LevelData> entry : eLevelData.entrySet()) {
                        Floor floor = entry.getKey();
                        Elevator.LevelData ld = entry.getValue();
                        if (!levelData.containsKey(floor)) {
                            levelData.put(floor, ld);
                            continue;
                        }
                        Elevator.LevelData existing = (Elevator.LevelData)levelData.get(floor);
                        if (existing == null || existing.equals(ld)) continue;
                        levelData.put(floor, null);
                    }
                }
                ElevatorLevelDlg dlg = new ElevatorLevelDlg((Window)MerlinApp.getApp().getActiveFrame(), levelData, toPass);
                if (dlg.doModal() == 1) {
                    md.pauseUpdates();
                    Undo.begin(Intl.intl("Edit Elevator Levels"));
                    Undo.insertUndoEntry_propRestore(md, ElevatorLevelPnl.this.d_objs, Elevator.PROP_LEVEL_DATA);
                    Map<Floor, Elevator.LevelData> newLevelData = dlg.getLevelData();
                    for (Elevator elevator : ElevatorLevelPnl.this.d_objs) {
                        elevator.setLevelData(newLevelData);
                    }
                    Undo.end(md);
                    md.resumeUpdates();
                }
            }
        }
    }

    private static class ElevatorDataPnl
    extends ElevatorPnl {
        public ElevatorDataPnl() {
            MerlinUDF sepFld = new MerlinUDF(9);
            sepFld.setToolTipText(Intl.intl("The approximate number of people in a full load."));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_NOMINAL_LOAD), sepFld));
            MerlinUDF openDelayFld = new MerlinUDF(1);
            openDelayFld.setToolTipText(Intl.intl("The minimum time an elevator door stays open on a pickup floor."));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_OPEN_DELAY), openDelayFld));
            MerlinUDF closeDelayFld = new MerlinUDF(1);
            closeDelayFld.setToolTipText(Intl.intl("The door closing delay after the last occupant goes through on a pickup floor."));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Elevator.PROP_CLOSE_DELAY), closeDelayFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Nominal Load:"), sepFld);
            gb.addRow(Intl.intl("Open Delay:"), openDelayFld);
            gb.addRow(Intl.intl("Close Delay:"), closeDelayFld);
        }
    }

    private static class ElevatorPnl
    extends EditorPanel {
        private ElevatorPnl() {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            super.bind(SelectionEditorPanel.getElevators(objs));
        }
    }

    private static class EgressNodeComboModel
    extends NodeComboModel<GeomComposite> {
        private static final String NEW_GROUP_ITEM = Intl.intl("<Add New...>");
        private final MerlinData d_data;
        private final ListDataListener d_listener;

        public EgressNodeComboModel(MerlinData md) {
            super(md, GeomComposite.class, new RootFinder());
            this.d_data = md;
            this.d_listener = new ListDataListener(){

                @Override
                public void contentsChanged(final ListDataEvent e) {
                    AMerlinOp op = new AMerlinOp(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run(MerlinApp app, MerlinData md) {
                            md.beginWrite();
                            try {
                                Undo.begin(Intl.intl("Change Working Group"));
                                NodeComboModel model = (NodeComboModel)e.getSource();
                                SetWorkingGroup.setWorkingGroup(md, md.activeFloor(), (GeomComposite)model.getSelectedNode());
                                Undo.end(md);
                            }
                            finally {
                                md.endWrite();
                            }
                        }
                    };
                    UIHook.run(UIHook.getComponent(e), "SelectionEditorPane.EgressNodeComboModel.ListDataListener.contentsChanged", op, 20);
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }
            };
            md.getEvents().addObserver(this);
        }

        @Override
        protected Collection<?> getObjects() {
            Collection<?> superObjs = super.getObjects();
            ArrayList<Object> objs = new ArrayList<Object>(superObjs.size() + 2);
            objs.add(NEW_GROUP_ITEM);
            objs.add(new JSeparator(0));
            objs.addAll(superObjs);
            return objs;
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == NEW_GROUP_ITEM) {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        Floor activeFloor = md.floors.getActive();
                        NewGroup.addNewGroup(MerlinApp.getApp(), md, Arrays.asList(activeFloor), activeFloor);
                    }
                };
                UIHook.run(null, "SelectionEditorPanel.EgressNodeComboModel.setSelectedItem", op, 20);
            } else {
                super.setSelectedItem(anObject);
            }
        }

        @Override
        public void update(Events events) {
            this.removeListDataListener(this.d_listener);
            super.update(events);
            boolean update = false;
            for (EventChannel<FloorComposite> eventChannel : events.getAffectedChannels(FloorComposite.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(FloorComposite.ACTIVE_FLOOR_CHANGED)) continue;
                update = true;
                break;
            }
            for (EventChannel<Composite> eventChannel : events.getAffectedChannels(Floor.class, new Class[0])) {
                if (!eventChannel.hasChangedObjs(Floor.WORKING_GROUP_CHANGED)) continue;
                update = true;
                break;
            }
            if (update) {
                this.setSelectedNode(this.d_data.activeFloor().getWorkingGeomGroup());
            }
            this.addListDataListener(this.d_listener);
        }

        private static class RootFinder
        implements NodeComboModel.RootFinder<GeomComposite> {
            private RootFinder() {
            }

            @Override
            public Collection<? extends GeomComposite<?>> getRoots(MerlinData md) {
                return Arrays.asList(md.activeFloor());
            }

            @Override
            public boolean includeRoot() {
                return true;
            }

            @Override
            public Predicate<? super GeomComposite> getFilter(MerlinData md) {
                return Predicates.alwaysTrue();
            }
        }
    }

    private static class NewCompGroupPnl
    extends EditorPanel {
        private final MerlinData d_md;
        private final NodeComboBox<?> d_nodeCB;
        private final guiLabel d_nodeLbl;

        public NewCompGroupPnl(MerlinData md) {
            this.d_md = md;
            EgressNodeComboModel nodeModel = new EgressNodeComboModel(md);
            this.d_nodeCB = new NodeComboBox<GeomComposite>(nodeModel);
            Dimension prefSize = this.d_nodeCB.getPreferredSize();
            if (prefSize.width < 300) {
                prefSize.width = 120;
                this.d_nodeCB.setPreferredSize(prefSize);
            }
            SelectionEditorPanel.adjustHeight(this.d_nodeCB);
            this.d_nodeLbl = new guiLabel(Intl.intl("Group:"));
            guiLabel title = new guiLabel(Intl.intl("New Egress Components"));
            title.setFont(title.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.d_rowSpace = 1;
            gb.addRow(title, GridBagHelper.REMAINING);
            gb.addIdentRow(this.d_nodeLbl, this.d_nodeCB);
            gb.finalizeRows();
        }

        private void updateEnabledStatus() {
            boolean nodeEnabled = this.d_md.floorSortOptions.get(FloorSort.AUTO_SELECT_FLOOR) == false;
            this.d_nodeLbl.setEnabled(nodeEnabled);
            this.d_nodeCB.setEnabled(nodeEnabled);
        }

        @Override
        public void bind(Collection<ICompElement> arg0) {
            super.bind(arg0);
            this.updateEnabledStatus();
        }

        @Override
        public void update(Events events) {
            if (events.isAffected(FloorSort.class)) {
                this.updateEnabledStatus();
            }
        }
    }

    private static class VariantProp<ValType>
    extends APropConnection<HTMLBtn> {
        private final String d_propDesc;
        private final IVariantEditor<ValType> d_varEditor;
        private IVariant<ValType> d_currVal;
        private boolean d_modified;

        public VariantProp(String propDesc, final CompElementActions.IObjectProp<ICompElement, IVariant<ValType>> prop, HTMLBtn btn, IVariantEditor<ValType> varEditor) {
            super(prop, btn);
            this.d_varEditor = varEditor;
            this.d_propDesc = propDesc;
            this.d_modified = false;
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.edit(prop);
                }
            });
        }

        private void edit(Object prop) {
            IVariant<ValType> newVal;
            guiPanel editorPnl = this.d_varEditor.getEditorPanel(UnitSystem.getType(1, true));
            this.d_varEditor.load(editorPnl, this.d_currVal);
            JFrame parent = Application.getApp() != null ? Application.getApp().getActiveFrame() : null;
            String title = String.format(Intl.intl("Edit %s"), this.d_propDesc);
            guiDialog dlg = new guiDialog((Window)parent, title, 9);
            guiPanel c = dlg.getDialogPane();
            c.setLayout(new BorderLayout());
            c.add((Component)editorPnl, "Center");
            if (dlg.doModal() == 1 && dlg.isModified() && (newVal = this.d_varEditor.save(editorPnl)) != null && !theUtil.equal(this.d_currVal, newVal)) {
                this.d_modified = true;
                this.d_currVal = newVal;
                this.onControlChanged();
                this.initFromProp();
            }
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(HTMLBtn comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            SelectionEditorPanel.setPropRecursive(String.format(Intl.intl("Edit %s"), this.d_propDesc), (CompElementActions.IObjectProp)prop, objs, this.d_currVal);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, HTMLBtn comp) {
            Object value = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            IVariant iVariant = this.d_currVal = value instanceof IVariant ? (IVariant)value : (IVariant)null;
            if (this.d_currVal != null) {
                comp.setText(this.d_varEditor.describe(this.d_currVal));
            } else {
                comp.setText("&lt;" + Intl.intl("varies") + "&gt;");
            }
            this.setModified(comp, false);
        }
    }

    private static class BlockageMaterialConn
    extends APropConnection<MaterialBtn>
    implements IObserver {
        public BlockageMaterialConn(CompElementActions.IObjectProp<ICompElement, Material> prop, MaterialBtn btn) {
            super(prop, btn);
            btn.addObserver(this, false);
        }

        @Override
        public void update(IObservable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == null || val instanceof Material) {
                comp.setMaterial((Material)val);
            } else {
                comp.setMaterial(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Material tex = comp.getMaterial();
            if (tex != null) {
                SelectionEditorPanel.setPropRecursive(Intl.intl("Set Texture"), (CompElementActions.IObjectProp)prop, objs, tex);
            }
        }
    }

    private static class BlockageVisSect
    extends EditorPanel {
        public BlockageVisSect() {
            MaterialBtn btn = new MaterialBtn(true);
            btn.setPreferredSize(new Dimension(64, 64));
            this.addConnection(new BlockageMaterialConn(new CompElementActions.DefProp<ICompElement, Material>(EgressBlockage.TEXTURE), btn));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Material:"), btn);
        }
    }

    private static class BlockageSect
    extends EditorPanel {
        public BlockageSect() {
            guiDoubleField fldFactor = new guiDoubleField(0.0);
            fldFactor.setValueRange(DoubleVR.between(0.0, 1.0, true, true));
            this.addConnection(new DoublePropConn(new CompElementActions.DefProp<ICompElement, Double>(EgressBlockage.SPEED_FACTOR), fldFactor));
            HTMLBtn stateBtn = new HTMLBtn("");
            DiscreteVarEditor varEditor = new DiscreteVarEditor(true, Intl.intl("Blocking"), false, Intl.intl("Non-blocking"));
            this.addConnection(new VariantProp(Intl.intl("Blockage State"), new CompElementActions.DefProp(EgressBlockage.STATE), stateBtn, varEditor));
            guiPanel p = new guiPanel(new GridBagLayout());
            GridBagHelper gb = new GridBagHelper(p);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Speed Factor:"), fldFactor, 1.0, 0);
            gb.addRow(Intl.intl("State:"), stateBtn, 1.0, 0);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    private static class ActivationSect
    extends EditorPanel {
        public ActivationSect() {
            GridBagHelper gb = new GridBagHelper(this);
            SelectionEditorPanel.addConnectorState(this, gb);
        }
    }

    public static class ValEditorConn<T, CompT extends JComponent>
    extends APropConnection<JComponent>
    implements Observer {
        private final IValEditor<T> d_editor;

        public ValEditorConn(CompElementActions.IObjectProp<ICompElement, IFunction1d> prop, IValEditor<T> editor) {
            super(prop, editor.getComponent());
            this.d_editor = editor;
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            Object obj = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            Class<T> type = this.d_editor.getType();
            this.d_editor.setValue(type.isInstance(obj) ? (Object)type.cast(obj) : null);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            if (val != null) {
                SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Property"), (CompElementActions.IObjectProp)prop, objs, val);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            this.setProp(prop, objs, (Object)this.d_editor.getValue());
        }
    }

    public static class CapacityEditor
    extends HTMLBtn
    implements Modifiable,
    IValEditor<IOccCount>,
    UnitUpdatableComponent {
        private IOccCount d_count;
        private boolean d_modified = false;
        private guiPanel d_pnl;
        private ValEditorConn d_conn;

        public CapacityEditor() {
            super("");
            UnitUpdator.addComp(this);
            this.addActionListener(e -> {
                IOccCount newCount;
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Capacity"), 9);
                MerlinApp app = MerlinApp.getApp();
                MerlinData md = app.getData();
                OccupancyPanel occupancyPnl = new OccupancyPanel(app, md);
                occupancyPnl.set(this.d_count, md);
                this.d_pnl = occupancyPnl.getCountPanel();
                dlg.getDialogPane().add(this.d_pnl);
                if (dlg.doModal() == 1 && !Objects.equals(newCount = occupancyPnl.getCount(), this.d_count)) {
                    this.setValue(newCount);
                    this.setModified(true);
                    if (this.d_conn != null) {
                        this.d_conn.onControlChanged();
                    }
                }
            });
            this.update();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Class<IOccCount> getType() {
            return IOccCount.class;
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setValue(IOccCount count) {
            if (Objects.equals(count, this.d_count)) {
                return;
            }
            this.d_count = count;
            this.update();
            this.setModified(false);
        }

        @Override
        public IOccCount getValue() {
            return this.d_count;
        }

        public void update() {
            this.setText(this.d_count != null ? CapacityEditor.format(this.d_count) : Intl.intl("&lt;mixed&gt;"));
        }

        public static String format(IOccCount count) {
            if (count instanceof ConstOccCount) {
                return String.format(Intl.intl("%d pers"), ((ConstOccCount)count).count);
            }
            if (count instanceof IOccArea) {
                return OccAreaListCellRenderer.getOccAreaString((IOccArea)count, MerlinApp.getApp().getUnitSystem());
            }
            return count.toString();
        }

        public void addConnection(ValEditorConn connection) {
            this.d_conn = connection;
        }

        @Override
        public void update(Unit newUnit) {
            this.update();
        }

        @Override
        public Unit getDisplayUnit() {
            return SI.METER;
        }
    }

    private static class RoomInfoSect
    extends EditorPanel {
        private guiUnitDoubleField d_fldArea;
        private guiIntField d_fldOccs;
        private guiUnitDoubleField d_fldDens;
        private volatile Thread d_lastUpdaterThread = null;
        private guiLabel d_labArea = new guiLabel(Intl.intl("Area:"));
        private guiLabel d_labOccs;
        private guiLabel d_labDens;

        public RoomInfoSect() {
            this.d_fldArea = new MerlinUDF(4);
            this.d_fldArea.setEditable(false);
            this.d_labOccs = new guiLabel(Intl.intl("Pers:"));
            this.d_fldOccs = new guiIntField(0);
            this.d_fldOccs.setEditable(false);
            this.d_labDens = new guiLabel(Intl.intl("Density:"));
            this.d_fldDens = new MerlinUDF(3);
            this.d_fldDens.setEditable(false);
            Dimension preferredSize = this.d_fldArea.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.15);
            this.d_fldArea.setPreferredSize(preferredSize);
            this.d_fldOccs.setPreferredSize(preferredSize);
            this.d_fldDens.setPreferredSize(preferredSize);
            guiPanel p = new guiPanel(new GridBagLayout());
            GridBagUtil.add(p, this.d_labArea, 0, 0, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldArea, 1, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labOccs, 0, 1, 1, 1, 3, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldOccs, 1, 1, 1, 1, 3, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_labDens, 0, 2, 1, 1, 3, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(p, this.d_fldDens, 1, 2, 1, 1, 3, 12, 0, 0, 0, 0.0, 0.0, 17);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
            this.addConnection(new Updater());
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.d_colSpace, 3);
            gb.addRow(this.d_labArea, this.d_fldArea, 1.0, 0);
            gb.addRow(this.d_labOccs, this.d_fldOccs, 1.0, 0);
            gb.addRow(this.d_labDens, this.d_fldDens, 1.0, 0);
            gb.popSpacing();
        }

        private UnitDouble accumulateUD(Object prop, Collection<ICompElement> objs, Unit defUnit) {
            UnitDouble udSum = null;
            Collection<ICompElement> dColl = MerlinUtil.flattenComposites(objs);
            for (ICompElement leaf : dColl) {
                UnitDouble ud;
                if (this.d_lastUpdaterThread != Thread.currentThread()) {
                    return null;
                }
                Object property = leaf.getProperty(prop);
                if (property == null || property == ICompElement.NOT_SUPPORTED || (ud = (UnitDouble)property) == null) continue;
                if (udSum == null) {
                    udSum = ud;
                    continue;
                }
                udSum = udSum.add(ud);
            }
            if (udSum == null) {
                udSum = new UnitDouble(0.0, defUnit);
            }
            return udSum;
        }

        private int accumulateInt(Object prop, Collection<ICompElement> objs) {
            int sum = 0;
            Collection<ICompElement> dColl = MerlinUtil.flattenComposites(objs);
            for (ICompElement leaf : dColl) {
                Integer i;
                if (this.d_lastUpdaterThread != Thread.currentThread()) {
                    return 0;
                }
                Object property = leaf.getProperty(prop);
                if (property == null || property == ICompElement.NOT_SUPPORTED || (i = (Integer)property) == null) continue;
                sum += i.intValue();
            }
            return sum;
        }

        private class Updater
        implements IPropConnection {
            private Collection<ICompElement> d_objs;

            private Updater() {
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.d_objs = objs;
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                this.d_objs = Collections.EMPTY_LIST;
                RoomInfoSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                RoomInfoSect.this.d_lastUpdaterThread = new Thread(new PropUpdater(this.d_objs));
                RoomInfoSect.this.d_lastUpdaterThread.start();
            }
        }

        private class PropUpdater
        implements Runnable {
            private final Collection<ICompElement> d_elements;

            public PropUpdater(Collection<ICompElement> elements) {
                this.d_elements = elements;
            }

            @Override
            public void run() {
                UnitSystem us = MerlinApp.getApp().getUnitSystem();
                Unit areaUnit = us.getUnit(4);
                final UnitDouble area = RoomInfoSect.this.accumulateUD(IEgressOccupiable.AREA, this.d_elements, areaUnit);
                final int occs = RoomInfoSect.this.accumulateInt(IEgressOccupiable.OCC_COUNT, this.d_elements);
                if (RoomInfoSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                    return;
                }
                double a = area.getValue(areaUnit);
                final UnitDouble dens = new UnitDouble((double)occs / a, us.getUnit(3));
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RoomInfoSect.this.d_fldArea.setValue(area);
                        RoomInfoSect.this.d_fldOccs.setValue(occs);
                        RoomInfoSect.this.d_fldDens.setValue(dens);
                    }
                });
            }
        }
    }

    private static class RoomPropSect
    extends EditorPanel {
        public RoomPropSect() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            SelectionEditorPanel.addTagCheckBox(this, gb, IEgressOccupiable.TAGS, "safe");
            SelectionEditorPanel.addSpeedModifier(this, gb);
            SelectionEditorPanel.addCapacityEditor(this, gb);
        }
    }

    private static class BoundsSect
    extends EditorPanel {
        private guiTextField d_xBoundsFld;
        private guiTextField d_yBoundsFld;
        private guiTextField d_zBoundsFld;
        private volatile Thread d_lastUpdaterThread = null;

        public BoundsSect() {
            this.setPreferredSize(new Dimension(150, 70));
            this.d_xBoundsFld = new guiTextField();
            this.d_yBoundsFld = new guiTextField();
            this.d_zBoundsFld = new guiTextField();
            this.d_xBoundsFld.setEditable(false);
            this.d_yBoundsFld.setEditable(false);
            this.d_zBoundsFld.setEditable(false);
            Dimension preferredSize = this.d_xBoundsFld.getPreferredSize();
            preferredSize.width = (int)((double)preferredSize.width * 1.3);
            this.d_xBoundsFld.setPreferredSize(preferredSize);
            this.d_yBoundsFld.setPreferredSize(preferredSize);
            this.d_zBoundsFld.setPreferredSize(preferredSize);
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 3;
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            this.addConnection(new Updater());
        }

        public void addToLayout(GridBagHelper gb) {
            gb.pushSpacing(gb.d_colSpace, 3);
            gb.addRow(Intl.intl("X Bounds:"), this.d_xBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Y Bounds:"), this.d_yBoundsFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Bounds:"), this.d_zBoundsFld, 1.0, 0);
            gb.popSpacing();
        }

        private void updateMinMax(Set<ICompElement> objs) {
            AABox bb = new AABox();
            if (objs != null) {
                for (ICompElement ice : objs) {
                    if (!(ice instanceof IMerlinGeomSrc)) continue;
                    AABox box = ((IMerlinGeomSrc)((Object)ice)).getBounds();
                    bb.add(box);
                }
            }
            BaseUnit u = SI.METER;
            Point3d boundsMin = bb.getMin();
            Point3d boundsMax = bb.getMax();
            UnitDouble xMin = new UnitDouble(boundsMin.x, u);
            UnitDouble xMax = new UnitDouble(boundsMax.x, u);
            UnitDouble yMin = new UnitDouble(boundsMin.y, u);
            UnitDouble yMax = new UnitDouble(boundsMax.y, u);
            UnitDouble zMin = new UnitDouble(boundsMin.z, u);
            UnitDouble zMax = new UnitDouble(boundsMax.z, u);
            UnitSystem us = MerlinApp.getApp().getUnitSystem();
            Unit length = us.getLength();
            String xBoundsStr = String.format("%1.2f %s, %1.2f %s", xMin.getValue(length), length, xMax.getValue(length), length);
            String yBoundsStr = String.format("%1.2f %s, %1.2f %s", yMin.getValue(length), length, yMax.getValue(length), length);
            String zBoundsStr = String.format("%1.2f %s, %1.2f %s", zMin.getValue(length), length, zMax.getValue(length), length);
            this.d_xBoundsFld.setText(xBoundsStr);
            this.d_xBoundsFld.setToolTipText(xBoundsStr);
            this.d_xBoundsFld.setCaretPosition(0);
            this.d_yBoundsFld.setText(yBoundsStr);
            this.d_yBoundsFld.setToolTipText(yBoundsStr);
            this.d_yBoundsFld.setCaretPosition(0);
            this.d_zBoundsFld.setText(zBoundsStr);
            this.d_zBoundsFld.setToolTipText(zBoundsStr);
            this.d_zBoundsFld.setCaretPosition(0);
        }

        private class PropUpdater
        implements Runnable {
            private final Collection<ICompElement> d_elements;

            public PropUpdater(Collection<ICompElement> elements) {
                this.d_elements = elements;
            }

            @Override
            public void run() {
                if (BoundsSect.this.d_lastUpdaterThread != Thread.currentThread()) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MerlinSelectionModel sel = MerlinApp.getApp().getData().selection;
                        Set objs = sel.getSelected(ICompElement.class);
                        BoundsSect.this.updateMinMax(objs);
                    }
                });
            }
        }

        private class Updater
        implements IPropConnection {
            private Collection<ICompElement> d_objs;

            private Updater() {
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.d_objs = objs;
                this.update(null);
            }

            @Override
            public void commit() {
            }

            @Override
            public void release() {
                this.d_objs = Collections.EMPTY_LIST;
                BoundsSect.this.d_lastUpdaterThread = null;
            }

            @Override
            public void update(Events events) {
                BoundsSect.this.d_lastUpdaterThread = new Thread(new PropUpdater(this.d_objs));
                BoundsSect.this.d_lastUpdaterThread.start();
            }
        }
    }

    private static class StairSect
    extends EditorPanel {
        public StairSect() {
            MerlinUDF fldRiser = new MerlinUDF(6);
            UDPropConnection connRiser = new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressStair.TREAD_RISE), fldRiser);
            this.addConnection(connRiser);
            MerlinUDF fldTread = new MerlinUDF(6);
            UDPropConnection connTread = new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressStair.TREAD_RUN), fldTread);
            this.addConnection(connTread);
            MerlinUDF fldLen = new MerlinUDF(0);
            fldLen.setEditable(false);
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.LENGTH), fldLen));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Riser:"), fldRiser);
            gb.addRow(Intl.intl("Tread:"), fldTread);
            gb.addRow(Intl.intl("Length:"), fldLen);
        }
    }

    private static class RampSect
    extends EditorPanel {
        public RampSect() {
            guiDoubleField fldSlope = new guiDoubleField();
            fldSlope.setEditable(false);
            this.addConnection(new DoublePropConn(new CompElementActions.DefProp<ICompElement, Double>(EgressCorridor.SLOPE), fldSlope));
            MerlinUDF fldSlopeAngle = new MerlinUDF(7);
            fldSlopeAngle.setEditable(false);
            this.addConnection(new SlopeAngleConn(fldSlopeAngle));
            MerlinUDF fldLen = new MerlinUDF(0);
            fldLen.setEditable(false);
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.LENGTH), fldLen));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Incline Angle:"), fldSlopeAngle);
            gb.addRow(Intl.intl("Incline (rise/run):"), fldSlope);
            gb.addRow(Intl.intl("Length:"), fldLen);
        }

        public static UnitDouble getSlopeAngle(double slope) {
            if (Double.isNaN(slope)) {
                return new UnitDouble(slope, SI.RADIAN);
            }
            double slopeAngle = Math.atan(slope);
            return new UnitDouble(slopeAngle, SI.RADIAN);
        }

        private static class SlopeAngleConn
        extends UDPropConnection {
            public SlopeAngleConn(guiUnitDoubleField field) {
                super(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.SLOPE), field);
            }

            @Override
            public void initFromVal(Object val, guiValueField<UnitDouble> comp) {
                if (val instanceof Double) {
                    val = RampSect.getSlopeAngle((Double)val);
                }
                super.initFromVal(val, comp);
            }
        }
    }

    private static class SpeedModifierValProp
    extends CompElementActions.DefProp<ICompElement, IVariant<UnitDouble>> {
        private final SpeedModifier.Type d_type;

        public SpeedModifierValProp(SpeedModifier.Type type) {
            super(IEgressOccupiable.SPEED_MODIFIER);
            this.d_type = type;
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val instanceof SpeedModifier) {
                SpeedModifier sm = (SpeedModifier)val;
                return sm.type == this.d_type ? sm.value : null;
            }
            return null;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, IVariant<UnitDouble> newVal) {
            SpeedModifier newModifier = new SpeedModifier(this.d_type, newVal);
            obj.setProperty(prop, newModifier);
        }
    }

    private static class SpeedModifierTypeProp
    extends CompElementActions.DefProp<ICompElement, SpeedModifier.Type> {
        public SpeedModifierTypeProp() {
            super(IEgressOccupiable.SPEED_MODIFIER);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val instanceof SpeedModifier) {
                SpeedModifier mod = (SpeedModifier)val;
                return mod.type;
            }
            return null;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, SpeedModifier.Type newVal) {
            SpeedModifier newModifier = this.getNewSpeedModifier(md, prop, obj, newVal);
            obj.setProperty(prop, newModifier);
        }

        private SpeedModifier getNewSpeedModifier(MerlinData md, Object prop, ICompElement obj, SpeedModifier.Type newVal) {
            SpeedModifier currModifier = (SpeedModifier)obj.getProperty(prop);
            if (currModifier.type == newVal) {
                return currModifier;
            }
            return new SpeedModifier(newVal, SpeedModifier.newValForType(newVal));
        }
    }

    private static class FlowrateProp
    extends CompElementActions.DefProp<ICompElement, IEgressFlowrate> {
        public FlowrateProp() {
            super(IEgressConnector.FLOWRATE);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val != null && !(val instanceof IEgressFlowrate)) {
                return val;
            }
            IEgressFlowrate flowrate = (IEgressFlowrate)val;
            if (flowrate == null) {
                assert (md != null);
                SimParams sp = md.simParams;
                return DoorUtil.getFlowrate(sp, SelectionEditorPanel.getDoorWidth(obj));
            }
            return flowrate;
        }
    }

    private static class FlowrateOverrideProp
    extends CompElementActions.DefProp<ICompElement, Boolean> {
        public FlowrateOverrideProp() {
            super(IEgressConnector.FLOWRATE);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val == null) {
                return false;
            }
            if (val instanceof IEgressFlowrate) {
                return true;
            }
            return val;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            IEgressFlowrate newFlowrate = this.getNewFlowrate(md, prop, obj, newVal);
            obj.setProperty(prop, newFlowrate);
        }

        private IEgressFlowrate getNewFlowrate(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            if (!newVal.booleanValue()) {
                return null;
            }
            IEgressFlowrate currFlowrate = (IEgressFlowrate)obj.getProperty(prop);
            if (currFlowrate != null) {
                return currFlowrate;
            }
            UnitDouble doorWidth = SelectionEditorPanel.getDoorWidth(obj);
            IEgressFlowrate flowrate = DoorUtil.getFlowrate(md.simParams, doorWidth);
            if (flowrate instanceof IEgressFlowrate.FromDensity) {
                UnitDouble sflowrate = SIUS.newud(1.32, 12);
                return new IEgressFlowrate.Limited(DoorUtil.getFlowrate(sflowrate, md.simParams.doorBoundaryLayer, doorWidth));
            }
            return flowrate;
        }
    }

    private static class ChangeProfileSect
    extends EditorPanel {
        public ChangeProfileSect(MerlinData md) {
            DistributionEditor<OccProfile> profileDistEd = new DistributionEditor<OccProfile>(md, Intl.intl("Profiles"), md.profiles, OccProfile.class, null);
            profileDistEd.setExtraObjs(data -> Collections.singleton(data.profiles.NO_CHANGE));
            this.addConnection(new DistributionConn(new CompElementActions.DefProp(ChangeProfile.PROP_PROFILE_DIST), profileDistEd, Intl.intl("Set Profile Distribution")));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Target Profiles:"), profileDistEd);
        }
    }

    private static class ChangeBehaviorSect
    extends EditorPanel {
        public ChangeBehaviorSect(MerlinData md) {
            DistributionEditor<Behavior> behaviorDistEd = new DistributionEditor<Behavior>(md, Intl.intl("Behaviors"), md.behaviors, Behavior.class, null);
            behaviorDistEd.setExtraObjs(data -> Collections.singleton(data.behaviors.NO_CHANGE));
            this.addConnection(new DistributionConn(new CompElementActions.DefProp(ChangeBehavior.PROP_BEHAVIOR_DIST), behaviorDistEd, Intl.intl("Set Behavior Distribution")));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Target Behaviors:"), behaviorDistEd);
        }
    }

    private static class JoinOccGroupSect
    extends EditorPanel {
        public JoinOccGroupSect() {
            MerlinComboBox<OccGroupObj> groupChooser = new MerlinComboBox<OccGroupObj>(MerlinApp.getApp().getData(), OccGroupObj.class);
            this.addConnection(new ComboPropConn<OccGroupObj>(new CompElementActions.DefProp(JoinOccGroup.PROP_GROUP), groupChooser));
            GridBagHelper gb = new GridBagHelper(this);
            guiLabel lbl = new guiLabel(Intl.intl("Group:"));
            lbl.setToolTipText(Intl.intl("The group that the occupant will join."));
            gb.addRow(lbl, groupChooser, 1.0, 0);
        }
    }

    private static class AssistSect
    extends EditorPanel {
        public AssistSect() {
            MerlinComboBox<AssistedEvacTeam> teamChooser = new MerlinComboBox<AssistedEvacTeam>(MerlinApp.getApp().getData(), AssistedEvacTeam.class);
            this.addConnection(new ComboPropConn<AssistedEvacTeam>(new CompElementActions.DefProp(AssistOccupants.TEAM), teamChooser));
            GridBagHelper gb = new GridBagHelper(this);
            guiLabel lbl = new guiLabel(Intl.intl("Team:"));
            lbl.setToolTipText(Intl.intl("The team on which the occupant will assist."));
            gb.addRow(lbl, teamChooser, 1.0, 0);
        }
    }

    private static class WaitForAssistanceSect
    extends EditorPanel {
        public WaitForAssistanceSect() {
            AETeamsChooser chooser = new AETeamsChooser(MerlinApp.getApp().getData());
            this.addConnection(new SetPropConnection<AssistedEvacTeam>(WaitForAssistance.TEAMS, chooser));
            GridBagHelper gb = new GridBagHelper(this);
            guiLabel lbl = new guiLabel(Intl.intl("Assisting Teams:"));
            lbl.setToolTipText(Intl.intl("The teams that will assist the occupant."));
            gb.addRow(lbl, chooser, 1.0, 0);
        }
    }

    private static class WaitUntilSect
    extends EditorPanel {
        public WaitUntilSect() {
            WaitUntilSrcPnl waitPnl = new WaitUntilSrcPnl(Intl.intl("Wait Until Time:"));
            this.addConnection(new WaitConn<IWaitUntilSrc>(WaitUntil.TIME_SOURCE, waitPnl));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Wait Until Time:"), waitPnl);
        }
    }

    private static class WaitSect
    extends EditorPanel {
        public WaitSect() {
            CompactCurvePnl delayPnl = new CompactCurvePnl(Intl.intl("Wait Time:"), 1);
            this.addConnection(new CurveConn<IDistributedVal<UnitDouble>>(Wait.TIME, delayPnl));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Wait Time:"), delayPnl, 1.0, 0);
        }
    }

    private static class GotoExitsSect
    extends EditorPanel {
        public GotoExitsSect() {
            ExitChooser chooser = new ExitChooser(MerlinApp.getApp().getData());
            this.addConnection(new SetPropConnection<EgressDoor>(GotoExits.PROP_EXITS, chooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Exits:"), chooser);
        }
    }

    private static class GotoRoomsPropConn
    extends SetPropConnection<IEgressOccupiable> {
        public GotoRoomsPropConn(RoomChooser chooser) {
            super((Object)GotoRooms.PROP_ROOMS, chooser);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<IEgressOccupiable> comp) {
            super.initFromProp(prop, objs, comp);
            Predicate<Object> filter = Predicates.alwaysTrue();
            for (GotoRooms room : MerlinUtil.flatten(objs, GotoRooms.class)) {
                filter = Predicates.and(filter, room.getFilter());
            }
            comp.setFilter(filter);
            comp.setAnyAllowed(GotoRooms.getAnyAllowed(filter));
        }
    }

    private static class GotoRoomsSect
    extends EditorPanel {
        public GotoRoomsSect() {
            RoomChooser chooser = new RoomChooser(MerlinApp.getApp().getData());
            this.addConnection(new GotoRoomsPropConn(chooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Rooms:"), chooser);
        }
    }

    private static class GotoElevatorsSect
    extends EditorPanel {
        public GotoElevatorsSect() {
            ElevatorChooser chooser = new ElevatorChooser(MerlinApp.getApp().getData());
            this.addConnection(new SetPropConnection<Elevator>(GotoElevators.PROP_ELEVATORS, chooser));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Elevators:"), chooser);
        }
    }

    private static class GotoWaypointSect
    extends EditorPanel {
        public GotoWaypointSect() {
            MerlinUDF arriveRadFld = new MerlinUDF(0);
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(GotoWaypoint.PROP_ARRIVE_RADIUS), arriveRadFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Arrival Radius:"), arriveRadFld);
        }
    }

    private class BehaviorActionSect
    extends ABehaviorSect {
        private final guiAction[] d_availActions;
        private final DropDownButton d_button;
        private final guiLabel d_addLbl;
        private final Map<guiAction, String> d_shortDescs;

        public BehaviorActionSect(guiAction ... actions) {
            this.d_availActions = actions;
            this.d_button = new DropDownButton(actions);
            this.d_shortDescs = new HashMap<guiAction, String>(actions.length);
            for (guiAction action : actions) {
                this.d_shortDescs.put(action, (String)action.getValue("ShortDescription"));
            }
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            this.d_addLbl = new guiLabel(Intl.intl("Add Action:"));
            gb.addRow(this.d_addLbl, this.d_button);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            super.updateBinding(objs);
            this.setEnabled(this.d_behaviors.size() == 1 && this.d_actions.size() <= 1);
            if (this.isEnabled()) {
                IBehaviorAction existingTerminalAction = null;
                if (!this.d_actions.isEmpty() || !this.d_behaviors.isEmpty()) {
                    existingTerminalAction = this.d_behaviors.stream().flatMap(b -> b.flatten(IBehaviorAction.class).stream()).filter(IBehaviorAction::isTerminal).findAny().orElse(null);
                }
                if (existingTerminalAction == null) {
                    Stream.of(this.d_availActions).forEach(a -> {
                        a.setEnabled(true);
                        a.putValue("ShortDescription", this.d_shortDescs.get(a));
                    });
                } else {
                    guiAction[] guiActionArray = this.d_availActions;
                    int n = guiActionArray.length;
                    for (int i = 0; i < n; ++i) {
                        guiAction taction;
                        boolean terminal = (taction = guiActionArray[i]).get(PROP_BEHAVIOR_ACTION_TERMINAL);
                        taction.setEnabled(!terminal);
                        if (terminal) {
                            String problem = String.format(Intl.intl("Cannot add. Delete \"%s\" first."), existingTerminalAction.getName());
                            taction.putValue("ShortDescription", problem);
                            continue;
                        }
                        taction.putValue("ShortDescription", this.d_shortDescs.get(taction));
                    }
                    Action selAction = this.d_button.getSelectedAction();
                    if (!selAction.isEnabled()) {
                        Stream.of(this.d_availActions).filter(AbstractAction::isEnabled).findFirst().ifPresent(a -> this.d_button.setAction((Action)a));
                    }
                }
            }
            if (this.d_actions.isEmpty()) {
                this.d_addLbl.setToolTipText(Intl.intl("Add a new action."));
            } else {
                this.d_addLbl.setToolTipText(Intl.intl("Insert a new action immediately after the current action."));
            }
        }
    }

    private static class SetPropConnection<T extends IMerlinObj>
    extends APropConnection<SetChooser<T>> {
        public SetPropConnection(Object prop, SetChooser<T> control) {
            super(prop, control);
            control.getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.onControlChanged();
                }
            });
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<T> comp) {
            Object choice = Composite.getProperty(prop, objs);
            Set objSet = choice instanceof Set ? (Set)choice : null;
            comp.setObjs(objSet);
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, SetChooser<T> comp) {
            Set<T> objSet = comp.getObjs();
            if (objSet == null) {
                return;
            }
            MerlinData md = MerlinApp.getApp().getData();
            assert (md != null);
            Undo.begin(Intl.intl("Edit Property"));
            Undo.insertUndoEntry_propRestore(md, objs, prop);
            this.setProp(prop, objs, objSet);
            Undo.end(md);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            Composite.setProperty(prop, val, objs);
        }
    }

    private static class BehaviorPropSect
    extends ABehaviorSect {
        public BehaviorPropSect() {
            CompactCurvePnl delayPnl = new CompactCurvePnl(Intl.intl("Initial Delay"), 1);
            this.addConnection(new CurveConn<IDistributedVal<UnitDouble>>(Behavior.PROP_INI_DELAY, delayPnl));
            ColorComp color = new ColorComp(null, new ColorButton());
            this.addConnection(new ColorConn(color.btn));
            GridBagHelper bg = new GridBagHelper(this);
            bg.d_rowSpace = 1;
            bg.addRow(Intl.intl("Initial Delay:"), delayPnl, 1.0);
            bg.addRow(Intl.intl("Color:"), color.btn, 1.0);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            super.updateBinding(objs);
            this.setEnabled(this.d_actions.isEmpty());
        }
    }

    private static class BehaviorSect
    extends ABehaviorSect {
        private final guiLabel d_actionLbl;
        private final guiTextField d_behaviorFld = new guiTextField();
        private final guiTextField d_actionFld;
        private final JButton d_leftBtn;
        private final JButton d_rightBtn;
        private final NamePropConnection d_behaviorConn;
        private final NamePropConnection d_actionConn;

        public BehaviorSect() {
            Dimension dim = new Dimension(150, this.d_behaviorFld.getPreferredSize().height);
            this.d_behaviorFld.setPreferredSize(dim);
            this.d_behaviorConn = new NamePropConnection(this.d_behaviorFld);
            this.addConnection(this.d_behaviorConn);
            this.d_actionFld = new guiTextField();
            this.d_actionFld.setPreferredSize(dim);
            this.d_actionFld.setEditable(false);
            this.d_actionConn = new NamePropConnection(this.d_actionFld);
            this.addConnection(this.d_actionConn);
            this.d_actionLbl = new guiLabel(Intl.intl("Action:"));
            this.d_leftBtn = new BasicArrowButton(7);
            this.d_rightBtn = new BasicArrowButton(3);
            guiPanel btnPnl = new guiPanel(new FlowLayout(0, 1, 0));
            btnPnl.add(this.d_leftBtn);
            btnPnl.add(this.d_rightBtn);
            this.d_leftBtn.addActionListener(new ChangeAction(-1));
            this.d_rightBtn.addActionListener(new ChangeAction(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorFld, 2);
            gb.addRow(this.d_actionLbl, this.d_actionFld, btnPnl);
        }

        @Override
        protected void updateBinding(Collection<ICompElement> objs) {
            int actionix;
            super.updateBinding(objs);
            this.d_actionConn.bind(this.d_actions);
            this.d_behaviorConn.bind(this.d_behaviors);
            this.d_behaviorFld.setEditable(this.d_actions.isEmpty());
            this.d_actionFld.setVisible(!this.d_actions.isEmpty());
            this.d_actionLbl.setVisible(!this.d_actions.isEmpty());
            boolean scrollEnabled = this.d_behaviors.size() == 1 && this.getBehavior().getMembers().size() > 1 && this.d_actions.size() == 1;
            this.d_leftBtn.setVisible(scrollEnabled);
            this.d_rightBtn.setVisible(scrollEnabled);
            if (scrollEnabled && (actionix = this.getActionIndex()) >= 0) {
                this.d_leftBtn.setEnabled(actionix > 0);
                this.d_rightBtn.setEnabled(actionix < this.getBehavior().getMembers().size() - 1);
            }
        }

        private int getActionIndex() {
            int ix = 0;
            for (IBehaviorAction action : this.getBehavior().getMembers(IBehaviorAction.class)) {
                if (action == this.getAction()) {
                    return ix;
                }
                ++ix;
            }
            return -1;
        }

        private IBehaviorAction getAction(int ix) {
            int m = 0;
            for (IBehaviorAction action : this.getBehavior().getMembers(IBehaviorAction.class)) {
                if (m == ix) {
                    return action;
                }
                ++m;
            }
            return null;
        }

        private class ChangeAction
        implements ActionListener {
            private final int direction;

            public ChangeAction(int direction) {
                this.direction = direction;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int currix = BehaviorSect.this.getActionIndex();
                int nextix = currix + this.direction;
                if (nextix < 0 || nextix >= BehaviorSect.this.getBehavior().getMembers().size()) {
                    return;
                }
                IBehaviorAction nextAction = BehaviorSect.this.getAction(nextix);
                if (nextAction != null) {
                    MerlinApp.getApp().getData().selection.set(nextAction);
                }
            }
        }
    }

    private static abstract class ABehaviorSect
    extends EditorPanel {
        protected Collection<Behavior> d_behaviors;
        protected Collection<IBehaviorAction> d_actions;

        private ABehaviorSect() {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_actions = theUtil.filter(objs, IBehaviorAction.class);
            LinkedIdentityHashSet<Behavior> behaviors = new LinkedIdentityHashSet<Behavior>((Collection<Behavior>)theUtil.filter(objs, Behavior.class));
            for (IBehaviorAction action : theUtil.filter(objs, IBehaviorAction.class)) {
                behaviors.add((Behavior)MerlinApp.getApp().getData().hierarchy.getParent(action));
            }
            this.d_behaviors = behaviors;
            super.bind(this.d_behaviors);
            this.updateBinding(objs);
        }

        protected Behavior getBehavior() {
            return this.d_behaviors.isEmpty() ? null : this.d_behaviors.iterator().next();
        }

        protected IBehaviorAction getAction() {
            return this.d_actions.isEmpty() ? null : this.d_actions.iterator().next();
        }

        protected void updateBinding(Collection<ICompElement> objs) {
        }
    }

    private static class CameraRangeProp
    extends CompElementActions.DefProp<ICompElement, UnitDouble> {
        private final int d_ix;
        private final Unit d_storeUnit;

        public CameraRangeProp(IPropertySet.Prop<Camera.PTZSpec> prop, Unit storeUnit, int ix) {
            super(prop);
            this.d_storeUnit = storeUnit;
            this.d_ix = ix;
        }

        private static double[] asList(Camera.PTZSpec range) {
            return new double[]{range.rangeMin, range.rangeMax, range.maxSpeed};
        }

        private static Camera.PTZSpec newSpec(double[] list) {
            return new Camera.PTZSpec(list[0], list[1], list[2]);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            if (!(obj instanceof Camera)) {
                return ICompElement.NOT_SUPPORTED;
            }
            Camera cam = (Camera)obj;
            IPropertySet.Prop rprop = (IPropertySet.Prop)prop;
            Camera.PTZSpec spec = (Camera.PTZSpec)cam.get(rprop);
            return new UnitDouble(CameraRangeProp.asList(spec)[this.d_ix], this.d_storeUnit);
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, UnitDouble newVal) {
            if (!(obj instanceof Camera)) {
                return;
            }
            IPropertySet.Prop rprop = (IPropertySet.Prop)prop;
            Camera cam = (Camera)obj;
            Camera.PTZSpec spec = (Camera.PTZSpec)cam.get(rprop);
            double[] newSpecList = CameraRangeProp.asList(spec);
            newSpecList[this.d_ix] = newVal.getValue(this.d_storeUnit);
            Camera.PTZSpec newSpec = CameraRangeProp.newSpec(newSpecList);
            if (spec.equals(newSpec)) {
                return;
            }
            cam.set(rprop, newSpec);
        }
    }

    private static class CameraLimitsSect
    extends EditorPanel {
        private Collection<? extends ICompElement> d_boundObjs = Collections.EMPTY_LIST;

        public CameraLimitsSect() {
            GridBagHelper gb = new GridBagHelper(this, false);
            gb.d_rowSpace = 1;
            this.addPTZSpec(gb, Intl.intl("Pan"), Camera.PROP_PAN_INFO, 7, SI.RADIAN, UnitDoubleVR.UNBOUNDED, 14, SI.RADIAN.divide(SI.SECOND), UnitDoubleVR.above(0.0, SI.RADIAN.divide(SI.SECOND), true));
            this.addPTZSpec(gb, Intl.intl("Tilt"), Camera.PROP_TILT_INFO, 7, SI.RADIAN, UnitDoubleVR.between(-90.0, 90.0, NonSI.DEGREE_ANGLE, true, true), 14, SI.RADIAN.divide(SI.SECOND), UnitDoubleVR.above(0.0, SI.RADIAN.divide(SI.SECOND), true));
            this.addPTZSpec(gb, Intl.intl("Zoom"), Camera.PROP_ZOOM_INFO, 10, Unit.ONE, UnitDoubleVR.above(1.0, Unit.ONE, true), 15, Unit.ONE.divide(SI.SECOND), UnitDoubleVR.above(0.0, Unit.ONE.divide(SI.SECOND), true));
        }

        private void addPTZSpec(GridBagHelper gb, String name, IPropertySet.Prop<Camera.PTZSpec> prop, int rangeUnitType, Unit rangeStoreUnit, UnitDoubleVR rangeRange, int speedUnitType, Unit speedStoreUnit, UnitDoubleVR speedRange) {
            guiUnitDoubleField minFld = CameraLimitsSect.newField(rangeUnitType, rangeRange);
            this.addConnection(new UDPropConnection(new CameraRangeProp(prop, rangeStoreUnit, 0), minFld));
            guiUnitDoubleField maxFld = CameraLimitsSect.newField(rangeUnitType, rangeRange);
            this.addConnection(new UDPropConnection(new CameraRangeProp(prop, rangeStoreUnit, 1), maxFld));
            guiUnitDoubleField speedFld = CameraLimitsSect.newField(speedUnitType, speedRange);
            this.addConnection(new UDPropConnection(new CameraRangeProp(prop, speedStoreUnit, 2), speedFld));
            gb.addRow(CameraLimitsSect.getBoldLbl(name), Intl.intl("Min:"), minFld, Intl.intl("Max:"), maxFld, Intl.intl("Max Speed:"), speedFld);
        }

        private static guiUnitDoubleField newField(int unitType, UnitDoubleVR range) {
            MerlinUDF fld = new MerlinUDF(unitType, range);
            fld.setColumns(7);
            return fld;
        }

        private static guiLabel getBoldLbl(String text) {
            return new guiLabel("<html><b>" + text + "</b></html>");
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            objs = new ArrayList<Camera>(MerlinUtil.flatten(objs, Camera.class));
            super.bind(objs);
            this.d_boundObjs = objs;
            this.updateEnabled();
        }

        @Override
        public void release() {
            super.release();
            this.d_boundObjs = Collections.EMPTY_LIST;
        }

        @Override
        public void update(Events events) {
            super.update(events);
            this.updateEnabled();
        }

        private void updateEnabled() {
            Object oval = Composite.getProperty(Camera.PROP_SECURITY, this.d_boundObjs);
            this.setEnabled(oval instanceof Boolean && (Boolean)oval != false || oval == ICompElement.NON_UNIFORM);
        }
    }

    private static class VectorProp
    extends CompElementActions.DefProp<ICompElement, Double> {
        private final int d_ix;

        public VectorProp(Object prop, int ix) {
            super(prop);
            this.d_ix = ix;
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val instanceof Vector3d) {
                Vector3d vec = (Vector3d)val;
                switch (this.d_ix) {
                    case 0: {
                        return vec.x;
                    }
                    case 1: {
                        return vec.y;
                    }
                }
                return vec.z;
            }
            return val;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, Double newVal) {
            Vector3d vec = (Vector3d)obj.getProperty(prop);
            Vector3d newVec = new Vector3d(vec);
            switch (this.d_ix) {
                case 0: {
                    newVec.x = newVal;
                    break;
                }
                case 1: {
                    newVec.y = newVal;
                    break;
                }
                default: {
                    newVec.z = newVal;
                }
            }
            if (!newVec.equals(vec)) {
                obj.setProperty(prop, newVec);
            }
        }
    }

    private static class CameraOrientSect
    extends EditorPanel {
        public CameraOrientSect() {
            int numCols = 5;
            guiDoubleField xfld = new guiDoubleField();
            xfld.setColumns(numCols);
            this.addConnection(new DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 0), xfld));
            guiDoubleField yfld = new guiDoubleField();
            yfld.setColumns(numCols);
            this.addConnection(new DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 1), yfld));
            guiDoubleField zfld = new guiDoubleField();
            zfld.setColumns(numCols);
            this.addConnection(new DoublePropConn(new VectorProp(Camera.PROP_PTZ_ORIENT, 2), zfld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Pan Axis (X):"), xfld, 0);
            gb.addRow(Intl.intl("Pan Axis (Y):"), yfld, 0);
            gb.addRow(Intl.intl("Pan Axis (Z):"), zfld, 0);
        }
    }

    private static class CameraControlSect
    extends EditorPanel {
        public CameraControlSect() {
            guiMultiStateCheckBox controllableCB = new guiMultiStateCheckBox(Intl.intl("Security Camera"));
            controllableCB.setToolTipText(Intl.intl("Treats the camera as a security camera that can be controlled during the simulation."));
            this.addConnection(new BoolPropConnection(new CompElementActions.DefProp<ICompElement, Boolean>(Camera.PROP_SECURITY), controllableCB));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(controllableCB);
        }
    }

    private static class CurveConn<T extends IDistributedVal<UnitDouble>>
    extends APropConnection<JComponent> {
        private final IValEditor<T> d_editor;

        public CurveConn(Object prop, IValEditor<T> editor) {
            super(prop, editor.getComponent());
            this.d_editor = editor;
            PropertyChangeListener listener = e -> {
                if (!(editor.getComponent() instanceof Validateable) || ((Validateable)((Object)editor.getComponent())).validateData(true, true)) {
                    this.onControlChanged();
                }
            };
            editor.addValueListener(listener);
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            Object curveObj = Composite.getProperty(prop, objs);
            IDistributedVal curve = this.d_editor.getType().isInstance(curveObj) ? (IDistributedVal)this.d_editor.getType().cast(curveObj) : null;
            this.d_editor.setValue(curve);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            if (val != null) {
                Undo.begin(Intl.intl("Edit Property"));
                Undo.insertUndoEntry_propRestore(MerlinApp.getApp().getData(), objs, prop);
                Composite.setProperty(prop, val, objs);
                Undo.end(MerlinApp.getApp().getData());
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            this.setProp(prop, objs, (Object)this.d_editor.getValue());
        }
    }

    private static class WaitConn<T extends IWaitUntilSrc>
    extends APropConnection<JComponent> {
        private final IValEditor<T> d_editor;

        public WaitConn(Object prop, IValEditor<T> editor) {
            super(prop, editor.getComponent());
            this.d_editor = editor;
            this.d_editor.addValueListener(e -> {
                if (!(editor.getComponent() instanceof Validateable) || ((Validateable)((Object)editor.getComponent())).validateData(true, true)) {
                    this.onControlChanged();
                }
            });
            MerlinApp.getApp().getData().getEvents().addObserver(this);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            Object waitObj = Composite.getProperty(prop, objs);
            IWaitUntilSrc waitSrc = this.d_editor.getType().isInstance(waitObj) ? (IWaitUntilSrc)this.d_editor.getType().cast(waitObj) : null;
            this.d_editor.setValue(waitSrc);
            if (comp instanceof Modifiable) {
                ((Modifiable)((Object)comp)).setModified(false);
            }
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, JComponent comp) {
            this.setProp(prop, objs, (Object)this.d_editor.getValue());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, Object val) {
            if (val != null) {
                Undo.begin(Intl.intl("Edit Property"));
                Undo.insertUndoEntry_propRestore(MerlinApp.getApp().getData(), objs, prop);
                Composite.setProperty(prop, val, objs);
                Undo.end(MerlinApp.getApp().getData());
            }
        }
    }

    private static class CorridorDoorPnl
    extends EditorPanel {
        private final Object d_doorProp;
        private List<ICompElement> d_boundDoors;

        public CorridorDoorPnl(Object doorProp) {
            this.d_doorProp = doorProp;
            MerlinUDF fldTopWid = new MerlinUDF(6);
            fldTopWid.aliasValue(EgressCorridor.DOOR_STAIR_WIDTH, Intl.intl("STAIR_WIDTH"));
            UDPropConnection connTopWid = new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(EgressCorridor.DoorInfo.WIDTH), fldTopWid);
            this.addConnection(connTopWid);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Width:"), fldTopWid, 0, 1.0);
            SelectionEditorPanel.addFlowrate(this, gb);
            SelectionEditorPanel.addCorridorDoorState(this, gb);
            gb.finalizeRows();
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_boundDoors = new ArrayList<ICompElement>();
            for (EgressCorridor corr : theUtil.filter(objs, EgressCorridor.class)) {
                corr = (EgressCorridor)corr.clone();
                EgressCorridor.DoorInfo di = this.d_doorProp == EgressCorridor.TOP_DOOR ? corr.getTopDoor() : corr.getBottomDoor();
                this.d_boundDoors.add(di);
            }
            super.bind(this.d_boundDoors);
        }

        public void save(MerlinData md, Collection<ICompElement> objs) {
            if (this.d_boundDoors == null) {
                return;
            }
            IFilteredCollection<EgressCorridor> corridors = theUtil.filter(objs, EgressCorridor.class);
            Undo.insertUndoEntry_propRestore(md, corridors, this.d_doorProp);
            assert (corridors.size() == this.d_boundDoors.size());
            int ix = 0;
            for (EgressCorridor corr : corridors) {
                corr.setProperty(this.d_doorProp, this.d_boundDoors.get(ix++));
            }
        }

        @Override
        public void release() {
            super.release();
            this.d_boundDoors = null;
        }
    }

    private static class CorridorExtraPnl2
    extends EditorPanel {
        public CorridorExtraPnl2() {
            HTMLBtn extraInfoBtn = new HTMLBtn(Intl.intl("Additional Info"));
            ViewMoreProp vmProp = new ViewMoreProp(extraInfoBtn);
            this.addConnection(vmProp);
            OnewayComboBox ocb = new OnewayComboBox();
            this.addConnection(new ComboPropConn<EgressDoorDir>(new OnewayProp(), ocb));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("One-way:"), ocb, 0);
            gb.addRow(extraInfoBtn, 0);
        }

        private static class ViewMoreProp
        implements IPropConnection,
        ActionListener {
            private final Component d_parent;
            private Collection<ICompElement> d_objs;

            public ViewMoreProp(HTMLBtn btn) {
                this.d_parent = btn;
                btn.addActionListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                BoundsSect bounds = new BoundsSect();
                RoomInfoSect roomInfo = new RoomInfoSect();
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this.d_parent), Intl.intl("Stair and Ramp Information"), 16);
                guiPanel mainPnl = dlg.getDialogPane();
                GridBagHelper gb = new GridBagHelper(mainPnl);
                gb.addFilledRow(new TitleSeparator(Intl.intl("Bounds")));
                gb.indent();
                bounds.addToLayout(gb);
                gb.unindent();
                gb.addFilledRow(new TitleSeparator(Intl.intl("Occupancy")));
                gb.indent();
                roomInfo.addToLayout(gb);
                gb.finalizeRows();
                bounds.bind(this.d_objs);
                roomInfo.bind(this.d_objs);
                dlg.setResizable(true);
                dlg.doModal();
            }

            @Override
            public void bind(Collection<ICompElement> objs) {
                this.d_objs = objs;
            }

            @Override
            public void release() {
                this.d_objs = null;
            }

            @Override
            public void commit() {
            }

            @Override
            public void update(Events events) {
            }
        }
    }

    private static class CorridorExtraPnl1
    extends EditorPanel {
        public CorridorExtraPnl1() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            SelectionEditorPanel.addTagCheckBox(this, gb, IEgressOccupiable.TAGS, "safe");
            SelectionEditorPanel.addSpeedModifier(this, gb);
            SelectionEditorPanel.addCapacityEditor(this, gb);
        }
    }

    private static class CorridorDoorAction
    implements IPropConnection,
    ActionListener {
        private final Component d_parent;
        private final String d_dlgTitle;
        private final Object d_doorProp;
        private Collection<ICompElement> d_objs;

        public CorridorDoorAction(Component parent, String dlgTitle, Object doorProp) {
            this.d_parent = parent;
            this.d_dlgTitle = dlgTitle;
            this.d_doorProp = doorProp;
        }

        @Override
        public void update(Events events) {
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            this.d_objs = objs;
        }

        @Override
        public void release() {
            this.d_objs = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.d_objs == null) {
                return;
            }
            final CorridorDoorPnl pnl = new CorridorDoorPnl(this.d_doorProp);
            pnl.bind(this.d_objs);
            guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this.d_parent), this.d_dlgTitle, 9);
            guiPanel mainPanel = dlg.getDialogPane();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add(pnl);
            if (dlg.doModal() == 1) {
                AMerlinOp op = new AMerlinOp(){

                    @Override
                    public void run(MerlinApp app, MerlinData md) {
                        Undo.begin(Intl.intl("Edit Door"));
                        md.beginWrite();
                        try {
                            pnl.save(md, d_objs);
                        }
                        finally {
                            md.endWrite();
                            Undo.end(md);
                        }
                    }
                };
                SwingUtilities.invokeLater(() -> UIHook.run(UIHook.getComponent(e), "SelectionEditorPane.CorridorDoorAction.actionPerformed", op, 16));
            }
        }

        @Override
        public void commit() {
        }
    }

    private static class CorridorDoorWidthProp
    extends CompElementActions.DefProp<ICompElement, UnitDouble> {
        public CorridorDoorWidthProp() {
            super(EgressCorridor.WIDTH);
        }

        @Override
        protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, UnitDouble newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_restore(md, theUtil.filter(modObjs, IRestorable.class));
        }
    }

    private static class CorridorSect
    extends EditorPanel {
        public CorridorSect() {
            MerlinUDF fldWidth = new MerlinUDF(6);
            UDPropConnection connWidth = new UDPropConnection(new CorridorDoorWidthProp(), fldWidth);
            this.addConnection(connWidth);
            CorridorDoorAction topDoorAction = new CorridorDoorAction(this, Intl.intl("Top Door Properties"), EgressCorridor.TOP_DOOR);
            HTMLBtn topDoorBtn = new HTMLBtn(Intl.intl("Edit"));
            topDoorBtn.addActionListener(topDoorAction);
            this.addConnection(topDoorAction);
            CorridorDoorAction bottomDoorAction = new CorridorDoorAction(this, Intl.intl("Bottom Door Properties"), EgressCorridor.BOTTOM_DOOR);
            HTMLBtn bottomDoorBtn = new HTMLBtn(Intl.intl("Edit"));
            bottomDoorBtn.addActionListener(bottomDoorAction);
            this.addConnection(bottomDoorAction);
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 1;
            gb.addRow(Intl.intl("Width:"), fldWidth);
            gb.addRow(Intl.intl("Top Door:"), topDoorBtn, 0);
            gb.addRow(Intl.intl("Bottom Door:"), bottomDoorBtn, 0);
        }
    }

    private static class OccCountSect
    extends EditorPanel {
        private guiIntField occCountFld = new guiIntField(0);

        public OccCountSect(MerlinData md) {
            this.occCountFld.setEditable(false);
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 3;
            gb.addRow(Intl.intl("Occupant Count: "));
            gb.addRow(this.occCountFld, 1.0);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            super.bind(objs);
            this.occCountFld.setValue(this.numEgressAgents(objs));
        }

        public int numEgressAgents(Collection<ICompElement> iCompElements) {
            int result = 0;
            for (ICompElement iCompElement : iCompElements) {
                if (iCompElement instanceof EgressAgent) {
                    ++result;
                    continue;
                }
                result += this.numEgressAgents(((EgressAgentComp)iCompElement).getMembers());
            }
            return result;
        }
    }

    private static class GenerateModelSect
    extends EditorPanel {
        public GenerateModelSect(boolean global) {
            JButton btn = global ? new JButton(GenerateModelFromBIM.UI_HOOK_GLOBAL) : new JButton(GenerateModelFromBIM.UI_HOOK_CONTEXT);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(btn, 1.0, 0);
        }
    }

    private static class FloorSect
    extends EditorPanel {
        public FloorSect() {
            MerlinUDF workingZFld = new MerlinUDF(0);
            MerlinUDF zminFld = new MerlinUDF(0);
            zminFld.aliasValue(Floor.CURR_FLOOR, Intl.intl("CURR_FLOOR"), "");
            MerlinUDF zmaxFld = new MerlinUDF(0);
            zmaxFld.aliasValue(Floor.NEXT_FLOOR, Intl.intl("NEXT_FLOOR"), "");
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.WORKING_Z), workingZFld));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.ZMIN_FILTER), zminFld));
            this.addConnection(new UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(Floor.ZMAX_FILTER), zmaxFld));
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 3;
            gb.addRow(Intl.intl("Working Z:"), workingZFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Min Filter:"), zminFld, 1.0, 0);
            gb.addRow(Intl.intl("Z Max Filter:"), zmaxFld, 1.0, 0);
        }
    }

    private static class DoorWidthProp
    extends CompElementActions.DefProp<ICompElement, Double> {
        public DoorWidthProp(Object prop) {
            super(prop);
        }

        @Override
        protected void saveState(MerlinData md, Object prop, Collection<? extends ICompElement> objs, Double newVal) {
            List<ICompElement> modObjs = CompElementActions.flattenToLocallyDefined(prop, objs);
            Undo.insertUndoEntry_restore(md, theUtil.filter(modObjs, IRestorable.class));
        }
    }

    private static class DoorSect2
    extends EditorPanel {
        public DoorSect2() {
            CompactCurvePnl delayPnl = new CompactCurvePnl(Intl.intl("Wait Time"), 1);
            this.addConnection(new CurveConn<IDistributedVal<UnitDouble>>(EgressDoor.WAIT_TIME, delayPnl));
            guiPanel p = new guiPanel();
            GridBagHelper gb = new GridBagHelper(p);
            gb.d_rowSpace = 2;
            gb.addRow(Intl.intl("Wait Time:"), delayPnl);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    private static class DoorSect1
    extends EditorPanel {
        public DoorSect1() {
            MerlinUDF fldWid = new MerlinUDF(6);
            UDPropConnection connWid = new UDPropConnection(new DToUDProp<ICompElement>(SI.METER, new DoorWidthProp(EgressDoor.WIDTH)), fldWid);
            this.addConnection(connWid);
            guiPanel p = new guiPanel();
            GridBagHelper gb = new GridBagHelper(p);
            gb.d_rowSpace = 2;
            gb.addRow(Intl.intl("Width:"), fldWid, 0, 1.0);
            SelectionEditorPanel.addFlowrate(this, gb);
            SelectionEditorPanel.addConnectorState(this, gb);
            this.setLayout(new BorderLayout());
            this.add((Component)p, "Center");
        }
    }

    private static class MaterialConn
    extends APropConnection<MaterialBtn>
    implements IObserver {
        public MaterialConn(MaterialBtn btn) {
            super(new MaterialProp(), btn);
            btn.addObserver(this, true);
        }

        @Override
        public void update(IObservable source, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Material mat = comp.getMaterial();
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Material"), (CompElementActions.IObjectProp)prop, objs, mat);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, MaterialBtn comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val instanceof Material || val == null) {
                comp.setMaterial((Material)val);
            } else {
                comp.setMultiple();
            }
            comp.setModified(false);
        }
    }

    private static class ColorDefProp
    extends CompElementActions.DefProp<ICompElement, Boolean> {
        public ColorDefProp() {
            super(MerlinData.COLOR);
        }

        @Override
        protected Object get(MerlinData md, Object prop, ICompElement obj) {
            Object val = obj.getProperty(prop);
            if (val == null) {
                return false;
            }
            if (val instanceof Color) {
                return true;
            }
            return val;
        }

        @Override
        protected void set(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            Color newColor = this.getNewColor(md, prop, obj, newVal);
            obj.setProperty(prop, newColor);
        }

        private Color getNewColor(MerlinData md, Object prop, ICompElement obj, Boolean newVal) {
            if (!newVal.booleanValue()) {
                return null;
            }
            return Color.WHITE;
        }
    }

    private static class ColorConn
    extends APropConnection<ColorButton>
    implements Observer {
        public ColorConn(ColorButton cb) {
            this(cb, MerlinData.COLOR);
        }

        public ColorConn(ColorButton cb, Object prop) {
            super(new CompElementActions.DefProp(prop), cb);
            cb.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == null) {
                comp.setColor(Color.WHITE);
            } else if (val instanceof Color) {
                comp.setColor((Color)val);
            } else {
                comp.setColor(null);
            }
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            Color color = comp.getColor();
            if (color != null) {
                SelectionEditorPanel.setPropRecursive(Intl.intl("Set Color"), (CompElementActions.IObjectProp)prop, objs, color);
            }
        }
    }

    private static class ColorComp
    extends JPanel
    implements Modifiable {
        public final guiMultiStateCheckBox checkBox;
        public final ColorButton btn;

        public ColorComp(guiMultiStateCheckBox colorCB, ColorButton cb) {
            this.checkBox = colorCB;
            this.btn = cb;
        }

        @Override
        public boolean isModified() {
            return this.checkBox != null && this.checkBox.isModified() || this.btn.isModified();
        }

        @Override
        public void setModified(boolean modified) {
            if (this.checkBox != null) {
                this.checkBox.setModified(modified);
            }
            this.btn.setModified(modified);
        }
    }

    private static class OpacityConn
    extends UDPropConnection {
        public OpacityConn(guiUnitDoubleField fld) {
            super(new OpacityUDProp(), fld);
            fld.setEmptyAllowed(true);
            fld.setValueRange(UnitDoubleVR.between(0.0, 100.0, NonSI.PERCENT, true, true));
            fld.setColumns(5);
        }

        private static class OpacityUDProp
        implements CompElementActions.IObjectProp<ICompElement, UnitDouble> {
            private final CompElementActions.IObjectProp<ICompElement, IOpacity> d_opacity = new CompElementActions.DefProp<ICompElement, IOpacity>(MerlinData.OPACITY);

            private OpacityUDProp() {
            }

            @Override
            public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
                Object val = this.d_opacity.get(md, objs);
                if (!(val instanceof IOpacity)) {
                    return val;
                }
                Double cval = ((IOpacity)val).getValue();
                return new UnitDouble(cval * 100.0, NonSI.PERCENT);
            }

            @Override
            public void set(MerlinData md, Collection<? extends ICompElement> objs, UnitDouble newVal) {
                UnitDouble udval = newVal;
                Opacity opacityVal = new Opacity((float)(udval.getValue(NonSI.PERCENT) * 0.01));
                this.d_opacity.set(md, objs, opacityVal);
            }
        }
    }
}

