/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.vecmath.Point3f;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.CompElementActions;
import merlin.actions.Undo;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.scripting.Behavior;
import merlin.data.property.Function1dProp;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.gui.AvatarEditor;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinUDF;
import merlin.gui.ProfilesPanel;
import merlin.gui.guiUtil;
import merlin.gui.value.Function1dEditorFactory;
import merlin.gui.value.IValEditor;
import merlin.mv.gui.SelectionEditorPanel;
import merlin.unitsystem.SIUS;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.gui.guiValueField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Property;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;

public class OccEditorPanel {
    private final List<SelectionEditorPanel.EditorPanel> d_panels;

    public OccEditorPanel(MerlinData data) {
        this.d_panels = Arrays.asList(new DefPanel(data), new PropsPnl(), new ExtraPnl(), new AdvancedPnl());
    }

    public List<SelectionEditorPanel.EditorPanel> getPanels() {
        return this.d_panels;
    }

    private void setUDFToText(guiValueField<UnitDouble> fld, String txt) {
        fld.addSpecialValue(txt, new UnitDouble(0.0, Unit.ONE));
        fld.setText(txt);
        fld.removeSpecialValue(txt);
        fld.setEditable(false);
    }

    private static Object[] newArray(int length, Object initValue) {
        Object[] vals = new Object[length];
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = initValue;
        }
        return vals;
    }

    private static PropField<IFunction1d, JComponent> newFunctionProp(Function1dProp prop) {
        return new PropField<IFunction1d, JComponent>(prop, Function1dEditorFactory.nonNullable(prop, false, () -> function1dProp.defVal != null ? (IFunction1d)function1dProp.defVal : new ConstFunction1d(SIUS.newud(0.0, function1dProp.y.unitType)), 7), prop.desc + ":", prop.longDesc);
    }

    private static PropField<OccProfile.IProfileFunction, JComponent> newSlopeFunctionProp(OccProfile.ProfileFunctionProp prop) {
        return new PropField<OccProfile.IProfileFunction, JComponent>(prop, ProfilesPanel.newSlopedFundEditor(prop, () -> profileFunctionProp.defVal instanceof OccProfile.ConstProfileFunction ? ((OccProfile.ConstProfileFunction)profileFunctionProp.defVal).function : new ConstFunction1d(SIUS.newud(0.0, profileFunctionProp.fprop.y.unitType))), prop.fprop.desc, prop.fprop.longDesc);
    }

    public static class CompRestrictionsEditor
    extends guiPanel {
        private JEditorPane editor;
        private CompRestrictionsDlg dlg;
        private OccProfile.CompRestrictions compRestrictions;
        private MerlinData md;
        private Window owner;
        protected boolean d_modified = false;

        public CompRestrictionsEditor(MerlinData md, Window owner) {
            this.md = md;
            this.owner = owner;
            this.editor = guiUtil.newHTMLLabel();
            this.editor.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    OccProfile.CompRestrictions newVal;
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && editor.isEnabled() && dlg.doModal() == 1 && !Objects.equals(newVal = dlg.commit(), compRestrictions)) {
                        compRestrictions = newVal;
                        this.setModified(true);
                        this.updateDesc(compRestrictions == null);
                    }
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.editor, new double[]{1.0, 1.0});
        }

        public OccProfile.CompRestrictions commit() {
            return this.compRestrictions;
        }

        private void updateDesc(boolean isMixed) {
            if (!isMixed) {
                this.editor.setText("<html><a href=\"blank\">" + Intl.intl("Edit...") + "</a></html>");
            } else {
                this.editor.setText("<html><a href=\"blank\">" + Intl.intl("&lt;mixed&gt;") + "</a></html>");
            }
        }

        public void init(OccProfile.CompRestrictions compRestrictions) {
            this.dlg = new CompRestrictionsDlg(this.owner, compRestrictions);
            this.updateDesc(compRestrictions == null);
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
            super.setModified(modified);
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }
    }

    public static class CompRestrictionsDlg
    extends guiDialog {
        private ProfilesPanel.CompRestrictionsPanel compRestrictionsPnl = new ProfilesPanel.CompRestrictionsPanel();

        public CompRestrictionsDlg(Window owner, OccProfile.CompRestrictions compRestrictions) {
            super(owner, Intl.intl("Restricted Components"), 9);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            this.compRestrictionsPnl.addToLayout(gb);
            this.compRestrictionsPnl.init(compRestrictions);
        }

        public OccProfile.CompRestrictions commit() {
            return this.compRestrictionsPnl.commit();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean emptySelection;
            boolean bl = emptySelection = !this.compRestrictionsPnl.validateData();
            if (emptySelection) {
                JOptionPane.showMessageDialog(this, Intl.intl("An empty selection is not allowed."), Intl.intl("Invalid data"), 0);
            }
            return !emptySelection;
        }
    }

    private static class AdvancedDlg
    extends guiDialog {
        private final List<?> d_fields;
        private final List<Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection>> d_connections;

        public AdvancedDlg(Window parent) {
            super(parent, Intl.intl("Additional Occupant Parameters"), 9);
            Comm comm = new Comm();
            MerlinData md = MerlinApp.getApp().getData();
            this.d_fields = Arrays.asList(new TabLbl(Intl.intl("Movement")), !MerlinApp.isFP() ? null : new BooleanField(OccProfile.PROP_ASSIST, Intl.intl("Yes"), Intl.intl("No"), false, Intl.intl("Requires Assistance"), null), new BooleanField(OccProfile.PROP_REQUIRES_ASSISTANCE, Intl.intl("Yes"), Intl.intl("No"), false, Intl.intl("Requires Assistance to Move"), Intl.intl("Recommended for occupants that are unable to move under their own power (e.g. in a bed or other carrying device).")), new BooleanField(OccProfile.PROP_OBEY_ONEWAY_DOORS, Intl.intl("Yes"), Intl.intl("No"), true, Intl.intl("Ignore One-way Door Restrictions:"), guiUtil.encodeToHtmlLabel(Intl.intl("Controls whether occupants observe directionality of one-way doors,<br>stairs, and ramps. If they ignore it, they will go through in either <br>direction; if not, they will go only in the required direction."))), new BooleanField(OccProfile.PROP_WALK_ON_ESCALATORS, Intl.intl("Yes"), Intl.intl("No"), false, Intl.intl("Walk on Escalators:"), guiUtil.encodeToHtmlLabel(Intl.intl("Controls whether occupants prefer to walk or stand on moving geometry<br>such as escalators."))), new PropField<OccProfile.CompRestrictions, CompRestrictionsEditor>(OccProfile.PROP_RESTRICTED_COMPONENTS, new CompRestrictionsEditor(md, this), Intl.intl("Restricted Components:"), Intl.intl("Restricted Components.")), new TabLbl(Intl.intl("Door Choice")), Intl.intl("Cost Factors:"), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_LOCAL_TRAVEL_TIME_FACTOR, new MerlinUDF(11), Intl.intl("Current Room Travel Time:"), guiUtil.encodeToHtmlLabel(Intl.intl("This value affects the cost of travelling to a door in the occupant's\ncurrent room.  Higher values increase a door's cost in this category."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_LOCAL_QUEUE_TIME_FACTOR, new MerlinUDF(11), Intl.intl("Current Room Queue Time:"), guiUtil.encodeToHtmlLabel(Intl.intl("This value affects the cost of waiting in a queue at a door in the\noccupant's current room.  Higher values increase a door's cost in\nthis category."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_TAIL_TIME_FACTOR, new MerlinUDF(11), Intl.intl("Global Travel Time:"), guiUtil.encodeToHtmlLabel(Intl.intl("This value affects the cost of travelling from a door in the occupant's\ncurrent room to an exit or the occupant's next goal. Higher values increase\na door's cost in this category."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_ELEVATOR_WAIT_TIME, new MerlinUDF(1), Intl.intl("Elevator Wait Time:"), guiUtil.encodeToHtmlLabel(Intl.intl("This value determines for how long occupants wait for an elevator even if there\nis a faster alternative.\n"))), Intl.intl("Advanced"), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_CURR_DOOR_PREF, new MerlinUDF(10), Intl.intl("Current Door Preference:"), guiUtil.encodeToHtmlLabel(Intl.intl("This value is used to help occupants stick to their currently chosen\ndoors, preventing excessive switching.  A value of 100 % will cause\noccupants to never switch doors, and a value of 0 % will allow occupants\nto freely change their selected doors."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_CURRENT_ROOM_DIST_PENALTY, new MerlinUDF(0), Intl.intl("Current Room Distance Penalty:"), guiUtil.encodeToHtmlLabel(Intl.intl("<b>NOTE: Enter <i>0</i> to turn off.</b>\nThis value is used as a simple way to model fatigue.  The further an occupant\ntravels in a room, the more the occupant prefers shorter distances over shorter\ntimes.<br>More precisely, every time the occupant travels this distance in the current\nroom, the overall travel time cost will have doubled."))), new TabLbl(Intl.intl("Output")), new BooleanField(OccProfile.PROP_PRINT_EXTRA_OUTPUT, Intl.intl("Yes"), Intl.intl("No"), false, Intl.intl("Print CSV Data"), Intl.intl("Create a CSV file with location and velocity information.")), new TabLbl(Intl.intl("Advanced")), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_ACCEL_TIME, new MerlinUDF(1), Intl.intl("Acceleration Time:"), guiUtil.encodeToHtmlLabel(Intl.intl("The amount of time for an occupant to accelerate from standing to moving at maximum velocity."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_PERSIST_TIME, new MerlinUDF(1), Intl.intl("Persist Time:"), guiUtil.encodeToHtmlLabel(Intl.intl("Amount of time an occupant keeps elevated priority to resolve conflicts when no progress is being made."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_COLLISION_RESPONSE_TIME, new MerlinUDF(1), Intl.intl("Collision Response Time:"), guiUtil.encodeToHtmlLabel(Intl.intl("Time used by an occupant to determine the critical stopping distance to avoid hitting other occupants."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_SLOW_FACTOR, new MerlinUDF(11), Intl.intl("Slow Factor:"), guiUtil.encodeToHtmlLabel(Intl.intl("The fraction of an occupant's maximum speed that determines if the occupant is slow,\nallowing the occupant to consider more travel directions."))), new PropField<ICurve, MerlinUDF>(OccProfile.PROP_BOUNDARY_LAYER, new MerlinUDF(0), Intl.intl("Wall Boundary Layer:"), guiUtil.encodeToHtmlLabel(Intl.intl("The distance the occupant tries to maintain with walls."))), new PropField<OccProfile.Spacing, ProfilesPanel.PersonalDistanceEditor>((IPropertySet.Prop<OccProfile.Spacing>)OccProfile.PROP_SPACING, new ProfilesPanel.PersonalDistanceEditor(comm, 1), Intl.intl("Personal Distance:"), guiUtil.encodeToHtmlLabel(Intl.intl("Controls the spacing of occupants when queueing or travelling with restricted speed."))), new PropField((IPropertySet.Prop<ICurve>)OccProfile.PROP_SOCIAL_DIST, new DisablableCurveEditor(new MerlinUDF(0), 0), Intl.intl("Social Distancing:"), guiUtil.encodeToHtmlLabel(Intl.intl("The preferred distance to other occupants outside the occupant's movement group."))), new TabLbl(Intl.intl("Advanced Speed")), Intl.intl("Level Terrain"), OccEditorPanel.newFunctionProp(OccProfile.PROP_FUNDAMENTAL), Intl.intl("Stairs"), OccEditorPanel.newFunctionProp(OccProfile.PROP_STAIR_SPEED_UP), OccEditorPanel.newSlopeFunctionProp(OccProfile.PROP_STAIR_FUNDAMENTAL_UP), OccEditorPanel.newFunctionProp(OccProfile.PROP_STAIR_SPEED_DOWN), OccEditorPanel.newSlopeFunctionProp(OccProfile.PROP_STAIR_FUNDAMENTAL_DOWN), Intl.intl("Ramps"), OccEditorPanel.newFunctionProp(OccProfile.PROP_RAMP_SPEED_UP), OccEditorPanel.newSlopeFunctionProp(OccProfile.PROP_RAMP_FUNDAMENTAL_UP), OccEditorPanel.newFunctionProp(OccProfile.PROP_RAMP_SPEED_DOWN), OccEditorPanel.newSlopeFunctionProp(OccProfile.PROP_RAMP_FUNDAMENTAL_DOWN));
            this.d_connections = new ArrayList<Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection>>(this.d_fields.size());
            JTabbedPane tabPane = new JTabbedPane();
            guiPanel currTabPnl = null;
            GridBagHelper gb = null;
            int iCount = 0;
            for (int m = 0; m < this.d_fields.size(); ++m) {
                SelectionEditorPanel.APropConnection conn;
                IsLocalProp localProp = null;
                Object prop = this.d_fields.get(m);
                if (prop == null) continue;
                if (prop instanceof TabLbl) {
                    if (gb != null) {
                        gb.finalizeRows();
                    }
                    currTabPnl = new guiPanel();
                    currTabPnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
                    gb = new GridBagHelper(currTabPnl);
                    tabPane.addTab(((TabLbl)prop).lbl, currTabPnl);
                    iCount = 0;
                    continue;
                }
                if (prop instanceof String) {
                    if (iCount > 0) {
                        gb.unindent();
                    }
                    gb.addFilledRow(new TitleSeparator((String)prop));
                    gb.indent();
                    iCount = 1;
                    continue;
                }
                if (prop instanceof Component) {
                    gb.addRow(prop, new double[]{0.0, 2.0});
                    continue;
                }
                PropField pf = (PropField)prop;
                if (prop instanceof BooleanField) {
                    BooleanField bf = (BooleanField)prop;
                    SelectionEditorPanel.ComboPropConn<String> cconn = new SelectionEditorPanel.ComboPropConn<String>(bf.getProp(), (guiComboBox)bf.comp);
                    cconn.setLive(false);
                    conn = cconn;
                } else if (pf.comp instanceof MerlinComboBox.MerlinComboBoxWithEmptyOption) {
                    SelectionEditorPanel.ComboPropConn cconn = new SelectionEditorPanel.ComboPropConn(new CompElementActions.DefProp(pf.prop), (MerlinComboBox.MerlinComboBoxWithEmptyOption)pf.comp);
                    cconn.setLive(false);
                    conn = cconn;
                } else {
                    PropField cfo = (PropField)prop;
                    if (cfo.comp instanceof MerlinUDF) {
                        PropField cf = (PropField)prop;
                        SelectionEditorPanel.UDPropConnection udconn = new SelectionEditorPanel.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(cf.prop), (guiUnitDoubleField)cf.comp);
                        udconn.setLive(false);
                        conn = udconn;
                    } else if (cfo.prop == OccProfile.PROP_RESTRICTED_COMPONENTS) {
                        CompRestrictionConn profConn = new CompRestrictionConn(md, cfo.prop, (CompRestrictionsEditor)cfo.comp);
                        profConn.setLive(false);
                        conn = profConn;
                    } else {
                        SelectionEditorPanel.ValEditorConn vconn = new SelectionEditorPanel.ValEditorConn(new CompElementActions.DefProp<ICompElement, IFunction1d>(cfo.prop), cfo.editor);
                        vconn.setLive(false);
                        conn = vconn;
                    }
                }
                if (localProp == null) {
                    localProp = new IsLocalProp(pf.prop);
                }
                SelectionEditorPanel.BoolPropConnection lconn = new SelectionEditorPanel.BoolPropConnection(localProp, pf.localCB);
                lconn.setLive(false);
                this.d_connections.add(new Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.ComboPropConn<String>>(lconn, (SelectionEditorPanel.ComboPropConn<String>)conn));
                gb.addRow(pf.localCB, pf.comp, 1.0, 0);
            }
            gb.finalizeRows();
            this.getDialogPane().add(tabPane);
        }

        public void load(Collection<ICompElement> objs) {
            for (Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection> pc : this.d_connections) {
                ((SelectionEditorPanel.BoolPropConnection)pc.v1).bind(objs);
                ((SelectionEditorPanel.IPropConnection)pc.v2).bind(objs);
            }
        }

        public void save(Collection<ICompElement> objs) {
            MerlinData md = MerlinApp.getApp().getData();
            md.pauseUpdates();
            Undo.begin(Intl.intl("Edit Advanced Occ Params"));
            for (Pair<SelectionEditorPanel.BoolPropConnection, SelectionEditorPanel.IPropConnection> pc : this.d_connections) {
                ((SelectionEditorPanel.BoolPropConnection)pc.v1).commit();
                if (!((guiMultiStateCheckBox)((SelectionEditorPanel.BoolPropConnection)pc.v1).getControl()).isSelected()) continue;
                ((SelectionEditorPanel.IPropConnection)pc.v2).commit();
            }
            Undo.end(md);
            md.resumeUpdates();
        }

        private static class TabLbl {
            public final String lbl;

            public TabLbl(String lbl) {
                this.lbl = lbl;
            }
        }
    }

    private static class AdvancedPnl
    extends SelectionEditorPanel.EditorPanel {
        private final JButton d_advancedPropsBtn;
        private final JButton d_resetPropsBtn;
        private Collection<ICompElement> d_currObjs = Collections.EMPTY_LIST;

        public AdvancedPnl() {
            this.d_advancedPropsBtn = new JButton(Intl.intl("More..."));
            this.d_advancedPropsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.editAdvanced();
                }
            });
            this.d_resetPropsBtn = new JButton(Intl.intl("Reset..."));
            this.d_resetPropsBtn.setToolTipText(Intl.intl("Clear customized parameters"));
            this.d_resetPropsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int option = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Are you sure you want to clear all customized parameters?"), Intl.intl("Clear Custom Parameters?"), 0);
                    if (option != 0) {
                        return;
                    }
                    this.resetParams();
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_advancedPropsBtn, 1.0, 0);
            gb.addRow(this.d_resetPropsBtn, 1.0, 0);
        }

        @Override
        public void bind(Collection<ICompElement> objs) {
            super.bind(objs);
            this.d_currObjs = new ArrayList<ICompElement>(objs);
            this.updateEnabled();
        }

        @Override
        public void release() {
            super.release();
            this.d_currObjs = Collections.EMPTY_LIST;
        }

        @Override
        public void update(Events events) {
            this.updateEnabled();
        }

        private void updateEnabled() {
            this.d_resetPropsBtn.setEnabled(!AdvancedPnl.getResetAgents(this.d_currObjs).isEmpty());
        }

        protected void editAdvanced() {
            AdvancedDlg dlg = new AdvancedDlg((Window)MerlinApp.getApp().getActiveFrame());
            dlg.load(this.d_currObjs);
            if (dlg.doModal() == 1) {
                dlg.save(this.d_currObjs);
            }
        }

        private static Collection<EgressAgent> getResetAgents(Collection<ICompElement> objs) {
            Collection<EgressAgent> agents = MerlinUtil.flatten(objs, EgressAgent.class, new Predicate<EgressAgent>(){

                @Override
                public boolean test(EgressAgent o) {
                    return o.getProfile().getNumLocal() != 0;
                }
            });
            Collection<Proxy> agentProxies = MerlinUtil.flatten(objs, Proxy.class, new Predicate<Proxy>(){

                @Override
                public boolean test(Proxy p) {
                    Object obj = p.getObj();
                    if (!(obj instanceof EgressAgent)) {
                        return false;
                    }
                    return ((EgressAgent)obj).getProfile().getNumLocal() != 0;
                }
            });
            if (agentProxies.isEmpty()) {
                return agents;
            }
            LinkedIdentityHashSet<EgressAgent> allResetAgents = new LinkedIdentityHashSet<EgressAgent>(agents);
            for (Proxy p : agentProxies) {
                EgressAgent a = (EgressAgent)p.getObj();
                allResetAgents.add(a);
            }
            return allResetAgents;
        }

        protected void resetParams() {
            MerlinData md = MerlinApp.getApp().getData();
            md.pauseUpdates();
            Collection<EgressAgent> agents = AdvancedPnl.getResetAgents(this.d_currObjs);
            Undo.begin(Intl.intl("Reset Occupant Params"));
            Undo.insertUndoEntry_restore(md, agents);
            for (EgressAgent agent : agents) {
                for (IPropertySet.Prop<?> prop : OccProfile.ALL_PROPS) {
                    if (!agent.getProfile().isDefinedLocally(prop)) continue;
                    agent.removeProfileProp(prop);
                }
            }
            Undo.end(md);
            md.resumeUpdates();
        }
    }

    private static class CompRestrictionConn
    extends SelectionEditorPanel.APropConnection<CompRestrictionsEditor> {
        private MerlinData md;

        public CompRestrictionConn(MerlinData md, Object prop, CompRestrictionsEditor control) {
            super(new CompElementActions.DefProp(prop), control);
            this.md = md;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, CompRestrictionsEditor comp) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Component Restrictions"), (CompElementActions.IObjectProp)prop, objs, comp.commit());
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, CompRestrictionsEditor comp) {
            Object compRestrictions = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            comp.init(compRestrictions instanceof OccProfile.CompRestrictions ? (OccProfile.CompRestrictions)compRestrictions : null);
            comp.setModified(false);
        }
    }

    public static class ShapePropConn
    extends SelectionEditorPanel.APropConnection<ProfilesPanel.ShapeEditor> {
        private boolean d_modified;
        private ProfilesPanel.ShapeEditor d_shapeEditor;

        public ShapePropConn(ProfilesPanel.ShapeEditor shapeEditor) {
            super(new CompElementActions.DefProp(OccProfile.PROP_SHAPE), shapeEditor);
            this.d_shapeEditor = shapeEditor;
            this.d_shapeEditor.addConnection(this);
            this.d_modified = false;
        }

        public void editModel(OccProfile.OccShape shape) {
            this.d_modified = true;
            this.onControlChanged();
            this.initFromProp();
        }

        @Override
        protected boolean isModified(HTMLBtn comp) {
            return this.d_modified;
        }

        @Override
        protected void setModified(HTMLBtn comp, boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, ProfilesPanel.ShapeEditor comp) {
            OccProfile.OccShape shape = this.d_shapeEditor.getValue();
            SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Shape"), (CompElementActions.IObjectProp)prop, objs, shape);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, ProfilesPanel.ShapeEditor shapeEditor) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            if (val == ICompElement.NON_UNIFORM || val == ICompElement.NOT_SUPPORTED) {
                shapeEditor.setValue(null);
            } else if (val instanceof OccProfile.OccShape) {
                shapeEditor.setValue((OccProfile.OccShape)val);
            } else {
                shapeEditor.setValue(null);
            }
            this.setModified(shapeEditor, false);
        }
    }

    private static class ModelPropConn<ObjT>
    extends SelectionEditorPanel.APropConnection<AvatarEditor> {
        public ModelPropConn(AvatarEditor editor) {
            super(new CompElementActions.DefProp(OccProfile.PROP_OCCMODEL), editor);
            editor.addValueListener(e -> this.onControlChanged());
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, AvatarEditor comp) {
            Property result = (Property)comp.getValue();
            if (!result.isUniform()) {
                return;
            }
            ArrayList lvals = new ArrayList();
            ((IUrn)result.get()).getUnique(lvals);
            assert (!lvals.isEmpty());
            IAvatar sel = (IAvatar)lvals.get(0);
            SelectionEditorPanel.setPropRecursive(Intl.intl("Edit Model"), (CompElementActions.IObjectProp)prop, objs, sel);
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, AvatarEditor comp) {
            Object val = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            Property uval = val instanceof IAvatar || val == null ? Property.of(new Urn<IAvatar>((IAvatar)val)) : Property.nonUniform();
            comp.setValue(uval);
            comp.setModified(false);
        }
    }

    private static class ColorPropConn
    extends SelectionEditorPanel.APropConnection<ColorButton>
    implements Observer {
        public ColorPropConn(ColorButton btn) {
            super(new ColorProp(), btn);
            btn.setText(Intl.intl("<multiple>"));
            btn.addObserver(this);
            Insets margin = btn.getMargin();
            btn.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        }

        @Override
        public void update(Observable o, Object arg) {
            this.onControlChanged();
        }

        @Override
        public void initFromProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            Object color = ((CompElementActions.IObjectProp)prop).get(MerlinApp.getApp().getData(), objs);
            comp.setColor(color instanceof Color ? (Color)color : null);
            comp.setModified(false);
        }

        @Override
        public void setProp(Object prop, Collection<? extends ICompElement> objs, ColorButton comp) {
            SelectionEditorPanel.setPropRecursive(Intl.intl("Set Occ. Color"), (CompElementActions.IObjectProp)prop, objs, comp.getColor());
        }
    }

    private static class ColorProp
    implements CompElementActions.IObjectProp<ICompElement, Color> {
        private final CompElementActions.IObjectProp<ICompElement, Point3f> d_baseProp = new CompElementActions.DefProp<ICompElement, Point3f>(OccProfile.PROP_COLOR);

        @Override
        public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
            Object color = this.d_baseProp.get(md, objs);
            if (color instanceof Point3f) {
                Point3f c3f = (Point3f)color;
                return new Color(c3f.x, c3f.y, c3f.z);
            }
            return color;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, Color color) {
            float[] comps = new float[3];
            color.getColorComponents(comps);
            Point3f newVal = new Point3f(comps);
            this.d_baseProp.set(md, objs, newVal);
        }
    }

    public static class ExtraPnl
    extends SelectionEditorPanel.EditorPanel {
        private final PropField<Point3f, ColorButton> d_color = new PropField<Point3f, ColorButton>(OccProfile.PROP_COLOR, new ColorButton(1), Intl.intl("Color:"), Intl.intl("Color used to draw occupants"));
        private final PropField<IUrn<IAvatar>, AvatarEditor> d_model;
        private CurveField d_orient;

        public ExtraPnl() {
            this.d_color.connect(this);
            this.addConnection(new ColorPropConn((ColorButton)this.d_color.comp));
            this.d_model = new PropField((IPropertySet.Prop<IUrn<IAvatar>>)OccProfile.PROP_OCCMODEL, new AvatarEditor(2, ResourceAvatar.Type.OCCUPANT), Intl.intl("3D Model:"), Intl.intl("3D model used to show this occupant."));
            this.d_model.connect(this);
            this.addConnection(new ModelPropConn((AvatarEditor)this.d_model.comp));
            this.d_orient = new CurveField(OccProfile.PROP_INIT_ORIENT, 7, Intl.intl("Orientation:"), Intl.intl("Initial orientation in degrees from positive x axis counter-clockwise"));
            this.d_orient.connect(this);
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 2;
            gb.addRow(this.d_color.localCB, this.d_color.comp, 1.0, 0);
            gb.addRow(this.d_model.localCB, this.d_model.comp, 1.0, 0);
            gb.addRow(this.d_orient.localCB, this.d_orient.comp, 1.0, 0);
        }
    }

    private static class BoolToStrProp
    implements CompElementActions.IObjectProp<ICompElement, String> {
        private final String d_checkStr;
        private final String d_uncheckStr;
        private final CompElementActions.IObjectProp<ICompElement, Boolean> d_boolProp;
        private final boolean d_invert;

        public BoolToStrProp(CompElementActions.IObjectProp<ICompElement, Boolean> boolProp, String checkStr, String uncheckStr, boolean invert) {
            this.d_boolProp = boolProp;
            this.d_checkStr = checkStr;
            this.d_uncheckStr = uncheckStr;
            this.d_invert = invert;
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, String newVal) {
            Boolean bval = this.d_checkStr.equals(newVal);
            if (this.d_invert) {
                bval = bval == false;
            }
            this.d_boolProp.set(md, objs, bval);
        }

        @Override
        public Object get(MerlinData md, Collection<? extends ICompElement> objs) {
            Object val = this.d_boolProp.get(md, objs);
            if (val instanceof Boolean) {
                boolean bval = (Boolean)val;
                if (this.d_invert) {
                    bval = !bval;
                }
                return bval ? this.d_checkStr : this.d_uncheckStr;
            }
            return val;
        }
    }

    private static class BooleanField
    extends PropField<IUrn<Boolean>, guiComboBox<String>> {
        private final BoolToStrProp d_b2strProp;

        public BooleanField(OccProfile.Prop<IUrn<Boolean>> prop, String checkStr, String uncheckStr, boolean invert, String desc, String tooltip) {
            super(prop, new guiComboBox<String>((T[])new String[]{checkStr, uncheckStr}), desc, tooltip);
            this.d_b2strProp = new BoolToStrProp(new CompElementActions.DefProp<ICompElement, Boolean>(prop), checkStr, uncheckStr, invert);
        }

        @Override
        public void connect(SelectionEditorPanel.EditorPanel pnl) {
            super.connect(pnl);
            pnl.addConnection(new SelectionEditorPanel.ComboPropConn<String>(this.d_b2strProp, (guiComboBox)this.comp));
        }

        public BoolToStrProp getProp() {
            return this.d_b2strProp;
        }
    }

    public static class PropsPnl
    extends SelectionEditorPanel.EditorPanel {
        private final PropField<Urn<Integer>, guiIntField> d_priority = new PropField<IUrn<Integer>, guiIntField>(OccProfile.PROP_PRIORITY_LEVEL, new guiIntField(IntVR.above(0, true)), Intl.intl("Priority:"), Intl.intl("Occupant priority - higher values indicate higher priority"));
        private final CurveField d_speed;
        private PropField<OccProfile.OccShape, ProfilesPanel.ShapeEditor> d_shapeEditor;

        public PropsPnl() {
            this.d_priority.connect(this);
            this.addConnection(new SelectionEditorPanel.IntPropConn(new CompElementActions.DefProp<ICompElement, Integer>(this.d_priority.prop), (guiIntField)this.d_priority.comp));
            this.d_speed = new CurveField(OccProfile.PROP_MAXVEL, 5, Intl.intl("Speed:"), Intl.intl("Maximum velocity"));
            this.d_speed.connect(this);
            this.d_shapeEditor = new PropField<OccProfile.OccShape, ProfilesPanel.ShapeEditor>((IPropertySet.Prop<OccProfile.OccShape>)OccProfile.PROP_SHAPE, new ProfilesPanel.ShapeEditor(this.getComm(), 1), Intl.intl("Shape:"), guiUtil.encodeToHtmlLabel(Intl.intl("Shape of the occupant.")));
            this.d_shapeEditor.connect(this);
            ShapePropConn conn = new ShapePropConn((ProfilesPanel.ShapeEditor)this.d_shapeEditor.comp);
            this.addConnection(conn);
            GridBagHelper gb = new GridBagHelper(this);
            gb.d_rowSpace = 2;
            gb.addRow(this.d_priority.localCB, this.d_priority.comp, 1.0, 0);
            gb.addRow(this.d_speed.localCB, this.d_speed.comp, 1.0, 0);
            gb.addRow(this.d_shapeEditor.localCB, this.d_shapeEditor.comp, 1.0, 0);
        }
    }

    public static class DefPanel
    extends SelectionEditorPanel.EditorPanel {
        private final guiComboBox<OccProfile> d_cbProfiles;
        private final guiComboBox<Behavior> d_behaviorCB;

        public DefPanel(MerlinData data) {
            this.d_cbProfiles = new MerlinComboBox<OccProfile>(data, OccProfile.class);
            SelectionEditorPanel.ComboPropConn<OccProfile> profConn = new SelectionEditorPanel.ComboPropConn<OccProfile>(Intl.intl("Edit Base Profile"), new CompElementActions.DefProp(OccProfile.PROP_PROF_PARENT), this.d_cbProfiles);
            data.getEvents().addObserver(profConn);
            this.addConnection(profConn);
            this.d_behaviorCB = new MerlinComboBox<Behavior>(data, Behavior.class);
            SelectionEditorPanel.ComboPropConn<Behavior> behaviorConn = new SelectionEditorPanel.ComboPropConn<Behavior>(Intl.intl("Edit Behavior"), new CompElementActions.DefProp(EgressAgent.BEHAVIOR), this.d_behaviorCB);
            data.getEvents().addObserver(behaviorConn);
            this.addConnection(behaviorConn);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Profile:"), this.d_cbProfiles, 1.0, 0);
            gb.addRow(Intl.intl("Behavior:"), this.d_behaviorCB, 1.0, 0);
        }
    }

    private static class CurveField
    extends PropField<ICurve, MerlinUDF> {
        public CurveField(OccProfile.Prop<ICurve> prop, int unitType, String desc, String tooltip) {
            super(prop, new MerlinUDF(unitType), desc, tooltip);
        }

        @Override
        public void connect(SelectionEditorPanel.EditorPanel pnl) {
            super.connect(pnl);
            pnl.addConnection(new SelectionEditorPanel.UDPropConnection(new CompElementActions.DefProp<ICompElement, UnitDouble>(this.prop), (guiUnitDoubleField)this.comp));
        }
    }

    private static class MakeInheritUndoOp
    implements Undo.UndoOp {
        private final EgressAgent[] d_objs;
        private final IPropertySet.Prop<?> d_prop;

        private MakeInheritUndoOp(EgressAgent[] objs, IPropertySet.Prop<?> prop) {
            this.d_objs = objs;
            this.d_prop = prop;
        }

        @Override
        public Undo.UndoOp perform(MerlinSelectionModel sel) {
            Object[] oldLocalVals = new Object[this.d_objs.length];
            for (int m = 0; m < this.d_objs.length; ++m) {
                EgressAgent agent = this.d_objs[m];
                assert (agent.getProfile().isDefinedLocally(this.d_prop));
                oldLocalVals[m] = agent.getProfileProp(this.d_prop);
                agent.removeProfileProp(this.d_prop);
            }
            return new MakeLocalUndoOp(this.d_objs, this.d_prop, oldLocalVals);
        }
    }

    private static class MakeLocalUndoOp
    implements Undo.UndoOp {
        private static final Object UNINITIALIZED = new Object();
        private final EgressAgent[] d_objs;
        private final Object[] d_makeLocalVals;
        private final IPropertySet.Prop<?> d_prop;

        private MakeLocalUndoOp(EgressAgent[] objs, IPropertySet.Prop<?> prop) {
            this(objs, prop, OccEditorPanel.newArray(objs.length, MakeLocalUndoOp.UNINITIALIZED));
        }

        private MakeLocalUndoOp(EgressAgent[] objs, IPropertySet.Prop<?> prop, Object[] localVals) {
            this.d_objs = objs;
            this.d_prop = prop;
            this.d_makeLocalVals = localVals;
        }

        @Override
        public Undo.UndoOp perform(MerlinSelectionModel sel) {
            for (int m = 0; m < this.d_objs.length; ++m) {
                EgressAgent agent = this.d_objs[m];
                assert (!agent.getProfile().isDefinedLocally(this.d_prop));
                Object newLocalVal = this.d_makeLocalVals[m];
                if (newLocalVal == UNINITIALIZED) {
                    newLocalVal = agent.getProfileProp(this.d_prop);
                }
                agent.setProfileProp(this.d_prop, newLocalVal);
            }
            return new MakeInheritUndoOp(this.d_objs, this.d_prop);
        }
    }

    private static class IsLocalProp<T>
    extends CompElementActions.DefProp<ICompElement, Boolean> {
        public IsLocalProp(IPropertySet.Prop<T> baseProp) {
            super(new OccProfile.IsLocalProp<T>(baseProp));
        }

        @Override
        public void set(MerlinData md, Collection<? extends ICompElement> objs, final Boolean newVal) {
            final OccProfile.IsLocalProp ilp = (OccProfile.IsLocalProp)this.getProp();
            Collection<EgressAgent> agents = MerlinUtil.flatten(objs, EgressAgent.class, new Predicate<EgressAgent>(){

                @Override
                public boolean test(EgressAgent o) {
                    boolean definedLocally = o.getProfile().isDefinedLocally(ilp.prop);
                    return newVal.booleanValue() ? !definedLocally : definedLocally;
                }
            });
            Collection<Proxy> agentProxies = MerlinUtil.flatten(objs, Proxy.class, new Predicate<Proxy>(){

                @Override
                public boolean test(Proxy p) {
                    Object obj = p.getObj();
                    if (!(obj instanceof EgressAgent)) {
                        return false;
                    }
                    boolean definedLocally = ((EgressAgent)obj).getProfile().isDefinedLocally(ilp.prop);
                    return newVal.booleanValue() ? !definedLocally : definedLocally;
                }
            });
            LinkedIdentityHashSet<EgressAgent> allAgents = null;
            if (!agentProxies.isEmpty()) {
                allAgents = new LinkedIdentityHashSet<EgressAgent>(agents);
                for (Proxy p : agentProxies) {
                    EgressAgent a = (EgressAgent)p.getObj();
                    allAgents.add(a);
                }
            }
            EgressAgent[] agentArray = allAgents != null ? allAgents.toArray(new EgressAgent[allAgents.size()]) : agents.toArray(new EgressAgent[agents.size()]);
            Undo.UndoOp op = newVal != false ? new MakeLocalUndoOp(agentArray, ilp.prop) : new MakeInheritUndoOp(agentArray, ilp.prop);
            Undo.begin(Intl.intl("Set Property"));
            Undo.UndoOp oppositeOp = op.perform(md.selection);
            Undo.insertEntry(md, oppositeOp);
            Undo.end(md);
        }
    }

    private static class DisablableCurveEditor
    extends guiPanel
    implements IValEditor<UnitDouble> {
        private final guiComboBox<Boolean> d_enabled = guiUtil.newCombo(Boolean.valueOf(false), Intl.intl("Disabled"), true, Intl.intl("Enabled"));
        private final MerlinUDF d_value;
        private final int d_unit;

        public DisablableCurveEditor(MerlinUDF value, int unit) {
            this.d_value = value;
            this.d_value.setEmptyAllowed(true);
            this.d_unit = unit;
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_enabled, this.d_value, 1.0);
            this.d_enabled.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.updateState();
                }
            });
            this.updateState();
        }

        private void updateState() {
            this.d_value.setEnabled(this.isEnabled() && this.d_enabled.getSelectedItem() != null && this.d_enabled.getSelectedItem() != false);
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            this.updateState();
        }

        @Override
        public Class<UnitDouble> getType() {
            return UnitDouble.class;
        }

        @Override
        public UnitDouble getValue() {
            Boolean enabled = this.d_enabled.getSelectedItem();
            if (enabled == null) {
                return null;
            }
            if (!enabled.booleanValue()) {
                return new UnitDouble(Double.NaN, SIUS.unit(this.d_unit));
            }
            return (UnitDouble)this.d_value.getValue();
        }

        @Override
        public void setValue(UnitDouble value) {
            if (value == null) {
                this.d_enabled.setSelectedIndex(-1);
                this.d_value.setValue(null);
            } else {
                boolean enabled = !Double.isNaN(value.getRawValue());
                this.d_enabled.setSelectedItem(enabled);
                this.d_value.setValue(enabled ? value : null);
            }
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }
    }

    private static class PropField<PropT, CompT extends Component> {
        public final IPropertySet.Prop<PropT> prop;
        public final guiMultiStateCheckBox localCB;
        public final CompT comp;
        public final IValEditor<?> editor;

        public PropField(IPropertySet.Prop<PropT> prop, CompT comp, String desc, String tooltip) {
            this(prop, comp instanceof IValEditor ? (IValEditor)comp : null, comp, desc, tooltip);
        }

        public PropField(IPropertySet.Prop<PropT> prop, IValEditor<?> editor, String desc, String tooltip) {
            this(prop, editor, editor.getComponent(), desc, tooltip);
        }

        private PropField(IPropertySet.Prop<PropT> prop, IValEditor<?> editor, CompT comp, String desc, String tooltip) {
            this.prop = prop;
            this.localCB = new guiMultiStateCheckBox(desc, false);
            this.localCB.setToolTipText(tooltip);
            this.comp = comp;
            this.editor = editor;
            LinkStatus.link((AbstractButton)this.localCB, new Component[]{comp});
        }

        public void connect(SelectionEditorPanel.EditorPanel pnl) {
            pnl.addConnection(new SelectionEditorPanel.BoolPropConnection(new IsLocalProp<PropT>(this.prop), this.localCB));
        }
    }
}

