/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Component;
import java.util.concurrent.Semaphore;
import javax.swing.JButton;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.geom.Geometry;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.mv.gui.LocationPanel;
import merlin.util.MerlinProps;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitPoint3D;

public class HandleManipPanel
extends APropEditPanel<MerlinProps> {
    private final Component d_renderComponent;
    private final ManipMgr d_manipMgr;
    private LocPanel d_locPanel;
    private CreateBtPanel d_createPanel;

    public HandleManipPanel(ManipMgr manipMgr, Component renderComp) {
        super(new Object[0]);
        this.d_manipMgr = manipMgr;
        this.d_renderComponent = renderComp;
        this.d_locPanel = new LocPanel();
        this.d_createPanel = new CreateBtPanel();
        this.d_locPanel.setProps(new MerlinProps());
        this.d_createPanel.setProps(new MerlinProps());
        this.addSection(this.d_locPanel);
        this.addSeparator();
        this.addSection(this.d_createPanel);
    }

    public void update() {
        this.d_locPanel.updateFromProps(null);
        this.d_createPanel.updateFromProps(null);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.d_locPanel.getXFld().requestFocusInWindow();
    }

    private class CreateBtPanel
    extends APropEditPanel<MerlinProps> {
        private final JButton d_commitBtn;
        private final JButton d_cancelBtn;

        public CreateBtPanel() {
            super(new Object[0]);
            this.d_commitBtn = this.initButton(new JButton(Intl.intl("Commit")), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    if (!CreateBtPanel.this.validateData(hardValidate, hardValidate) || !HandleManipPanel.this.d_locPanel.validateData(hardValidate, hardValidate)) {
                        return;
                    }
                    HandleManipPanel.this.d_manipMgr.end(true);
                }
            });
            this.d_cancelBtn = this.initButton(new JButton(Intl.intl("Cancel")), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    if (!CreateBtPanel.this.validateData(hardValidate, hardValidate)) {
                        return;
                    }
                    HandleManipPanel.this.d_manipMgr.end(false);
                    HandleManipPanel.this.d_renderComponent.repaint();
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(this.d_commitBtn);
            gb.addRow(this.d_cancelBtn);
        }

        @Override
        protected void updateFromProps(MerlinProps props) {
            this.d_commitBtn.setEnabled(HandleManipPanel.this.d_manipMgr.isManipulating() && HandleManipPanel.this.d_manipMgr.isModified());
            this.d_cancelBtn.setEnabled(HandleManipPanel.this.d_manipMgr.isManipulating());
        }

        @Override
        protected void updateToProps(MerlinProps props) {
        }
    }

    private class LocPanel
    extends LocationPanel<MerlinProps> {
        private final Semaphore d_lock = new Semaphore(1);

        private LocPanel() {
        }

        @Override
        protected void updateFromProps(MerlinProps props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (HandleManipPanel.this.d_manipMgr.isManipulating()) {
                    Point3d p = HandleManipPanel.this.d_manipMgr.getManipLast();
                    if (p == null) {
                        p = HandleManipPanel.this.d_manipMgr.getManipBegin();
                    }
                    if (p == null) {
                        return;
                    }
                    this.setValue(new UnitPoint3D(p, Geometry.LENGTH_UNIT));
                }
            }
            finally {
                this.d_lock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void updateToProps(MerlinProps props) {
            if (!this.d_lock.tryAcquire()) {
                return;
            }
            try {
                if (HandleManipPanel.this.d_manipMgr.isManipulating()) {
                    Point3d p = this.getValue().getPoint3dValue(Geometry.LENGTH_UNIT);
                    ISnapConstraint constraint = HandleManipPanel.this.d_manipMgr.getManipConstraint();
                    Point3d point3d = p = constraint != null ? constraint.snapPoint(p) : p;
                    if (p != null) {
                        HandleManipPanel.this.d_manipMgr.modify(p);
                        HandleManipPanel.this.d_renderComponent.repaint();
                    }
                }
            }
            catch (ManipException p) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                this.d_lock.release();
            }
        }
    }
}

