/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays.scenefinders;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import merlin.data.MerlinHierarchy;
import merlin.mv.displays.scenefinders.ISceneFinder;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.Filters;

public class DescendentSceneFinder<T extends IDisplayableGeomSrc>
implements ISceneFinder<T> {
    private final MerlinHierarchy d_hierarchy;
    private final List<ParentScene> d_parentScenes;

    public DescendentSceneFinder(MerlinHierarchy hier, Object ... parentAndScenes) {
        this.d_hierarchy = hier;
        assert (parentAndScenes.length % 2 == 0);
        this.d_parentScenes = new ArrayList<ParentScene>(parentAndScenes.length / 2);
        for (int m = 0; m < parentAndScenes.length; m += 2) {
            this.d_parentScenes.add(new ParentScene(parentAndScenes[m], (ModelScene)parentAndScenes[m + 1]));
        }
    }

    @Override
    public ModelScene[] getPossibleScenes() {
        ModelScene[] scenes = new ModelScene[this.d_parentScenes.size()];
        for (int m = 0; m < this.d_parentScenes.size(); ++m) {
            scenes[m] = this.d_parentScenes.get((int)m).scene;
        }
        return scenes;
    }

    public ModelScene getScene(T obj) {
        int lastIx = this.d_parentScenes.size() - 1;
        for (int m = 0; m < lastIx; ++m) {
            ParentScene ps = this.d_parentScenes.get(m);
            if (!this.d_hierarchy.isDescendent(ps.parent, obj)) continue;
            return ps.scene;
        }
        return this.d_parentScenes.get((int)lastIx).scene;
    }

    @Override
    public Predicate<T> getFilter(ModelScene scene) {
        for (final ParentScene ps : this.d_parentScenes) {
            if (ps.scene != scene) continue;
            return new Predicate<T>(){

                @Override
                public boolean test(T o) {
                    return DescendentSceneFinder.this.d_hierarchy.isDescendent(ps.parent, o);
                }
            };
        }
        return Filters.rejectAll();
    }

    private static class ParentScene {
        public final Object parent;
        public final ModelScene scene;

        public ParentScene(Object parent, ModelScene scene) {
            this.parent = parent;
            this.scene = scene;
        }
    }
}

