/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import java.awt.Shape;
import merlin.builders.PlanarGeomBuilder;
import merlin.data.ImportedGeom;
import merlin.geom.Geometry;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.displays.APropsDisplay;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.ShapeGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;

public class PlanarGeomBuilderDisplay
extends APropsDisplay<PlanarGeomBuilder> {
    public PlanarGeomBuilderDisplay(ModelView mv) {
        super(mv);
    }

    @Override
    protected Object[] getInterestingChanges() {
        return new Object[0];
    }

    @Override
    protected IMerlinGeomSrc constructGeom(PlanarGeomBuilder builder) {
        Shape outline = builder.getShape();
        if (outline == null) {
            return null;
        }
        ShapeGeom geom = new ShapeGeom(outline, this.getPlane(builder));
        IPrimProps.Edge props = new IPrimProps.Edge(this.getColor(), 3.0, IPrimProps.DEF_STIPPLE, 0);
        return new ImportedGeom("", new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), (IPrimProps)props));
    }

    protected Shape getOutline(PlanarGeomBuilder builder) {
        return builder.getShape();
    }

    protected Plane3d getPlane(PlanarGeomBuilder builder) {
        double z = builder.getZLoc().getValue(Geometry.LENGTH_UNIT);
        return new Plane3d(0.0, 0.0, 1.0, -z);
    }

    protected Color getColor() {
        return Color.GREEN;
    }
}

