/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.data.MerlinData;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.agents.IOccArea;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.material.Material;
import merlin.geom.IMerlinDispProps;
import merlin.mv.MerlinColors;
import merlin.mv.displays.IntensityColorMap;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.Unit;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.DefNativeDisplayProps;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;

public class MerlinDispProps
extends DefNativeDisplayProps
implements IMerlinDispProps,
IEventObserver {
    public static final Color DOORWAY_COLOR = new Color(0.9f, 0.7f, 0.0f, 1.0f);
    public static final Color CORRIDOR_COLOR = new Color(0.9f, 0.7f, 0.6f, 1.0f);
    public static final Color STAIR_EDGE_COLOR = Color.BLACK;
    public static final Color GOAL_COLOR = new Color(50, 255, 50);
    public static final Color FLOOR_COLOR = new Color(0.7f, 0.7f, 0.9f, 1.0f);
    private MerlinData d_md;
    private ColorBy d_colorByType;
    private int d_stairDrawOptions;
    private int d_doorDrawOptions;

    public MerlinDispProps(MerlinData md) {
        this.d_md = md;
        this.d_colorByType = ColorBy.SET_COLOR;
        this.d_stairDrawOptions = 3;
        this.d_doorDrawOptions = 1;
        this.updateDisplayError();
    }

    private void updateDisplayError() {
        this.setCurveError(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_EDGE_ERROR));
        this.setFaceError(MerlinPrefs.getDouble(MerlinPrefs.DISPLAY_FACE_ERROR));
    }

    public void setColorBy(ColorBy cb) {
        this.d_colorByType = cb;
    }

    public ColorBy getColorBy() {
        return this.d_colorByType;
    }

    @Override
    public IPrimProps getEdgeProps(IEgressObj obj, IMerlinDispProps.EgressType primType, Color setColor, float opacity) {
        double lineWidth = MerlinDispProps.getLineWidth(primType);
        Color c = MerlinDispProps.getLineColor(primType, setColor);
        int stipple = MerlinDispProps.getLineStipple(primType);
        c = this.applyAlpha(c, opacity);
        return new IPrimProps.Edge(c, lineWidth, stipple, 0);
    }

    private static int getLineStipple(IMerlinDispProps.EgressType primType) {
        switch (primType) {
            case BLOCKAGE: {
                return IPrimProps.Edge.makeStipple(1, (short)-256);
            }
        }
        return IPrimProps.DEF_STIPPLE;
    }

    private static double getLineWidth(IMerlinDispProps.EgressType primType) {
        switch (primType) {
            case BLOCKAGE: 
            case BOUNDARY: {
                return 2.0;
            }
            case EXIT_DOOR: {
                return 5.0;
            }
            case THIN_DOOR: {
                return 3.0;
            }
        }
        return 1.0;
    }

    private static Color getLineColor(IMerlinDispProps.EgressType primType, Color setColor) {
        switch (primType) {
            case BLOCKAGE: 
            case BOUNDARY: {
                return MerlinApp.getApp().getColorManager().getColor(MerlinColors.BOUNDARY_COLOR);
            }
            case EXIT_DOOR: {
                return setColor != null ? setColor : GOAL_COLOR;
            }
            case THIN_DOOR: {
                return setColor != null ? setColor : DOORWAY_COLOR;
            }
            case CORRIDOR: {
                return STAIR_EDGE_COLOR;
            }
        }
        return Color.WHITE;
    }

    @Override
    public IPrimProps getFaceProps(IEgressObj obj, IMerlinDispProps.EgressType primType, Color setColor, float opacity) {
        Color c = this.getFaceColor(obj, primType, setColor);
        c = this.applyAlpha(c, opacity);
        return new IPrimProps.Face(c, null, 0);
    }

    private Color getFaceColor(IEgressObj obj, IMerlinDispProps.EgressType primType, Color setColor) {
        if (primType == IMerlinDispProps.EgressType.ROOM || primType == IMerlinDispProps.EgressType.CORRIDOR) {
            if (this.d_colorByType == ColorBy.OCC_DENSITY || this.d_colorByType == ColorBy.MIXED) {
                IEgressOccupiable occ = (IEgressOccupiable)obj;
                IOccArea oa = occ.getOccupancy().getOccDensity(this.d_md.occAreas);
                double intensity = 0.0;
                if (!this.d_md.occAreas.isDefault(oa)) {
                    Unit u = SIUS.getInstance().getOccDensity();
                    double densityM = oa.getArea().getValue(u);
                    double minDensityM = this.d_md.occAreas.getMinDensity().getValue(u);
                    double maxDensityM = this.d_md.occAreas.getMaxDensity().getValue(u);
                    intensity = 1.0 - (densityM - minDensityM) / (maxDensityM - minDensityM);
                }
                if (this.d_colorByType == ColorBy.OCC_DENSITY) {
                    return IntensityColorMap.color(intensity, 1.0f);
                }
                if (intensity != 0.0) {
                    return IntensityColorMap.color(intensity, 1.0f);
                }
            } else if (this.d_colorByType == ColorBy.TYPE) {
                IEgressOccupiable occ = (IEgressOccupiable)obj;
                boolean refuge = occ.getTags().contains("safe");
                return refuge ? Color.GREEN : FLOOR_COLOR;
            }
        }
        switch (primType) {
            case EXIT_DOOR: {
                return setColor != null ? setColor : GOAL_COLOR;
            }
            case THICK_DOOR: {
                return setColor != null ? setColor : DOORWAY_COLOR;
            }
            case CORRIDOR: {
                return setColor != null ? setColor : CORRIDOR_COLOR;
            }
            case ROOM: {
                return setColor != null ? setColor : FLOOR_COLOR;
            }
        }
        return Color.WHITE;
    }

    private Color applyAlpha(Color c, float opacity) {
        int alpha = (int)(opacity * 255.0f);
        if (alpha != c.getAlpha()) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return c;
    }

    public void setStairDrawOptions(int options, boolean enabled) {
        this.d_stairDrawOptions = enabled ? (this.d_stairDrawOptions |= options) : (this.d_stairDrawOptions &= ~options);
    }

    @Override
    public int getCorridorDrawOptions() {
        return this.d_stairDrawOptions;
    }

    public void setDoorDrawOptions(int options, boolean enabled) {
        this.d_doorDrawOptions = enabled ? (this.d_doorDrawOptions |= options) : (this.d_doorDrawOptions &= ~options);
    }

    @Override
    public int getDoorDrawOptions() {
        return this.d_doorDrawOptions;
    }

    @Override
    public void update(Events events) {
        if (events.getEvents(MerlinData.class, new Class[0]).containsChange(MerlinData.PREFS_CHANGED)) {
            this.updateDisplayError();
        }
        IEventRecord<Material> texEvts = events.getEvents(Material.class, new Class[0]);
        for (Material tadded : texEvts.getAddedObjs()) {
            this.registerMat(tadded);
        }
        for (Material tremoved : texEvts.getRemovedObjs()) {
            this.removeMat(tremoved);
        }
        for (Material tchanged : texEvts.getChangedObjs(new Object[0])) {
            this.updateMat(tchanged);
        }
    }

    public static enum ColorAgentsBy {
        DEFAULT(0, Intl.intl("Default")),
        SET_COLOR(9, Intl.intl("By Occupant Color")),
        MOVEMENT_GROUP(1, Intl.intl("By Movement Group")),
        MOVEMENT_GROUP_TEMPLATE(2, Intl.intl("By Movement Group Template")),
        BEHAVIOR(3, Intl.intl("By Behavior")),
        PROFILE(4, Intl.intl("Profile"));

        public final String desc;
        public final int prefId;

        private ColorAgentsBy(int prefId, String desc) {
            this.desc = desc;
            this.prefId = prefId;
        }
    }

    public static enum ColorBy {
        SET_COLOR(1, Intl.intl("Default"), Intl.intl("Show the color set on each room.")),
        OCC_DENSITY(0, Intl.intl("By Occupant Density"), Intl.intl("Use an intensity map to show number of occupants/room area.")),
        MIXED(2, Intl.intl("Mixed"), Intl.intl("If no occupants in a room, use room color; otherwise, use occupant density.")),
        TYPE(3, Intl.intl("By Room Type"), Intl.intl("Color by the type of room, such as \"normal\" or \"refuge\"."));

        public final String desc;
        public final String longDesc;
        public final int prefId;

        private ColorBy(int prefId, String desc, String longDesc) {
            this.desc = desc;
            this.longDesc = longDesc;
            this.prefId = prefId;
        }
    }
}

