/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;

public class IntensityColorMap {
    private static float clampIntensity(float value) {
        if (value > 1.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            return 0.0f;
        }
        return value;
    }

    public static Color color(float intensity, float alpha) {
        float blue;
        float green;
        float red;
        intensity = IntensityColorMap.clampIntensity(intensity);
        float i2 = 2.0f * intensity;
        if (intensity <= 0.5f) {
            red = 0.0f;
            green = i2;
            blue = 1.0f - i2;
        } else {
            red = -1.0f + i2;
            green = 2.0f - i2;
            blue = 0.0f;
        }
        return new Color(red, green, blue, alpha);
    }

    public static Color color(double intensity, float alpha) {
        return IntensityColorMap.color((float)intensity, alpha);
    }

    public static float red(float intensity) {
        if ((intensity = IntensityColorMap.clampIntensity(intensity)) <= 0.5f) {
            return 0.0f;
        }
        return -1.0f + 2.0f * intensity;
    }

    public static float green(float intensity) {
        if ((intensity = IntensityColorMap.clampIntensity(intensity)) <= 0.5f) {
            return 2.0f * intensity;
        }
        return 2.0f - 2.0f * intensity;
    }

    public static float blue(float intensity) {
        if ((intensity = IntensityColorMap.clampIntensity(intensity)) <= 0.5f) {
            return 1.0f - 2.0f * intensity;
        }
        return 0.0f;
    }
}

