/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import merlin.MerlinApp;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.GotoWaypoint;
import merlin.mv.displays.GeomDispMgr;
import merlin.mv.displays.IMerlinDisplay;
import merlin.mv.displays.MerlinDispProps;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.StringRenderer;
import thunderheadeng.scene3d.nativebuffered.TextRenderer;

public class GotoDisplay
implements IMerlinDisplay {
    private final GotoWaypoint d_waypoint;
    private final GeomDispMgr.Display d_geom;
    private final StringRenderer d_number;

    public GotoDisplay(MerlinDispProps dispProps, GotoWaypoint waypoint, TextRenderer textRenderer) {
        this.d_waypoint = waypoint;
        this.d_geom = new GeomDispMgr.Display(dispProps, waypoint);
        this.d_number = new StringRenderer();
        this.d_number.setRenderer(textRenderer);
        this.update();
    }

    @Override
    public IDisplayable[] getDisplayObjs() {
        return new IDisplayable[]{this.d_geom, this.d_number};
    }

    @Override
    public void setSelected(boolean selected) {
        this.d_geom.setSelected(selected);
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_geom.setVisible(visible);
        this.d_number.setVisible(visible);
    }

    @Override
    public void update() {
        this.d_geom.update();
        this.d_number.setLocation(this.d_waypoint.getLocation(), null);
        int ix = this.getIndex();
        String text = ix >= 0 ? Integer.toString(ix + 1) : "";
        this.d_number.setString(text);
    }

    private int getIndex() {
        Object parent = MerlinApp.getApp().getData().hierarchy.getParent(this.d_waypoint);
        if (parent instanceof Behavior) {
            int ix = 0;
            for (GotoWaypoint gw : ((Behavior)parent).getMembers(GotoWaypoint.class)) {
                if (gw == this.d_waypoint) {
                    return ix;
                }
                ++ix;
            }
        }
        return -1;
    }
}

