/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import merlin.Intl;
import merlin.gui.value.AValEditor;
import merlin.gui.value.EditValDlg;
import merlin.gui.value.IValEditor;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.guiTextField;

public class PopupValEditor<T>
extends AValEditor<T>
implements IValEditor<T> {
    private final Mode d_mode;
    private final Supplier<? extends IValEditor<T>> d_editor;
    private final String d_desc;
    private final Function<T, String> d_formatter;
    private final guiTextField d_fldText;
    private final JButton d_editButton;
    private final HTMLBtn d_htmlBtn;

    public PopupValEditor(Mode mode, Class<T> type, String desc, Supplier<? extends IValEditor<T>> popupEditor, Function<T, String> formatter) {
        super(type);
        this.d_mode = mode;
        this.d_formatter = formatter;
        this.d_editor = popupEditor;
        this.d_desc = desc;
        ActionListener editAction = e -> SwingUtilities.invokeLater(() -> this.editValue());
        if (mode == Mode.HTML) {
            this.d_fldText = null;
            this.d_editButton = null;
            this.d_htmlBtn = new HTMLBtn("");
            this.d_htmlBtn.addActionListener(editAction);
        } else {
            this.d_htmlBtn = null;
            this.d_fldText = new guiTextField();
            this.d_fldText.setEditable(false);
            Dimension szFld = this.d_fldText.getPreferredSize();
            this.d_fldText.setPreferredSize(new Dimension((int)((double)szFld.width * 2.5), szFld.height));
            this.d_editButton = new JButton(Intl.intl("Edit..."));
            this.d_editButton.addActionListener(editAction);
        }
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.finalizeRows();
    }

    @Override
    public void add(GridBagHelper gb) {
        if (this.d_mode == Mode.HTML) {
            gb.add(this.d_htmlBtn, 1.0);
        } else {
            gb.add(this.d_fldText, 1.0, this.d_editButton);
        }
    }

    @Override
    public T saveValue() {
        return this.getValue();
    }

    @Override
    public void loadValue(T value) {
        String text = this.d_formatter.apply(value);
        switch (this.d_mode) {
            case BUTTON: {
                this.d_fldText.setText(text);
                this.d_fldText.setCaretPosition(0);
                String tt = text.isEmpty() ? null : text;
                this.d_fldText.setToolTipText(tt);
                break;
            }
            case HTML: {
                this.d_htmlBtn.setText(text);
                String tt = text.isEmpty() ? null : "<html>" + text + "</html>";
                this.d_htmlBtn.setToolTipText(tt);
                break;
            }
        }
    }

    public boolean editValue() {
        JTextComponent comp = this.d_htmlBtn != null ? this.d_htmlBtn : this.d_fldText;
        Window parent = SwingUtilities.getWindowAncestor(comp);
        IValEditor editor = this.d_editor.get();
        editor.setValue(this.getValue());
        EditValDlg<T> dlg = new EditValDlg<T>(parent, this.d_desc, editor);
        if (dlg.doModal() == 1) {
            T newVal = editor.getValue();
            this.setValue(newVal);
            return true;
        }
        return false;
    }

    public static enum Mode {
        HTML,
        BUTTON;

    }
}

