/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.stat;

import java.util.function.Predicate;
import java.util.function.Supplier;
import merlin.Intl;
import merlin.gui.MerlinValueFields;
import merlin.gui.value.AValEditor;
import merlin.unitsystem.SIUS;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.stat.LogNormCurve;

public class LogNormEditor
extends AValEditor<LogNormCurve> {
    private ValueField<UnitDouble> d_min;
    private ValueField<UnitDouble> d_max;
    private ValueField<UnitDouble> d_logMean;
    private ValueField<UnitDouble> d_logStDev;

    public LogNormEditor(int unitType) {
        this(unitType, UnitDoubleVR.above(0.0, SIUS.unit(unitType), true));
    }

    public LogNormEditor(int unitType, UnitDoubleVR range) {
        super(LogNormCurve.class);
        Supplier<ValueField> fieldFactory = () -> this.registerEd(MerlinValueFields.udFld(SIUS.newud(0.0, unitType), (Predicate<UnitDouble>)range, unitType));
        this.d_min = fieldFactory.get();
        this.d_max = fieldFactory.get();
        this.d_logMean = fieldFactory.get();
        this.d_logStDev = fieldFactory.get();
        guiLabel location = new guiLabel(Intl.intl("Location (\u03bc):"));
        location.setToolTipText(Intl.intl("Location parameter (\u03bc) is the normal mean of this lognormal distribution."));
        guiLabel scale = new guiLabel(Intl.intl("Scale (\u03c3):"));
        scale.setToolTipText(Intl.intl("Scale parameter (\u03c3) is the normal std. dev. of this lognormal distribution - it must be positive or zero."));
        GridBagHelper gb = new GridBagHelper(this, false);
        gb.addRow(Intl.intl("Min:"), this.d_min, Intl.intl("Max:"), this.d_max);
        gb.addRow(location, this.d_logMean, scale, this.d_logStDev);
        gb.finalizeRows();
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this, 1.0);
    }

    @Override
    public void loadValue(LogNormCurve lnc) {
        this.d_min.setValue(lnc.getMin());
        this.d_max.setValue(lnc.getMax());
        this.d_logMean.setValue(lnc.getAvg());
        this.d_logStDev.setValue(lnc.getStdDev());
    }

    @Override
    public LogNormCurve saveValue() {
        return new LogNormCurve((UnitDouble)this.d_min.getValue(), (UnitDouble)this.d_max.getValue(), (UnitDouble)this.d_logMean.getValue(), (UnitDouble)this.d_logStDev.getValue());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        UnitDouble max;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        UnitDouble min = (UnitDouble)this.d_min.getValue();
        if (min.sub(max = (UnitDouble)this.d_max.getValue()).getValueNoUnit() > 0.0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Req: Min <= Max"));
            }
            return false;
        }
        UnitDouble stdDev = (UnitDouble)this.d_logStDev.getValue();
        if (stdDev.getValueNoUnit() < 0.0) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Req: Location parameter >= 0"));
            }
            return false;
        }
        return true;
    }
}

