/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.scripting;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.NewObject;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.data.scripting.ScriptGroup;
import merlin.data.scripting.ScriptObj;
import merlin.gui.ManagerDlg;
import merlin.gui.NewActionListener;
import merlin.gui.scripting.ScriptEditorPanel;
import merlin.unitsystem.UnitSystem;
import thunderheadeng.gui.IEditor;

public class ScriptDlg
extends ManagerDlg<ScriptObj, ManagerDlg.IManager<ScriptObj>> {
    private final IEditor<ScriptObj> d_editor = new ScriptEditorPanel();
    private final Action[] d_actions;
    private ManagerDlg.IManager<ScriptObj> d_mgr;

    public ScriptDlg(JFrame owner, UnitSystem uSys) {
        super(owner, Intl.intl("Edit Custom Scripts"), ScriptObj.class);
        String newMsg = "New Custom Script";
        this.d_actions = new Action[]{this.newAction(new NewActionListener<ScriptObj>(new NewObject<ScriptObj>(ScriptObj.class, md -> md.customScripts, md -> md.customScriptNameGen, (mgr, obj) -> {
            ScriptDlg dlg = new ScriptDlg(MerlinApp.getApp().getMainFrame(), MerlinApp.getApp().getUnitSystem());
            dlg.init(MerlinApp.getApp().getData(), (ManagerDlg.IManager<ScriptObj>)mgr, (ScriptObj)obj);
            dlg.doModal();
        }, newMsg, ScriptObj.PROP_NAME, ScriptGroup.class, md -> new ScriptObj()))), new ManagerDlg.RenameAction(ScriptObj.PROP_NAME, newMsg, md -> md.customScripts), new ManagerDlg.DeleteAction()};
        this.updateActions();
    }

    @Override
    protected boolean validateEditor(IEditor<ScriptObj> editor, boolean showWarn, boolean allowModify) {
        boolean modified = this.d_editor.isModified();
        if (!super.validateEditor(editor, showWarn, allowModify)) {
            return false;
        }
        if (modified) {
            int ix = this.getList().getSelectedIx();
            ScriptObj prof = (ScriptObj)this.getList().getItem(ix);
            if (prof != null && !this.validateScript(prof, showWarn, allowModify)) {
                return false;
            }
        }
        return true;
    }

    protected boolean validateScript(ScriptObj prof, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[1].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    public void init(MerlinData md, ManagerDlg.IManager<ScriptObj> mgr, ScriptObj init) {
        this.d_mgr = mgr;
        super.init(md, this.d_mgr, this.d_editor, this.d_actions);
        this.updateActions();
        if (init != null) {
            this.getList().select(init);
        }
    }

    public static ScriptObj addScript(MerlinData md, String name) {
        ScriptObj scriptNew;
        Undo.begin(Intl.intl("New Custom Script"));
        try {
            scriptNew = new ScriptObj();
            scriptNew.setName(name);
            AddObject.add((MerlinData)md, (Composite)md.customScripts, (int)md.customScripts.getMembers().size(), (ICompElement[])new ScriptObj[]{scriptNew});
        }
        finally {
            Undo.end(md);
        }
        return scriptNew;
    }

    private class NewAction
    extends AbstractAction {
        public NewAction() {
            super(Intl.intl("New..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ScriptDlg.this.preSave()) {
                return;
            }
            final ScriptObj[] newScript = new ScriptObj[1];
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    md.beginWrite();
                    try {
                        newScript[0] = ScriptDlg.addScript(md, null);
                    }
                    finally {
                        md.endWrite();
                    }
                }
            };
            UIHook.run(UIHook.getComponent(e), "ScriptDlg.NewAction", op, 2);
            assert (newScript[0] != null);
            ScriptDlg.this.getList().updateModelView(ScriptDlg.this.d_mgr);
            ScriptDlg.this.getList().select(newScript[0]);
            ScriptDlg.this.d_editor.getEditorPanel().setModified(false);
            ScriptDlg.this.updateActions();
        }
    }
}

