/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.BoundedStack;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.MerlinSelectionModel;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.VehicleShape;
import merlin.geom.Geometry;
import merlin.gui.AvatarEditor;
import merlin.gui.MerlinUDF;
import merlin.gui.MerlinValueFields;
import merlin.gui.PointListEditor;
import merlin.gui.PolygonEditor;
import merlin.gui.guiUtil;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Property;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;

public class VehicleShapesPanel
extends guiPanel
implements IEditor<VehicleShape> {
    private static final UnitDouble MAX_NURSE_DIST = new UnitDouble(1.5, SI.METER);
    private String TITLE = Intl.intl("Vehicle Shapes");
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final ValueField<UnitDouble> d_height;
    private final PolygonEditor d_vehicleShapeEditor;
    private final PolygonEditor d_attachedAgentsSpotsEditor;
    private final PointListEditor d_pivotEditor;
    private final guiCheckBox d_allowSideways;
    private final guiComboBox<VehicleShape.AnimType> d_animType;
    private final AvatarEditor d_model;
    private final ValueField<UnitDouble> d_offsetx;
    private final ValueField<UnitDouble> d_offsety;
    private final ValueField<UnitDouble> d_offsetz;
    private final VehicleShape2DViewCanvas d_vehicleShapeView;
    private final guiLabel d_errorLbl;
    private final ImageIcon d_warnIcon;
    private VehicleShapeUndo d_undo;
    private JButton d_undoBtn;
    private JButton d_redoBtn;
    public final Icon ICON_UNDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Undo16.gif");
    public final Icon ICON_REDO = UIHook.loadIcon("thunderheadeng/gui/graphics/Redo16.gif");
    private MerlinUDF d_areaField;
    private guiIntField d_corrOccField;

    public VehicleShapesPanel(MerlinData md) {
        this.setLayout(new GridBagLayout());
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_desc = new guiTextField();
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        this.d_height = MerlinValueFields.udFld(0);
        Supplier<ValueField> offsetFld = () -> {
            ValueField<UnitDouble> fld = MerlinValueFields.udFld(0);
            fld.setColumns(6);
            return fld;
        };
        this.d_offsetx = offsetFld.get();
        this.d_offsety = offsetFld.get();
        this.d_offsetz = offsetFld.get();
        this.d_allowSideways = new guiCheckBox(Intl.intl("Allow sideways movement"));
        this.d_allowSideways.setToolTipText("<html>" + Intl.intl("Whether occupants using this shape can move in a direction they<br>are not facing in order to avoid other occupants."));
        this.d_animType = new guiComboBox<VehicleShape.AnimType>(VehicleShape.AnimType.values());
        this.d_animType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String txt;
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                switch ((VehicleShape.AnimType)((Object)value)) {
                    case BED: {
                        txt = Intl.intl("Bed");
                        break;
                    }
                    case WHEELCHAIR: {
                        txt = Intl.intl("Wheelchair");
                        break;
                    }
                    default: {
                        txt = Intl.intl("Default");
                    }
                }
                this.setText(txt);
                return this;
            }
        });
        this.d_model = new AvatarEditor(6, ResourceAvatar.Type.VEHICLE);
        this.d_model.addValueListener(e -> this.setModified(true));
        BiFunction<String, String, guiLabel> lbl = (desc, tt) -> {
            guiLabel label = new guiLabel((String)desc);
            label.setToolTipText((String)tt);
            return label;
        };
        guiPanel topPnl = new guiPanel(new GridBagLayout());
        GridBagHelper gb = new GridBagHelper(topPnl);
        gb.addRow(Intl.intl("Name:"), this.d_name, 1.0, GridBagHelper.REMAINING);
        gb.addRow(Intl.intl("Description:"), this.d_desc, 1.0, GridBagHelper.REMAINING);
        gb.addRow(lbl.apply(Intl.intl("Height:"), Intl.intl("The height of the collision volume for the shape")), this.d_height, 1.0, GridBagHelper.REMAINING);
        gb.addRow(lbl.apply(Intl.intl("3d Model:"), "<html>" + Intl.intl("The 3d model that represents the shape. This is shown in addition to<br>the 3d model of the occupant using the shape.")), this.d_model, 1.0, 0);
        gb.addRow(lbl.apply(Intl.intl("Occupant Animation:"), Intl.intl("The animation applied to occupants using the shape.")), this.d_animType, 0.0, 0);
        gb.addRow(lbl.apply(Intl.intl("Occupant Offset:"), Intl.intl("The offset for the occupant's 3d model so it lines up with the shape's 3d model.")), Intl.intl("X:"), this.d_offsetx, Intl.intl("Y:"), this.d_offsety, Intl.intl("Z:"), this.d_offsetz, 0);
        if (md.simParams.enableVehicleLateralMovementVis) {
            gb.addRow(this.d_allowSideways, 1.0, GridBagHelper.REMAINING);
        }
        this.d_vehicleShapeView = new VehicleShape2DViewCanvas();
        this.d_vehicleShapeEditor = new PolygonEditor(false, 14, true);
        this.d_attachedAgentsSpotsEditor = new PolygonEditor(false, 2, false);
        this.d_pivotEditor = new PointListEditor(false, false, 0, false);
        this.d_pivotEditor.setPreferredSize(new Dimension(223, 43));
        this.d_pivotEditor.setMinimumSize(new Dimension(223, 0));
        this.d_areaField = new MerlinUDF(4);
        this.d_areaField.setEditable(false);
        String areaToolTip = Intl.intl("The area of the vehicle shape (not including attached occupants)");
        this.d_areaField.setToolTipText(areaToolTip);
        guiLabel areaLbl = new guiLabel(Intl.intl("Shape Area:"));
        areaLbl.setToolTipText(areaToolTip);
        this.d_corrOccField = new guiIntField();
        this.d_corrOccField.setEditable(false);
        String corrOccToolTip = Intl.intl("The number of occupants corresponding to the shape area (not including attached occupants)");
        this.d_corrOccField.setToolTipText(corrOccToolTip);
        guiLabel corrOccLbl = new guiLabel(Intl.intl("Corresponding occupant count:"));
        corrOccLbl.setToolTipText(corrOccToolTip);
        this.addTableChangedListeners();
        this.addSelectionListeners();
        guiPanel vehicle2dViewPnl = new guiPanel(new GridBagLayout());
        gb = new GridBagHelper(vehicle2dViewPnl);
        gb.addIdentRow(this.d_vehicleShapeView, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        vehicle2dViewPnl.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        guiPanel editors = new guiPanel(new GridBagLayout());
        gb = new GridBagHelper(editors);
        gb.addRow(Intl.intl("Points:"), new double[]{0.0, 0.0}, GridBagHelper.REMAINING);
        gb.addIdentRow(this.d_vehicleShapeEditor, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        gb.addRow(Intl.intl("Pivot:"), 1.0, GridBagHelper.REMAINING);
        gb.addIdentRow(this.d_pivotEditor, new double[]{0.0, 0.0}, GridBagHelper.REMAINING);
        gb.addRow(Intl.intl("Positions of attached occupants:"), 1.0, GridBagHelper.REMAINING);
        gb.addIdentRow(this.d_attachedAgentsSpotsEditor, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        gb.addRow(areaLbl, this.d_areaField, new double[]{0.0, 0.0}, GridBagHelper.REMAINING);
        gb.addRow(corrOccLbl, this.d_corrOccField, new double[]{0.0, 0.0}, GridBagHelper.REMAINING);
        gb = new GridBagHelper(this);
        gb.addRow(topPnl, 1.0, GridBagHelper.REMAINING);
        gb.addFilledRow(new guiSeparator());
        gb.addCol((Component)editors, new Object[]{new double[]{0.0, 1.0}});
        gb.addCol((Component)vehicle2dViewPnl, new Object[]{new double[]{1.0, 1.0}, GridBagHelper.REMAINING});
        this.d_errorLbl = new guiLabel();
        this.d_errorLbl.setPreferredSize(new Dimension(500, 15));
        this.d_errorLbl.setForeground(Color.red);
        this.d_warnIcon = guiUtil.loadMerlinIcon("warn16.gif");
        gb.nextRow();
        gb.addRow(this.d_errorLbl, GridBagHelper.REMAINING);
        this.setMinimumSize(this.getMinimumSize());
    }

    private void addTableChangedListeners() {
        this.d_vehicleShapeEditor.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Point3d[] points = VehicleShapesPanel.this.d_vehicleShapeEditor.savePoints();
                VehicleShapesPanel.this.d_vehicleShapeView.setVehicleShape(points);
                VehicleShapesPanel.this.checkForErrors(VehicleShapesPanel.this.d_vehicleShapeView.d_shapePointsOrig, VehicleShapesPanel.this.d_vehicleShapeView.d_attachedPositionsOrig, VehicleShapesPanel.this.d_vehicleShapeView.d_pivotOrig);
                VehicleShapesPanel.this.refreshAreaAndOccCount();
            }
        });
        this.d_attachedAgentsSpotsEditor.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                VehicleShapesPanel.this.d_vehicleShapeView.setAttachedPositions(VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.savePoints());
                VehicleShapesPanel.this.checkForErrors(VehicleShapesPanel.this.d_vehicleShapeView.d_shapePointsOrig, VehicleShapesPanel.this.d_vehicleShapeView.d_attachedPositionsOrig, VehicleShapesPanel.this.d_vehicleShapeView.d_pivotOrig);
            }
        });
        this.d_pivotEditor.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                List<Point3d> newPivot = VehicleShapesPanel.this.d_pivotEditor.save();
                if (newPivot == null || newPivot.isEmpty()) {
                    return;
                }
                VehicleShapesPanel.this.d_vehicleShapeView.setPivot(newPivot.get(0));
                VehicleShapesPanel.this.checkForErrors(VehicleShapesPanel.this.d_vehicleShapeView.d_shapePointsOrig, VehicleShapesPanel.this.d_vehicleShapeView.d_attachedPositionsOrig, VehicleShapesPanel.this.d_vehicleShapeView.d_pivotOrig);
            }
        });
    }

    private void addSelectionListeners() {
        this.d_vehicleShapeEditor.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = VehicleShapesPanel.this.d_vehicleShapeEditor.getSelectedRows();
                if (selectedRows.length == 1) {
                    VehicleShapesPanel.this.d_vehicleShapeView.setSelectedPoint(selectedRows[0], true);
                    VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.clearSelection();
                } else if (selectedRows.length > 1) {
                    VehicleShapesPanel.this.d_vehicleShapeView.clearSelection();
                }
            }
        });
        this.d_attachedAgentsSpotsEditor.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.getSelectedRows();
                if (selectedRows.length == 1) {
                    VehicleShapesPanel.this.d_vehicleShapeView.setSelectedPoint(selectedRows[0], false);
                    VehicleShapesPanel.this.d_vehicleShapeEditor.clearSelection();
                } else if (selectedRows.length > 1) {
                    VehicleShapesPanel.this.d_vehicleShapeView.clearSelection();
                }
            }
        });
    }

    private void checkForErrors(Point3d[] shapePoints, Point3d[] attachedPositions, Point2d pivot) {
        this.error(null);
        if (shapePoints == null) {
            return;
        }
        if (!this.d_vehicleShapeEditor.validateData(false, false) || !this.d_attachedAgentsSpotsEditor.getPointListEditor().validateData(false, false)) {
            this.error(Intl.intl("Invalid data"));
        }
        if (shapePoints.length <= 2) {
            this.error(Intl.intl("Vehicle shape is not a polygon"));
            return;
        }
        if (!Util3D.isConvex(1.0E-6, shapePoints)) {
            this.error(Intl.intl("Vehicle shape is non-convex"));
            return;
        }
        if (!Inter3D.pointInPoly(0.0, new Point3d(0.0, 0.0, 0.0), shapePoints)) {
            this.error(Intl.intl("Vehicle shape does not contain the origin"));
            return;
        }
        if (attachedPositions != null && attachedPositions.length != 0) {
            for (int i = 0; i < attachedPositions.length; ++i) {
                if (Inter3D.pointInPoly(0.0, attachedPositions[i], shapePoints)) {
                    this.error(Intl.intl("Some assisting occupants are intersecting with the vehicle shape"));
                    break;
                }
                double dist = (Double)VehicleShapesPanel.findClosestEdge((Point3d[])shapePoints, (Point3d)attachedPositions[i]).v1;
                if (!(dist > MAX_NURSE_DIST.get(Geometry.LENGTH_UNIT))) continue;
                this.error(Intl.intl("Some assisting occupants are too far away from the vehicle"));
            }
        }
    }

    private void error(String msg) {
        if (msg != null && !msg.isEmpty()) {
            this.d_errorLbl.setIcon(this.d_warnIcon);
        } else {
            this.d_errorLbl.setIcon(null);
        }
        this.d_errorLbl.setText(msg);
    }

    @Override
    public void init(VehicleShape dataObj) {
        if (dataObj != null) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                this.d_name.setText(dataObj.getProperty(VehicleShape.PROP_NAME));
                this.d_desc.setText(dataObj.getProperty(VehicleShape.PROP_DESC));
            }
            finally {
                md.endRead();
            }
        }
        this.initData(dataObj);
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initData(VehicleShape dataObj) {
        if (dataObj != null) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                this.d_height.setValue(dataObj.getProperty(VehicleShape.PROP_HEIGHT));
                this.d_allowSideways.setSelected(dataObj.getProperty(VehicleShape.PROP_ALLOW_LATERAL));
                this.d_animType.setSelectedItem((Object)dataObj.getProperty(VehicleShape.PROP_ANIM_TYPE));
                IAvatar model = dataObj.getProperty(VehicleShape.PROP_MODEL);
                Urn<IAvatar> modelUrn = new Urn<IAvatar>(model);
                this.d_model.setValue(Property.of(modelUrn));
                this.d_vehicleShapeEditor.load(dataObj.getProperty(VehicleShape.PROP_POINTS));
                this.d_attachedAgentsSpotsEditor.load(dataObj.getProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS));
                this.d_pivotEditor.setPoint(dataObj.getProperty(VehicleShape.PROP_PIVOT), 0);
                this.d_vehicleShapeView.clearAll(true);
                this.d_vehicleShapeView.setVehicleShape(this.d_vehicleShapeEditor.savePoints());
                this.d_vehicleShapeView.setAttachedPositions(this.d_attachedAgentsSpotsEditor.savePoints());
                UnitPoint3D offset = dataObj.getProperty(VehicleShape.PROP_OCCAVATAR_OFFSET);
                this.d_offsetx.setValue(offset.xu());
                this.d_offsety.setValue(offset.yu());
                this.d_offsetz.setValue(offset.zu());
                this.d_undo = new VehicleShapeUndo();
                this.d_undo.refreshButtons();
                this.refreshAreaAndOccCount();
            }
            finally {
                md.endRead();
            }
        }
        this.setModified(false);
    }

    @Override
    public VehicleShape commit(final VehicleShape dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Undo.begin(Intl.intl("Edit Vehicle Shape"));
                    md.beginWrite();
                    try {
                        VehicleShapesPanel.insertUndoOp(md, dataObj);
                        dataObj.setProperty(VehicleShape.PROP_DESC, VehicleShapesPanel.this.d_desc.getText());
                        dataObj.setProperty(VehicleShape.PROP_HEIGHT, VehicleShapesPanel.this.d_height.getValue());
                        dataObj.setProperty(VehicleShape.PROP_ALLOW_LATERAL, Boolean.valueOf(VehicleShapesPanel.this.d_allowSideways.isSelected()));
                        dataObj.setProperty(VehicleShape.PROP_ANIM_TYPE, VehicleShapesPanel.this.d_animType.getSelectedItem());
                        IAvatar model = null;
                        ArrayList avatars = new ArrayList();
                        ((IUrn)((Property)VehicleShapesPanel.this.d_model.getValue()).get()).getUnique(avatars);
                        assert (!avatars.isEmpty());
                        model = (IAvatar)avatars.get(0);
                        dataObj.setProperty(VehicleShape.PROP_MODEL, model);
                        UnitDouble x = (UnitDouble)VehicleShapesPanel.this.d_offsetx.getValue();
                        UnitDouble y = (UnitDouble)VehicleShapesPanel.this.d_offsety.getValue();
                        UnitDouble z = (UnitDouble)VehicleShapesPanel.this.d_offsetz.getValue();
                        dataObj.setProperty(VehicleShape.PROP_OCCAVATAR_OFFSET, new UnitPoint3D(x, y, z));
                        dataObj.setProperty(VehicleShape.PROP_POINTS, VehicleShapesPanel.this.d_vehicleShapeEditor.savePolygon());
                        dataObj.setProperty(VehicleShape.PROP_ATTACHED_AGENTS_POSITIONS, VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.savePoints());
                        dataObj.setProperty(VehicleShape.PROP_PIVOT, VehicleShapesPanel.this.d_pivotEditor.save().get(0));
                    }
                    finally {
                        Undo.end(MerlinApp.getApp().getData());
                        md.endWrite();
                    }
                }
            };
            UIHook.run(this, "VehicleShapesPanel.commit", op, 2);
        }
        this.setModified(false);
        return dataObj;
    }

    private static void insertUndoOp(MerlinData md, VehicleShape shape) {
        Collection<EgressAgent> agents = VehicleShapesPanel.getAgentsUsing(md, shape);
        Op op = new Op(shape, shape.getRestoreObj(), md.selection.isSelected(shape), agents);
        Undo.insertEntry(md, op);
        VehicleShapesPanel.updateAgents(agents);
    }

    private static void updateAgents(Collection<EgressAgent> agents) {
        for (EgressAgent agent : agents) {
            agent.updateProps();
        }
    }

    private static Collection<EgressAgent> getAgentsUsing(MerlinData md, VehicleShape shape) {
        ArrayList<EgressAgent> agents = new ArrayList<EgressAgent>();
        for (EgressAgent agent : md.agents.getDeepMembers(EgressAgent.class)) {
            if (agent.getProfile().getProperty(OccProfile.PROP_VEHICLE_SHAPE) != shape) continue;
            agents.add(agent);
        }
        return agents;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_errorLbl.getText() == null) {
            return true;
        }
        JOptionPane.showMessageDialog(this, this.d_errorLbl.getText(), Intl.intl("Invalid data"), 0);
        return false;
    }

    public static Pair<Double, Integer> findClosestEdge(Point3d[] polygon, Point3d point) {
        double minDist = Double.MAX_VALUE;
        int minDistIndex = 0;
        for (int i = 0; i < polygon.length; ++i) {
            int start = i;
            int end = (i + 1) % polygon.length;
            Point3d nearestPoint = Inter3D.nearestPointOnLineSeg(polygon[start], polygon[end], point);
            double distToSeg = nearestPoint.distance(point);
            if (!(distToSeg < minDist)) continue;
            minDist = distToSeg;
            minDistIndex = i;
        }
        return new Pair<Double, Integer>(minDist, minDistIndex);
    }

    private void refreshAreaAndOccCount() {
        Point3d[] points = this.d_vehicleShapeEditor.savePoints();
        if (points != null) {
            double area = Util3D.simplePolygonArea(Arrays.asList(points));
            Unit au = MerlinApp.getApp().getUnitSystem().getArea();
            UnitDouble areaUD = UnitDouble.from(area, Geometry.AREA_UNIT, au);
            this.d_areaField.setValue(areaUD);
            double occArea = Math.PI * Math.pow(0.24, 2.0);
            int correspondingOccCount = (int)Math.round(area / occArea);
            this.d_corrOccField.setValue(correspondingOccCount);
        }
    }

    public class VehicleShapeUndoItem {
        private Point3d[] vehicleShape;
        private Point3d[] attachedAgentsPositions;
        private Point3d pivot;
        private String d_text;

        public VehicleShapeUndoItem(Point3d[] vehicleShape, Point3d[] attachedAgentsPositions, Point3d pivot, String text) {
            this.vehicleShape = this.clone(vehicleShape);
            this.attachedAgentsPositions = this.clone(attachedAgentsPositions);
            this.pivot = new Point3d(pivot);
            this.d_text = text;
        }

        private Point3d[] clone(Point3d[] input) {
            if (input == null) {
                return null;
            }
            Point3d[] output = new Point3d[input.length];
            for (int i = 0; i < input.length; ++i) {
                output[i] = new Point3d(input[i]);
            }
            return output;
        }

        public String getText() {
            return this.d_text;
        }
    }

    public class VehicleShapeUndo {
        private static final int STACK_SIZE = 10;
        private final BoundedStack<VehicleShapeUndoItem> STACK_UNDO = new BoundedStack(10);
        private final BoundedStack<VehicleShapeUndoItem> STACK_REDO = new BoundedStack(10);
        private final String undoText = Intl.intl("Undo");
        private final String redoText = Intl.intl("Redo");

        public void createUndo(String text) {
            VehicleShapeUndoItem undoItem = new VehicleShapeUndoItem(VehicleShapesPanel.this.d_vehicleShapeEditor.savePoints(), VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.savePoints(), VehicleShapesPanel.this.d_pivotEditor.save().get(0), text);
            this.STACK_UNDO.push(undoItem);
            this.STACK_REDO.clear();
            this.refreshButtons();
        }

        public void performUndo() {
            if (this.STACK_UNDO.size() == 0) {
                return;
            }
            VehicleShapeUndoItem undoItem = this.STACK_UNDO.pop();
            this.createRedo(undoItem.getText());
            VehicleShapesPanel.this.d_vehicleShapeEditor.load(undoItem.vehicleShape);
            VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.load(undoItem.attachedAgentsPositions);
            VehicleShapesPanel.this.d_pivotEditor.setPoint(undoItem.pivot, 0);
            VehicleShapesPanel.this.d_vehicleShapeView.clearAll(true);
            this.refreshButtons();
        }

        private void createRedo(String text) {
            VehicleShapeUndoItem undoItem = new VehicleShapeUndoItem(VehicleShapesPanel.this.d_vehicleShapeEditor.savePoints(), VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.savePoints(), VehicleShapesPanel.this.d_pivotEditor.save().get(0), text);
            this.STACK_REDO.push(undoItem);
            this.refreshButtons();
        }

        public void performRedo() {
            if (this.STACK_REDO.size() == 0) {
                return;
            }
            VehicleShapeUndoItem undoItem = this.STACK_REDO.pop();
            this.createUndo(undoItem.getText());
            VehicleShapesPanel.this.d_vehicleShapeEditor.load(undoItem.vehicleShape);
            VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.load(undoItem.attachedAgentsPositions);
            VehicleShapesPanel.this.d_pivotEditor.setPoint(undoItem.pivot, 0);
            VehicleShapesPanel.this.d_vehicleShapeView.clearAll(true);
            this.refreshButtons();
        }

        public String getUndoText() {
            if (this.STACK_UNDO.size() == 0) {
                return "";
            }
            return this.STACK_UNDO.peek().getText();
        }

        public void refreshButtons() {
            if (this.STACK_UNDO.size() == 0) {
                VehicleShapesPanel.this.d_undoBtn.setToolTipText(null);
                VehicleShapesPanel.this.d_undoBtn.setEnabled(false);
            } else {
                VehicleShapesPanel.this.d_undoBtn.setToolTipText(this.undoText + " " + this.STACK_UNDO.peek().getText());
                VehicleShapesPanel.this.d_undoBtn.setEnabled(true);
            }
            if (this.STACK_REDO.size() == 0) {
                VehicleShapesPanel.this.d_redoBtn.setToolTipText(null);
                VehicleShapesPanel.this.d_redoBtn.setEnabled(false);
            } else {
                VehicleShapesPanel.this.d_redoBtn.setToolTipText(this.redoText + " " + this.STACK_REDO.peek().getText());
                VehicleShapesPanel.this.d_redoBtn.setEnabled(true);
            }
        }
    }

    public class SelectedPoint
    implements Comparable<Object> {
        private Point3i d_point;
        private boolean d_isSelectedShapePoint;
        private boolean d_isSelectedAttachedPosPoint;
        private double d_dist;
        private int d_index;
        private boolean d_isSelectedPivot;

        public SelectedPoint(Point3i point, boolean isSelectedShapePoint, boolean isSelectedAttachPosPoint, boolean isSelectedPivot, double dist, int index) {
            this.d_point = point;
            this.d_isSelectedShapePoint = isSelectedShapePoint;
            this.d_isSelectedAttachedPosPoint = isSelectedAttachPosPoint;
            this.d_isSelectedPivot = isSelectedPivot;
            this.d_dist = dist;
            this.d_index = index;
        }

        public SelectedPoint(SelectedPoint selectedPoint) {
            this.d_point = new Point3i(selectedPoint.d_point);
            this.d_isSelectedShapePoint = selectedPoint.d_isSelectedShapePoint;
            this.d_isSelectedAttachedPosPoint = selectedPoint.d_isSelectedAttachedPosPoint;
            this.d_dist = selectedPoint.d_dist;
            this.d_index = selectedPoint.d_index;
        }

        @Override
        public int compareTo(Object arg0) {
            if (!(arg0 instanceof SelectedPoint)) {
                return 0;
            }
            SelectedPoint other = (SelectedPoint)arg0;
            return (int)Math.signum(this.d_dist - other.d_dist);
        }
    }

    public class VehicleShape2DViewCanvas
    extends JComponent {
        private Point3i[] d_shapePoints;
        private Point3i d_pivot;
        private Point2d d_origin;
        private int d_viewSizeX = 450;
        private int d_viewSizeY = 450;
        public double d_zoom;
        private boolean d_isDefaultView = true;
        private Point3i[] d_attachedPositions;
        private Point3d d_mousePos;
        private guiPanel d_bottomPnl;
        private guiLabel d_mousePosLbl;
        private Point3d[] d_attachedPositionsOrig;
        private Point3d[] d_shapePointsOrig;
        private Point2d d_pivotOrig;
        private SelectedPoint d_selectedPoint;
        private SelectedPoint d_closestPoint;
        private boolean d_isDragging = false;
        private final char d_separator;
        private final float[] dash1 = new float[]{3.0f};
        private final float[] dash2 = new float[]{1.5f};
        private final BasicStroke d_dashedStroke = new BasicStroke(1.0f, 0, 0, 10.0f, this.dash1, 0.0f);
        private final BasicStroke d_dottedStroke = new BasicStroke(1.0f, 0, 0, 10.0f, this.dash2, 0.0f);
        private final BasicStroke d_fullStroke = new BasicStroke(2.0f);
        private double selectDistEps = 10.0;

        public VehicleShape2DViewCanvas() {
            this.setPreferredSize(new Dimension(this.d_viewSizeX, this.d_viewSizeY));
            this.setMinimumSize(new Dimension(this.d_viewSizeX, this.d_viewSizeY));
            VehicleMouseAdapter mouseAdapter = new VehicleMouseAdapter();
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            this.addMouseWheelListener(mouseAdapter);
            DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
            DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
            char localeSep = symbols.getDecimalSeparator();
            this.d_separator = (char)(localeSep != ',' ? 44 : 59);
            this.d_bottomPnl = new guiPanel();
            this.d_mousePosLbl = new guiLabel("");
            this.setLayout(new BorderLayout());
            this.d_bottomPnl.add((Component)this.d_mousePosLbl, "After");
            guiPanel btnPnl = this.createBtnsPnl();
            this.d_bottomPnl.add((Component)btnPnl, "Before");
            this.d_bottomPnl.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.add((Component)this.d_bottomPnl, "Last");
            this.setBorder(BorderFactory.createLineBorder(Color.gray));
            this.setVisible(true);
            this.d_viewSizeY -= this.d_bottomPnl.getSize().height;
            this.d_pivot = new Point3i(this.d_viewSizeX / 2, this.d_viewSizeY / 2, 0);
            this.d_origin = new Point2d(this.d_viewSizeX / 2, this.d_viewSizeY / 2);
            this.d_pivotOrig = new Point2d(0.0, 0.0);
            this.addComponentListener(new VehicleShape2DViewListener());
        }

        public void clearAll(boolean clearSelection) {
            this.d_origin = new Point2d(this.d_viewSizeX / 2, this.d_viewSizeY / 2);
            this.d_isDefaultView = true;
            if (clearSelection) {
                this.clearSelection();
            }
            this.computeZoom();
            this.recomputePoints();
        }

        public void setSelectedPoint(int index, boolean isShapePoint) {
            Point3i p = null;
            if (isShapePoint && index < this.d_shapePoints.length) {
                p = this.d_shapePoints[index];
            }
            if (!isShapePoint && index < this.d_attachedPositions.length) {
                p = this.d_attachedPositions[index];
            }
            if (p == null) {
                this.clearSelection();
                return;
            }
            this.d_selectedPoint = new SelectedPoint(p, isShapePoint, !isShapePoint, false, 0.0, index);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.d_viewSizeX, this.d_viewSizeY);
            float transparency = 0.15f;
            g2.setColor(Color.gray);
            g2.setStroke(this.d_dashedStroke);
            g2.drawLine(0, this.d_pivot.y, this.d_viewSizeX, this.d_pivot.y);
            g2.drawLine(this.d_pivot.x, 0, this.d_pivot.x, this.d_viewSizeY);
            Point2d point2d = new Point2d(this.d_pivot.x, this.d_pivot.y);
            if (this.d_origin.distance(point2d) > 0.1) {
                g2.setColor(Color.gray);
                g2.setStroke(this.d_dottedStroke);
                g2.drawLine(0, (int)this.d_origin.y, this.d_viewSizeX, (int)this.d_origin.y);
                g2.drawLine((int)this.d_origin.x, 0, (int)this.d_origin.x, this.d_viewSizeY);
            }
            g2.setColor(Color.red);
            g2.setStroke(this.d_fullStroke);
            g2.drawOval(this.d_pivot.x - 1, this.d_pivot.y - 1, 2, 2);
            g2.drawLine(this.d_pivot.x, this.d_pivot.y, this.d_pivot.x + 30, this.d_pivot.y);
            Polygon tr = new Polygon();
            tr.addPoint(this.d_pivot.x + 35, this.d_pivot.y);
            tr.addPoint(this.d_pivot.x + 30, this.d_pivot.y + 4);
            tr.addPoint(this.d_pivot.x + 30, this.d_pivot.y - 4);
            g2.drawPolygon(tr);
            g2.fillPolygon(tr);
            g2.setColor(Color.black);
            for (int i = 0; i < this.d_shapePoints.length - 1; ++i) {
                g2.drawLine(this.d_shapePoints[i].x, this.d_shapePoints[i].y, this.d_shapePoints[i + 1].x, this.d_shapePoints[i + 1].y);
                this.drawPoint(g2, this.d_shapePoints[i].x, this.d_shapePoints[i].y, Color.blue);
            }
            if (this.d_shapePoints.length > 1) {
                g2.drawLine(this.d_shapePoints[this.d_shapePoints.length - 1].x, this.d_shapePoints[this.d_shapePoints.length - 1].y, this.d_shapePoints[0].x, this.d_shapePoints[0].y);
            }
            if (this.d_shapePoints.length > 0) {
                this.drawPoint(g2, this.d_shapePoints[this.d_shapePoints.length - 1].x, this.d_shapePoints[this.d_shapePoints.length - 1].y, Color.blue);
            }
            Polygon shapePol = new Polygon();
            for (int i = 0; i < this.d_shapePoints.length; ++i) {
                shapePol.addPoint(this.d_shapePoints[i].x, this.d_shapePoints[i].y);
            }
            g2.setColor(new Color(1.0f, 0.0f, 0.0f, transparency));
            g2.fillPolygon(shapePol);
            int occRad = (int)(0.5 * this.d_zoom / 2.0);
            for (int i = 0; i < this.d_attachedPositions.length; ++i) {
                g2.setColor(Color.blue);
                g2.drawOval(this.d_attachedPositions[i].x - occRad, this.d_attachedPositions[i].y - occRad, 2 * occRad, 2 * occRad);
                this.drawPoint(g2, this.d_attachedPositions[i].x, this.d_attachedPositions[i].y, Color.blue);
                g2.setColor(new Color(0.0f, 0.0f, 1.0f, transparency));
                g2.fillOval(this.d_attachedPositions[i].x - occRad, this.d_attachedPositions[i].y - occRad, 2 * occRad, 2 * occRad);
            }
            if (this.d_selectedPoint != null) {
                this.drawPoint(g2, ((SelectedPoint)this.d_selectedPoint).d_point.x, ((SelectedPoint)this.d_selectedPoint).d_point.y, Color.yellow);
            }
            if (this.d_closestPoint != null && !this.d_isDragging) {
                this.drawPoint(g2, ((SelectedPoint)this.d_closestPoint).d_point.x, ((SelectedPoint)this.d_closestPoint).d_point.y, Color.orange);
            }
            if (this.d_mousePos != null) {
                this.d_mousePosLbl.setText(this.format(this.d_mousePos));
            } else {
                this.d_mousePosLbl.setText(" ");
            }
            super.paintComponent(g2);
        }

        private void drawPoint(Graphics2D g2, int x, int y, Color color) {
            Color origColor = g2.getColor();
            g2.setColor(color);
            int pointRad = 2;
            g2.drawOval(x - pointRad, y - pointRad, 2 * pointRad, 2 * pointRad);
            g2.fillOval(x - pointRad, y - pointRad, 2 * pointRad, 2 * pointRad);
            g2.setColor(origColor);
        }

        public void setVehicleShape(Point3d[] shapePoints) {
            if (shapePoints == null) {
                return;
            }
            this.d_shapePointsOrig = shapePoints;
            if (this.d_isDefaultView) {
                this.computeZoom();
            }
            this.clearSelection();
            this.recomputePoints();
        }

        public void setAttachedPositions(Point3d[] attachedPositions) {
            if (attachedPositions == null) {
                return;
            }
            this.d_attachedPositionsOrig = attachedPositions;
            if (this.d_isDefaultView) {
                this.computeZoom();
            }
            this.clearSelection();
            this.recomputePoints();
        }

        public void setPivot(Point3d pivot) {
            this.d_pivotOrig = new Point2d(pivot.x, pivot.y);
            if (this.d_isDefaultView) {
                this.computeZoom();
            }
            this.clearSelection();
            this.recomputePoints();
        }

        private void recomputePoints() {
            int i;
            if (this.d_shapePointsOrig != null) {
                this.d_shapePoints = new Point3i[this.d_shapePointsOrig.length];
                for (i = 0; i < this.d_shapePoints.length; ++i) {
                    this.d_shapePoints[i] = this.convertToGraphicsCoord(this.d_shapePointsOrig[i]);
                }
            }
            if (this.d_attachedPositionsOrig != null) {
                this.d_attachedPositions = new Point3i[this.d_attachedPositionsOrig.length];
                for (i = 0; i < this.d_attachedPositionsOrig.length; ++i) {
                    this.d_attachedPositions[i] = this.convertToGraphicsCoord(this.d_attachedPositionsOrig[i]);
                }
            }
            this.d_pivot = this.convertToGraphicsCoord(new Point3d(this.d_pivotOrig.x, this.d_pivotOrig.y, 0.0));
            if (this.d_selectedPoint != null) {
                this.d_selectedPoint.d_point = this.d_selectedPoint.d_isSelectedShapePoint ? this.d_shapePoints[this.d_selectedPoint.d_index] : this.d_attachedPositions[this.d_selectedPoint.d_index];
            }
            if (this.d_closestPoint != null) {
                this.d_closestPoint.d_point = this.d_closestPoint.d_isSelectedShapePoint ? this.d_shapePoints[this.d_closestPoint.d_index] : this.d_attachedPositions[this.d_closestPoint.d_index];
            }
            this.repaint();
        }

        private void clearSelection() {
            this.d_selectedPoint = null;
            this.d_closestPoint = null;
            this.repaint();
        }

        private void computeZoom() {
            Point3d[] points = this.concat(this.concat(this.d_shapePointsOrig, this.d_attachedPositionsOrig), new Point3d[]{new Point3d(this.d_pivotOrig.x, this.d_pivotOrig.y, 0.0)});
            if (points == null) {
                return;
            }
            if (points.length == 0) {
                return;
            }
            double miny = Double.MAX_VALUE;
            double minx = Double.MAX_VALUE;
            double maxy = -1.7976931348623157E308;
            double maxx = -1.7976931348623157E308;
            for (int i = 0; i < points.length; ++i) {
                if (points[i].x < minx) {
                    minx = points[i].x;
                }
                if (points[i].x > maxx) {
                    maxx = points[i].x;
                }
                if (points[i].y < miny) {
                    miny = points[i].y;
                }
                if (!(points[i].y > maxy)) continue;
                maxy = points[i].y;
            }
            double maxxDist = Math.max(Math.abs(maxx), Math.abs(minx));
            double maxyDist = Math.max(Math.abs(maxy), Math.abs(miny));
            this.d_isDefaultView = true;
            double sizeRatio = (double)this.d_viewSizeX / (double)this.d_viewSizeY;
            if (maxxDist > maxyDist * sizeRatio) {
                double maxLength = 2.0 * maxxDist;
                this.d_zoom = (double)this.d_viewSizeX / (1.5 * maxLength);
            } else {
                double maxLength = 2.0 * maxyDist;
                this.d_zoom = (double)this.d_viewSizeY / (1.5 * maxLength);
            }
        }

        public Point3d[] concat(Point3d[] first, Point3d[] second) {
            if (first == null) {
                return second;
            }
            if (second == null) {
                return first;
            }
            Point3d[] result = Arrays.copyOf(first, first.length + second.length);
            System.arraycopy(second, 0, result, first.length, second.length);
            return result;
        }

        private Point3d convertToModelCoord(int coordX, int coordY) {
            return new Point3d(((double)coordX - this.d_origin.x) / this.d_zoom, -((double)coordY - this.d_origin.y) / this.d_zoom, 0.0);
        }

        private Point3i convertToGraphicsCoord(Point3d point) {
            return new Point3i((int)(this.d_origin.x + this.d_zoom * point.x), (int)(this.d_origin.y - this.d_zoom * point.y), 0);
        }

        private String format(Point3d point) {
            Unit lu = MerlinApp.getApp().getUnitSystem().getLength();
            double x = UnitDouble.from(point.x, Geometry.LENGTH_UNIT, lu).getRawValue();
            double y = UnitDouble.from(point.y, Geometry.LENGTH_UNIT, lu).getRawValue();
            int precision = 3;
            return "(" + Global.format(x, precision) + this.d_separator + " " + Global.format(y, precision) + ") " + lu + " ";
        }

        private guiPanel createBtnsPnl() {
            int btnSize = 24;
            VehicleShapesPanel.this.d_undoBtn = new JButton();
            VehicleShapesPanel.this.d_undoBtn.setIcon(VehicleShapesPanel.this.ICON_UNDO);
            VehicleShapesPanel.this.d_undoBtn.setPreferredSize(new Dimension(btnSize, btnSize));
            VehicleShapesPanel.this.d_undoBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleShapesPanel.this.d_undo.performUndo();
                }
            });
            VehicleShapesPanel.this.d_redoBtn = new JButton();
            VehicleShapesPanel.this.d_redoBtn.setIcon(VehicleShapesPanel.this.ICON_REDO);
            VehicleShapesPanel.this.d_redoBtn.setPreferredSize(new Dimension(btnSize, btnSize));
            VehicleShapesPanel.this.d_redoBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleShapesPanel.this.d_undo.performRedo();
                }
            });
            JButton resetBtn = new JButton();
            resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VehicleShape2DViewCanvas.this.clearAll(false);
                }
            });
            resetBtn.setIcon(thunderheadeng.gui.guiUtil.loadTeciIcon("ZoomFit16.gif"));
            resetBtn.setPreferredSize(new Dimension(btnSize, btnSize));
            resetBtn.setToolTipText(Intl.intl("Reset View"));
            resetBtn.setFocusable(false);
            guiPanel btnPnl = new guiPanel(new FlowLayout(0, 1, 3));
            btnPnl.add(VehicleShapesPanel.this.d_undoBtn);
            btnPnl.add(VehicleShapesPanel.this.d_redoBtn);
            btnPnl.add(resetBtn);
            btnPnl.setPreferredSize(new Dimension(90, 30));
            btnPnl.setMinimumSize(btnPnl.getPreferredSize());
            return btnPnl;
        }

        public class VehicleShape2DViewListener
        implements ComponentListener {
            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                VehicleShape2DViewCanvas.this.d_viewSizeX = e.getComponent().getWidth();
                VehicleShape2DViewCanvas.this.d_viewSizeY = e.getComponent().getHeight() - ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_bottomPnl.getSize().height;
                if (VehicleShape2DViewCanvas.this.d_isDefaultView) {
                    VehicleShape2DViewCanvas.this.clearAll(false);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.componentResized(e);
            }
        }

        private class VehiclePopUpMenu
        extends JPopupMenu {
            private JMenuItem d_addAttachedAgent;
            private JMenuItem d_addPoint;
            private JMenuItem d_deletePoint;
            private Point d_point;
            private final String addAttachedStr = Intl.intl("Add a position of an attached occupant");
            private final String deletePointStr = Intl.intl("Delete point");
            private final String addPointStr = Intl.intl("Add a point to the shape");

            public VehiclePopUpMenu(Point point, SelectedPoint selectedPoint) {
                this.d_point = point;
                this.d_addPoint = new JMenuItem(this.addPointStr);
                this.d_addAttachedAgent = new JMenuItem(this.addAttachedStr);
                this.d_deletePoint = new JMenuItem(this.deletePointStr);
                this.d_addPoint.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VehicleShapesPanel.this.d_undo.createUndo(VehiclePopUpMenu.this.addPointStr);
                        Point3d point = VehicleShape2DViewCanvas.this.convertToModelCoord(((VehiclePopUpMenu)VehiclePopUpMenu.this).d_point.x, ((VehiclePopUpMenu)VehiclePopUpMenu.this).d_point.y);
                        if (VehicleShape2DViewCanvas.this.d_shapePointsOrig.length == 0) {
                            VehicleShapesPanel.this.d_vehicleShapeEditor.addPoint(point, 0);
                            return;
                        }
                        Pair<Double, Integer> closest = VehicleShapesPanel.findClosestEdge(VehicleShape2DViewCanvas.this.d_shapePointsOrig, point);
                        VehicleShapesPanel.this.d_vehicleShapeEditor.addPoint(point, (Integer)closest.v2 + 1);
                    }
                });
                this.d_addAttachedAgent.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        VehicleShapesPanel.this.d_undo.createUndo(VehiclePopUpMenu.this.addAttachedStr);
                        Point3d point = VehicleShape2DViewCanvas.this.convertToModelCoord(((VehiclePopUpMenu)VehiclePopUpMenu.this).d_point.x, ((VehiclePopUpMenu)VehiclePopUpMenu.this).d_point.y);
                        VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.addPoint(point);
                    }
                });
                this.d_deletePoint.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectedPoint toRemove;
                        SelectedPoint selectedPoint = toRemove = VehicleShape2DViewCanvas.this.d_selectedPoint != null ? VehicleShape2DViewCanvas.this.d_selectedPoint : VehicleShape2DViewCanvas.this.d_closestPoint;
                        if (toRemove == null) {
                            return;
                        }
                        VehicleShapesPanel.this.d_undo.createUndo(VehiclePopUpMenu.this.deletePointStr);
                        if (toRemove.d_isSelectedAttachedPosPoint) {
                            VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.removePoint(toRemove.d_index);
                        }
                        if (toRemove.d_isSelectedShapePoint) {
                            VehicleShapesPanel.this.d_vehicleShapeEditor.removePoint(toRemove.d_index);
                        }
                        VehicleShape2DViewCanvas.this.clearSelection();
                        VehicleShapesPanel.this.d_vehicleShapeEditor.clearSelection();
                        VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.clearSelection();
                    }
                });
                if (selectedPoint != null && (selectedPoint.d_isSelectedShapePoint || selectedPoint.d_isSelectedAttachedPosPoint)) {
                    this.add(this.d_deletePoint);
                    this.addSeparator();
                }
                this.add(this.d_addAttachedAgent);
                this.add(this.d_addPoint);
            }
        }

        private class VehicleMouseAdapter
        extends MouseAdapter {
            private Point d_dragPoint;

            private VehicleMouseAdapter() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                } else {
                    this.select(e.getPoint());
                    this.d_dragPoint = e.getPoint();
                }
            }

            private void select(Point point) {
                VehicleShape2DViewCanvas.this.clearSelection();
                VehicleShape2DViewCanvas.this.d_selectedPoint = this.findSelected(point);
                if (VehicleShape2DViewCanvas.this.d_selectedPoint != null) {
                    VehicleShapesPanel.this.d_vehicleShapeEditor.clearSelection();
                    VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.clearSelection();
                    if (VehicleShape2DViewCanvas.this.d_selectedPoint.d_isSelectedShapePoint) {
                        VehicleShapesPanel.this.d_vehicleShapeEditor.selectRow(VehicleShape2DViewCanvas.this.d_selectedPoint.d_index);
                    }
                    if (VehicleShape2DViewCanvas.this.d_selectedPoint.d_isSelectedAttachedPosPoint) {
                        VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.selectRow(VehicleShape2DViewCanvas.this.d_selectedPoint.d_index);
                    }
                }
                VehicleShape2DViewCanvas.this.repaint();
            }

            private SelectedPoint findSelected(Point point) {
                double dist;
                int i;
                PriorityQueue<SelectedPoint> closePoints = new PriorityQueue<SelectedPoint>();
                for (i = 0; i < VehicleShape2DViewCanvas.this.d_shapePoints.length; ++i) {
                    dist = this.distance(VehicleShape2DViewCanvas.this.d_shapePoints[i], point);
                    if (!(dist < VehicleShape2DViewCanvas.this.selectDistEps)) continue;
                    closePoints.add(new SelectedPoint(VehicleShape2DViewCanvas.this.d_shapePoints[i], true, false, false, dist, i));
                }
                for (i = 0; i < VehicleShape2DViewCanvas.this.d_attachedPositions.length; ++i) {
                    dist = this.distance(VehicleShape2DViewCanvas.this.d_attachedPositions[i], point);
                    if (!(dist < VehicleShape2DViewCanvas.this.selectDistEps)) continue;
                    closePoints.add(new SelectedPoint(VehicleShape2DViewCanvas.this.d_attachedPositions[i], false, true, false, dist, i));
                }
                Point3i centerP = new Point3i(((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_pivot.x, ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_pivot.y, 0);
                dist = this.distance(centerP, point);
                if (dist < VehicleShape2DViewCanvas.this.selectDistEps) {
                    closePoints.add(new SelectedPoint(centerP, false, false, true, dist, 0));
                }
                return (SelectedPoint)closePoints.poll();
            }

            private double distance(Point3i point1, Point point2) {
                return Math.sqrt(Math.pow(point1.x - point2.x, 2.0) + Math.pow(point1.y - point2.y, 2.0));
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                } else if (!VehicleShape2DViewCanvas.this.d_isDragging) {
                    this.select(e.getPoint());
                } else {
                    if (VehicleShape2DViewCanvas.this.d_selectedPoint != null) {
                        VehicleShapesPanel.this.d_undo.createUndo(Intl.intl("Move point"));
                        Point3d newPoint = VehicleShape2DViewCanvas.this.convertToModelCoord(((SelectedPoint)((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_selectedPoint).d_point.x, ((SelectedPoint)((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_selectedPoint).d_point.y);
                        SelectedPoint tempPoint = new SelectedPoint(VehicleShape2DViewCanvas.this.d_selectedPoint);
                        if (VehicleShape2DViewCanvas.this.d_selectedPoint.d_isSelectedShapePoint) {
                            VehicleShapesPanel.this.d_vehicleShapeEditor.setPoint(newPoint, VehicleShape2DViewCanvas.this.d_selectedPoint.d_index);
                        } else if (VehicleShape2DViewCanvas.this.d_selectedPoint.d_isSelectedAttachedPosPoint) {
                            VehicleShapesPanel.this.d_attachedAgentsSpotsEditor.setPoint(newPoint, VehicleShape2DViewCanvas.this.d_selectedPoint.d_index);
                        } else if (VehicleShape2DViewCanvas.this.d_selectedPoint.d_isSelectedPivot) {
                            VehicleShapesPanel.this.d_pivotEditor.setPoint(newPoint, 0);
                        }
                        VehicleShape2DViewCanvas.this.d_selectedPoint = tempPoint;
                        VehicleShape2DViewCanvas.this.d_selectedPoint.d_point = VehicleShape2DViewCanvas.this.convertToGraphicsCoord(newPoint);
                    }
                    VehicleShape2DViewCanvas.this.d_isDragging = false;
                }
            }

            private void showMenu(MouseEvent e) {
                VehiclePopUpMenu menu = new VehiclePopUpMenu(e.getPoint(), VehicleShape2DViewCanvas.this.d_selectedPoint);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                VehicleShape2DViewCanvas.this.d_mousePos = VehicleShape2DViewCanvas.this.convertToModelCoord(e.getX(), e.getY());
                VehicleShape2DViewCanvas.this.setCursor(new Cursor(1));
                VehicleShape2DViewCanvas.this.d_closestPoint = this.findSelected(e.getPoint());
                VehicleShape2DViewCanvas.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (VehicleShape2DViewCanvas.this.d_selectedPoint == null) {
                    this.select(e.getPoint());
                }
                if (VehicleShape2DViewCanvas.this.d_selectedPoint == null && this.d_dragPoint != null) {
                    VehicleShape2DViewCanvas.this.setCursor(new Cursor(13));
                    int xMoved = e.getX() - (int)this.d_dragPoint.getX();
                    int yMoved = e.getY() - (int)this.d_dragPoint.getY();
                    this.d_dragPoint = e.getPoint();
                    ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_origin.x += (double)xMoved;
                    ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_origin.y += (double)yMoved;
                    VehicleShape2DViewCanvas.this.d_isDefaultView = false;
                    VehicleShape2DViewCanvas.this.recomputePoints();
                } else if (VehicleShape2DViewCanvas.this.d_selectedPoint != null) {
                    ((SelectedPoint)((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_selectedPoint).d_point.x = e.getX();
                    ((SelectedPoint)((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_selectedPoint).d_point.y = e.getY();
                    if (VehicleShape2DViewCanvas.this.d_selectedPoint.d_isSelectedPivot) {
                        ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_pivot.x = e.getX();
                        ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_pivot.y = e.getY();
                    }
                    VehicleShape2DViewCanvas.this.d_isDragging = true;
                }
                this.mouseMoved(e);
                VehicleShape2DViewCanvas.this.repaint();
                super.mouseDragged(e);
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Point3d mouseOld = VehicleShape2DViewCanvas.this.convertToModelCoord(e.getPoint().x, e.getPoint().y);
                int clickCount = e.getWheelRotation();
                double increment = -0.1 * (double)clickCount * VehicleShape2DViewCanvas.this.d_zoom;
                VehicleShape2DViewCanvas.this.d_zoom += increment;
                Point3d mouseNew = VehicleShape2DViewCanvas.this.convertToModelCoord(e.getPoint().x, e.getPoint().y);
                Point3i moveTo = VehicleShape2DViewCanvas.this.convertToGraphicsCoord(new Point3d(mouseNew.x - mouseOld.x, mouseNew.y - mouseOld.y, 0.0));
                ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_origin.x = moveTo.x;
                ((VehicleShape2DViewCanvas)VehicleShape2DViewCanvas.this).d_origin.y = moveTo.y;
                VehicleShape2DViewCanvas.this.d_isDefaultView = false;
                VehicleShape2DViewCanvas.this.recomputePoints();
                super.mouseWheelMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                VehicleShape2DViewCanvas.this.d_mousePos = null;
                VehicleShape2DViewCanvas.this.d_mousePosLbl.setText(null);
                super.mouseExited(arg0);
            }
        }
    }

    public static class Op
    extends Undo.RestoreOp {
        private Collection<EgressAgent> d_agentsUsing;

        public Op(IRestorable shape, Object restoreObj, boolean selected, Collection<EgressAgent> agentsUsing) {
            super(shape, restoreObj, selected);
            this.d_agentsUsing = agentsUsing;
        }

        @Override
        public Undo.RestoreOp perform(MerlinSelectionModel sel) {
            Undo.RestoreOp op = super.perform(sel);
            VehicleShapesPanel.updateAgents(this.d_agentsUsing);
            return new Op(op.getObj(), op.getMomento(), op.getSelect(), this.d_agentsUsing);
        }

        @Override
        public String toString() {
            return "vehicle shape undo op";
        }
    }
}

