/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import merlin.EntryPointFactory;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.geom.IMerlinGeomSrc;
import thunderheadeng.gui.dialogs.AFindDlg;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.Filters;

public class PthFindDlg
extends AFindDlg<ICompElement, MerlinData> {
    public PthFindDlg(Window owner, MerlinData md) {
        super(owner, md);
    }

    @Override
    public void perform(final guiComboBox<String> findFld, final guiLabel message, final AFindDlg.ActionAfterQuery action) {
        UIHook.run(this, "Find", new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                PthFindDlg.this.run(findFld, message, action);
            }
        }, 0);
    }

    @Override
    protected Collection<ICompElement> find(String query) {
        if (query.trim().isEmpty()) {
            return Collections.emptySet();
        }
        ArrayDeque<ICompElement> matches = new ArrayDeque<ICompElement>();
        Predicate<ICompElement> filter = PthFindDlg.getObjFilter(query);
        MerlinData md = (MerlinData)this.getDomain();
        for (Object child : EntryPointFactory.get(md).tvEntryPoint.getChildren(md, md)) {
            if (!(child instanceof Composite)) continue;
            matches.addAll(PthFindDlg.find(filter, (Composite)child));
        }
        return matches;
    }

    @Override
    protected void selectNext() {
        if (!this.getIterator().hasNext()) {
            return;
        }
        ((MerlinData)this.getDomain()).beginWrite();
        try {
            ((MerlinData)this.getDomain()).selection.set(this.getIterator().next());
        }
        finally {
            ((MerlinData)this.getDomain()).endWrite();
        }
        PthFindDlg.showSelectionInTree();
    }

    @Override
    protected void selectAll() {
        ((MerlinData)this.getDomain()).beginWrite();
        try {
            ((MerlinData)this.getDomain()).selection.set(this.getSelection());
        }
        finally {
            ((MerlinData)this.getDomain()).endWrite();
        }
        PthFindDlg.showSelectionInTree();
    }

    private static Collection<ICompElement> find(Predicate<ICompElement> filter, Composite<? extends ICompElement> composite) {
        return composite.getDeepMembers().stream().filter(filter).collect(Collectors.toList());
    }

    private static Predicate<ICompElement> getObjFilter(String query) {
        Predicate<ICompElement> filter = Filters.rejectAll();
        filter = Filters.or(filter, PthFindDlg.getNameFilter(query));
        filter = Filters.or(filter, PthFindDlg.getNumTrisFilter(query));
        return filter;
    }

    private static Predicate<ICompElement> getNameFilter(String query) {
        String lcQuery = query.toLowerCase();
        return elem -> elem.getName().toLowerCase().contains(lcQuery);
    }

    private static Predicate<ICompElement> getNumTrisFilter(String query) {
        int count;
        IntPredicate comparator;
        if (!query.toLowerCase().startsWith("numtris")) {
            return Filters.rejectAll();
        }
        StringTokenizer toks = new StringTokenizer(query, " ");
        if (toks.countTokens() != 3) {
            return Filters.rejectAll();
        }
        toks.nextToken();
        String compStr = toks.nextToken();
        String numStr = toks.nextToken();
        switch (compStr) {
            case ">": {
                comparator = i -> i > 0;
                break;
            }
            case ">=": {
                comparator = i -> i >= 0;
                break;
            }
            case "<": {
                comparator = i -> i < 0;
                break;
            }
            case "<=": {
                comparator = i -> i <= 0;
                break;
            }
            case "==": {
                comparator = i -> i == 0;
                break;
            }
            default: {
                return Filters.rejectAll();
            }
        }
        try {
            count = Integer.parseInt(numStr.trim());
        }
        catch (Throwable t) {
            return Filters.rejectAll();
        }
        return elem -> {
            if (!(elem instanceof IMerlinGeomSrc)) {
                return false;
            }
            IMerlinGeomSrc geom = (IMerlinGeomSrc)((Object)elem);
            int numPrims = geom.getGeom().getNumPrims(1);
            return comparator.test(numPrims - count);
        };
    }

    private static void showSelectionInTree() {
        EventQueue.invokeLater(() -> {
            MerlinApp app = MerlinApp.getApp();
            if (app != null) {
                app.getTreeView().showCurrentSelection();
            }
        });
    }
}

