/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.egress.agents.OccProfile;
import merlin.gui.MerlinComboBox;
import merlin.gui.MerlinValueFields;
import merlin.gui.guiUtil;
import merlin.gui.stat.VerboseCurveEditor;
import merlin.gui.stat.guiCurveUtil;
import merlin.gui.value.IValEditor;
import merlin.unitsystem.UnitUpdatableComponent;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.CmdButton;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUnitDoubleField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;

public class OccGroupsPanel
extends guiPanel
implements IEditor<OccGroupObj> {
    private final JFrame d_owner;
    private final guiTextField d_name;
    private final guiTextField d_desc;
    private final MerlinData d_md;
    private OccGroupObj d_dataObj;
    private boolean d_isModified = false;
    private guiPanel d_allAgentsPnl;
    private CmdButton d_addBtn;
    private CmdButton d_removeBtn;
    private ValueField<UnitDouble> d_maxDistanceFld;
    private guiUnitDoubleField d_slowdownTimeFld;
    private guiCheckBox d_socialDistInGroup;
    private guiCheckBox d_cbFollowLeader;
    private boolean d_isGroupType;
    private VerboseCurveEditor d_minNumberOfMembers;
    private VerboseCurveEditor d_prefNumberOfMembers;
    private guiCheckBox d_cbAllowSmaller;
    private guiLabel d_lMinNumberOfMembers;
    private ProfileConstraintsPanel d_profileConstraintsPanel;
    private guiRadioButton d_specifyOverallCount;
    private guiRadioButton d_specifyProfiles;
    private GroupCreationEditor d_groupCreationEditor;
    private MerlinComboBox.MerlinComboBoxWithEmptyOption<OccProfile> d_cbLeaderProfile;
    private guiLabel d_lLeaderProfile;
    private ColorButton d_colorBtn;
    public static final String MIN_WARNING = Intl.intl("Total number of members must be at least 1.");
    private ActionListener enableLeadersProfileListener = e -> {
        if (this.d_isGroupType) {
            this.d_cbLeaderProfile.setEnabled(this.d_cbFollowLeader.isSelected() && this.d_specifyProfiles.isSelected());
            this.d_lLeaderProfile.setEnabled(this.d_cbFollowLeader.isSelected() && this.d_specifyProfiles.isSelected());
        }
    };
    public static final Pair<String, String> SOCIAL_DIST_IN_GROUP_LBL = new Pair<String, String>(Intl.intl("Enforce social distancing between group members"), "<html>" + Intl.intl("Whether an occupant in the group should try to separate with other<br>group members if the <b>Social Distance</b> property is enabled<br>in the occupant's profile. Enabling this option expands the group's<br><b>Maximum Distance</b> to include the maximum social distance of<br>the group members."));
    public static final Pair<String, String> MAX_DIST_LBL = new Pair<String, String>(Intl.intl("Maximum Distance:"), "<html>" + Intl.intl("Maximum distance from any group member to the closest other group member.<br>Enforcing social distancing in the group will cause this value to be <br>expanded by the maximum social distance of the group members."));

    public OccGroupsPanel(JFrame owner, boolean isGroupType) {
        this.d_isGroupType = isGroupType;
        this.setLayout(new GridBagLayout());
        this.d_md = MerlinApp.getApp().getData();
        this.d_owner = owner;
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_desc = new guiTextField();
        this.d_desc.setColumns(25);
        this.d_desc.getDocument().addDocumentListener(this.d_comm);
        String followLeaderLbl = Intl.intl("Follow Leader");
        this.d_cbFollowLeader = new guiCheckBox(followLeaderLbl);
        this.d_cbFollowLeader.addActionListener(this.enableLeadersProfileListener);
        this.d_cbFollowLeader.setToolTipText(Intl.intl("Whether the group should follow a leader."));
        this.d_socialDistInGroup = new guiCheckBox((String)OccGroupsPanel.SOCIAL_DIST_IN_GROUP_LBL.v1);
        this.d_socialDistInGroup.setToolTipText((String)OccGroupsPanel.SOCIAL_DIST_IN_GROUP_LBL.v2);
        this.d_maxDistanceFld = MerlinValueFields.udFld(0);
        this.d_slowdownTimeFld = new guiUnitDoubleField((Unit)SI.SECOND, UnitDoubleVR.above(0.0, SI.SECOND, true));
        this.d_colorBtn = new ColorButton(1);
        this.d_colorBtn.setMinimumSize(this.d_colorBtn.getPreferredSize());
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(Intl.intl("Name:"), this.d_name, 1.0, GridBagHelper.REMAINING);
        gb.addRow(Intl.intl("Description:"), this.d_desc, 1.0, GridBagHelper.REMAINING);
        gb.addRow(Intl.intl("Color:"), this.d_colorBtn);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Movement")));
        guiLabel lMaxDist = new guiLabel((String)OccGroupsPanel.MAX_DIST_LBL.v1);
        lMaxDist.setToolTipText((String)OccGroupsPanel.MAX_DIST_LBL.v2);
        gb.addIdentRow(lMaxDist, this.d_maxDistanceFld, 1.0, GridBagHelper.REMAINING);
        guiLabel lSlowDown = new guiLabel(Intl.intl("Slowdown Time:"));
        lSlowDown.setToolTipText(Intl.intl("Time interval during which the group will keep slowing down after it is disconnected."));
        gb.addIdentRow(lSlowDown, this.d_slowdownTimeFld, 1.0, GridBagHelper.REMAINING);
        gb.addIdentRow(this.d_cbFollowLeader, 1.0, GridBagHelper.REMAINING);
        gb.addIdentRow(this.d_socialDistInGroup, 1.0, GridBagHelper.REMAINING);
        if (this.d_isGroupType) {
            this.d_groupCreationEditor = new GroupCreationEditor(this.getComm(), false);
            gb.addFilledRow(new TitleSeparator(Intl.intl("Creation")));
            gb.indent();
            this.d_specifyOverallCount = new guiRadioButton(Intl.intl("Specify Number of Members"));
            this.d_specifyOverallCount.setToolTipText(Intl.intl("Specify total number of members regardless of their profiles."));
            String specNumMembersProfLbl = Intl.intl("Specify Number of Members per Profile");
            this.d_specifyProfiles = new guiRadioButton(specNumMembersProfLbl);
            this.d_specifyProfiles.setToolTipText(Intl.intl("Specify number of members with each profile."));
            guiUtil.group(new AbstractButton[]{this.d_specifyProfiles, this.d_specifyOverallCount});
            LinkStatus.link2((AbstractButton)this.d_specifyOverallCount, this.d_groupCreationEditor);
            this.d_specifyOverallCount.addActionListener(this.enableLeadersProfileListener);
            this.d_specifyProfiles.addActionListener(this.enableLeadersProfileListener);
            this.d_profileConstraintsPanel = new ProfileConstraintsPanel();
            this.d_cbLeaderProfile = new MerlinComboBox.MerlinComboBoxWithEmptyOption<OccProfile>(this.d_md, OccProfile.class, Intl.intl("[Any]"));
            this.d_cbLeaderProfile.setEnabled(false);
            this.d_lLeaderProfile = new guiLabel(Intl.intl("Leader's Profile:"));
            this.d_lLeaderProfile.setToolTipText("<html>" + String.format(Intl.intl("Profile of the groups' leader. This option is enabled only if <b>%s</b> and <b>%s</b> are selected."), followLeaderLbl, specNumMembersProfLbl) + "</html>");
            LinkStatus.link2((AbstractButton)this.d_specifyProfiles, this.d_profileConstraintsPanel, this.d_cbLeaderProfile, this.d_lLeaderProfile);
            LinkStatus.link2((AbstractButton)this.d_cbFollowLeader, this.d_cbLeaderProfile, this.d_lLeaderProfile);
            gb.addRow(this.d_specifyOverallCount, GridBagHelper.REMAINING);
            gb.indent();
            gb.addFilledRow(this.d_groupCreationEditor);
            gb.unindent();
            gb.addRow(this.d_specifyProfiles, GridBagHelper.REMAINING);
            gb.addIdentRow(this.d_profileConstraintsPanel, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
            gb.addIdentRow(this.d_lLeaderProfile, this.d_cbLeaderProfile, new double[]{1.0, 0.0}, GridBagHelper.REMAINING);
            gb.unindent();
        }
        this.setModified(false);
    }

    @Override
    public void init(OccGroupObj dataObj) {
        if (dataObj != null) {
            MerlinData md = MerlinApp.getApp().getData();
            md.beginRead();
            try {
                this.d_name.setText(dataObj.getProperty(OccGroupObj.PROP_NAME));
                this.d_desc.setText(dataObj.getProperty(OccGroupObj.PROP_DESC));
                this.d_maxDistanceFld.setValue(dataObj.getProperty(OccGroupObj.PROP_MAX_DISTANCE));
                this.d_slowdownTimeFld.setValue(dataObj.getProperty(OccGroupObj.PROP_SLOWDOWN_TIME));
                this.d_cbFollowLeader.setSelected(dataObj.getProperty(OccGroupObj.PROP_REQUIRES_GROUP_LEADER));
                this.d_socialDistInGroup.setSelected(dataObj.getProperty(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP));
                if (this.d_isGroupType) {
                    this.d_groupCreationEditor.setValue(new OccGroupTypeObj.GroupCreationDataObj((OccGroupTypeObj)dataObj));
                    this.d_specifyProfiles.setSelected(dataObj.getProperty(OccGroupTypeObj.PROP_SPECIFY_PROFILES));
                    this.d_specifyOverallCount.setSelected(dataObj.getProperty(OccGroupTypeObj.PROP_SPECIFY_PROFILES) == false);
                    this.d_profileConstraintsPanel.init(dataObj.getProperty(OccGroupTypeObj.PROP_PROFILE_DATA));
                    this.d_cbLeaderProfile.setEnabled(this.d_cbFollowLeader.isSelected() && this.d_specifyOverallCount.isSelected());
                    this.d_cbLeaderProfile.setSelectedItem(dataObj.getProperty(OccGroupTypeObj.PROP_LEADER_PROFILE));
                    this.d_colorBtn.setColor(dataObj.getProperty(OccGroupObj.PROP_COLOR));
                }
                this.d_dataObj = dataObj;
            }
            finally {
                md.endRead();
            }
        }
        this.setModified(false);
    }

    @Override
    public OccGroupObj commit(final OccGroupObj dataObj) {
        if (dataObj != null) {
            AMerlinOp op = new AMerlinOp(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Undo.begin(Intl.intl("Edit Movement Group Templates"));
                    md.beginWrite();
                    try {
                        Undo.insertUndoEntry_restore(md, dataObj);
                        dataObj.setProperty(OccGroupObj.PROP_DESC, OccGroupsPanel.this.d_desc.getText());
                        dataObj.setProperty(OccGroupObj.PROP_REQUIRES_GROUP_LEADER, Boolean.valueOf(OccGroupsPanel.this.d_cbFollowLeader.isSelected()));
                        dataObj.setProperty(OccGroupObj.PROP_SOCIAL_DIST_IN_GROUP, Boolean.valueOf(OccGroupsPanel.this.d_socialDistInGroup.isSelected()));
                        dataObj.setProperty(OccGroupObj.PROP_MAX_DISTANCE, OccGroupsPanel.this.d_maxDistanceFld.getValue());
                        dataObj.setProperty(OccGroupObj.PROP_SLOWDOWN_TIME, OccGroupsPanel.this.d_slowdownTimeFld.getValue());
                        if (OccGroupsPanel.this.d_isGroupType) {
                            OccGroupTypeObj.GroupCreationDataObj data = OccGroupsPanel.this.d_groupCreationEditor.getValue();
                            ((OccGroupTypeObj)dataObj).setProperty(OccGroupTypeObj.PROP_MIN_NUMBER_OF_MEMBERS, data.minNumberOfMembers);
                            ((OccGroupTypeObj)dataObj).setProperty(OccGroupTypeObj.PROP_PREF_NUMBER_OF_MEMBERS, data.prefNumberOfMembers);
                            ((OccGroupTypeObj)dataObj).setProperty(OccGroupTypeObj.PROP_ALLOW_SMALLER_GROUPS, Boolean.valueOf(data.allowSmallerGroups));
                            ((OccGroupTypeObj)dataObj).setProperty(OccGroupTypeObj.PROP_SPECIFY_PROFILES, Boolean.valueOf(OccGroupsPanel.this.d_specifyProfiles.isSelected()));
                            ((OccGroupTypeObj)dataObj).setProperty(OccGroupTypeObj.PROP_PROFILE_DATA, OccGroupsPanel.this.d_profileConstraintsPanel.commit());
                            ((OccGroupTypeObj)dataObj).setProperty(OccGroupTypeObj.PROP_LEADER_PROFILE, OccGroupsPanel.this.d_cbLeaderProfile.getSelectedItem());
                            ((OccGroupTypeObj)dataObj).setProperty(OccGroupObj.PROP_COLOR, OccGroupsPanel.this.d_colorBtn.getColor());
                        }
                    }
                    finally {
                        Undo.end(MerlinApp.getApp().getData());
                        md.endWrite();
                    }
                }
            };
            UIHook.run(this, "OccGroupsPanel.commit", op, 2);
        }
        this.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public boolean isModified() {
        return this.d_isModified || super.isModified();
    }

    @Override
    public void setModified(boolean isModified) {
        this.d_isModified = isModified;
        super.setModified(isModified);
    }

    @Override
    public void setEnabled(boolean enable) {
        if (!enable) {
            this.clear();
        }
        super.setEnabled(enable);
    }

    public void clear() {
        this.d_name.setText("");
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (this.d_isGroupType) {
            double minPrefNumberOfMembers;
            ICurve minConstraints;
            OccProfile leaderProf;
            if (this.d_cbFollowLeader.isSelected() && this.d_specifyProfiles.isSelected() && (leaderProf = (OccProfile)this.d_cbLeaderProfile.getSelectedItem()) != null && (minConstraints = this.d_profileConstraintsPanel.getMinConstraints(leaderProf)).getMin().getValue(Unit.ONE) == 0.0) {
                String msg = Intl.intl("Leader's Profile must have minimum number of members set to at least 1.");
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid data"), 0);
                return false;
            }
            if (this.d_specifyOverallCount.isSelected() && (minPrefNumberOfMembers = this.d_groupCreationEditor.getValue().prefNumberOfMembers.getMin().get(Unit.ONE)) < 1.0) {
                String msg = MIN_WARNING;
                JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid data"), 0);
                return false;
            }
            if (this.d_specifyProfiles.isSelected()) {
                double totalMin = 0.0;
                for (OccProfile prof : this.d_profileConstraintsPanel.profMap.keySet()) {
                    if (!((totalMin += ((GroupCreationEditor)((ProfileConstraintsPanel)this.d_profileConstraintsPanel).profMap.get((Object)prof)).getValue().prefNumberOfMembers.getMin().get(Unit.ONE)) >= 1.0)) continue;
                    break;
                }
                if (totalMin < 1.0) {
                    String msg = MIN_WARNING;
                    JOptionPane.showMessageDialog(this, msg, Intl.intl("Invalid data"), 0);
                    return false;
                }
            }
        }
        return super.validateData(showWarn, allowModify);
    }

    public static class GroupCreationPanel
    extends guiPanel {
        private VerboseCurveEditor minNumberOfMembers;
        private VerboseCurveEditor prefNumberOfMembers;
        private guiCheckBox cbAllowSmaller;
        private guiLabel lMinNumberOfMembers;
        private OccGroupTypeObj groupType;

        public GroupCreationPanel(boolean allowZero) {
            this.minNumberOfMembers = new VerboseCurveEditor(11, false, UnitDoubleVR.above(new UnitDouble(0.0, Unit.ONE), allowZero));
            this.prefNumberOfMembers = new VerboseCurveEditor(11, false, UnitDoubleVR.above(new UnitDouble(0.0, Unit.ONE), allowZero));
            this.cbAllowSmaller = new guiCheckBox(Intl.intl("Allow Smaller Groups"));
            this.lMinNumberOfMembers = new guiLabel(Intl.intl("Min Number of Members:"));
            LinkStatus.link2((AbstractButton)this.cbAllowSmaller, this.minNumberOfMembers, this.lMinNumberOfMembers);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Number of Members:"), this.prefNumberOfMembers, 1.0, GridBagHelper.REMAINING);
            gb.addRow(this.cbAllowSmaller, 1.0, GridBagHelper.REMAINING);
            gb.addIdentRow(this.lMinNumberOfMembers, this.minNumberOfMembers, 1.0, GridBagHelper.REMAINING);
        }

        public void load(OccGroupTypeObj.GroupCreationDataObj groupCreationData) {
            boolean allowSmaller = groupCreationData.allowSmallerGroups;
            this.cbAllowSmaller.setSelected(allowSmaller);
            ICurve min = groupCreationData.minNumberOfMembers != null ? groupCreationData.minNumberOfMembers : new ConstantCurve(new UnitDouble(0.0, Unit.ONE));
            this.minNumberOfMembers.setValue(min);
            this.prefNumberOfMembers.setValue(groupCreationData.prefNumberOfMembers);
        }

        public OccGroupTypeObj.GroupCreationDataObj save() {
            OccGroupTypeObj.GroupCreationDataObj data = new OccGroupTypeObj.GroupCreationDataObj((ICurve)this.prefNumberOfMembers.getValue(), this.cbAllowSmaller.isSelected(), this.cbAllowSmaller.isSelected() ? (ICurve)this.minNumberOfMembers.getValue() : null);
            return data;
        }
    }

    public static class GroupCreationEditor
    extends HTMLBtn
    implements Modifiable,
    IValEditor<OccGroupTypeObj.GroupCreationDataObj>,
    UnitUpdatableComponent {
        private final Comm d_comm;
        private OccGroupTypeObj.GroupCreationDataObj d_groupCreationData;
        private boolean d_modified;
        private GroupCreationPanel d_pnl;

        public GroupCreationEditor(Comm comm, boolean allowZero) {
            super("");
            this.d_comm = comm;
            this.d_modified = false;
            this.addActionListener(e -> {
                OccGroupTypeObj.GroupCreationDataObj newData;
                guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Group Creation"), 9);
                this.d_pnl = new GroupCreationPanel(allowZero);
                this.d_pnl.load(this.d_groupCreationData);
                dlg.getDialogPane().add(this.d_pnl);
                if (dlg.doModal() == 1 && !Objects.equals(newData = this.d_pnl.save(), this.d_groupCreationData)) {
                    this.setValue(newData);
                    this.setModified(true);
                    this.d_comm.touch(e);
                }
            });
            this.update();
        }

        @Override
        public void add(GridBagHelper gb) {
            gb.add(this, 1.0);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public Class<OccGroupTypeObj.GroupCreationDataObj> getType() {
            return OccGroupTypeObj.GroupCreationDataObj.class;
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }

        @Override
        public void setValue(OccGroupTypeObj.GroupCreationDataObj newType) {
            if (Objects.equals(newType, this.d_groupCreationData)) {
                return;
            }
            this.d_groupCreationData = newType;
            this.update();
            this.setModified(false);
        }

        @Override
        public OccGroupTypeObj.GroupCreationDataObj getValue() {
            return this.d_groupCreationData;
        }

        public void update() {
            this.setText(this.d_groupCreationData != null ? GroupCreationEditor.format(this.d_groupCreationData) : Intl.intl("&lt;mixed&gt;"));
        }

        public static String format(OccGroupTypeObj.GroupCreationDataObj groupType) {
            if (!groupType.allowSmallerGroups) {
                return String.format(Intl.intl("Number of Members: %s"), guiCurveUtil.format(groupType.prefNumberOfMembers));
            }
            return String.format(Intl.intl("Number of Members: %s, Min: %s"), guiCurveUtil.format(groupType.prefNumberOfMembers), guiCurveUtil.format(groupType.minNumberOfMembers));
        }

        @Override
        public void update(Unit newUnit) {
            this.update();
        }

        @Override
        public Unit getDisplayUnit() {
            return Unit.ONE;
        }
    }

    private static class ProfileConstraintsPanel
    extends guiPanel {
        private Map<OccProfile, GroupCreationEditor> profMap;

        public ProfileConstraintsPanel() {
            MerlinData md = MerlinApp.getApp().getData();
            ArrayList<OccProfile> allProfiles = new ArrayList<OccProfile>(md.profiles.flatten(OccProfile.class));
            allProfiles.sort((p1, p2) -> p1.getName().compareTo(p2.getName()));
            int rowHeight = 30;
            int height = Math.min(allProfiles.size() * rowHeight + 10, 150);
            JPanel panel = new JPanel();
            JScrollPane sp = new JScrollPane(panel);
            sp.setBorder(BorderFactory.createEmptyBorder());
            sp.getVerticalScrollBar().setUnitIncrement(6);
            this.setLayout(new BorderLayout());
            this.add((Component)sp, "Center");
            GridBagHelper gb = new GridBagHelper(panel, false, 12, 3);
            this.profMap = new LinkedHashMap<OccProfile, GroupCreationEditor>();
            int maxNameLength = 15;
            for (OccProfile prof : allProfiles) {
                guiLabel lbl;
                GroupCreationEditor groupCreationEditor = new GroupCreationEditor(this.getComm(), true);
                groupCreationEditor.setWrapEnabled(false);
                groupCreationEditor.setValue(new OccGroupTypeObj.GroupCreationDataObj(new ConstantCurve(new UnitDouble(0.0, Unit.ONE)), false, new ConstantCurve(new UnitDouble(0.0, Unit.ONE))));
                this.profMap.put(prof, groupCreationEditor);
                String name = prof.getName();
                if (name.length() > maxNameLength) {
                    name = name.substring(0, maxNameLength);
                    name = name + "...";
                    lbl = new guiLabel(name);
                    lbl.setToolTipText(prof.getName());
                } else {
                    lbl = new guiLabel(name);
                }
                gb.addRow(new Object[]{lbl, groupCreationEditor, new double[]{1.0, 0.0}, GridBagHelper.REMAINING, GridBagHelper.Anchor.LEFT});
            }
            gb.finalizeRows();
            sp.setPreferredSize(new Dimension(100, height));
        }

        public void init(Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> map) {
            for (OccProfile prof : this.profMap.keySet()) {
                this.profMap.get(prof).setValue(map.getOrDefault(prof, new OccGroupTypeObj.GroupCreationDataObj(prof)));
            }
        }

        public Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> commit() {
            LinkedHashMap<OccProfile, OccGroupTypeObj.GroupCreationDataObj> profileConstraints = new LinkedHashMap<OccProfile, OccGroupTypeObj.GroupCreationDataObj>();
            for (OccProfile prof : this.profMap.keySet()) {
                GroupCreationEditor editor = this.profMap.get(prof);
                profileConstraints.put(prof, editor.getValue());
            }
            return profileConstraints;
        }

        public ICurve getMinConstraints(OccProfile profile) {
            Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> map = this.commit();
            if (!map.containsKey(profile)) {
                return null;
            }
            OccGroupTypeObj.GroupCreationDataObj data = map.get(profile);
            return data.allowSmallerGroups ? data.minNumberOfMembers : data.prefNumberOfMembers;
        }
    }
}

