/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataListener;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;

public class NodeComboModel<T extends IMerlinObj>
extends DefaultComboBoxModel<Object>
implements IEventObserver {
    private final MerlinData d_md;
    private final Class<T> d_type;
    private final RootFinder<T> d_rootFinder;

    public NodeComboModel(MerlinData md, Class<T> type, RootFinder<T> rootFinder) {
        this.d_md = md;
        this.d_type = type;
        this.d_rootFinder = rootFinder;
        this.d_md.getEvents().addObserver(this);
        this.regen();
    }

    public MerlinData getData() {
        return this.d_md;
    }

    @Override
    public void update(Events events) {
        for (EventChannel<T> channel : events.getAffectedChannels(this.d_type, new Class[0])) {
            if (channel.areChangesExclusiveTo(MerlinData.SELECTION_CHANGED, MerlinData.VISIBILITY)) continue;
            this.regen();
            break;
        }
    }

    private void regen() {
        ListDataListener[] listeners;
        T selectedNode = this.getSelectedNode();
        this.removeAllElements();
        for (ListDataListener listener : listeners = this.getListDataListeners()) {
            this.removeListDataListener(listener);
        }
        Collection<?> objs = this.getObjects();
        for (Object o : objs) {
            this.insertElementAt(o, this.getSize());
        }
        for (ListDataListener listener : listeners) {
            this.addListDataListener(listener);
        }
        this.fireIntervalAdded(this, 0, objs.size() - 1);
        CompositeItem<T> item = this.itemFromComposite(selectedNode);
        if (item == null) {
            item = this.getFirstCompositeItem();
        }
        this.setSelectedItem(item);
    }

    protected Collection<?> getObjects() {
        Predicate<T> filter = this.d_rootFinder.getFilter(this.d_md);
        ArrayList<Object> objs = new ArrayList<Object>();
        if (this.d_rootFinder.includeRoot()) {
            for (IMerlinObj root : this.d_rootFinder.getRoots(this.d_md)) {
                this.buildGroupList(objs, filter, root, 0);
            }
        } else {
            for (IMerlinObj root : this.d_rootFinder.getRoots(this.d_md)) {
                for (IMerlinObj iMerlinObj : root.getChildren()) {
                    this.buildGroupList(objs, filter, iMerlinObj, 0);
                }
            }
        }
        return objs;
    }

    private void buildGroupList(Collection<Object> objs, Predicate<? super T> filter, IMerlinObj item, int depth) {
        if (this.d_type.isInstance(item) && filter.test(this.d_type.cast(item))) {
            objs.add(new CompositeItem<IMerlinObj>(item, depth));
            for (IMerlinObj iMerlinObj : item.getChildren()) {
                this.buildGroupList(objs, filter, iMerlinObj, depth + 1);
            }
        }
    }

    public void setSelectedNode(T comp) {
        CompositeItem<T> selItem = this.itemFromComposite(comp);
        if (selItem != null) {
            this.setSelectedItem(selItem);
        }
    }

    public T getSelectedNode() {
        CompositeItem item = (CompositeItem)this.getSelectedItem();
        return item != null ? (T)item.composite : null;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject instanceof CompositeItem) {
            super.setSelectedItem(anObject);
        }
    }

    private CompositeItem<T> getFirstCompositeItem() {
        for (int i = 0; i < this.getSize(); ++i) {
            Object obj = this.getElementAt(i);
            if (!(obj instanceof CompositeItem)) continue;
            return (CompositeItem)obj;
        }
        return null;
    }

    private CompositeItem<T> itemFromComposite(T composite) {
        for (int i = 0; i < this.getSize(); ++i) {
            Object obj = this.getElementAt(i);
            if (!(obj instanceof CompositeItem)) continue;
            CompositeItem item = (CompositeItem)obj;
            if (item.composite != composite) continue;
            return item;
        }
        return null;
    }

    public static class CompositeItem<T extends IMerlinObj> {
        public T composite;
        public int depth;

        public CompositeItem(T composite, int depth) {
            this.composite = composite;
            this.depth = depth;
        }
    }

    public static interface RootFinder<T extends IMerlinObj> {
        public Collection<? extends T> getRoots(MerlinData var1);

        public boolean includeRoot();

        public Predicate<? super T> getFilter(MerlinData var1);
    }
}

