/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import merlin.EntryPoint;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.data.Composite;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.gui.guiUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class MerlinComboBox<T extends IMerlinObj>
extends guiComboBox<T>
implements IEventObserver {
    private final MerlinData d_data;
    private final Class<T> d_type;
    private Predicate<? super T> d_filter;
    private String d_nullName;
    private Comparator<T> d_sorter;
    private Semaphore d_updateLock = new Semaphore(1);

    public MerlinComboBox(MerlinData md, Class<T> type) {
        this(md, type, Predicates.alwaysTrue());
    }

    public MerlinComboBox(final MerlinData md, Class<T> type, Predicate<? super T> filter) {
        this.d_data = md;
        this.d_type = type;
        this.d_filter = filter;
        this.d_nullName = "";
        this.d_sorter = new DefComparator();
        md.getEvents().addObserver(this);
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value == null || !guiUtil.decorateCellRenderer(md, value, this, isSelected, cellHasFocus)) {
                    this.setText(MerlinComboBox.this.d_nullName);
                }
                return this;
            }
        });
        this.updateEntries();
    }

    public Semaphore getUpdateLock() {
        return this.d_updateLock;
    }

    public void setFilter(Predicate<? super T> filter) {
        this.d_filter = filter;
        this.updateEntries();
    }

    public void setNullName(String nullName) {
        this.d_nullName = nullName;
        this.repaint();
    }

    public void setSorter(Comparator<T> sorter) {
        this.d_sorter = sorter;
        this.updateEntries();
    }

    protected String getName(MerlinData md, Object o) {
        if (!(o instanceof IMerlinObj)) {
            return o == null ? "" : o.toString();
        }
        EntryPoint<IMerlinObj> ep = EntryPointFactory.get((IMerlinObj)o);
        return ep.tvEntryPoint.getName(md, (IMerlinObj)o);
    }

    protected List<T> getItems(MerlinData md) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (this.d_type.equals(Material.class)) {
            items.addAll(theUtil.filter(md.materials.flatten(Material.class), this.d_type, this.d_filter));
        } else {
            for (IMerlinObj iMerlinObj : this.d_data.getChildren()) {
                if (!(iMerlinObj instanceof Composite)) continue;
                items.addAll(theUtil.filter(((Composite)iMerlinObj).getDeepMembers(this.d_type), this.d_filter));
            }
        }
        Collections.sort(items, this.d_sorter);
        return items;
    }

    private void updateEntries() {
        IMerlinObj selItem = (IMerlinObj)this.getSelectedItem();
        List<T> items = this.getItems(this.d_data);
        this.setItems(items);
        if (items.contains(selItem)) {
            this.setSelectedItem(selItem);
        } else if (!items.isEmpty()) {
            this.setSelectedIndex(0);
        }
    }

    @Override
    public void update(Events events) {
        if (!this.d_updateLock.tryAcquire()) {
            return;
        }
        try {
            IEventRecord<T> evt = events.getEvents(this.d_type, new Class[0]);
            if (!evt.getAddedObjs().isEmpty() || !evt.getRemovedObjs().isEmpty()) {
                this.updateEntries();
            } else if (evt.hasChangedObjs()) {
                this.repaint();
            }
        }
        finally {
            this.d_updateLock.release();
        }
    }

    public static class MerlinComboBoxWithEmptyOption<T extends IMerlinObj>
    extends MerlinComboBox<T> {
        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type, String msg, Predicate<? super T> filter) {
            super(md, type, filter);
            this.setNullName(msg);
        }

        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type, String msg) {
            this(md, type, msg, Predicates.alwaysTrue());
        }

        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type, Predicate<? super T> filter) {
            this(md, type, Intl.intl("[None]"), filter);
        }

        public MerlinComboBoxWithEmptyOption(MerlinData md, Class<T> type) {
            this(md, type, Intl.intl("[None]"));
        }

        @Override
        public List<T> getItems(MerlinData md) {
            List list = super.getItems(md);
            list.add(0, null);
            return list;
        }

        @Override
        public int getSelectedIndex() {
            int index = super.getSelectedIndex();
            if (index == -1) {
                index = 0;
            }
            return index;
        }
    }

    private class DefComparator
    implements Comparator<T> {
        private DefComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            String name1 = MerlinComboBox.this.getName(MerlinApp.getApp().getData(), o1);
            String name2 = MerlinComboBox.this.getName(MerlinApp.getApp().getData(), o2);
            return name1.compareToIgnoreCase(name2);
        }
    }
}

