/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.Delete;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.data.material.MaterialDB;
import merlin.gui.ImageBtnListener;
import merlin.gui.MerlinValueFields;
import merlin.gui.guiUtil;
import merlin.util.Dependencies;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.DlgListener;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IListenerStripper;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class MaterialDlg
extends guiDialog
implements IEventObserver,
DlgListener {
    public static final boolean ADVANCED_MATERIALS = theUtil.testSystemProp("ADVANCED_MATERIALS");
    public static final String MATERIAL_DLG_VIEW = "MaterialDlg.View";
    public static final String LIST_OPTION = "list option";
    public static final String ICONS_OPTION = "icons option";
    private List<Material> d_materials;
    private Material d_choice;
    private final MaterialDB d_texDB;
    private final EditorPnl d_editor;
    private final IconsPanel d_iconsPanel;
    private final JButton d_removeBtn;
    private final JButton d_removeUnusedBtn;

    public MaterialDlg(JFrame parent, MaterialDB texDB, Material init, boolean includeNull) {
        super((Window)parent, Intl.intl("Materials"), 11);
        super.setResizable(true);
        this.d_choice = null;
        this.d_texDB = texDB;
        this.d_editor = new EditorPnl();
        this.d_removeBtn = new JButton(new RemoveAction());
        this.d_removeUnusedBtn = new JButton(new RemoveUnusedAction());
        JButton importBtn = new JButton(new ImportAction());
        JButton newBtn = new JButton(new NewAction());
        this.d_iconsPanel = new IconsPanel(this.d_editor);
        this.d_iconsPanel.setPreferredSize(new Dimension(200, 400));
        guiPanel leftPanel = new guiPanel();
        GridBagHelper gb = new GridBagHelper(leftPanel);
        gb.addRow(this.d_iconsPanel, new int[]{0, 1}, new double[]{1.0, 1.0});
        gb.addFilledRow(newBtn);
        gb.addFilledRow(importBtn);
        gb.addFilledRow(this.d_removeBtn);
        gb.addFilledRow(this.d_removeUnusedBtn);
        JSplitPane splitPane = new JSplitPane(1, leftPanel, this.d_editor);
        guiPanel content = super.getDialogPane();
        content.setLayout(new GridBagLayout());
        GridBagUtil.add(content, splitPane, 0, 0, 3, 1, 0, 0, 0, 0, 1, 1.0, 1.0);
        this.addDlgListener(this);
        CloseListener closeLis = new CloseListener();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().unregisterKeyboardAction(ks);
        this.getRootPane().registerKeyboardAction(closeLis, ks, 2);
        this.setDefaultCloseOperation(0);
        this.removeWindowListener(this.d_cancelListener);
        this.addWindowListener(closeLis);
        MerlinApp.getApp().getData().getEvents().addObserver(this);
        this.d_iconsPanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                Material newMat = (Material)e.getItem();
                if (newMat == MaterialDlg.this.d_choice) {
                    return;
                }
                if (MaterialDlg.this.d_choice != null && MaterialDlg.this.d_editor.isModified()) {
                    switch (MaterialDlg.this.showConfirm()) {
                        case 0: {
                            boolean isValid = MaterialDlg.this.handleYes();
                            if (!isValid) {
                                MaterialDlg.this.setChoice(MaterialDlg.this.d_choice);
                                break;
                            }
                        }
                        case 1: {
                            MaterialDlg.this.setChoice(newMat);
                            break;
                        }
                        default: {
                            MaterialDlg.this.setChoice(MaterialDlg.this.d_choice);
                            break;
                        }
                    }
                } else {
                    MaterialDlg.this.setChoice(newMat);
                }
            }
        });
        this.updateMaterialsList(includeNull);
        this.setChoice(init);
    }

    protected final boolean preSave() {
        if (this.d_editor.isModified()) {
            int opt = this.showConfirm();
            if (opt == 1) {
                this.d_editor.init(this.d_choice);
            } else if (opt == 0) {
                if (!this.handleYes()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public int showConfirm() {
        Material edObj = this.d_choice;
        String msg = String.format(Intl.intl("Save changes to: %s?"), edObj.getName());
        return JOptionPane.showConfirmDialog(this, msg);
    }

    protected boolean handleYes() {
        if (!this.d_editor.validateData(true, true)) {
            this.setChoice(this.d_choice);
            return false;
        }
        this.d_editor.commit(this.d_choice, false);
        return true;
    }

    @Override
    public void okPressed() {
        this.applyPressed();
    }

    @Override
    public void applyPressed() {
        if (this.d_editor.isModified()) {
            this.d_editor.commit(this.d_choice, false);
            this.d_iconsPanel.repaint();
        }
    }

    @Override
    public void cancelPressed() {
    }

    @Override
    public void helpPressed() {
    }

    @Override
    public void resetPressed() {
    }

    @Override
    public void closePressed() {
        if (this.d_editor.isModified()) {
            switch (this.showConfirm()) {
                case 0: {
                    if (this.handleYes()) {
                        this.setChoice(this.d_choice);
                        this.setVisible(false);
                        break;
                    }
                    this.setChoice(this.d_choice);
                    break;
                }
                case 1: {
                    this.setChoice(this.d_choice);
                    this.setVisible(false);
                    break;
                }
                default: {
                    this.setChoice(this.d_choice);
                    break;
                }
            }
        } else {
            this.setVisible(false);
        }
    }

    public Material getSelectedEntry() {
        return this.d_choice;
    }

    private void setChoice(Material choice) {
        this.d_choice = choice;
        this.d_removeBtn.setEnabled(this.d_choice != null);
        this.d_iconsPanel.setSelectedItem(choice);
        this.d_editor.init(choice);
    }

    private static <T extends JComponent> T cinit(T comp) {
        comp.setMinimumSize(comp.getPreferredSize());
        return comp;
    }

    protected void showException(Exception e, String msg) {
        guiUtil.showError(this, Intl.intl("Error"), msg, (Throwable)e);
    }

    protected void updateMaterialsList(boolean includeNull) {
        this.d_materials = new ArrayList<Material>(this.d_texDB.flatten(Material.class));
        if (includeNull) {
            this.d_materials.add(null);
        }
        this.sortMaterials();
        this.d_iconsPanel.update(this.d_materials);
    }

    private void sortMaterials() {
        Collections.sort(this.d_materials, new Comparator<Material>(){

            @Override
            public int compare(Material o1, Material o2) {
                if (o1 == o2) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    @Override
    public void update(Events events) {
        IEventRecord<Material> mevts = events.getEvents(Material.class, new Class[0]);
        boolean sort = false;
        boolean updatePnl = false;
        Material newSel = this.d_choice;
        for (Material mat : mevts.getAddedObjs()) {
            if (newSel == null) {
                newSel = mat;
            }
            this.d_materials.add(mat);
            updatePnl = true;
            sort = true;
        }
        for (Material mat : mevts.getRemovedObjs()) {
            if (mat.equals(this.d_choice)) {
                newSel = null;
            }
            this.d_materials.remove(mat);
            updatePnl = true;
        }
        if (sort) {
            this.sortMaterials();
        }
        if (updatePnl) {
            this.d_iconsPanel.update(this.d_materials);
            this.repaint();
        }
        this.setChoice(newSel);
    }

    private class RemoveAction
    extends guiAction {
        public RemoveAction() {
            super(Intl.intl("Remove") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MaterialDlg.this.d_choice == null) {
                return;
            }
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Material toRemove = MaterialDlg.this.d_choice;
                    Delete.uiDelete(app, md, Arrays.asList(toRemove));
                }
            };
            UIHook.run(UIHook.getComponent(e), "MaterialDlg.RemoveAction.actionPerformed", op, 0);
        }
    }

    private class RemoveUnusedAction
    extends guiAction {
        public RemoveUnusedAction() {
            super(Intl.intl("Remove Unused") + "...");
            this.putValue("ShortDescription", Intl.intl("Removes unused materials unless stored in the global database."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AMerlinOp op = new AMerlinOp(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(MerlinApp app, MerlinData md) {
                    ArrayList<Object> unused = new ArrayList();
                    md.beginRead();
                    try {
                        Set<Material> inuse = md.getMaterialsInUse();
                        Predicate<Material> filter = Filters.reject(inuse).and(mat -> merlinData.materials.isLocal((Material)mat));
                        unused = new ArrayList<Material>(md.materials.flatten(Material.class, filter));
                    }
                    finally {
                        md.endRead();
                    }
                    if (unused.isEmpty()) {
                        JOptionPane.showMessageDialog(app.getActiveFrame(), Intl.intl("All unused materials are stored in the global database and will not be deleted."), Intl.intl("Delete Warning"), 2);
                        return;
                    }
                    Delete.uiDelete(app, md, unused);
                }
            };
            UIHook.run(UIHook.getComponent(e), "MaterialDlg.RemoveUnusedAction.actionPerformed", op, 0);
        }
    }

    private class ImportAction
    extends guiAction {
        public ImportAction() {
            super(Intl.intl("Import") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MaterialDlg.this.preSave()) {
                return;
            }
            guiFileChooser chooser = guiUtil.getChooser(MerlinPrefs.OPEN_DIR_PREF, Optional.empty(), MaterialDlg.this.d_texDB.getFileFilters());
            chooser.setMultiSelectionEnabled(true);
            if (chooser.showOpenDialog(MaterialDlg.this) != 0) {
                return;
            }
            final File[] texfiles = chooser.getSelectedFiles();
            final ArrayList newMaterials = new ArrayList(texfiles.length);
            final ArrayList exceptions = new ArrayList();
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    md.beginWrite();
                    Undo.insertEntry_breakChain(md);
                    try {
                        for (File texFile : texfiles) {
                            IImage img = ImageManager.getImage(texFile.getAbsolutePath(), 3, 0);
                            String name = FilenameManager.splitFilename(texFile.getName())[0];
                            Texture diffTex = Texture.repeated(img, "uvset");
                            MatAttrs matAttrs = new MatAttrs(Color.WHITE, diffTex, 1.0);
                            Material newMat = new Material(name, matAttrs);
                            MaterialDlg.this.d_texDB.add(newMat);
                            MaterialDlg.this.d_texDB.importToDB(newMat);
                            newMaterials.add(newMat);
                        }
                    }
                    catch (Exception ioe) {
                        exceptions.add(ioe);
                    }
                    md.endWrite();
                }
            };
            UIHook.run(UIHook.getComponent(e), Intl.intl("Import Materials"), op, 2);
            if (!exceptions.isEmpty()) {
                MaterialDlg.this.showException((Exception)exceptions.get(0), Intl.intl("Error importing material."));
            }
        }
    }

    private class NewAction
    extends guiAction {
        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MaterialDlg.this.preSave()) {
                return;
            }
            final ArrayList exceptions = new ArrayList();
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    String name = JOptionPane.showInputDialog("Enter material name: ");
                    if (name == null) {
                        return;
                    }
                    md.beginWrite();
                    Undo.insertEntry_breakChain(md);
                    try {
                        if (name.equals("")) {
                            name = "untitled";
                        }
                        MatAttrs matAttrs = new MatAttrs();
                        Material newMat = new Material(name, matAttrs);
                        MaterialDlg.this.d_texDB.add(newMat);
                        MaterialDlg.this.d_texDB.importToDB(newMat);
                    }
                    catch (Exception ioe) {
                        exceptions.add(ioe);
                    }
                    md.endWrite();
                }
            };
            UIHook.run(UIHook.getComponent(e), Intl.intl("Create New Materials"), op, 2);
            if (!exceptions.isEmpty()) {
                MaterialDlg.this.showException((Exception)exceptions.get(0), Intl.intl("Error creating material."));
            }
        }
    }

    private static class TiledPanel
    extends guiPanel {
        private final MatChannel d_channel;
        private Material d_choice;

        public TiledPanel(MatChannel channel) {
            this.d_channel = channel;
        }

        public void setMaterial(Material choice) {
            this.d_choice = choice;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Rectangle visrect = this.getBounds();
            if (this.d_choice == null) {
                FontMetrics fm = g2d.getFontMetrics();
                String str = Intl.intl("No Material");
                Rectangle2D bnds = fm.getStringBounds(str, g2d);
                int x = visrect.width / 2 - (int)(bnds.getWidth() / 2.0);
                int y = visrect.height / 2 - (int)(bnds.getHeight() / 2.0);
                g2d.setColor(Color.BLACK);
                g2d.drawString(str, x, y);
            } else if (this.d_choice.getAttributes().getTexture(this.d_channel) != null) {
                Texture tex = this.d_choice.getAttributes().getTexture(this.d_channel);
                BufferedImage img = guiUtil.getBufferedImage(tex.image);
                if (img == null) {
                    return;
                }
                int wid = img.getWidth();
                int ht = img.getHeight();
                int tx = (visrect.width + wid - 1) / wid;
                int ty = (visrect.height + ht - 1) / ht;
                for (int i = 0; i < tx; ++i) {
                    for (int j = 0; j < ty; ++j) {
                        g2d.drawImage(img, null, i * wid, j * ht);
                    }
                }
            } else {
                Color color = this.d_choice.getAttributes().getColor(this.d_channel);
                g2d.setColor(color);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private static class ImagePanel
    extends guiPanel {
        private Material d_choice;
        private final MatChannel d_channel;

        public ImagePanel(MatChannel channel) {
            this.d_channel = channel;
        }

        public void setMaterial(Material mat) {
            this.d_choice = mat;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Rectangle visrect = this.getBounds();
            if (this.d_choice == null) {
                FontMetrics fm = g2d.getFontMetrics();
                String str = Intl.intl("No Material");
                Rectangle2D bnds = fm.getStringBounds(str, g2d);
                int x = visrect.width / 2 - (int)(bnds.getWidth() / 2.0);
                int y = visrect.height / 2 - (int)(bnds.getHeight() / 2.0);
                g2d.setColor(Color.BLACK);
                g2d.drawString(str, x, y);
            } else if (this.d_choice.getAttributes().getTexture(this.d_channel) != null) {
                Texture tex = this.d_choice.getAttributes().getTexture(this.d_channel);
                BufferedImage img = guiUtil.getBufferedImage(tex.image);
                if (img == null) {
                    return;
                }
                int wid = img.getWidth();
                int ht = img.getHeight();
                double sx = Math.min(1.0, (double)this.getWidth() / (double)wid);
                double sy = Math.min(1.0, (double)this.getHeight() / (double)ht);
                double scale = Math.min(sx, sy);
                double swid = scale * (double)wid;
                double sht = scale * (double)ht;
                double tx = Math.max(0.0, ((double)this.getWidth() - swid) / 2.0);
                double ty = Math.max(0.0, ((double)this.getHeight() - sht) / 2.0);
                AffineTransform xform = new AffineTransform();
                xform.translate(tx, ty);
                xform.scale(scale, scale);
                g2d.drawImage(img, xform, this);
            } else {
                Color color = this.d_choice.getAttributes().getColor(this.d_channel);
                double wid = 128.0;
                double ht = 128.0;
                double centerx = (double)this.getWidth() * 0.5;
                double centery = (double)this.getHeight() * 0.5;
                g2d.setColor(color);
                g2d.fillRect((int)Math.round(centerx - wid * 0.5), (int)Math.round(centery - ht * 0.5), (int)wid, (int)ht);
            }
        }
    }

    private static class EditorPnl
    extends guiPanel
    implements Observer {
        private final guiLabel d_title;
        private final JButton d_advMatBtn;
        private final ValueField<UnitDouble> d_wid;
        private final ValueField<UnitDouble> d_ht;
        private final ImagePanel d_preview = new ImagePanel(MatChannel.DIFFUSE);
        private final TiledPanel d_tiled;
        private final ColorChannelProps diffuseProps;
        private final ValueChannelProps opacityProps;
        private final ColorChannelProps emissiveProps;
        private final TextureChannelProps normalProps;
        private final ColorChannelProps specularProps;
        private final ValueChannelProps shininessProps;
        private final ValueChannelProps metallicProps;
        private final ValueChannelProps roughnessProps;
        private Material d_previewObj;

        public EditorPnl() {
            this.d_preview.setPreferredSize(new Dimension(400, 300));
            this.d_tiled = new TiledPanel(MatChannel.DIFFUSE);
            this.d_tiled.setPreferredSize(new Dimension(400, 300));
            this.d_title = new guiLabel();
            this.d_title.setFont(new Font("Sans Serif", 1, 11));
            guiLabel widLbl = new guiLabel(Intl.intl("Texture Width:"));
            this.d_wid = (ValueField)MaterialDlg.cinit(MerlinValueFields.udFld(0));
            guiLabel htLbl = new guiLabel(Intl.intl("Texture Height:"));
            this.d_ht = (ValueField)MaterialDlg.cinit(MerlinValueFields.udFld(0));
            this.d_advMatBtn = new JButton("Advanced Materials...");
            this.d_advMatBtn.addActionListener(e -> {
                Component component = (Component)e.getSource();
                Window parent = SwingUtilities.getWindowAncestor(component);
                AdvancedMaterialsDlg dlg = new AdvancedMaterialsDlg(parent, this.d_previewObj);
                dlg.doModal();
            });
            this.diffuseProps = new ColorChannelProps(MatChannel.DIFFUSE, Intl.intl("Diffuse/Albedo"), false);
            this.opacityProps = new ValueChannelProps(MatChannel.OPACITY, Intl.intl("Opacity"), false, 10, 1.0, DoubleVR.between(0.0, 1.0, true, true), Unit.ONE);
            this.emissiveProps = new ColorChannelProps(MatChannel.EMISSIVE, Intl.intl("Emissive"), true);
            this.normalProps = new TextureChannelProps(MatChannel.NORMAL, Intl.intl("Normal"), true);
            this.specularProps = new ColorChannelProps(MatChannel.SPECULAR, Intl.intl("Specular"), true);
            this.shininessProps = new ValueChannelProps(MatChannel.SHININESS, Intl.intl("Shininess"), true, 11, 0.0, DoubleVR.above(0.0, true), Unit.ONE);
            this.metallicProps = new ValueChannelProps(MatChannel.METALLIC, Intl.intl("Metallic"), true, 10, 0.0, DoubleVR.between(0.0, 1.0, true, true), Unit.ONE);
            this.roughnessProps = new ValueChannelProps(MatChannel.ROUGHNESS, Intl.intl("Roughness"), true, 10, 1.0, DoubleVR.between(0.0, 1.0, true, true), Unit.ONE);
            JTabbedPane jtp = new JTabbedPane();
            jtp.setTabPlacement(3);
            jtp.add(Intl.intl("Image"), this.d_preview);
            jtp.add(Intl.intl("Tiled"), this.d_tiled);
            GridBagHelper gb = new GridBagHelper(this, true);
            gb.addRow(Intl.intl("Name:"), this.d_title, 0);
            gb.addRow(widLbl, this.d_wid, 0);
            gb.addRow(htLbl, this.d_ht, 0);
            this.diffuseProps.add(gb);
            this.opacityProps.add(gb);
            if (ADVANCED_MATERIALS) {
                gb.addRow(new Object[]{this.d_advMatBtn, 0, GridBagHelper.Anchor.RIGHT});
            }
            gb.addFilledRow(new TitleSeparator(Intl.intl("Preview")));
            gb.addIdentRow(jtp, new double[]{1.0, 1.0}, new int[]{0, 0});
            gb.finalizeRows();
            this.d_comm.addObserver(this);
        }

        private boolean chooseImage(ImageBtn imgBtn) {
            if (imgBtn.getImage() != null) {
                return true;
            }
            return ImageBtnListener.INSTANCE.chooseNewImage(imgBtn);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (this.d_previewObj != null && this.validateData(false, false)) {
                this.commit(this.d_previewObj, true);
                this.d_preview.repaint();
                this.d_tiled.repaint();
            }
        }

        public void init(Material entry) {
            this.d_previewObj = entry != null ? entry.clone() : null;
            this.setEnabled(entry != null && entry.getAttributes() instanceof MatAttrs);
            this.diffuseProps.load(entry);
            this.opacityProps.load(entry);
            if (entry == null) {
                this.d_title.setText("no material");
                this.d_wid.setValue(new UnitDouble(0.0, SI.METER));
                this.d_ht.setValue(new UnitDouble(0.0, SI.METER));
            } else {
                this.d_wid.setValue(entry.getWidth());
                this.d_ht.setValue(entry.getHeight());
            }
            this.d_preview.setMaterial(this.d_previewObj);
            this.d_tiled.setMaterial(this.d_previewObj);
            this.setModified(false);
        }

        public void commit(final Material entry, boolean preview) {
            if (preview) {
                this.apply(entry);
                return;
            }
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    md.beginWrite();
                    Undo.insertEntry_breakChain(md);
                    try {
                        MatAttrs attrs = (MatAttrs)entry.getAttributes();
                        attrs = attrs.mergeWith(d_previewObj.getAttributes(), IMatAttrs.ALL);
                        entry.setAttributes(attrs);
                        this.updateReferencing(md, entry);
                        md.materials.updateFile(entry);
                    }
                    catch (Exception exp) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                guiUtil.showError(this, Intl.intl("Error"), Intl.intl("Error saving material to file."), (Throwable)exp);
                            }
                        });
                    }
                    md.endWrite();
                }
            };
            UIHook.run(this, Intl.intl("Edit Material"), op, 2);
        }

        private void updateReferencing(MerlinData md, Material entry) {
            LinkedIdentityHashSet referencing = new LinkedIdentityHashSet();
            Dependencies.getObjReferences(md, o -> o == entry, (r, e) -> referencing.add(r));
            for (IMerlinObj ref : referencing) {
                ref.changedEvt(new Object[0]);
            }
        }

        private void apply(Material entry) {
            this.diffuseProps.save(entry);
            this.opacityProps.save(entry);
        }

        public class AdvancedMaterialsDlg
        extends guiDialog
        implements DlgListener {
            private final guiComboBox<String> combo;
            private final CardLayout cardLayout;
            private final guiPanel cardPanel;
            private Material entry;

            public AdvancedMaterialsDlg(Window parent, final Material entry) {
                super(parent, Intl.intl("Advanced Materials"), 11);
                this.entry = entry;
                this.addDlgListener(this);
                guiPanel panel = new guiPanel();
                GridBagHelper gb = new GridBagHelper(panel);
                EditorPnl.this.emissiveProps.add(gb);
                EditorPnl.this.normalProps.add(gb);
                String[] options = new String[]{Intl.intl("Specular"), Intl.intl("Metallic")};
                IMatAttrs attrs = entry.getAttributes();
                IMatAttrs.Workflow workflow = attrs.getWorkflow();
                this.combo = new guiComboBox<String>((T[])options);
                switch (workflow) {
                    case SPECULAR: {
                        this.combo.setSelectedIndex(0);
                        break;
                    }
                    case METALLIC: {
                        this.combo.setSelectedIndex(1);
                    }
                }
                gb.addRow(Intl.intl("Workflow:"), this.combo, 1.0);
                this.combo.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (((String)AdvancedMaterialsDlg.this.combo.getSelectedItem()).equals(Intl.intl("Specular"))) {
                            AdvancedMaterialsDlg.this.cardLayout.show(AdvancedMaterialsDlg.this.cardPanel, Intl.intl("Specular"));
                            MatAttrs attrs = (MatAttrs)entry.getAttributes();
                            attrs = attrs.applyWorkflow(IMatAttrs.Workflow.SPECULAR);
                        } else {
                            AdvancedMaterialsDlg.this.cardLayout.show(AdvancedMaterialsDlg.this.cardPanel, Intl.intl("Metallic"));
                            MatAttrs attrs = (MatAttrs)entry.getAttributes();
                            MatAttrs matAttrs = attrs.applyWorkflow(IMatAttrs.Workflow.METALLIC);
                        }
                    }
                });
                this.cardLayout = new CardLayout();
                guiPanel specularCard = new guiPanel(new GridBagLayout());
                guiPanel metallicCard = new guiPanel(new GridBagLayout());
                this.cardPanel = new guiPanel(this.cardLayout);
                this.cardPanel.add((Component)specularCard, Intl.intl("Specular"));
                this.cardPanel.add((Component)metallicCard, Intl.intl("Metallic"));
                GridBagHelper g1 = new GridBagHelper(specularCard);
                GridBagHelper g2 = new GridBagHelper(metallicCard);
                g1.indent();
                g2.indent();
                EditorPnl.this.specularProps.add(g1);
                EditorPnl.this.shininessProps.add(g1);
                EditorPnl.this.metallicProps.add(g2);
                EditorPnl.this.roughnessProps.add(g2);
                guiPanel content = super.getDialogPane();
                content.setLayout(new GridBagLayout());
                GridBagUtil.add(content, panel, 0, 0, 3, 1, 0, 0, 0, 0, 2, 1.0, 1.0);
                GridBagUtil.add(content, this.cardPanel, 0, 1, 3, 1, 0, 0, 0, 0, 2, 1.0, 1.0);
                this.load();
            }

            private void load() {
                this.setEnabled(this.entry != null && this.entry.getAttributes() instanceof MatAttrs);
                EditorPnl.this.emissiveProps.load(this.entry);
                EditorPnl.this.normalProps.load(this.entry);
                EditorPnl.this.specularProps.load(this.entry);
                EditorPnl.this.shininessProps.load(this.entry);
                EditorPnl.this.metallicProps.load(this.entry);
                EditorPnl.this.roughnessProps.load(this.entry);
            }

            private void save() {
                EditorPnl.this.emissiveProps.save(this.entry);
                EditorPnl.this.normalProps.save(this.entry);
                EditorPnl.this.specularProps.save(this.entry);
                EditorPnl.this.shininessProps.save(this.entry);
                EditorPnl.this.metallicProps.save(this.entry);
                EditorPnl.this.roughnessProps.save(this.entry);
            }

            @Override
            public void applyPressed() {
                this.save();
            }

            @Override
            public void okPressed() {
                this.applyPressed();
            }

            @Override
            public void resetPressed() {
            }

            @Override
            public void cancelPressed() {
            }

            @Override
            public void closePressed() {
            }

            @Override
            public void helpPressed() {
            }
        }

        public class TextureChannelProps {
            public final MatChannel channel;
            public final String name;
            public final boolean extend;
            public final ImageBtn texButton = (ImageBtn)MaterialDlg.access$1300(new ImageBtn());
            private final guiRadioButton noneRB = new guiRadioButton(Intl.intl("None"));
            private final guiRadioButton imgRB = new guiRadioButton(Intl.intl("Texture Image:"));

            public TextureChannelProps(MatChannel channel, String name, boolean extend) {
                this.channel = channel;
                this.name = name;
                this.extend = extend;
                this.imgRB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!EditorPnl.this.chooseImage(TextureChannelProps.this.texButton)) {
                            TextureChannelProps.this.noneRB.setSelected(true);
                        }
                    }
                });
                new guiButtonGroup(this.noneRB, this.imgRB);
                this.texButton.addActionListener(ImageBtnListener.INSTANCE);
                this.texButton.addObserver(new IObserver(){

                    @Override
                    public void update(IObservable source, Object arg) {
                        EditorPnl.this.setModified(true);
                    }
                }, false);
                LinkStatus.link((AbstractButton)this.imgRB, this.texButton);
            }

            public void load(Material entry) {
                EditorPnl.this.setEnabled(entry != null && entry.getAttributes() instanceof MatAttrs);
                if (entry == null) {
                    this.noneRB.setSelected(true);
                    this.texButton.setImage(null);
                } else {
                    IMatAttrs attrs = entry.getAttributes();
                    Texture diffTex = attrs.getTexture(this.channel);
                    if (diffTex == null) {
                        this.texButton.setImage(null);
                        this.noneRB.setSelected(true);
                    } else {
                        this.imgRB.setSelected(true);
                        this.texButton.setImage(diffTex.image);
                    }
                }
            }

            public void save(Material entry) {
                MatAttrs attrs = (MatAttrs)entry.getAttributes();
                Texture oldTex = attrs.getTexture(this.channel);
                Texture tex = null;
                if (this.texButton.getImage() != null) {
                    String uvSet = oldTex != null ? oldTex.uvSet : "uvset";
                    tex = Texture.repeated(this.texButton.getImage(), uvSet);
                }
                if (this.channel != null) {
                    attrs = attrs.applyTexture(this.channel, tex);
                }
                entry.setAttributes(attrs);
            }

            public void add(GridBagHelper gbh) {
                gbh.addFilledRow(new TitleSeparator(Intl.intl(this.name)));
                gbh.indent();
                if (this.extend) {
                    gbh.addRow(this.noneRB, 0, 1.0);
                    gbh.addRow(this.imgRB, this.texButton, 0, 1.0);
                } else {
                    gbh.addRow(this.noneRB, 0);
                    gbh.addRow(this.imgRB, this.texButton, 0);
                }
                gbh.unindent();
            }
        }

        public class ValueChannelProps {
            public final MatChannel channel;
            public final String name;
            public final boolean extend;
            public final ImageBtn texButton = (ImageBtn)MaterialDlg.access$1300(new ImageBtn());
            public final ValueField<UnitDouble> valueFld;
            private final UnitDouble d_defValue;
            private final Unit d_nativeUnit;
            private final guiRadioButton imgRB = new guiRadioButton(Intl.intl("Texture Image:"));
            private final guiRadioButton valueRB = new guiRadioButton(Intl.intl("Value:"));

            public ValueChannelProps(MatChannel channel, String name, boolean extend, int unitType, double defVal, DoubleVR range, Unit nativeUnit) {
                this.channel = channel;
                this.name = name;
                this.extend = extend;
                this.valueFld = (ValueField)MaterialDlg.cinit(MerlinValueFields.udFld(defVal, range, nativeUnit, unitType));
                this.d_nativeUnit = nativeUnit;
                this.d_defValue = new UnitDouble(defVal, nativeUnit);
                this.imgRB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!EditorPnl.this.chooseImage(ValueChannelProps.this.texButton)) {
                            ValueChannelProps.this.valueRB.setSelected(true);
                        }
                    }
                });
                new guiButtonGroup(this.valueRB, this.imgRB);
                this.valueFld.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EditorPnl.this.setModified(true);
                    }
                });
                this.texButton.addActionListener(ImageBtnListener.INSTANCE);
                this.texButton.addObserver(new IObserver(){

                    @Override
                    public void update(IObservable source, Object arg) {
                        EditorPnl.this.setModified(true);
                    }
                }, false);
                LinkStatus.link((AbstractButton)this.valueRB, this.valueFld);
                LinkStatus.link((AbstractButton)this.imgRB, this.texButton);
                this.valueFld.setPreferredSize(new Dimension(this.texButton.getPreferredSize().width, this.valueFld.getPreferredSize().height));
            }

            public void load(Material entry) {
                EditorPnl.this.setEnabled(entry != null && entry.getAttributes() instanceof MatAttrs);
                if (entry == null) {
                    this.valueFld.setValue(this.d_defValue);
                    this.texButton.setImage(null);
                } else if (this.channel != null) {
                    IMatAttrs attrs = entry.getAttributes();
                    Texture diffTex = attrs.getTexture(this.channel);
                    double value = attrs.getValue(this.channel);
                    if (diffTex == null) {
                        this.valueRB.setSelected(true);
                        this.valueFld.setValue(new UnitDouble(value, this.d_nativeUnit));
                        this.texButton.setImage(null);
                    } else {
                        this.imgRB.setSelected(true);
                        this.valueFld.setValue(this.d_defValue);
                        this.texButton.setImage(diffTex.image);
                    }
                }
            }

            public void save(Material entry) {
                MatAttrs attrs = (MatAttrs)entry.getAttributes();
                Texture oldTex = attrs.getTexture(this.channel);
                Texture tex = null;
                if (this.imgRB.isSelected() && this.texButton.getImage() != null) {
                    String uvSet = oldTex != null ? oldTex.uvSet : "uvset";
                    tex = Texture.repeated(this.texButton.getImage(), uvSet);
                }
                UnitDouble value = (UnitDouble)this.valueFld.getValue();
                if (this.channel != null) {
                    attrs = attrs.applyTexture(this.channel, tex);
                    attrs = attrs.applyValue(this.channel, value.getValue(this.d_nativeUnit));
                }
                entry.setAttributes(attrs);
            }

            public void add(GridBagHelper gbh) {
                gbh.addFilledRow(new TitleSeparator(Intl.intl(this.name)));
                gbh.indent();
                if (this.extend) {
                    gbh.addRow(this.valueRB, this.valueFld, 0, 1.0);
                    gbh.addRow(this.imgRB, this.texButton, 0, 1.0);
                } else {
                    gbh.addRow(this.valueRB, this.valueFld, 0);
                    gbh.addRow(this.imgRB, this.texButton, 0);
                }
                gbh.unindent();
            }
        }

        public class ColorChannelProps {
            public final MatChannel channel;
            public final String name;
            public final boolean extend;
            public final ColorButton colorBtn = (ColorButton)MaterialDlg.access$1300(new ColorButton(1));
            public final ImageBtn texButton = (ImageBtn)MaterialDlg.access$1300(new ImageBtn());
            private final guiRadioButton colorRB = new guiRadioButton(Intl.intl("Color:"));
            private final guiRadioButton imgRB = new guiRadioButton(Intl.intl("Texture Image:"));

            public ColorChannelProps(MatChannel channel, String name, boolean extend) {
                this.channel = channel;
                this.name = name;
                this.extend = extend;
                this.imgRB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!EditorPnl.this.chooseImage(ColorChannelProps.this.texButton)) {
                            ColorChannelProps.this.colorRB.setSelected(true);
                        }
                    }
                });
                new guiButtonGroup(this.colorRB, this.imgRB);
                this.colorBtn.addObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        EditorPnl.this.setModified(true);
                    }
                });
                this.texButton.addActionListener(ImageBtnListener.INSTANCE);
                this.texButton.addObserver(new IObserver(){

                    @Override
                    public void update(IObservable source, Object arg) {
                        EditorPnl.this.setModified(true);
                    }
                }, false);
                LinkStatus.link((AbstractButton)this.colorRB, this.colorBtn);
                LinkStatus.link((AbstractButton)this.imgRB, this.texButton);
            }

            public void load(Material entry) {
                EditorPnl.this.setEnabled(entry != null && entry.getAttributes() instanceof MatAttrs);
                if (entry == null) {
                    this.colorBtn.setSelected(true);
                    this.colorBtn.setColor(Color.WHITE);
                    this.texButton.setImage(null);
                } else if (this.channel != null) {
                    String name = entry.getName();
                    EditorPnl.this.d_title.setText(name);
                    IMatAttrs attrs = entry.getAttributes();
                    Texture diffTex = attrs.getTexture(this.channel);
                    Color color = attrs.getColor(this.channel);
                    this.colorBtn.setColor(color);
                    if (diffTex == null) {
                        this.colorRB.setSelected(true);
                        this.texButton.setImage(null);
                    } else {
                        this.imgRB.setSelected(true);
                        this.texButton.setImage(diffTex.image);
                    }
                }
            }

            public void save(Material entry) {
                MatAttrs attrs = (MatAttrs)entry.getAttributes();
                Texture oldTex = attrs.getTexture(this.channel);
                Texture tex = null;
                if (this.imgRB.isSelected() && this.texButton.getImage() != null) {
                    String uvSet = oldTex != null ? oldTex.uvSet : "uvset";
                    tex = Texture.repeated(this.texButton.getImage(), uvSet);
                }
                Color color = this.colorBtn.getColor();
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
                if (this.channel != null) {
                    attrs = attrs.applyTexture(this.channel, tex);
                    attrs = attrs.applyColor(this.channel, color);
                }
                entry.setAttributes(attrs);
            }

            public void add(GridBagHelper gbh) {
                gbh.addFilledRow(new TitleSeparator(Intl.intl(this.name)));
                gbh.indent();
                if (this.extend) {
                    gbh.addRow(this.colorRB, this.colorBtn, 0, 1.0);
                    gbh.addRow(this.imgRB, this.texButton, 0, 1.0);
                } else {
                    gbh.addRow(this.colorRB, this.colorBtn, 0);
                    gbh.addRow(this.imgRB, this.texButton, 0);
                }
                gbh.unindent();
            }
        }
    }

    private static class FlowPanel
    extends guiPanel
    implements IconView,
    ItemListener {
        private final guiPanel d_changeTrackPnl;
        private final List<ItemListener> d_listeners;

        public FlowPanel(guiPanel changeTrackPnl) {
            super(new FlowLayout(0));
            this.d_changeTrackPnl = changeTrackPnl;
            this.d_changeTrackPnl.getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.updateModified();
                }
            });
            this.setBackground(UIManager.getDefaults().getColor("List.background"));
            this.d_listeners = new ArrayList<ItemListener>();
        }

        private void updateModified() {
            for (MaterialButton btn : this.getButtons()) {
                btn.setModified(btn.isSelected() && this.d_changeTrackPnl.isModified());
            }
        }

        @Override
        public Object[] getSelectedObjects() {
            Object[] objectArray;
            MaterialButton tb = (MaterialButton)this.getSelectedButton().v1;
            if (tb != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = tb.d_ti;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = null;
            }
            return objectArray;
        }

        @Override
        public void addItemListener(ItemListener listener) {
            this.d_listeners.add(listener);
        }

        @Override
        public void removeItemListener(ItemListener listener) {
            this.d_listeners.remove(listener);
        }

        @Override
        public JComponent getPanel() {
            JScrollPane comp = new JScrollPane(this){

                @Override
                public void setBounds(int x, int y, int width, int height) {
                    int flowPanelHeight;
                    int rows;
                    int cols;
                    super.setBounds(x, y, width, height);
                    int numButtons = this.getButtons().size();
                    int hGap = ((FlowLayout)this.getLayout()).getHgap();
                    int vGap = ((FlowLayout)this.getLayout()).getVgap();
                    int flowPanelMaxWidth = width;
                    int buttonWidth = 0;
                    int buttonHeight = 0;
                    if (this.getComponentCount() != 0) {
                        Component c = this.getComponent(0);
                        Dimension d = c.getPreferredSize();
                        buttonWidth = (int)d.getWidth();
                        buttonHeight = (int)d.getHeight();
                    }
                    if ((cols = (flowPanelMaxWidth - hGap) / (buttonWidth + hGap)) < 1) {
                        cols = 1;
                    }
                    if ((rows = numButtons / cols) * cols != numButtons) {
                        ++rows;
                    }
                    if ((flowPanelHeight = rows * buttonHeight + (rows + 1) * vGap) > height) {
                        flowPanelMaxWidth = width - this.getVerticalScrollBar().getPreferredSize().width;
                        cols = (flowPanelMaxWidth - hGap) / (buttonWidth + hGap);
                        if (cols < 1) {
                            cols = 1;
                        }
                        if ((rows = numButtons / cols) * cols != numButtons) {
                            ++rows;
                        }
                        flowPanelHeight = rows * buttonHeight + (rows + 1) * vGap;
                    }
                    int flowPanelWidth = cols * buttonWidth + (cols + 1) * hGap;
                    this.setPreferredSize(new Dimension(flowPanelWidth, flowPanelHeight));
                }
            };
            comp.setHorizontalScrollBarPolicy(31);
            return comp;
        }

        @Override
        public void update(List<Material> materials) {
            this.removeAll();
            ButtonGroup bg = new ButtonGroup();
            for (Material mat : materials) {
                MaterialButton button = new MaterialButton(mat);
                button.addItemListener(this);
                this.add(button);
                bg.add(button);
            }
        }

        @Override
        public void updateSel(Material choice) {
            for (MaterialButton tb : this.getButtons()) {
                if (!theUtil.equal(tb.d_ti, choice)) continue;
                IListenerStripper listeners = guiUtil.stripListeners(tb);
                tb.setSelected(true);
                listeners.restore();
                Rectangle bounds = tb.getBounds();
                this.scrollRectToVisible(bounds);
                break;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                MaterialButton tb = (MaterialButton)e.getItem();
                Material item = tb != null ? tb.d_ti : null;
                ItemEvent evt = new ItemEvent(this, e.getID(), item, e.getStateChange());
                for (ItemListener listener : this.d_listeners) {
                    listener.itemStateChanged(evt);
                }
            }
        }

        private Pair<MaterialButton, Integer> getSelectedButton() {
            int ix = 0;
            for (MaterialButton btn : this.getButtons()) {
                if (btn.isSelected()) {
                    return new Pair<MaterialButton, Integer>(btn, ix);
                }
                ++ix;
            }
            return new Pair<Object, Integer>(null, -1);
        }

        private List<MaterialButton> getButtons() {
            ArrayList<MaterialButton> buttons = new ArrayList<MaterialButton>();
            for (int m = 0; m < this.getComponentCount(); ++m) {
                Component c = this.getComponent(m);
                if (!(c instanceof MaterialButton)) continue;
                MaterialButton tb = (MaterialButton)c;
                buttons.add(tb);
            }
            return buttons;
        }

        private static class MaterialButton
        extends JToggleButton {
            private final Material d_ti;

            public MaterialButton(Material ti) {
                this.d_ti = ti;
                guiUtil.initButton((AbstractButton)this, ti, 32, 32);
            }

            public void setModified(boolean modified) {
                if (modified) {
                    this.setFont(this.getFont().deriveFont(2));
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                }
            }
        }
    }

    private static class ListPanel
    extends guiPanel
    implements IconView {
        private final guiPanel d_changeTrackPnl;
        private final JList<Object> d_selList;

        public ListPanel(guiPanel changeTrackPnl) {
            super(new GridBagLayout());
            this.d_changeTrackPnl = changeTrackPnl;
            this.d_changeTrackPnl.getComm().addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    this.repaint();
                }
            });
            this.d_selList = new JList();
        }

        @Override
        public Object[] getSelectedObjects() {
            return new Object[]{this.d_selList.getSelectedValue()};
        }

        @Override
        public JComponent getPanel() {
            return new JScrollPane(this);
        }

        @Override
        public void addItemListener(ItemListener listener) {
            this.d_selList.addListSelectionListener(new SelListener(listener));
        }

        @Override
        public void removeItemListener(ItemListener listener) {
            for (ListSelectionListener llistener : this.d_selList.getListSelectionListeners()) {
                if (!(llistener instanceof SelListener) || ((SelListener)llistener).ilistener != listener) continue;
                this.d_selList.removeListSelectionListener(llistener);
                break;
            }
        }

        @Override
        public void update(List<Material> materials) {
            IListenerStripper listeners = guiUtil.stripListeners(this.d_selList);
            this.remove(this.d_selList);
            this.d_selList.setListData(new Vector<Material>(materials));
            this.d_selList.setSelectionMode(0);
            this.d_selList.setCellRenderer(new MaterialListCellRenderer());
            GridBagUtil.add(this, this.d_selList, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
            listeners.restore();
        }

        @Override
        public void updateSel(Material choice) {
            IListenerStripper listeners = guiUtil.stripListeners(this.d_selList);
            if (choice == null && this.d_selList.getModel().getSize() > 0 && this.d_selList.getModel().getElementAt(0) == null) {
                this.d_selList.setSelectedIndex(0);
            } else {
                this.d_selList.setSelectedValue(choice, true);
            }
            listeners.restore();
        }

        private class MaterialListCellRenderer
        extends DefaultListCellRenderer {
            private MaterialListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text;
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Material mat = (Material)value;
                Font font = this.getFont();
                if (mat == null) {
                    font = font.deriveFont(1);
                    text = Intl.intl("<No Material>");
                } else {
                    text = mat.getName();
                }
                if (ListPanel.this.d_changeTrackPnl.isModified() && isSelected) {
                    font = font.deriveFont(2);
                }
                Icon[] icon = guiUtil.getIcons((Material)value, 32, 32, 0, guiUtil.ImageFilter.NORMAL, guiUtil.ImageFilter.DISABLED);
                this.setIcon(icon[0]);
                this.setDisabledIcon(icon[1]);
                this.setFont(font);
                this.setText(text);
                return this;
            }
        }

        private class SelListener
        implements ListSelectionListener {
            public final ItemListener ilistener;

            public SelListener(ItemListener listener) {
                this.ilistener = listener;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Material mat = (Material)ListPanel.this.d_selList.getSelectedValue();
                ItemEvent evt = new ItemEvent(ListPanel.this, 701, mat, 1);
                this.ilistener.itemStateChanged(evt);
            }
        }
    }

    private static interface IconView
    extends ItemSelectable {
        public void update(List<Material> var1);

        public void updateSel(Material var1);

        public JComponent getPanel();
    }

    private static class IconsPanel
    extends guiPanel
    implements ItemSelectable {
        private final CardLayout d_cards;
        private final guiPanel d_cardPanel;
        private final List<View> d_views;
        private View d_currView;
        private List<Material> d_materials = Collections.EMPTY_LIST;

        public IconsPanel(guiPanel changeTrackPnl) {
            this.d_views = Arrays.asList(new View(Intl.intl("List"), new ListPanel(changeTrackPnl), MaterialDlg.LIST_OPTION), new View(Intl.intl("Icons"), new FlowPanel(changeTrackPnl), MaterialDlg.ICONS_OPTION));
            this.d_cards = new CardLayout(0, 0);
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.setLayout(new GridBagLayout());
            ButtonGroup bg = new ButtonGroup();
            int col = 0;
            for (final View view : this.d_views) {
                bg.add(view.btn);
                view.btn.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            this.selectedPanel(view);
                        }
                    }
                });
                JComponent comp = view.iv.getPanel();
                this.d_cardPanel.add((Component)comp, view.pref);
                this.d_cards.addLayoutComponent(comp, view.pref);
                GridBagUtil.add(this, view.btn, col++, 0, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0);
            }
            GridBagUtil.add(this, this.d_cardPanel, 0, 1, 2, 1, 12, 6, 6, 6, 1, 1.0, 1.0);
            this.d_currView = this.d_views.get(0);
            String viewPref = Application.getApp().getPreference(MaterialDlg.MATERIAL_DLG_VIEW);
            for (View view : this.d_views) {
                if (!view.pref.equals(viewPref)) continue;
                view.btn.setSelected(true);
                break;
            }
            this.selectedPanel(this.d_currView);
        }

        @Override
        public void addItemListener(ItemListener l) {
            for (View view : this.d_views) {
                view.iv.addItemListener(l);
            }
        }

        @Override
        public void removeItemListener(ItemListener l) {
            for (View view : this.d_views) {
                view.iv.removeItemListener(l);
            }
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.d_currView.iv.getSelectedObjects();
        }

        private void selectedPanel(View view) {
            Object[] objectArray;
            if (this.d_currView != null) {
                objectArray = this.d_currView.iv.getSelectedObjects();
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = null;
            }
            Object[] sel = objectArray;
            this.d_currView = view;
            this.update(this.d_materials);
            this.setSelectedItem((Material)sel[0]);
            this.d_cards.show(this.d_cardPanel, this.d_currView.pref);
            Application.getApp().setPreference(MaterialDlg.MATERIAL_DLG_VIEW, this.d_currView.pref);
        }

        public void update(List<Material> materials) {
            this.d_materials = materials;
            this.d_currView.iv.update(this.d_materials);
        }

        public void setSelectedItem(Material mat) {
            this.d_currView.iv.updateSel(mat);
        }

        private class View {
            public final guiRadioButton btn;
            public final IconView iv;
            public final String pref;

            public View(String desc, IconView iv, String pref) {
                this.btn = new guiRadioButton(desc);
                this.iv = iv;
                this.pref = pref;
            }
        }
    }

    private class CloseListener
    extends WindowAdapter
    implements ActionListener {
        private CloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.close();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.close();
        }

        private void close() {
            MaterialDlg.this.d_status = 16;
            MaterialDlg.this.fireButtonPressed(16);
        }
    }
}

