/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import merlin.gui.value.AValEditor;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.UrnUtil;
import thunderheadeng.util.theUtil;

public class DistributionEditor<T extends IMerlinObj>
extends AValEditor<IUrn<T>>
implements IEventObserver {
    private final MerlinData d_data;
    private boolean d_modified = false;
    private final JEditorPane d_editor;
    private final String d_desc;
    private final Composite<? extends ICompElement> d_root;
    private final Class<T> d_clazz;
    private final Predicate<T> d_filter;
    private List<T> d_availObjs;
    private Function<MerlinData, Collection<T>> d_getExtraObjs;

    public DistributionEditor(MerlinData md, String desc, Composite<? extends ICompElement> root, Class<T> clazz, Predicate<T> availFilter) {
        super(IUrn.class);
        this.d_data = md;
        this.d_desc = desc;
        this.d_root = root;
        this.d_clazz = clazz;
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.newHTMLLabel();
        this.d_editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && DistributionEditor.this.d_editor.isEnabled()) {
                    DistributionEditor.this.edit();
                }
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
        this.d_editor.setPreferredSize(new Dimension(200, this.d_editor.getPreferredSize().height));
        this.setValue(UrnUtil.newUrn(Collections.emptyMap()));
        this.updateAvailable();
        this.setModified(false);
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.addRow(this.d_editor, 1.0);
    }

    private void edit() {
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        DistDlg<T> dlg = new DistDlg<T>(parent, this.d_desc, this.d_root, this.d_getExtraObjs);
        IUrn val = (IUrn)this.getValue();
        this.updateAvailable();
        dlg.setDistribution(this.d_availObjs, val != null ? val.getWeights() : null);
        if (dlg.doModal() != 1) {
            return;
        }
        this.setValue(UrnUtil.newUrn(dlg.getDistribution()));
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    public void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        IUrn val = (IUrn)this.getValue();
        if (val != null && !this.d_availObjs.isEmpty()) {
            Map weights = val.getWeights();
            LinkedIdentityHashMap distribution = new LinkedIdentityHashMap(weights);
            distribution.keySet().retainAll(new IdentityHashSet<T>(this.d_availObjs));
            double total = DistributionEditor.sum(distribution.values());
            if (theUtil.lt(total, 1.0, 1.0E-6)) {
                assert (!this.d_availObjs.isEmpty());
                IMerlinObj firstObj = (IMerlinObj)this.d_availObjs.get(0);
                double fracForFirst = distribution.containsKey(firstObj) ? (Double)distribution.get(firstObj) : 0.0;
                double remain = 1.0 - (total -= fracForFirst);
                distribution.put(firstObj, remain);
            }
            this.setValue(UrnUtil.newUrn(distribution));
        }
        this.updateDesc();
    }

    public void setExtraObjs(Function<MerlinData, Collection<T>> getExtraObjs) {
        this.d_getExtraObjs = getExtraObjs;
    }

    private static double sum(Collection<Double> values) {
        double total = 0.0;
        for (Double frac : values) {
            total += frac.doubleValue();
        }
        return total;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    private List<T> getAllAvailableObjs() {
        ArrayList<IMerlinObj> all = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : this.d_root.getDeepMembers(this.d_clazz)) {
            if (!this.d_filter.test(obj)) continue;
            all.add(obj);
        }
        if (this.d_getExtraObjs != null) {
            Collection<IMerlinObj> extraObjs = this.d_getExtraObjs.apply((MerlinData)this.d_root.getDomain());
            extraObjs.forEach(o -> {
                if (this.d_filter.test((IMerlinObj)o)) {
                    all.add((IMerlinObj)o);
                }
            });
        }
        Collections.sort(all, ObjSorter.INSTANCE);
        return all;
    }

    public List<T> getAvailable() {
        return this.d_availObjs;
    }

    public void setAvailable(List<T> avail) {
        this.d_availObjs = avail;
        this.updateDesc();
    }

    @Override
    public void loadValue(IUrn<T> value) {
        this.updateDesc();
    }

    @Override
    protected IUrn<T> saveValue() {
        return (IUrn)this.getValue();
    }

    protected void updateDesc() {
        boolean isShortened;
        Map dist;
        String desc = null;
        Map map = dist = this.getValue() != null ? ((IUrn)this.getValue()).getWeights() : null;
        if (dist == null) {
            desc = Intl.intl("[mixed]");
        } else if (dist.isEmpty()) {
            desc = Intl.intl("[none]");
        } else if (dist.size() == 1) {
            desc = MerlinUtil.getName((IMerlinObj)dist.keySet().iterator().next());
        } else {
            ArrayList objList = new ArrayList(dist.keySet());
            Collections.sort(objList, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    double frac1 = (Double)dist.get(o1);
                    double frac2 = (Double)dist.get(o2);
                    int comp = Double.compare(frac2, frac1);
                    if (comp != 0) {
                        return comp;
                    }
                    comp = MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
                    return comp;
                }
            });
            desc = "";
            for (IMerlinObj obj : objList) {
                if (!desc.isEmpty()) {
                    desc = desc + "; ";
                }
                desc = desc + String.format(Intl.intl("%.1f%% %s"), dist.get(obj) * 100.0, MerlinUtil.getName(obj));
            }
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        String displayDesc = guiUtil.shorten(desc, 150, fm);
        boolean bl = isShortened = !displayDesc.equals(desc);
        if (this.d_availObjs.size() > 1 || dist != null && dist.isEmpty() && !this.d_availObjs.isEmpty()) {
            displayDesc = "<html><a href=\"blank\">" + displayDesc + "</a></html>";
        }
        this.d_editor.setText(displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText(desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.updateDesc();
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    MouseListener {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            if (table != null && (header = table.getTableHeader()) != null) {
                header.removeMouseListener(this);
                header.addMouseListener(this);
            }
            return this;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doClick(0);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private static class DistDlg<T extends IMerlinObj>
    extends guiDialog {
        private final guiTable d_table;
        private final Composite<? extends ICompElement> d_root;

        public DistDlg(Window parent, String desc, Composite<? extends ICompElement> root, final Function<MerlinData, Collection<T>> getExtraObjs) {
            super(parent, desc, 9);
            this.d_root = root;
            JButton evenDistBtn = new JButton(Intl.intl("Distribute Evenly"));
            evenDistBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.distributeEvenly();
                }
            });
            JButton clearBtn = new JButton(Intl.intl("Clear"));
            clearBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.clearDistribution();
                }
            });
            ObjTableModel tm = new ObjTableModel();
            tm.setColumnCount(2);
            this.d_table = new guiTable((TableModel)tm, 0);
            this.d_table.setRowSelectionAllowed(true);
            this.d_table.setColumnSelectionAllowed(true);
            tm.setColumnClass(0, Double.class);
            this.d_table.getColumnModel().getColumn(0).setHeaderValue(Intl.intl("%"));
            TableColumn objCol = this.d_table.getColumnModel().getColumn(1);
            objCol.setHeaderValue(desc);
            objCol.setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (getExtraObjs != null && ((Collection)getExtraObjs.apply(d_root.getDomain())).contains(value)) {
                        comp.setFont(comp.getFont().deriveFont(2));
                    }
                    this.setText(DistDlg.format((IMerlinObj)value));
                    return comp;
                }
            });
            final guiLabel countLbl = new guiLabel("test");
            countLbl.setFont(countLbl.getFont().deriveFont(1));
            this.d_table.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    String text;
                    Color color = countLbl.getForeground();
                    if (!d_table.validateData(false, false)) {
                        text = Intl.intl("Invalid table entry.");
                        color = Color.RED;
                    } else {
                        double percent = this.getTotalPercent();
                        text = String.format(Intl.intl("Total distribution: %.1f%%"), percent);
                        color = Color.BLACK;
                    }
                    countLbl.setText(text);
                    countLbl.setForeground(color);
                }
            });
            JScrollPane sp = new JScrollPane(this.d_table);
            sp.setPreferredSize(new Dimension(150, 120));
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(sp, new double[]{1.0, 1.0}, 0);
            gb.addRow(countLbl, 0);
            gb.addRow(clearBtn, evenDistBtn);
            this.d_table.autoSizeColumns();
            this.setResizable(true);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            for (int m = 0; m < this.d_table.getRowCount(); ++m) {
                Double val = (Double)this.d_table.getValueAt(m, 0);
                if (val == null || !(val < 0.0) && !(val > 100.0)) continue;
                if (showWarn) {
                    DistDlg.showInvalidEntryMessage(this, Intl.intl("Each percentage must be >= 0 && <= 100."));
                }
                return false;
            }
            double totalPercent = this.getTotalPercent();
            if (!theUtil.eq(totalPercent, 100.0, 1.0E-6)) {
                if (showWarn) {
                    DistDlg.showInvalidEntryMessage(this, Intl.intl("The total distribution must add to 100%."));
                }
                return false;
            }
            return true;
        }

        private void distributeEvenly() {
            TableModel model = this.d_table.getModel();
            int numEntries = model.getRowCount();
            Double val = 100.0 / (double)numEntries;
            for (int m = 0; m < numEntries; ++m) {
                this.d_table.setValueAt(val, m, 0);
            }
        }

        private void clearDistribution() {
            TableModel model = this.d_table.getModel();
            for (int m = 0; m < model.getRowCount(); ++m) {
                this.d_table.setValueAt(0.0, m, 0);
            }
        }

        private static <T extends IMerlinObj> String format(T mobj) {
            return MerlinUtil.getName(mobj);
        }

        public void setDistribution(List<T> availObjs, Map<T, Double> objs) {
            DefaultTableModel model = (DefaultTableModel)this.d_table.getModel();
            model.setRowCount(availObjs.size());
            for (int m = 0; m < availObjs.size(); ++m) {
                IMerlinObj obj = (IMerlinObj)availObjs.get(m);
                Double percent = null;
                if (objs != null) {
                    percent = objs.containsKey(obj) ? Double.valueOf(objs.get(obj) * 100.0) : Double.valueOf(0.0);
                }
                model.setValueAt(percent, m, 0);
                model.setValueAt(obj, m, 1);
            }
        }

        public Map<T, Double> getDistribution() {
            LinkedIdentityHashMap<IMerlinObj, Double> dist = new LinkedIdentityHashMap<IMerlinObj, Double>();
            TableModel model = this.d_table.getModel();
            for (int m = 0; m < model.getRowCount(); ++m) {
                Double percent = (Double)model.getValueAt(m, 0);
                if (percent == null || !(percent > 0.0)) continue;
                dist.put((IMerlinObj)model.getValueAt(m, 1), percent * 0.01);
            }
            return dist;
        }

        private double getTotalPercent() {
            double percent = 0.0;
            for (int m = 0; m < this.d_table.getRowCount(); ++m) {
                Double val = (Double)this.d_table.getValueAt(m, 0);
                if (val == null) continue;
                percent += val.doubleValue();
            }
            return percent;
        }

        private static class ObjTableModel
        extends guiDefaultTableModel {
            private ObjTableModel() {
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        }
    }

    private static class ObjSorter<T extends IMerlinObj>
    implements Comparator<T> {
        public static final ObjSorter<IMerlinObj> INSTANCE = new ObjSorter();

        private ObjSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            return MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
        }
    }
}

