/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import merlin.Intl;
import merlin.data.egress.agents.AvatarImportUtil;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.ShapeAvatar;
import merlin.gui.AvatarEditor;
import merlin.gui.WrapLayout;
import merlin.util.BitOptions;
import thunderheadeng.gui.FilteredIcon;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ImageFilterToBufferedImageOp;
import thunderheadeng.gui.NoIcon;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.Property;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.Urn;

public class AvatarChooser
extends guiDialog
implements ComponentListener {
    private static final int IMAGE_HEIGHT = 200;
    private guiPanel d_selectorPanel;
    private JButton d_btnClearAll;
    private JButton d_btnImport;
    private guiLabel d_info;
    private Dimension d_szBtn;
    private int d_vgap;
    private int d_hgap;
    private Map<IAvatar, ModelImageButton> d_buttonMap;
    private boolean d_loaded;
    private final int d_min;
    private final int d_max;
    private final ButtonGroup d_btnGroup;
    private final JScrollPane d_imageScroll;
    private Property<IUrn<IAvatar>> d_loadedValue;
    private boolean d_modified = false;
    private final BitOptions d_options;
    private final ResourceAvatar.Type d_type;
    private final Collection<File> d_modelDirs;
    private Thread d_imageThread;

    public AvatarChooser(Window owner, int minCount, int maxCount, int options, ResourceAvatar.Type type) {
        super(owner, Intl.intl("3D Model"), 9);
        this.d_type = type;
        this.d_options = new BitOptions(options);
        this.d_modelDirs = ResourceAvatar.getAvatarDirs(false, type);
        assert (minCount <= maxCount);
        assert (maxCount >= 1);
        this.d_min = minCount;
        this.d_max = maxCount;
        this.d_btnGroup = new ButtonGroup();
        this.d_loaded = false;
        this.d_szBtn = null;
        this.d_hgap = 6;
        this.d_vgap = 4;
        this.d_buttonMap = new LinkedHashMap<IAvatar, ModelImageButton>();
        this.d_selectorPanel = new guiPanel(new WrapLayout(0, this.d_hgap, this.d_vgap));
        this.loadModels();
        String info = this.d_max == 1 ? Intl.intl("Select a 3D model.") : Intl.intl("Click to enable or disable 3D models.");
        this.d_info = new guiLabel(info);
        this.d_btnClearAll = new JButton(new ClearAllAction());
        this.d_btnClearAll.setVisible(this.d_max > 1);
        this.d_btnImport = new JButton(new ImportModelAction(this));
        super.getContentPane().remove(super.getButtonPanel());
        guiPanel southPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(southPnl, this.d_btnImport, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0);
        GridBagUtil.add(southPnl, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(southPnl, this.getButtonPanel(), 2, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0);
        super.getContentPane().add((Component)southPnl, "South");
        this.pack();
        this.setPreferredWidth(this.d_selectorPanel, 640);
        this.setSize(640, 480);
        this.d_imageScroll = new JScrollPane(this.d_selectorPanel);
        this.d_imageScroll.getVerticalScrollBar().setUnitIncrement(16);
        guiPanel p = this.getDialogPane();
        p.setLayout(new GridBagLayout());
        GridBagUtil.add(p, this.d_info, 0, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(p, this.d_btnClearAll, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 13);
        GridBagUtil.add(p, this.d_imageScroll, 0, 1, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        this.setResizable(true);
        this.addComponentListener(this);
        this.initSelection();
    }

    private void setPreferredWidth(Component c, int width) {
        c.setSize(new Dimension(width, 1));
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        List<IAvatar> sel = this.getSelectedModels();
        if (sel.size() < this.d_min) {
            String msg = this.d_min == 1 ? Intl.intl("Select at least one 3D model.") : String.format(Intl.intl("Select at least %d 3D models."), this.d_min);
            this.showMessageBox(msg);
            return false;
        }
        return true;
    }

    public void loadModels() {
        ArrayList<IAvatar> avatars = new ArrayList<IAvatar>();
        if (this.d_options.get(2L)) {
            avatars.add(null);
        }
        if (this.d_options.get(4L)) {
            avatars.add(ShapeAvatar.INSTANCE);
        }
        avatars.addAll(ResourceAvatar.getValidAvatars(this.d_modelDirs));
        Collections.sort(avatars, new AvatarEditor.AvatarComparator());
        this.d_selectorPanel.removeAll();
        this.d_buttonMap.clear();
        for (IAvatar occModel : avatars) {
            ModelImageButton btn = this.newBtn(occModel);
            this.d_buttonMap.put(occModel, btn);
            this.d_selectorPanel.add(btn);
            if (this.d_szBtn == null) {
                this.d_szBtn = btn.getPreferredSize();
            }
            if (this.d_max == 1) {
                this.d_btnGroup.add(btn);
                continue;
            }
            this.d_btnGroup.remove(btn);
        }
        if (avatars.isEmpty()) {
            ModelImageButton btn = this.newBtn(null);
            this.d_szBtn = btn.getPreferredSize();
        }
    }

    public void initSelection() {
        if (this.d_min == 0) {
            this.setValue(Property.of(new Urn<IAvatar>(new IAvatar[0])));
        } else if (this.d_buttonMap.keySet().isEmpty()) {
            Iterator<IAvatar> it = this.d_buttonMap.keySet().iterator();
            ArrayList<IAvatar> iniSel = new ArrayList<IAvatar>();
            for (int m = 0; m < Math.min(this.d_min, this.d_buttonMap.size()); ++m) {
                iniSel.add(it.next());
            }
            this.setValue(Property.of(new Urn(iniSel)));
        }
    }

    public void setValue(Property<IUrn<IAvatar>> models) {
        this.d_loadedValue = models;
        HashSet avatars = new HashSet();
        if (models.isUniform()) {
            models.get().getUnique(avatars);
        }
        this.selectModels(avatars);
        this.setModified(false);
    }

    private void selectModels(Set<? extends IAvatar> models) {
        if (this.d_max == 1 && models.size() > 1) {
            models = Collections.singleton(models.iterator().next());
        }
        if (models.isEmpty() && this.d_max == 1) {
            this.d_btnGroup.clearSelection();
        } else {
            for (Map.Entry<IAvatar, ModelImageButton> entry : this.d_buttonMap.entrySet()) {
                boolean select = models.contains(entry.getKey());
                entry.getValue().setSelected(select);
            }
        }
    }

    public ModelImageButton getButtonFromName(String name) {
        List validAvatars = this.d_buttonMap.keySet().stream().filter(avatar -> avatar != null).filter(avatar -> name.equals(avatar.getName())).collect(Collectors.toList());
        if (validAvatars.size() == 0) {
            return null;
        }
        return this.d_buttonMap.get(validAvatars.get(0));
    }

    public Property<IUrn<IAvatar>> getValue() {
        if (!this.isModified()) {
            return this.d_loadedValue;
        }
        return Property.of(new Urn<IAvatar>((Collection<IAvatar>)this.getSelectedModels()));
    }

    private List<IAvatar> getSelectedModels() {
        ArrayList<IAvatar> selected = new ArrayList<IAvatar>();
        for (Map.Entry<IAvatar, ModelImageButton> entry : this.d_buttonMap.entrySet()) {
            IAvatar avatar = entry.getKey();
            ModelImageButton btn = entry.getValue();
            if (!btn.isSelected()) continue;
            selected.add(avatar);
        }
        return selected;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified || super.isModified();
    }

    private ModelImageButton newBtn(IAvatar name) {
        ModelImageButton btn = new ModelImageButton(name);
        btn.addActionListener(e -> this.setModified(true));
        return btn;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension szControlling = this.getSize();
        this.setPreferredWidth(this.d_selectorPanel, szControlling.width);
    }

    private void loadImages(String modelToFocus) {
        for (ModelImageButton mib : this.d_buttonMap.values()) {
            mib.initImage();
        }
        EventQueue.invokeLater(() -> {
            int maxWidth = 0;
            for (ModelImageButton mib : this.d_buttonMap.values()) {
                maxWidth = Math.max(maxWidth, mib.getPreferredSize().width);
            }
            System.out.println(maxWidth);
            for (ModelImageButton mib : this.d_buttonMap.values()) {
                mib.setPreferredSize(new Dimension(maxWidth, mib.getPreferredSize().height));
            }
            int width2 = maxWidth * 2 + this.d_hgap * 3 + this.d_imageScroll.getInsets().left + this.d_imageScroll.getInsets().right + this.d_imageScroll.getVerticalScrollBar().getWidth();
            if (width2 > this.getSize().width) {
                this.d_imageScroll.setSize(new Dimension(width2, this.d_imageScroll.getSize().height));
                this.setSize(width2, this.getHeight());
                this.pack();
            }
            this.d_selectorPanel.invalidate();
            Runnable r = modelToFocus != null ? () -> this.scrollToModel(modelToFocus) : () -> this.scrollToFirstSelected();
            EventQueue.invokeLater(r);
        });
    }

    private void scrollToModel(String modelName) {
        ModelImageButton a = this.getButtonFromName(modelName);
        if (a.getParent() instanceof JComponent) {
            ((JComponent)a.getParent()).scrollRectToVisible(a.getBounds());
        }
    }

    private void scrollToFirstSelected() {
        this.d_buttonMap.values().stream().filter(AbstractButton::isSelected).findFirst().ifPresent(b -> {
            if (b.getParent() instanceof JComponent) {
                ((JComponent)b.getParent()).scrollRectToVisible(b.getBounds());
            }
        });
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.startImageThread(null);
    }

    public void startImageThread(String modelToFocus) {
        if (!this.d_loaded) {
            this.d_imageThread = new Thread(() -> this.loadImages(modelToFocus));
            this.d_imageThread.start();
        }
    }

    private static class ImportModelAction
    extends AbstractAction {
        private final AvatarChooser d_parent;

        public ImportModelAction(AvatarChooser parent) {
            super(Intl.intl("Import..."));
            this.d_parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String modelName = AvatarImportUtil.importFBXModel(this.d_parent, this.d_parent.d_type);
            if (modelName != null) {
                Property<IUrn<IAvatar>> selState = this.d_parent.getValue();
                this.d_parent.loadModels();
                this.d_parent.startImageThread(modelName);
                this.d_parent.initSelection();
                this.d_parent.setValue(selState);
            }
        }
    }

    private class ClearAllAction
    extends AbstractAction {
        public ClearAllAction() {
            super(Intl.intl("Clear All"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AvatarChooser.this.selectModels(Collections.EMPTY_SET);
            AvatarChooser.this.setModified(true);
        }
    }

    private static class ModelImageButton
    extends JToggleButton {
        public final IAvatar model;

        public ModelImageButton(IAvatar model) {
            super(model == null ? Intl.intl("<hidden>") : model.getName());
            this.model = model;
            if (this.getText() != null && this.model != null) {
                this.setToolTipText(this.getText());
                this.shortenButtonText(this.model.getPreviewImage().getWidth(this), this.model.getPreviewImage().getHeight(this));
            }
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            Insets margin = this.getMargin();
            margin.top = margin.left;
            this.setMargin(margin);
        }

        public void shortenButtonText(int imageWidth, int imageHeight) {
            if (imageHeight != 200) {
                imageWidth = (int)Math.round((double)imageWidth / (double)imageHeight * 200.0);
            }
            int maxLength = (int)Math.round((double)imageWidth / 5.26316);
            if (this.getToolTipText().length() <= maxLength) {
                return;
            }
            char[] shortenedText = new char[maxLength];
            for (int i = 0; i < maxLength - 3; ++i) {
                shortenedText[i] = this.getText().charAt(i);
            }
            Arrays.fill(shortenedText, maxLength - 3, maxLength, '.');
            this.setText(new String(shortenedText));
        }

        public void initImage() {
            if (this.model == null) {
                Function<Color, NoIcon> newIcon = color -> new NoIcon((Color)color, 100, 200);
                Color selColor = Color.RED;
                Color nselColor = new Color(guiUtil.DISABLED_FILTER.filterRGB(0, 0, selColor.getRGB()));
                this.setIcons(newIcon.apply(selColor), newIcon.apply(nselColor));
            } else {
                this.setImage(this.model.getPreviewImage());
            }
        }

        private void setImage(Image img) {
            int height = img.getHeight(this);
            if (height != 200) {
                int width = img.getWidth(this);
                width = (int)Math.round((double)width / (double)height * 200.0);
                img = img.getScaledInstance(width, 200, 4);
            }
            GrayFilter filter = ModelImageButton.getFilter();
            FilteredImageSource producer = new FilteredImageSource(img.getSource(), filter);
            Image blkWht = this.createImage(producer);
            this.setIcons(new ImageIcon(img), new ImageIcon(blkWht));
        }

        private void setIcons(Icon selectedIcon) {
            GrayFilter filter = ModelImageButton.getFilter();
            ImageFilterToBufferedImageOp op = new ImageFilterToBufferedImageOp(filter);
            FilteredIcon blkWht = new FilteredIcon(selectedIcon, op);
            this.setIcons(selectedIcon, blkWht);
        }

        private void setIcons(Icon selectedIcon, Icon notSelectedIcon) {
            this.setIcon(notSelectedIcon);
            this.setSelectedIcon(selectedIcon);
        }

        private static GrayFilter getFilter() {
            return new GrayFilter(true, 50);
        }
    }
}

