/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.CancelledException;

public interface IMerlinGeomSrc
extends IDisplayableGeomSrc,
IPickable,
IMutableGeomSrc {
    default public DisplayGeom getPickGeom() {
        return new DisplayGeom(this.getGeom(), DEF_PROPS);
    }

    @Override
    default public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    default public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        DisplayGeom pgeom = this.getPickGeom();
        pgeom.node.pickPoints(IPickable.convertCollector(isects, pgeom.props), filter, this, rayBegin, rayEnd, rayDirN, tester);
    }

    @Override
    default public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull region) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        DisplayGeom pgeom = this.getPickGeom();
        try {
            pgeom.node.pickBox(this, filter, region, IPickable.convertCollector(result, pgeom.props));
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    @Override
    default public void getAll(Consumer<Object> result, IIsectFilter filter) {
        if (filter.acceptPickObject(this)) {
            result.accept(this);
        }
    }

    default public void transform(TransformInfo ti) {
        if (ti.isIdentity()) {
            return;
        }
        IGeomNode geom = this.getGeom().transform(ti);
        this.setGeom(geom);
    }
}

