/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.material;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import merlin.data.material.Material;
import merlin.geom.Geometry;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;

public class TexMappers {
    static final long serialVersionUID = 1L;

    public static PlanarCoordMapper newPlanarCoordMapper(Point3d texOrigin) {
        return new PlanarCoordMapper(MatSizeRetriever.INSTANCE, texOrigin);
    }

    private static class MatSizeRetriever
    implements Serializable,
    Function<IMaterial, Point2d> {
        public static final MatSizeRetriever INSTANCE = new MatSizeRetriever();

        private MatSizeRetriever() {
        }

        @Override
        public Point2d apply(IMaterial m) {
            if (!(m instanceof Material)) {
                return new Point2d(1.0, 1.0);
            }
            Material mat = (Material)m;
            return new Point2d(mat.getWidth().getValue(Geometry.LENGTH_UNIT), mat.getHeight().getValue(Geometry.LENGTH_UNIT));
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

