/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import merlin.MerlinApp;
import merlin.builders.CorridorUtil;
import merlin.data.AMerlinObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.AEgressComp;
import merlin.data.egress.geom.EgressConnectorState;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoorDir;
import merlin.data.egress.geom.EgressGeomUtil;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.value.ConstVariant;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IVariant;
import merlin.data.value.VariantUtil;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.geom.PointGeomFinder;
import merlin.geom.StrutUtil;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import merlin.util.Dependencies;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IParametric3D;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.Rectifier;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.QuadConsumer;
import thunderheadeng.util.Sets;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class EgressDoor
extends AEgressComp
implements IEgressConnector,
Serializable {
    static final long serialVersionUID = 1L;
    public static final UnitDouble DEF_MAX_EDGE_ANGLE = new UnitDouble(45.0, NonSI.DEGREE_ANGLE);
    public static final Object WIDTH = "EgressDoor.WIDTH";
    public static final Set<Object> PROP_TYPES = Sets.appendLHS(AEgressComp.PROP_TYPES, WIDTH, IEgressConnector.WAIT_TIME, IEgressConnector.TRAVEL_DIR, IEgressConnector.FLOWRATE, IEgressConnector.STATE);
    private boolean d_forceAsExit;
    private LineSeg3D d_attachedEdge1;
    private LineSeg3D d_attachedEdge2;
    private Point3d[] d_boundary;
    @Deprecated
    private Vector2d d_dirVec;
    private IEgressOccupiable d_comp1;
    private IEgressOccupiable d_comp2;
    private IVariant<EgressConnectorState> d_state;
    private IEgressFlowrate d_flowrate;
    private IDistributedVal<UnitDouble> d_waitTime;
    private transient Collection<Pair<IEgressComp, IEgressComp.ConflictType>> d_conflicts;
    private static final Plane3d s_doorPlane = new Plane3d(0.0, 0.0, 1.0, 0.0);
    private static final Matrix4d s_doorPlaneWLXform = Geometry.getWorldToLocalXform(s_doorPlane);
    private static final Matrix4d s_doorPlaneLWXform = Geometry.getLocalToWorldXform(s_doorPlane);
    private static final Vector3d s_xDir = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d s_yDir = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d s_zDir = new Vector3d(0.0, 0.0, 1.0);

    public EgressDoor(String name, boolean forceAsExit, IEgressOccupiable comp1, IEgressOccupiable comp2, LineSeg3D attachedEdge1, LineSeg3D attachedEdge2, Point3d[] boundary) {
        super(name);
        this.d_comp1 = comp1;
        this.d_comp2 = comp2;
        this.d_attachedEdge1 = attachedEdge1;
        this.d_attachedEdge2 = attachedEdge2;
        this.d_boundary = boundary;
        this.d_conflicts = Collections.EMPTY_LIST;
        this.d_state = new ConstVariant<EgressConnectorState>(EgressConnectorState.CONNECTOR_OPEN);
        this.d_waitTime = new ConstantCurve(new UnitDouble(0.0, SI.SECOND));
    }

    public EgressDoor(String name, boolean forceAsExit, IEgressOccupiable comp1, IEgressOccupiable comp2, DoorGeom dg) {
        super(name);
        this.d_comp1 = comp1;
        this.d_comp2 = comp2;
        this.d_conflicts = Collections.EMPTY_LIST;
        this.d_state = new ConstVariant<EgressConnectorState>(EgressConnectorState.CONNECTOR_OPEN);
        this.d_waitTime = new ConstantCurve(new UnitDouble(0.0, SI.SECOND));
        this.setGeom(dg, false);
    }

    @Override
    public void restoreFrom(Object obj) {
        this.pauseUpdates();
        super.restoreFrom(obj);
        EgressDoor door = (EgressDoor)obj;
        this.d_forceAsExit = door.d_forceAsExit;
        this.d_state = door.d_state;
        this.d_flowrate = door.d_flowrate;
        this.setGeom(door.getDoorGeom(), true);
        this.resumeUpdates();
    }

    public Vector2d adjustForDoor(EgressDoorDir dir) {
        Vector2d vec = null;
        if (dir != EgressDoorDir.ALL) {
            Point3d[] boundary = this.getDoorGeom().getBoundary();
            LineSeg doorDir = boundary.length == 2 ? new LineSeg(boundary[0], boundary[1]) : new LineSeg(Util3D.getMidPoint(boundary[0], boundary[3]), Util3D.getMidPoint(boundary[1], boundary[2]));
            vec = dir.adjustForDoor(doorDir);
        }
        return vec;
    }

    public void setDirection(EgressDoorDir dir) {
        Vector2d vec = this.adjustForDoor(dir);
        this.setDirectionVec(vec);
    }

    public void setDirectionVec(Vector2d vec) {
        if (theUtil.equal(vec, this.getDirectionVec())) {
            return;
        }
        boolean open = vec == null;
        this.d_state = VariantUtil.setInitialValue(this.d_state, new EgressConnectorState(open, false, vec));
        this.changedEvt(new Object[0]);
    }

    public EgressDoorDir getDirection() {
        return VariantUtil.getInitialValue(this.d_state).toDoorDir();
    }

    public Vector2d getDirectionVec() {
        return VariantUtil.getInitialValue(this.d_state).openDir;
    }

    @Override
    public Point3d astarGetTestPoint() {
        Point3d[] boundary = this.getDoorGeom().getBoundary();
        Point3d p = new Point3d();
        for (Point3d bp : boundary) {
            p.add(bp);
        }
        p.scale(1.0 / (double)boundary.length);
        return p;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        if (this.d_comp1 == obj || this.d_comp2 == obj) {
            return this.astarGetSharedPt(obj);
        }
        return this.astarGetTestPoint();
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        Point3d[] boundary = this.getDoorGeom().getBoundary();
        if (boundary.length == 2 || adj == this.d_comp1) {
            return Util3D.getMidPoint(boundary[0], boundary[1]);
        }
        return Util3D.getMidPoint(boundary[2], boundary[3]);
    }

    public IEgressOccupiable getRoom1() {
        return this.d_comp1;
    }

    public IEgressOccupiable getRoom2() {
        return this.d_comp2;
    }

    public LineSeg3D getEdge1() {
        return this.d_attachedEdge1;
    }

    public LineSeg3D getEdge2() {
        return this.d_attachedEdge2;
    }

    public Point3d[] getBoundary() {
        return this.d_boundary;
    }

    @Override
    public IEgressFlowrate getFlowrate() {
        return this.d_flowrate;
    }

    @Override
    public void setFlowrate(IEgressFlowrate flowrate) {
        this.d_flowrate = flowrate;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
    }

    public void makeGeomValid() {
        this.d_attachedEdge2 = this.d_attachedEdge1;
    }

    @Override
    public Collection<? extends IParametric3D> getSharedEdges(IEgressOccupiable room) {
        if (room != this.d_comp1 && room != this.d_comp2) {
            return Collections.EMPTY_LIST;
        }
        Point3d[] boundary = this.getDoorGeom().getBoundary();
        if (boundary.length == 2) {
            return Arrays.asList(new LineSeg3D(boundary[0], boundary[1]));
        }
        ArrayList<LineSeg3D> edges = new ArrayList<LineSeg3D>(2);
        if (room == this.d_comp1) {
            edges.add(new LineSeg3D(boundary[0], boundary[1]));
        }
        if (room == this.d_comp2) {
            edges.add(new LineSeg3D(boundary[2], boundary[3]));
        }
        return edges;
    }

    @Override
    public void connectTo(IEgressObj obj) {
    }

    @Override
    public void disconnectFrom(IEgressObj obj) {
        if (EgressGeomUtil.removeConflict(this.d_conflicts, obj)) {
            this.d_conflicts.addAll(this.computeConflicts(false, true));
        }
        if (obj instanceof IEgressOccupiable) {
            IEgressOccupiable conn = (IEgressOccupiable)obj;
            if (conn == this.d_comp1) {
                this.d_comp1 = null;
            }
            if (conn == this.d_comp2) {
                this.d_comp2 = null;
            }
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public boolean propEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EgressDoor)) {
            return false;
        }
        EgressDoor door = (EgressDoor)obj;
        return super.propEquals(obj) && this.d_attachedEdge1.equals(door.d_attachedEdge1) && this.d_attachedEdge2.equals(door.d_attachedEdge2) && Arrays.equals(this.d_boundary, door.d_boundary) && theUtil.equal(this.d_flowrate, door.d_flowrate) && this.d_state.equals(door.d_state);
    }

    @Override
    public Object clone() {
        EgressDoor clone = (EgressDoor)super.clone();
        clone.d_attachedEdge1 = (LineSeg3D)this.d_attachedEdge1.clone();
        clone.d_attachedEdge2 = (LineSeg3D)this.d_attachedEdge2.clone();
        clone.d_comp2 = null;
        clone.d_comp1 = null;
        clone.d_conflicts = Collections.EMPTY_LIST;
        return clone;
    }

    private void imprintGeometry(EgressDoor door2) {
        this.d_forceAsExit = door2.d_forceAsExit;
        this.d_attachedEdge1 = (LineSeg3D)door2.d_attachedEdge1.clone();
        this.d_attachedEdge2 = (LineSeg3D)door2.d_attachedEdge2.clone();
        this.d_boundary = door2.d_boundary;
        this.pauseUpdates();
        this.d_comp2 = null;
        this.d_comp1 = null;
        if (door2.d_comp1 != null && this.hasOpenSpots(door2.d_comp1.getClass())) {
            this.d_comp1 = door2.d_comp1;
        }
        if (door2.d_comp2 != null && this.hasOpenSpots(door2.d_comp2.getClass())) {
            this.d_comp2 = door2.d_comp2;
        }
        this.d_conflicts = door2.d_conflicts.isEmpty() ? Collections.EMPTY_LIST : new ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>>(door2.d_conflicts);
        this.d_state = door2.d_state;
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public void setState(IVariant<EgressDoorDir> state) {
        this.d_state = EgressConnectorState.getConnectorStateVariant(state, this::adjustForDoor);
        this.changedEvt(new Object[0]);
    }

    public IVariant<EgressDoorDir> getState() {
        return EgressConnectorState.getDoorDirStateVariant(this.d_state);
    }

    public void setRawState(IVariant<EgressConnectorState> state) {
        this.d_state = state;
        this.changedEvt(new Object[0]);
    }

    public IVariant<EgressConnectorState> getRawState() {
        return this.d_state;
    }

    @Override
    public Collection<Pair<IEgressComp, IEgressComp.ConflictType>> getConflicts() {
        return this.d_conflicts;
    }

    protected Collection<Pair<IEgressComp, IEgressComp.ConflictType>> computeConflicts(boolean edge, boolean manifold) {
        if (this.getDomain() == null) {
            return Collections.EMPTY_LIST;
        }
        Point3d[] boundary = this.getDoorGeom().getBoundary();
        if (boundary == null) {
            return Collections.EMPTY_LIST;
        }
        if (boundary.length == 2) {
            return EgressGeomUtil.computeConflicts((MerlinData)this.getDomain(), Filters.reject(this), edge, manifold, 2, new LineSeg(boundary[0], boundary[1]));
        }
        LineSeg[] edges = new LineSeg[]{new LineSeg(boundary[0], boundary[1]), new LineSeg(boundary[2], boundary[3])};
        Predicate[] filters = new Predicate[]{Filters.reject(this, this.d_comp2), Filters.reject(this, this.d_comp1)};
        ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>> conflicts = new ArrayList<Pair<IEgressComp, IEgressComp.ConflictType>>(2);
        for (int m = 0; m < 2; ++m) {
            conflicts.addAll(EgressGeomUtil.computeConflicts((MerlinData)this.getDomain(), filters[m], edge, manifold, 1, edges[m]));
        }
        return conflicts;
    }

    private void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    private static LineSeg3D toLineSeg3D(LineSeg ls) {
        return new LineSeg3D(ls.p1, ls.p2);
    }

    private Comparator<Pair<DoorLoc, DoorLoc>> getDoorLocComparator(final Point3d[] boundary) {
        return new Comparator<Pair<DoorLoc, DoorLoc>>(){

            private double getCost(DoorLoc o, IEgressOccupiable desiredRoom, LineSeg3D desiredEdge, Point3d l1, Point3d l2) {
                if (EgressDoor.toLineSeg3D(o.edge).equals(desiredEdge)) {
                    if (o.room == desiredRoom) {
                        return 0.0;
                    }
                    return 1.0;
                }
                double offset = 2.0;
                double[] overlap = Inter3D.lineSeglineSegOverlap(l1, l2, o.edge.p1, o.edge.p2, 1.0E-9, 1.0E-12);
                if (overlap == null) {
                    return Double.MAX_VALUE;
                }
                return offset + 1.0 - (overlap[1] - overlap[0]);
            }

            private double getCost(Pair<DoorLoc, DoorLoc> o) {
                double costa = this.getCost((DoorLoc)o.v1, EgressDoor.this.d_comp1, EgressDoor.this.d_attachedEdge1, boundary[0], boundary[1]) + this.getCost((DoorLoc)o.v2, EgressDoor.this.d_comp2, EgressDoor.this.d_attachedEdge2, boundary[2], boundary[3]);
                double costb = this.getCost((DoorLoc)o.v1, EgressDoor.this.d_comp2, EgressDoor.this.d_attachedEdge2, boundary[2], boundary[3]) + this.getCost((DoorLoc)o.v2, EgressDoor.this.d_comp1, EgressDoor.this.d_attachedEdge1, boundary[0], boundary[1]);
                return Math.min(costa, costb);
            }

            @Override
            public int compare(Pair<DoorLoc, DoorLoc> o1, Pair<DoorLoc, DoorLoc> o2) {
                double cost1 = this.getCost(o1);
                double cost2 = this.getCost(o2);
                return (int)Math.signum(cost1 - cost2);
            }
        };
    }

    private EgressDoor findDoor() {
        Point3d[] boundary = this.getBoundary();
        double maxAngle = DEF_MAX_EDGE_ANGLE.getValue(SI.RADIAN);
        Point3d[] tboundary = boundary;
        if (boundary.length == 2) {
            tboundary = new Point3d[]{boundary[0], boundary[1], boundary[1], boundary[0]};
        }
        int findDoorOptions = this.isEnabled() ? 1 : 3;
        DoorSearchResult bresult = EgressDoor.findDoor((MerlinData)this.getDomain(), tboundary[0], tboundary[1], tboundary[2], tboundary[3], maxAngle, 1.0E-6, findDoorOptions);
        if (bresult != null) {
            return bresult.toDoor(this.getName(), this.d_forceAsExit);
        }
        double maxWidth = this.getWidth();
        ArrayList<Point3d[]> thinSearches = new ArrayList<Point3d[]>();
        if (boundary.length > 2) {
            ArrayList<DoorSearchResult> thickSearches = new ArrayList<DoorSearchResult>();
            bresult = EgressDoor.findDoor((MerlinData)this.getDomain(), tboundary[0], tboundary[1], tboundary[2], tboundary[3], maxAngle, 0.01, findDoorOptions);
            if (bresult != null) {
                thickSearches.add(bresult);
            }
            QuadConsumer<Point3d, Point3d, Point3d, Point3d> trySideEdge = (e1p1, e1p2, e2p1, e2p2) -> {
                Collection<DoorLoc> doorLocs1a = EgressDoor.findDoorLocs((MerlinData)this.getDomain(), e1p2, 1.0E-6, 1, maxAngle);
                Collection<DoorLoc> doorLocs2b = EgressDoor.findDoorLocs((MerlinData)this.getDomain(), e2p1, 1.0E-6, 1, maxAngle);
                if (!doorLocs1a.isEmpty() && !doorLocs2b.isEmpty()) {
                    ArrayList<Pair<DoorLoc, DoorLoc>> pairs = new ArrayList<Pair<DoorLoc, DoorLoc>>();
                    for (DoorLoc doorLoc : doorLocs1a) {
                        for (DoorLoc doorLoc2b : doorLocs2b) {
                            pairs.add(new Pair<DoorLoc, DoorLoc>(doorLoc, doorLoc2b));
                        }
                    }
                    Collections.sort(pairs, this.getDoorLocComparator(new Point3d[]{e1p1, e1p2, e2p1, e2p2}));
                    for (Pair pair : pairs) {
                        DoorLoc doorLoc2b;
                        DoorLoc doorLoc1a = (DoorLoc)pair.v1;
                        doorLoc2b = (DoorLoc)pair.v2;
                        LineSeg edge1 = doorLoc1a.edge;
                        double t1e1 = doorLoc1a.edget;
                        double t2e1 = Inter3D.nearestTOnLineSeg(edge1.p1, edge1.p2, e1p1);
                        DoorSearchResult result = EgressDoor.findBoundaryDoor(doorLoc1a.room, edge1, t1e1, t2e1, doorLoc2b.room, doorLoc2b.edge, maxWidth, maxAngle);
                        if (result == null) continue;
                        thickSearches.add(result);
                        break;
                    }
                }
            };
            trySideEdge.accept(boundary[0], boundary[1], boundary[2], boundary[3]);
            trySideEdge.accept(boundary[2], boundary[3], boundary[0], boundary[1]);
            if (!thickSearches.isEmpty()) {
                DoorSearchResult result = thickSearches.stream().min(new ThickDoorBoundaryComparator(boundary)).get();
                return result.toDoor(this.getName(), false);
            }
            thinSearches.add(new Point3d[]{boundary[1], boundary[0]});
            thinSearches.add(new Point3d[]{boundary[3], boundary[2]});
        } else {
            thinSearches.add(new Point3d[]{boundary[1], boundary[0]});
        }
        EgressDoor foundDoor = null;
        for (Point3d[] search : thinSearches) {
            SearchResult result = EgressDoor.findDoor((MerlinData)this.getDomain(), search[0], search[1], this.getName(), this.d_forceAsExit, maxAngle, 1.0E-6, 1);
            if (result == null || result.internal) continue;
            foundDoor = result.door;
            break;
        }
        return foundDoor;
    }

    @Override
    public boolean updateTopo() {
        this.pauseUpdates();
        EgressDoor foundDoor = this.findDoor();
        if (foundDoor == null) {
            foundDoor = new EgressDoor(this.getName(), this.d_forceAsExit, null, null, this.d_attachedEdge1, this.d_attachedEdge2, this.d_boundary);
        }
        foundDoor.setState(this.getState());
        this.imprintGeometry(foundDoor);
        this.d_conflicts = this.computeConflicts(true, true);
        this.resumeUpdates();
        return true;
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return true;
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class, EgressDoor.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        ArrayList<IEgressOccupiable> conns = new ArrayList<IEgressOccupiable>();
        if (this.d_comp1 != null) {
            conns.add(this.d_comp1);
        }
        if (this.d_comp2 != null) {
            conns.add(this.d_comp2);
        }
        for (Pair<IEgressComp, IEgressComp.ConflictType> overlap : this.d_conflicts) {
            conns.add((IEgressOccupiable)overlap.v1);
        }
        return conns;
    }

    @Override
    public IEgressOccupiable[] getConnectedComps() {
        return new IEgressOccupiable[]{this.d_comp1, this.d_comp2};
    }

    @Override
    public boolean isExit() {
        return this.d_comp2 == null || this.d_comp1 == null;
    }

    public boolean isThin() {
        return this.getBoundary().length == 2;
    }

    public void setForceAsExit(boolean force) {
        if (force == this.d_forceAsExit) {
            return;
        }
        this.d_forceAsExit = force;
        if (this.d_comp1 != null && this.d_comp2 != null) {
            this.d_attachedEdge2 = this.d_attachedEdge1;
            this.d_comp2 = this.d_comp1;
        }
        this.markTopoDirty();
        this.changedEvt(new Object[0]);
    }

    @Override
    public void getConnectors(Collection<? super IEgressConnector> connectors) {
        connectors.add(this);
    }

    @Override
    public UnitDouble getUDWidth() {
        return new UnitDouble(this.getWidth(), SI.METER);
    }

    public double getWidth() {
        if (this.d_boundary.length == 2) {
            return this.d_boundary[0].distance(this.d_boundary[1]);
        }
        assert (this.d_boundary.length == 4);
        return Math.max(this.d_boundary[0].distance(this.d_boundary[1]), this.d_boundary[2].distance(this.d_boundary[3]));
    }

    public void setWidth(double width) {
        if (this.getWidth() == width || width <= 0.0) {
            return;
        }
        BiFunction<LineSeg3D, Point3d[], double[]> adjustPoints = (edge, points) -> {
            double twidth = width / edge.length();
            double midt = Util3D.tOnLineSeg(edge.p1, edge.p2, Util3D.getMidPoint(points[0], points[1]));
            double loc1 = midt - twidth * 0.5;
            double loc2 = midt + twidth * 0.5;
            return new double[]{loc1, loc2};
        };
        Point3d[] newBoundary = null;
        double[] adjusted1 = adjustPoints.apply(this.d_attachedEdge1, new Point3d[]{this.d_boundary[0], this.d_boundary[1]});
        double[] adjusted2 = this.d_boundary.length == 2 ? adjustPoints.apply(this.d_attachedEdge2, new Point3d[]{this.d_boundary[0], this.d_boundary[1]}) : adjustPoints.apply(this.d_attachedEdge2, new Point3d[]{this.d_boundary[2], this.d_boundary[3]});
        newBoundary = StrutUtil.calcStrutBoundaryFull(EgressDoor.convert(this.d_attachedEdge1), EgressDoor.convert(this.d_attachedEdge2), adjusted1[0], adjusted1[1], adjusted2[0], adjusted2[1]);
        if (newBoundary != null) {
            this.d_boundary = newBoundary;
            this.markTopoDirty();
            this.changedEvt(WIDTH);
        }
    }

    public void setWaitTime(IDistributedVal<UnitDouble> waitTime) {
        this.d_waitTime = waitTime;
    }

    @Override
    public IDistributedVal<UnitDouble> getWaitTime() {
        return this.d_waitTime;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (MerlinOIS.isPrior(ois, MerlinIO.Version.VER_0125) && this.d_state != null) {
            this.d_state = EgressDoor.convertState(this.d_state, this.d_dirVec);
            this.d_dirVec = null;
        }
        this.d_conflicts = Collections.EMPTY_LIST;
        if (this.d_state == null) {
            this.d_state = new ConstVariant<EgressConnectorState>(EgressConnectorState.CONNECTOR_OPEN);
        }
        if (this.d_waitTime == null) {
            this.d_waitTime = new ConstantCurve(new UnitDouble(0.0, SI.SECOND));
        }
    }

    public static IVariant<EgressConnectorState> convertState(IVariant<Boolean> state, Vector2d dirVec) {
        if (state == null) {
            return new ConstVariant<EgressConnectorState>(EgressConnectorState.CONNECTOR_OPEN);
        }
        BiFunction<Boolean, EgressConnectorState, EgressConnectorState> processVal = (value, onewayDir) -> {
            if (value.booleanValue()) {
                return onewayDir != null ? onewayDir : EgressConnectorState.CONNECTOR_OPEN;
            }
            return EgressConnectorState.CONNECTOR_CLOSED;
        };
        EgressConnectorState initDir = dirVec != null ? new EgressConnectorState(false, false, dirVec) : null;
        List<DiscreteVariant.Entry<Boolean>> values = VariantUtil.getDiscreteValues(state, false);
        ArrayList newValues = new ArrayList();
        EgressConnectorState initVal = processVal.apply(VariantUtil.getInitialValue(state), initDir);
        for (DiscreteVariant.Entry<Boolean> entry : values) {
            newValues.add(new DiscreteVariant.Entry<EgressConnectorState>(entry.t, processVal.apply((Boolean)entry.val, initDir)));
        }
        return VariantUtil.newVariant(initVal, newValues);
    }

    public boolean isWalkable(Point3d p) {
        return false;
    }

    private static Collection<DoorLoc> findDoorLocs(MerlinData md, Point3d loc1, double searchDist, int options, double maxEdgeAngle) {
        PointGeomFinder<EgressRoom> finder1 = new PointGeomFinder<EgressRoom>(loc1, searchDist, EgressRoom.class);
        md.geomLocation.getLocator().find(finder1.test, finder1.result, options);
        return theUtil.map(EgressDoor.getPotentialDoorLocs(finder1.getResults().keySet(), loc1, searchDist, maxEdgeAngle), o -> (DoorLoc)o.v2);
    }

    private static SearchResult doorSearch(DoorLoc doorLoc1, DoorLoc doorLoc2, String name, boolean forceAsExit, double maxEdgeAngle) {
        DoorSearchResult dg = EgressDoor.findBoundaryDoor(doorLoc1.room, doorLoc1.edge, doorLoc1.edget, doorLoc2.room, doorLoc2.edge, doorLoc2.edget, maxEdgeAngle);
        if (dg == null) {
            return null;
        }
        IEgressOccupiable room2 = dg.isExit ? null : doorLoc2.room;
        EgressDoor door = new EgressDoor(name, forceAsExit, doorLoc1.room, room2, dg.dg);
        return new SearchResult(false, door);
    }

    public static DoorSearchResult findDoor(MerlinData md, Point3d e1p1, Point3d e1p2, Point3d e2p1, Point3d e2p2, double maxEdgeAngle, double searchTolerance, int options) {
        CorridorUtil.SearchResult result = CorridorUtil.findCorr(md, e1p1, e1p2, e2p1, e2p2, maxEdgeAngle, searchTolerance, options, Predicates.alwaysTrue());
        if (result == null) {
            return null;
        }
        boolean isExit = EgressDoor.isExit(result.room1, result.geom.edge1, result.room2, result.geom.edge2);
        DoorGeom dg = new DoorGeom(result.room1, result.room2, result.geom.edge1, result.geom.edge2, result.geom.boundary, null, true);
        return new DoorSearchResult(dg, isExit);
    }

    private static boolean isExit(IEgressOccupiable room1, LineSeg edge1, IEgressOccupiable room2, LineSeg edge2) {
        return room1 == room2 && edge1.equals(edge2, true);
    }

    public static SearchResult findDoor(MerlinData md, Point3d loc1, Point3d loc2, String name, boolean forceAsExit, double maxEdgeAngle, double searchTolerance, int options) {
        double searchDist = searchTolerance;
        Collection<DoorLoc> doorLocs1 = EgressDoor.findDoorLocs(md, loc1, searchDist, options, maxEdgeAngle);
        if (doorLocs1.isEmpty()) {
            return null;
        }
        Collection<DoorLoc> doorLocs2 = EgressDoor.findDoorLocs(md, loc2, searchDist, options, maxEdgeAngle);
        if (doorLocs2.isEmpty()) {
            return null;
        }
        ArrayList<SearchResult> possibleThin = new ArrayList<SearchResult>(doorLocs1.size() * doorLocs2.size());
        ArrayList<SearchResult> possibleThick = new ArrayList<SearchResult>(doorLocs1.size() * doorLocs2.size());
        for (DoorLoc doorLoc1 : doorLocs1) {
            for (DoorLoc doorLoc2 : doorLocs2) {
                SearchResult doorSearch = EgressDoor.doorSearch(doorLoc1, doorLoc2, name, forceAsExit, maxEdgeAngle);
                if (doorSearch != null && doorSearch.door.isThin()) {
                    possibleThin.add(doorSearch);
                    continue;
                }
                if (doorSearch == null || doorSearch.door.isThin()) continue;
                possibleThick.add(doorSearch);
            }
        }
        Collections.sort(possibleThin, EgressDoor.getDoorLocComparator(loc1, loc2));
        Collections.sort(possibleThick, EgressDoor.getDoorLocComparator(loc1, loc2));
        SearchResult bestDoor = null;
        if (!possibleThick.isEmpty() && !possibleThin.isEmpty()) {
            int comp = EgressDoor.getDoorLocComparator(loc1, loc2).compare((SearchResult)possibleThick.get(0), (SearchResult)possibleThin.get(0));
            bestDoor = comp < 0 ? (SearchResult)possibleThick.get(0) : (SearchResult)possibleThin.get(0);
        }
        if (possibleThick.isEmpty() && !possibleThin.isEmpty()) {
            bestDoor = (SearchResult)possibleThin.get(0);
        }
        if (!possibleThick.isEmpty() && possibleThin.isEmpty()) {
            bestDoor = (SearchResult)possibleThick.get(0);
        }
        return bestDoor;
    }

    private static Comparator<SearchResult> getDoorLocComparator(final Point3d loc1, final Point3d loc2) {
        return new Comparator<SearchResult>(){
            private final String EXIT = "EXIT";
            private final String THIN = "THIN";
            private final String THICK = "THICK";

            @Override
            public int compare(SearchResult o1, SearchResult o2) {
                if (!o1.door.isThin() && !o2.door.isThin()) {
                    return this.compareThick(o1, o2);
                }
                if (!o1.door.isThin() && o2.door.isThin()) {
                    return this.compareThickThin(o1, o2);
                }
                if (o1.door.isThin() && !o2.door.isThin()) {
                    return -1 * this.compareThickThin(o2, o1);
                }
                Pair<Double, String> cost1 = this.getCost(o1);
                Pair<Double, String> cost2 = this.getCost(o2);
                return this.compare(cost1, cost2);
            }

            @Override
            private int compare(Pair<Double, String> cost1, Pair<Double, String> cost2) {
                int comp = theUtil.compare((Double)cost1.v1, (Double)cost2.v1, 1.0E-6);
                if (comp != 0) {
                    return comp;
                }
                if (((String)cost1.v2).equals("EXIT") && ((String)cost2.v2).equals("THIN")) {
                    return 1;
                }
                if (((String)cost2.v2).equals("EXIT") && ((String)cost1.v2).equals("THIN")) {
                    return -1;
                }
                if (((String)cost1.v2).equals("THICK") && !((String)cost2.v2).equals("THICK")) {
                    return 1;
                }
                if (((String)cost2.v2).equals("THICK") && !((String)cost1.v2).equals("THICK")) {
                    return -1;
                }
                return Double.compare((Double)cost1.v1, (Double)cost2.v1);
            }

            private Pair<Double, String> getCost(SearchResult search) {
                EgressDoor door = search.door;
                if (door.isThin()) {
                    return this.getThinCost(door);
                }
                return this.getThickCost(door);
            }

            private Pair<Double, String> getThinCost(EgressDoor door) {
                return new Pair<Double, String>(2.0 * this.getCost(door.d_attachedEdge1, door.d_boundary[0], door.d_boundary[1]), door.isExit() ? this.EXIT : this.THIN);
            }

            private Pair<Double, String> getThickCost(EgressDoor door) {
                double cost = 0.0;
                double multFactor = 0.5;
                double p1e1 = Inter3D.distSqToNearestPtOnLineSeg(((EgressDoor)door).d_attachedEdge1.p1, ((EgressDoor)door).d_attachedEdge1.p2, loc1);
                double p1e2 = Inter3D.distSqToNearestPtOnLineSeg(((EgressDoor)door).d_attachedEdge2.p1, ((EgressDoor)door).d_attachedEdge2.p2, loc1);
                double p2e1 = Inter3D.distSqToNearestPtOnLineSeg(((EgressDoor)door).d_attachedEdge1.p1, ((EgressDoor)door).d_attachedEdge1.p2, loc2);
                double p2e2 = Inter3D.distSqToNearestPtOnLineSeg(((EgressDoor)door).d_attachedEdge2.p1, ((EgressDoor)door).d_attachedEdge2.p2, loc2);
                if (p1e1 + p2e1 < 1.0E-6) {
                    multFactor = 10.0;
                    cost = 1.0 + p1e2 + p2e2;
                } else if (p1e2 + p2e2 < 1.0E-6) {
                    multFactor = 10.0;
                    cost = 1.0 + p1e1 + p2e1;
                } else if (p1e1 > 1.0E-6 && p2e1 > 1.0E-6 && p1e2 > 1.0E-6 && p2e2 > 1.0E-6) {
                    multFactor = 20.0;
                }
                if (cost == 0.0) {
                    double width1 = door.d_boundary[0].distance(door.d_boundary[1]);
                    double width2 = door.d_boundary[2].distance(door.d_boundary[3]);
                    cost = this.getCost(door.d_attachedEdge1, door.d_boundary[0], door.d_boundary[1]) + this.getCost(door.d_attachedEdge2, door.d_boundary[2], door.d_boundary[3]);
                    if (loc1.distance(loc2) > 1.5 * width1 || loc1.distance(loc2) < 0.25 * width2) {
                        multFactor = 2.0;
                    }
                }
                return new Pair<Double, String>(cost *= multFactor, "THICK");
            }

            private double getCost(LineSeg3D edge, Point3d p1, Point3d p2) {
                return Math.min(this.getDist(loc1, p1) + this.getDist(loc2, p2), this.getDist(loc2, p1) + this.getDist(loc1, p2));
            }

            private double getDist(Point3d p1, Point3d p2) {
                return p1.distance(p2);
            }

            public int compareThickThin(SearchResult thick, SearchResult thin) {
                int comp = -1 * Integer.compare(this.countPointsThick(thick.door), this.countPointsThin(thin.door));
                if (comp != 0) {
                    return comp;
                }
                return this.compare(this.getCost(thick), this.getCost(thin));
            }

            public int compareThick(SearchResult d1, SearchResult d2) {
                int pointsD1 = this.countPointsThick(d1.door);
                int pointsD2 = this.countPointsThick(d2.door);
                if (pointsD1 == 2 && pointsD2 != 2) {
                    return -1;
                }
                if (pointsD1 != 2 && pointsD2 == 2) {
                    return 1;
                }
                return this.compare(this.getCost(d1), this.getCost(d2));
            }

            private int countPointsThin(EgressDoor door) {
                return this.sharedPoint(door.d_attachedEdge1, loc1) + this.sharedPoint(door.d_attachedEdge1, loc2);
            }

            private int countPointsThick(EgressDoor door) {
                int pointsOnD1 = 0;
                if ((pointsOnD1 += this.sharedPoint(door.d_attachedEdge1, loc1)) == 1) {
                    pointsOnD1 += this.sharedPoint(door.d_attachedEdge2, loc2);
                } else if ((pointsOnD1 += this.sharedPoint(door.d_attachedEdge1, loc2)) == 1) {
                    pointsOnD1 += this.sharedPoint(door.d_attachedEdge2, loc1);
                }
                return pointsOnD1;
            }

            private int sharedPoint(LineSeg3D seg, Point3d pt) {
                if (Inter3D.distSqToNearestPtOnLineSeg(seg.p1, seg.p2, pt) < 1.0E-12) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static SearchResult findDoor(MerlinData md, Point3d location, String name, boolean forceAsExit, double minWidth, double maxWidth, double minDepth, double maxDepth, double maxEdgeAngle, int options) {
        SearchResult result;
        DoorLoc doorLoc;
        double searchDist = maxDepth * 0.5 + 1.0E-6;
        PointGeomFinder<EgressRoom> finder = new PointGeomFinder<EgressRoom>(location, searchDist, EgressRoom.class);
        md.geomLocation.getLocator().find(finder.test, finder.result, options);
        if (finder.getResults().isEmpty()) {
            return null;
        }
        List<Pair<DoorDist, DoorLoc>> doorLocs = EgressDoor.getPotentialDoorLocs(finder.getResults().keySet(), location, searchDist, maxEdgeAngle);
        for (Pair<DoorDist, DoorLoc> pair : doorLocs) {
            if (((DoorDist)pair.v1).d_dist > 1.0E-6) break;
            doorLoc = (DoorLoc)pair.v2;
            result = EgressDoor.findDoor(md, doorLoc.room, doorLoc.edge, doorLoc.edget, name, forceAsExit, minWidth, maxWidth, minDepth, maxDepth, maxEdgeAngle, options);
            if (result == null) continue;
            return result;
        }
        for (EgressRoom egressRoom : finder.getResults().keySet()) {
            EgressDoor door = EgressDoor.findInternalDoor(name, egressRoom, location, minWidth, maxWidth, minDepth, maxDepth);
            if (door == null) continue;
            return new SearchResult(true, door);
        }
        for (Pair pair : doorLocs) {
            if (((DoorDist)pair.v1).d_dist <= 1.0E-6) continue;
            doorLoc = (DoorLoc)pair.v2;
            result = EgressDoor.findDoor(md, doorLoc.room, doorLoc.edge, doorLoc.edget, name, forceAsExit, minWidth, maxWidth, minDepth, maxDepth, maxEdgeAngle, options);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static SearchResult findDoor(MerlinData md, IEgressOccupiable room, LineSeg edge, double edgeT, String name, boolean forceAsExit, double minWidth, double maxWidth, double minDepth, double maxDepth, double maxEdgeAngle, int options) {
        double widtht;
        StrutUtil.StrutParam doorParams;
        EgressDoor door = null;
        if (!forceAsExit) {
            door = EgressDoor.findBoundaryDoor(md, name, room, edge, edgeT, minWidth, maxWidth, minDepth, maxDepth, maxEdgeAngle, options);
        }
        if (door == null && minDepth == 0.0 && (doorParams = StrutUtil.toStrutParam(edge, Geometry.getEdgeSegment(edge, edgeT, edgeT + (widtht = maxWidth / edge.length()), 0.0, 1.0, minWidth, true))) != null) {
            LineSeg3D ls = EgressDoor.convert(edge);
            Point3d[] boundary = StrutUtil.calcStrutBoundary(EgressDoor.convert(ls), doorParams);
            door = new EgressDoor(name, forceAsExit, room, null, ls, ls, boundary);
        }
        return door != null ? new SearchResult(false, door) : null;
    }

    public static Object[] getPotentialDoorLoc(IEgressOccupiable room, Point3d loc, double distTol, double maxEdgeAngle) {
        List<DoorLoc> doorLocs = theUtil.map(EgressDoor.getPotentialDoorLocs(Arrays.asList(room), loc, distTol, maxEdgeAngle), o -> (DoorLoc)o.v2);
        if (doorLocs.isEmpty()) {
            return null;
        }
        DoorLoc doorLoc = (DoorLoc)doorLocs.iterator().next();
        return new Object[]{doorLoc.edge, doorLoc.edget};
    }

    public static List<Pair<DoorDist, DoorLoc>> getPotentialDoorLocs(Collection<? extends IEgressOccupiable> rooms, Point3d loc, double distTol, double maxAngle) {
        ArrayList<Pair<DoorDist, DoorLoc>> locs = new ArrayList<Pair<DoorDist, DoorLoc>>();
        for (IEgressOccupiable iEgressOccupiable : rooms) {
            IGeom geom = iEgressOccupiable.getGeom().flatten().getLocalGeom();
            for (LineSeg edge1 : thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(0.0, geom)) {
                double dist;
                Vector3d edgeDir;
                double zplaneAngle;
                if (edge1.p1.epsilonEquals(edge1.p2, 1.0E-6) || theUtil.gt(zplaneAngle = Util3D.angleWithPlane(s_doorPlane, edgeDir = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false), 1.0E-6), maxAngle, 1.0E-6)) continue;
                double t = Inter3D.nearestTOnLine(edge1.p1, edgeDir, loc);
                if (Double.isNaN(t = Util.clampTIfValid(t, 0.0, 1.0, 1.0E-6)) || !((dist = Util3D.linePoint(edge1.p1, edgeDir, t).distance(loc)) < distTol)) continue;
                locs.add(new Pair<DoorDist, DoorLoc>(new DoorDist(dist, edge1), new DoorLoc(iEgressOccupiable, edge1, t)));
            }
        }
        Collections.sort(locs, (o1, o2) -> ((DoorDist)o1.v1).compareTo((DoorDist)o2.v1));
        return locs;
    }

    public static EgressDoor findInternalDoor(String name, IEgressOccupiable room, Point3d location, double minWidth, double maxWidth, double minDepth, double maxDepth) {
        double searchRadiusSq = maxDepth * maxDepth + maxWidth * maxWidth;
        if (!room.isWalkable(location)) {
            return null;
        }
        IGeom rgeom = room.getGeom().flatten().getLocalGeom();
        List<LineSeg> edges = thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(0.0, rgeom);
        for (int m = 0; m < edges.size(); ++m) {
            LineSeg edge1 = edges.get(m);
            double dist = Inter3D.nearestPointOnLineSeg(edge1.p1, edge1.p2, location).distanceSquared(location);
            if (theUtil.gt(dist, searchRadiusSq, 1.0E-6)) continue;
            Vector3d edge1Dir = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false);
            Vector3d edge1DirN = Util3D.normalize(edge1Dir);
            for (int n = m + 1; n < edges.size(); ++n) {
                double t2;
                double t1;
                double[] t;
                double width;
                Vector3d edge2Dir;
                LineSeg edge2 = edges.get(n);
                double dist2 = Inter3D.nearestPointOnLineSeg(edge2.p1, edge2.p2, location).distanceSquared(location);
                if (theUtil.gt(dist2, searchRadiusSq, 1.0E-6) || !Util3D.testParallel(edge1Dir, edge2Dir = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false), 1.0E-6)) continue;
                Vector3d sideVec = Util3D.vectorN(edge2.p1, edge1.p1);
                sideVec.cross(sideVec, edge1DirN);
                if (!Util3D.testSameDir(sideVec, s_doorPlane.getNormal(), 1.0E-6) || !Util.checkRange(minWidth, maxWidth, width = Inter3D.nearestPointOnLine(edge1.p1, edge1Dir, edge2.p1).distance(edge2.p1), 1.0E-6) || theUtil.ge((t = Util.rectify(t1 = Inter3D.nearestTOnLineSeg(edge1.p1, edge1.p2, edge2.p1), t2 = Inter3D.nearestTOnLineSeg(edge1.p1, edge1.p2, edge2.p2)))[0], 1.0, 1.0E-6) || theUtil.le0(t[1], 1.0E-6)) continue;
                Point3d p1 = edge1.evaluate(t[0]);
                Point3d p2 = edge1.evaluate(t[1]);
                Point3d p1a = Inter3D.nearestPointOnLineSeg(edge2.p1, edge2.p2, p1);
                Point3d p2a = Inter3D.nearestPointOnLineSeg(edge2.p1, edge2.p2, p2);
                double depth = p1.distance(p2);
                if (!Util.checkRange(minDepth, maxDepth, depth, 1.0E-6) || !Inter3D.pointInPoly(1.0E-6, location, p1, p1a, p2a, p2) || EgressDoor.linesIntersectBoundary(room, p1, p1a, p2, p2a, edge1, edge2)) continue;
                LineSeg3D newEdge1 = new LineSeg3D(p1, p1a);
                LineSeg3D newEdge2 = new LineSeg3D(p2, p2a);
                Point3d[] boundary = new Point3d[]{p1, p1a, p2a, p2};
                return new EgressDoor(name, false, room, room, newEdge1, newEdge2, boundary);
            }
        }
        return null;
    }

    private static boolean linesIntersectBoundary(IEgressOccupiable comp, Point3d l1a, Point3d l1b, Point3d l2a, Point3d l2b, LineSeg ... exclusions) {
        for (LineSeg parm : thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(0.0, comp.getGeom().flatten().getLocalGeom())) {
            for (LineSeg excl : exclusions) {
                if (!parm.equals(excl, false)) continue;
            }
            double[] isect = Inter3D.getLineSegLineSegIntersection(parm.p1, parm.p2, l1a, l1b, 1.0E-6, 1.0E-6);
            if (isect != null && !theUtil.eq0(isect[0], 1.0E-6) && !theUtil.eq(isect[0], 1.0, 1.0E-6) && isect[1] > 1.0E-6 && isect[1] < 0.999999) {
                return true;
            }
            isect = Inter3D.getLineSegLineSegIntersection(parm.p1, parm.p2, l2a, l2b, 1.0E-6, 1.0E-6);
            if (isect == null || theUtil.eq0(isect[0], 1.0E-6) || theUtil.eq(isect[0], 1.0, 1.0E-6) || !(isect[1] > 1.0E-6) || !(isect[1] < 0.999999)) continue;
            return true;
        }
        return false;
    }

    public static EgressDoor findBoundaryDoor(MerlinData md, String name, IEgressOccupiable room, LineSeg edge1, double loct, double minWidth, double maxWidth, double minDepth, double maxDepth, double maxEdgeAngle, int options) {
        if (md == null) {
            return null;
        }
        Vector3d edgeDirN = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, true);
        Point3d loc = Util3D.linesegPoint(edge1.p1, edge1.p2, loct);
        Collection<? extends IEgressOccupiable> potentialRooms = EgressDoor.findTouchingRooms(md, loc, edge1, maxDepth, options);
        ArrayList<Pair<Double, DoorGeom>> doors = new ArrayList<Pair<Double, DoorGeom>>();
        double loct2 = loct + maxWidth / edge1.length();
        double[] seg1 = Geometry.getEdgeSegment(edge1, loct, loct2, 0.0, 1.0, minWidth, true);
        if (seg1 == null) {
            return null;
        }
        double midt1 = (seg1[0] + seg1[1]) * 0.5;
        Vector3d e1dir = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false);
        for (IEgressOccupiable iEgressOccupiable : potentialRooms) {
            IGeom geom = iEgressOccupiable.getGeom().flatten().getLocalGeom();
            for (LineSeg edge2 : thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(0.0, geom)) {
                double width1;
                Point3d[] doorBound;
                StrutUtil.StrutParam doorParams;
                double angle;
                if (room == iEgressOccupiable && edge1.equals(edge2, true) || theUtil.eq0(edge2.lengthSq(), 1.0E-9) || (angle = Util3D.lineAngle(edgeDirN, edge2.getTangent(0.0, ICurve.Orient.POSITIVE, true))) > maxEdgeAngle || (doorParams = StrutUtil.calcStrutParam(edge1, edge2, loct, loct2, minWidth, true)) == null || (doorBound = StrutUtil.calcStrutBoundary(edge1, edge2, midt1, maxWidth)) == null || theUtil.lt(width1 = doorBound[0].distance(doorBound[1]), minWidth, 1.0E-6)) continue;
                double edgeDist = 0.0;
                if (doorBound.length == 4) {
                    double width2 = doorBound[2].distance(doorBound[3]);
                    if (theUtil.lt(width2, minWidth, 1.0E-6)) continue;
                    edgeDist = Math.max(Inter3D.distSqToNearestPtOnLine(edge1.p1, e1dir, doorBound[2]), Inter3D.distSqToNearestPtOnLine(edge1.p1, e1dir, doorBound[3]));
                    if (!Util.checkRange(minDepth, maxDepth, edgeDist = Math.sqrt(edgeDist), 1.0E-6)) continue;
                }
                DoorGeom dg2 = new DoorGeom(room, iEgressOccupiable, edge1, edge2, doorBound, null, false);
                doors.add(new Pair<Double, DoorGeom>(edgeDist, dg2));
            }
        }
        Collections.sort(doors, (o1, o2) -> {
            boolean inDoor1 = EgressDoor.pointInDoor(loc, (DoorGeom)o1.v2);
            boolean inDoor2 = EgressDoor.pointInDoor(loc, (DoorGeom)o2.v2);
            if (inDoor1 && !inDoor2) {
                return -1;
            }
            if (!inDoor1 && inDoor2) {
                return 1;
            }
            return ((Double)o1.v1).compareTo((Double)o2.v1);
        });
        Optional<EgressDoor> result = doors.stream().map(pair -> (DoorGeom)pair.v2).filter(door -> !EgressDoor.doorOverlapsRooms(door, door.d_room1, door.d_room2)).findFirst().map(dg -> new EgressDoor(name, false, dg.d_room1, dg.d_room2, (DoorGeom)dg));
        if (result.isPresent()) {
            return result.get();
        }
        if (!doors.isEmpty()) {
            DoorGeom doorGeom = (DoorGeom)((Pair)doors.iterator().next()).v2;
            return new EgressDoor(name, false, doorGeom.d_room1, doorGeom.d_room2, doorGeom);
        }
        return null;
    }

    private static boolean pointInDoor(Point3d p, DoorGeom dg) {
        if (dg.d_boundary.length == 2) {
            return EgressDoor.isBetweenEndpoints(dg.d_attachedEdge1, dg.d_boundary[0], dg.d_boundary[1], p);
        }
        ToDoubleFunction<Point3d> x = p3d -> p3d.x;
        ToDoubleFunction<Point3d> y = p3d -> p3d.y;
        return Inter2D.pointInConvexPoly(1.0E-6, x, y, p.x, p.y, dg.d_boundary[0], dg.d_boundary[1], dg.d_boundary[2]) || Inter2D.pointInConvexPoly(1.0E-6, x, y, p.x, p.y, dg.d_boundary[0], dg.d_boundary[2], dg.d_boundary[3]);
    }

    private static boolean isBetweenEndpoints(LineSeg edge, Point3d p1e, Point3d p2e, Point3d p) {
        Vector3d edir = edge.getTangent(0.0, ICurve.Orient.POSITIVE, false);
        double neart = Inter3D.nearestTOnLine(edge.p1, edir, p);
        if (Double.isNaN(Util.clampTIfValid(neart, 0.0, 1.0, 1.0E-6))) {
            return false;
        }
        double t1e = Util3D.tOnLine(edge.p1, edir, p1e);
        double t2e = Util3D.tOnLine(edge.p1, edir, p2e);
        if (t2e < t1e) {
            double t = t2e;
            t2e = t1e;
            t1e = t;
        }
        return !Double.isNaN(Util.clampTIfValid(neart, t1e, t2e, 1.0E-6));
    }

    private static String format(LineSeg ls) {
        return String.format("LineSeg: %s -> %s", ls.p1, ls.p2);
    }

    private static DoorSearchResult findBoundaryDoor(IEgressOccupiable room1, LineSeg edge1, double t1e1, IEgressOccupiable room2, LineSeg edge2, double t2e2, double maxEdgeAngle) {
        Point3d p2e2 = edge2.evaluate(t2e2);
        double t2e1 = StrutUtil.getCorrespondingT(edge2, edge1, p2e2);
        if (Double.isNaN(t2e1)) {
            return null;
        }
        Point3d p1e1 = edge1.evaluate(t1e1);
        double t1e2 = StrutUtil.getCorrespondingT(edge1, edge2, p1e1);
        if (Double.isNaN(t1e2)) {
            return null;
        }
        t1e1 = Util.clampT(t1e1, 0.0, 1.0);
        t2e1 = Util.clampT(t2e1, 0.0, 1.0);
        t1e2 = Util.clampT(t1e2, 0.0, 1.0);
        t2e2 = Util.clampT(t2e2, 0.0, 1.0);
        double width1 = (t2e1 - t1e1) * edge1.length();
        double width2 = (t2e2 - t1e2) * edge2.length();
        if (Math.abs(width1) <= Math.abs(width2)) {
            double diff = Math.signum(width2) * (Math.abs(width2) - Math.abs(width1));
            t1e2 += diff / edge2.length();
        } else {
            double diff = Math.signum(width1) * (Math.abs(width1) - Math.abs(width2));
            t2e1 -= diff / edge1.length();
        }
        return EgressDoor.findBoundaryDoor(room1, edge1, t1e1, t2e1, room2, edge2, t1e2, t2e2, maxEdgeAngle);
    }

    private static DoorSearchResult findBoundaryDoor(IEgressOccupiable room1, LineSeg edge1, double t1e1, double t2e1, IEgressOccupiable room2, LineSeg edge2, double maxWidth, double maxEdgeAngle) {
        EgressCorridor.CorridorGeom cg = CorridorUtil.findBoundaryCorr(room1, edge1, t1e1, t2e1, room2, edge2, null, null, maxWidth, maxEdgeAngle, true);
        if (cg == null) {
            return null;
        }
        Point3d[] doorBound = cg.boundary;
        boolean isExit = EgressDoor.isExit(room1, edge1, room2, edge2);
        DoorGeom door = new DoorGeom(room1, room2, edge1, edge2, doorBound, null, false);
        return new DoorSearchResult(door, isExit);
    }

    private static DoorSearchResult findBoundaryDoor(IEgressOccupiable room1, LineSeg edge1, double t1e1, double t2e1, IEgressOccupiable room2, LineSeg edge2, double t1e2, double t2e2, double maxEdgeAngle) {
        Vector3d edgeDirN2;
        Vector3d edgeDirN1 = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, true);
        double angle = Util3D.lineAngle(edgeDirN1, edgeDirN2 = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, true));
        if (angle > maxEdgeAngle) {
            return null;
        }
        Point3d[] doorBound = StrutUtil.calcStrutBoundaryFull(edge1, edge2, t1e1, t2e1, t1e2, t2e2);
        if (doorBound == null) {
            return null;
        }
        boolean isExit = EgressDoor.isExit(room1, edge1, room2, edge2);
        DoorGeom door = new DoorGeom(room1, room2, edge1, edge2, doorBound, null, false);
        return new DoorSearchResult(door, isExit);
    }

    private static boolean doorOverlapsRooms(DoorGeom door, IEgressOccupiable room1, IEgressOccupiable room2) {
        if (EgressDoor.doorOverlapsRoom(door, room1)) {
            return true;
        }
        return room2 != room1 && EgressDoor.doorOverlapsRoom(door, room2);
    }

    private static boolean doorOverlapsRoom(DoorGeom door, IEgressOccupiable room) {
        if (room == null) {
            return false;
        }
        Model shape = door.asModel();
        if (shape.getFaces().isEmpty()) {
            return false;
        }
        shape = (Model)shape.clone();
        int[] id = new int[]{Integer.MAX_VALUE};
        for (Face face : shape.getFaces()) {
            face.groups = id;
        }
        Model roomGeom = (Model)room.getModel().clone();
        roomGeom.merge(shape);
        for (Face face : roomGeom.getFaces()) {
            if (!face.partOfGroup(Integer.MAX_VALUE) || face.groups.length <= 1) continue;
            return true;
        }
        return false;
    }

    private static Collection<? extends IEgressOccupiable> findTouchingRooms(MerlinData md, Point3d searchLoc, LineSeg edge, double searchDist, int options) {
        LinkedIdentityHashSet potentialRooms = new LinkedIdentityHashSet();
        Vector3d edgeDirN = edge.getTangent(0.0, ICurve.Orient.POSITIVE, true);
        Vector3d searchTan = Util3D.cross(edgeDirN, s_doorPlane.getNormal());
        searchTan.normalize();
        Vector3d searchAdder = Util3D.scale(searchTan, searchDist + 1.0E-6);
        Point3d searchL1 = Util3D.sub(searchLoc, (Tuple3d)searchAdder);
        Point3d searchL2 = Util3D.add(searchLoc, (Tuple3d)searchAdder);
        Rectifier.rectify(searchL1, searchL2);
        searchL1.x -= 0.001;
        searchL2.x += 0.001;
        searchL1.y -= 0.001;
        searchL2.y += 0.001;
        searchL1.z -= 0.001;
        searchL2.z += 0.001;
        AABox searchBox = new AABox(searchL1, searchL2);
        Box3d box = new Box3d(searchBox);
        md.geomLocation.getLocator().find(box, new CollResult(potentialRooms, EgressRoom.class), options);
        return potentialRooms;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDoorGeom());
    }

    public DoorGeom getDoorGeom() {
        return new DoorGeom(this.d_comp1, this.d_comp2, EgressDoor.convert(this.d_attachedEdge1), EgressDoor.convert(this.d_attachedEdge2), this.d_boundary, this.getDirectionVec(), this.getModificationsAllowed());
    }

    @Override
    public void setGeom(IGeomNode node) {
        IGeom geom = node.flatten().getLocalGeom();
        if (!(geom instanceof DoorGeom)) {
            return;
        }
        this.setGeom((DoorGeom)geom, true);
    }

    public void setGeom(DoorGeom geom, boolean markTopoDirty) {
        this.d_attachedEdge1 = EgressDoor.convert(geom.d_attachedEdge1);
        this.d_attachedEdge2 = EgressDoor.convert(geom.d_attachedEdge2);
        this.d_boundary = geom.d_boundary;
        this.setDirectionVec(geom.d_dirVec);
        if (markTopoDirty) {
            this.markTopoDirty();
        }
        this.changedEvt(new Object[0]);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dprops) {
        IGeom dirGeom;
        IMerlinDispProps.EgressType type;
        if (!(dprops instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps props = (IMerlinDispProps)dprops;
        DoorGeom dgeom = this.getDoorGeom();
        IGeom geom = dgeom;
        if (geom.getNumPrims(7) == 0) {
            return DisplayGeom.EMPTY;
        }
        ITransform xform = TransformUtil.translate(0.0, 0.0, 0.001);
        TransformInfo ti = xform.getInfo();
        geom = geom.transform(ti, 0);
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        geoms.add(geom);
        if (geom.equals(EmptyGeom.INSTANCE)) {
            return DisplayGeom.EMPTY;
        }
        int numFaces = geom.getNumPrims(1);
        int numCurves = geom.getNumPrims(2);
        PropsBuilder propsSrc = new PropsBuilder();
        if (numFaces == 0) {
            assert (numCurves == 1);
            type = this.isExit() ? IMerlinDispProps.EgressType.EXIT_DOOR : IMerlinDispProps.EgressType.THIN_DOOR;
            IPrimProps eprops = props.getEdgeProps(this, type, this.getColor(), this.getOpacity());
            propsSrc.add(eprops, 1);
        } else {
            type = this.isExit() ? IMerlinDispProps.EgressType.EXIT_DOOR : IMerlinDispProps.EgressType.THICK_DOOR;
            IPrimProps fprops = props.getFaceProps(this, type, this.getColor(), this.getOpacity());
            IPrimProps beprops = props.getEdgeProps(this, IMerlinDispProps.EgressType.BOUNDARY, this.getColor(), this.getOpacity());
            propsSrc.add(fprops, numFaces);
            propsSrc.add(beprops, numCurves);
            IMerlinDispProps.EgressType thinType = this.isExit() ? IMerlinDispProps.EgressType.EXIT_DOOR : IMerlinDispProps.EgressType.THIN_DOOR;
            Point3d[] boundary = dgeom.getBoundary();
            IPrimProps deprops = props.getEdgeProps(this, thinType, this.getColor(), this.getOpacity());
            geoms.add(new LineSeg(boundary[0], boundary[1]).transform(ti, 0));
            geoms.add(new LineSeg(boundary[2], boundary[3]).transform(ti, 0));
            propsSrc.add(deprops, 2);
        }
        Vector2d dirVec = this.getDirectionVec();
        if (dirVec != null && (dirGeom = EgressDoorDir.generateDisplayGeom(this, props, dirVec, dgeom.getBoundary(), this.d_comp1, this.d_comp2, propsSrc)) != null) {
            geoms.add(dirGeom);
        }
        geom = thunderheadeng.geometry.objs.GeomUtil.group(geoms);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), propsSrc.finalizeProps());
    }

    private Point3d[] getInfernoDoorVerts() {
        Point3d[] boundary = this.getDoorGeom().getBoundary();
        if (boundary.length == 4) {
            if (this.d_comp1 != null && this.d_comp2 != null && this.d_comp1 != this.d_comp2) {
                EgressRoom extraGeom1 = this.getExtraGeom(this.d_comp1);
                EgressRoom extraGeom2 = this.getExtraGeom(this.d_comp2);
                if (extraGeom1 == null) {
                    return new Point3d[]{boundary[0], boundary[1]};
                }
                if (extraGeom2 == null) {
                    return new Point3d[]{boundary[2], boundary[3]};
                }
            }
            Point3d mid1 = Util3D.getMidPoint(boundary[1], boundary[2]);
            Point3d mid2 = Util3D.getMidPoint(boundary[3], boundary[0]);
            boundary = new Point3d[]{mid1, mid2};
        }
        return boundary;
    }

    @Override
    public void getInfernoGeom(List<InfernoGeom> geoms) {
        Point3d[] boundary = this.getInfernoDoorVerts();
        LineSeg ls = new LineSeg(boundary[0], boundary[1]);
        InfernoType type = this.isExit() ? InfernoType.EXIT_DOOR : InfernoType.INTERNAL_DOOR;
        geoms.add(new InfernoGeom(this, type, ls));
    }

    @Override
    public EgressRoom getExtraGeom(IEgressOccupiable connectedObj) {
        Point3d[] boundary = this.getDoorGeom().getBoundary();
        if (boundary.length == 2) {
            return null;
        }
        assert (connectedObj == this.d_comp1 || connectedObj == this.d_comp2);
        ArrayList<Point3d[]> boundaryAttempts = new ArrayList<Point3d[]>();
        if (this.d_comp1 != this.d_comp2) {
            Point3d mid1 = Util3D.getMidPoint(boundary[1], boundary[2]);
            Point3d mid2 = Util3D.getMidPoint(boundary[3], boundary[0]);
            if (connectedObj == this.d_comp1) {
                boundaryAttempts.add(new Point3d[]{boundary[0], boundary[1], mid1, mid2});
            } else {
                boundaryAttempts.add(new Point3d[]{mid2, mid1, boundary[2], boundary[3]});
            }
            if (connectedObj == this.d_comp1) {
                boundaryAttempts.add(boundary);
            }
        } else {
            boundaryAttempts.add(boundary);
        }
        for (Point3d[] bnd : boundaryAttempts) {
            IGeom extraGeom = DoorGeom.getGeom(bnd, false);
            Model model = new Model();
            for (IFace iFace : thunderheadeng.geometry.objs.GeomUtil.explode(extraGeom, IFace.class)) {
                GeomUtil.addFaceToModel(iFace, model, 0, 0.0, 0.0);
            }
            for (ICurve iCurve : thunderheadeng.geometry.objs.GeomUtil.explode(extraGeom, ICurve.class)) {
                GeomUtil.addCurveToModel(iCurve, model, 1, 0.0);
            }
            for (Face face : model.getFaces()) {
                Vector3d normal = face.plane.getNormal();
                if (!(normal.z < 0.0)) continue;
                face.flipOrient();
            }
            EgressRoom room = new EgressRoom("", model);
            if (room.getModel().getFaces().isEmpty()) continue;
            return room;
        }
        return null;
    }

    @Override
    public <T> void setProperty(Object prop, T val) {
        if (prop == WIDTH) {
            this.setWidth((Double)val);
        } else if (prop == IEgressConnector.TRAVEL_DIR) {
            this.setDirection((EgressDoorDir)((Object)val));
        } else if (prop == IEgressConnector.FLOWRATE) {
            this.setFlowrate((IEgressFlowrate)val);
        } else if (prop == IEgressConnector.STATE) {
            this.setState((IVariant)val);
        } else if (prop == IEgressConnector.WAIT_TIME) {
            this.setWaitTime((IDistributedVal)val);
        }
        super.setProperty(prop, val);
    }

    @Override
    public Object getProperty(Object prop) {
        if (prop == WIDTH) {
            return this.getWidth();
        }
        if (prop == IEgressConnector.TRAVEL_DIR) {
            return this.getDirection();
        }
        if (prop == IEgressConnector.FLOWRATE) {
            return this.getFlowrate();
        }
        if (prop == IEgressConnector.STATE) {
            return this.getState();
        }
        if (prop == IEgressConnector.WAIT_TIME) {
            return this.getWaitTime();
        }
        return super.getProperty(prop);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    public boolean getModificationsAllowed() {
        return true;
    }

    private static LineSeg3D convert(LineSeg ls) {
        return new LineSeg3D(ls.p1, ls.p2);
    }

    private static LineSeg convert(LineSeg3D ls) {
        return new LineSeg(ls.p1, ls.p2);
    }

    @Override
    public Collection<AMerlinObj> getConnObjectsForEnable(MerlinData md) {
        ArrayList allReferences = new ArrayList();
        Dependencies.getObjReferences(md, o -> o == this, (source, target) -> allReferences.add((AMerlinObj)source));
        IFilteredCollection<OccSourceObj> occSources = theUtil.filter(allReferences, OccSourceObj.class);
        return new LinkedHashSet<AMerlinObj>(occSources);
    }

    public static class DoorGeom
    implements IGeom,
    IManipulatable {
        public final IEgressOccupiable d_room1;
        public final IEgressOccupiable d_room2;
        public final LineSeg d_attachedEdge1;
        public final LineSeg d_attachedEdge2;
        public final boolean d_allowManip;
        public final Vector2d d_dirVec;
        public final Point3d[] d_boundary;
        private IGeom d_geom;
        private IGeom d_selectableGeom;

        public DoorGeom(IEgressOccupiable room1, IEgressOccupiable room2, LineSeg edge1, LineSeg edge2, Point3d[] boundary, Vector2d dirVec, boolean allowManip) {
            this.d_room1 = room1;
            this.d_room2 = room2;
            this.d_attachedEdge1 = edge1;
            this.d_attachedEdge2 = edge2;
            this.d_boundary = boundary;
            this.d_dirVec = dirVec;
            this.d_allowManip = allowManip;
        }

        public DoorGeom setDirection(Vector2d dirVec) {
            Vector2d vec = null;
            if (dirVec != null) {
                Point3d[] boundary = this.getBoundary();
                LineSeg doorDir = boundary.length == 2 ? new LineSeg(boundary[0], boundary[1]) : new LineSeg(Util3D.getMidPoint(boundary[0], boundary[3]), Util3D.getMidPoint(boundary[1], boundary[2]));
                vec = EgressDoorDir.adjustForDoor(dirVec, doorDir);
            }
            if (theUtil.equal(vec, this.d_dirVec)) {
                return this;
            }
            return new DoorGeom(this.d_room1, this.d_room2, this.d_attachedEdge1, this.d_attachedEdge2, this.d_boundary, vec, this.d_allowManip);
        }

        public boolean isValid() {
            return this.getBoundary() != null;
        }

        public boolean isThin() {
            return this.getBoundary().length == 2;
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return false;
        }

        @Override
        public boolean isShell() {
            return true;
        }

        @Override
        public IGeom optimize(IPointOptimizer pointOptimizer) {
            LineSeg e1 = this.d_attachedEdge1.optimize(pointOptimizer);
            LineSeg e2 = this.d_attachedEdge2.optimize(pointOptimizer);
            Object[] boundary = new Point3d[this.d_boundary.length];
            for (int m = 0; m < this.d_boundary.length; ++m) {
                boundary[m] = pointOptimizer.getExisting(this.d_boundary[m]);
            }
            boolean bEquals = Arrays.equals(boundary, this.d_boundary);
            if (bEquals) {
                boundary = this.d_boundary;
            }
            if (e1 == this.d_attachedEdge1 && e2 == this.d_attachedEdge2 && bEquals) {
                return this;
            }
            return new DoorGeom(this.d_room1, this.d_room2, e1, e2, (Point3d[])boundary, this.d_dirVec, this.d_allowManip);
        }

        @Override
        public int getNumPrims(int types) {
            return this.getGeom(false).getNumPrims(types);
        }

        @Override
        public boolean canExplode() {
            return true;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            prims.add(this.getGeom(false));
            return prims;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            return this.getGeom(false).getBoundingBox(aabb);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.INVERTIBLE;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            LineSeg e1 = new LineSeg(Util3D.xform(xform, this.d_attachedEdge1.p1), Util3D.xform(xform, this.d_attachedEdge1.p2));
            LineSeg e2 = new LineSeg(Util3D.xform(xform, this.d_attachedEdge2.p1), Util3D.xform(xform, this.d_attachedEdge2.p2));
            Vector2d newOWVec = this.d_dirVec != null ? GeomUtil.to2d(Util3D.xform(xform, GeomUtil.to3d(this.d_dirVec, false)), true) : null;
            Point3d[] boundary = new Point3d[this.d_boundary.length];
            for (int m = 0; m < this.d_boundary.length; ++m) {
                boundary[m] = Util3D.xform(xform, this.d_boundary[m]);
            }
            LineSeg fe1 = e1;
            LineSeg fe2 = e2;
            ToDoubleFunction<Point3d> e1t = p -> Util3D.tOnLineSeg(lineSeg.p1, lineSeg.p2, p);
            ToDoubleFunction<Point3d> e2t = p -> Util3D.tOnLineSeg(lineSeg.p1, lineSeg.p2, p);
            if ((boundary = boundary.length == 2 ? StrutUtil.calcStrutBoundaryFull(e1, e2, e1t.applyAsDouble(boundary[0]), e1t.applyAsDouble(boundary[1]), e2t.applyAsDouble(boundary[0]), e2t.applyAsDouble(boundary[1])) : StrutUtil.calcStrutBoundaryFull(e1, e2, e1t.applyAsDouble(boundary[0]), e1t.applyAsDouble(boundary[1]), e2t.applyAsDouble(boundary[2]), e2t.applyAsDouble(boundary[3]))) == null) {
                return EmptyGeom.INSTANCE;
            }
            if (boundary.length > 2) {
                Vector3d v1 = Util3D.vector(boundary[0], boundary[1]);
                Vector3d v2 = Util3D.vector(boundary[0], boundary[2]);
                Vector3d normal = Util3D.cross(v1, v2);
                normal.normalize();
                double zdot = normal.dot(s_zDir);
                if (theUtil.lt0(zdot, 1.0E-6)) {
                    e1 = new LineSeg(e1.p2, e1.p1);
                    e2 = new LineSeg(e2.p2, e2.p1);
                    theUtil.reverse(boundary);
                }
            }
            return new DoorGeom(null, null, e1, e2, boundary, newOWVec, this.d_allowManip);
        }

        @Override
        public void pickBox(Object source, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelledException {
            this.getGeom(true).pickBox(source, filter, region, isects);
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, Point3d rayBegin, Point3d rayEnd, Vector3d rayDirN, ITest<AABox> tester) {
            this.getGeom(true).pickPoints(isects, filter, source, rayBegin, rayEnd, rayDirN, tester);
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IPrimitive> result) {
            this.getGeom(true).find(test, result);
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
            this.getGeom(true).getAll(result);
        }

        private IGeom getGeom(boolean selectable) {
            if (selectable) {
                if (this.d_selectableGeom == null) {
                    this.d_selectableGeom = this.getGeomUncached(true);
                }
                return this.d_selectableGeom;
            }
            if (this.d_geom == null) {
                this.d_geom = this.getGeomUncached(false);
            }
            return this.d_geom;
        }

        private IGeom getGeomUncached(boolean selectable) {
            return DoorGeom.getGeom(this.getBoundary(), selectable);
        }

        public static IGeom getGeom(Point3d[] boundary, boolean selectable) {
            if (boundary == null) {
                System.err.println("[EgressDoor.getDisplayGeom()] getBoundary() is null");
                return EmptyGeom.INSTANCE;
            }
            if (boundary.length == 2) {
                return new LineSeg(boundary[0], boundary[1]);
            }
            ArrayList<IManipulatable> geom = new ArrayList<IManipulatable>(3);
            Quad q = new Quad(boundary[0], boundary[1], boundary[2], boundary[3]);
            if (Util3D.areCoplanar(1.0E-12, boundary)) {
                geom.add(q);
            } else {
                geom.add(q.triangulate(0.0));
            }
            if (!selectable) {
                geom.add(new LineSeg(boundary[1], boundary[2]));
                geom.add(new LineSeg(boundary[3], boundary[0]));
            } else {
                geom.add(new PolyLine(boundary[0], boundary[1], boundary[2], boundary[3], boundary[0]));
            }
            return new GeomGroup(geom);
        }

        public Point3d[] getBoundary() {
            return this.d_boundary;
        }

        public Model asModel() {
            IGeom geom = this.getGeom(false);
            Model model = new Model();
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode(geom, IFace.class)) {
                GeomUtil.addFaceToModel(face, model, 0, 0.0, 0.0);
            }
            for (ICurve curve : thunderheadeng.geometry.objs.GeomUtil.explode(geom, ICurve.class)) {
                GeomUtil.addCurveToModel(curve, model, 1, 0.0);
            }
            return model;
        }

        private Point3d[] copyBoundary() {
            Point3d[] boundary = new Point3d[this.d_boundary.length];
            for (int m = 0; m < boundary.length; ++m) {
                boundary[m] = this.d_boundary[m];
            }
            return boundary;
        }

        protected DoorGeom reverseDoor() {
            DoorGeom door = this;
            Point3d[] doorPoints = door.getBoundary();
            if (doorPoints == null) {
                return null;
            }
            if (doorPoints.length == 2) {
                return door;
            }
            Point3d[] boundary = new Point3d[this.d_boundary.length];
            boundary[0] = this.d_boundary[2];
            boundary[1] = this.d_boundary[3];
            boundary[2] = this.d_boundary[0];
            boundary[3] = this.d_boundary[1];
            return new DoorGeom(door.d_room2, door.d_room1, door.d_attachedEdge2, door.d_attachedEdge1, boundary, door.d_dirVec, door.d_allowManip);
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            if (!this.d_allowManip) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<IHandle> handles = new ArrayList<IHandle>(6);
            handles.add(new RoomHandle(this, true));
            handles.add(new EdgeLocHandle(this, true, true));
            handles.add(new EdgeLocHandle(this, true, false));
            if (!this.isThin()) {
                handles.add(new RoomHandle(this, false));
                handles.add(new EdgeLocHandle(this, false, true));
                handles.add(new EdgeLocHandle(this, false, false));
            }
            return handles;
        }

        private class EdgeLocHandle
        implements IHandle {
            private final boolean d_edge1;
            private final boolean d_point1;
            private DoorGeom d_geom;

            public EdgeLocHandle(DoorGeom geom, boolean edge1, boolean point1) {
                this.d_geom = geom;
                this.d_edge1 = edge1;
                this.d_point1 = point1;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof EdgeLocHandle && ((EdgeLocHandle)obj).d_edge1 == this.d_edge1 && ((EdgeLocHandle)obj).d_point1 == this.d_point1;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.getLocation()));
            }

            protected Point3d getLocation() {
                Point3d[] points = this.d_geom.getBoundary();
                if (this.d_edge1 || points.length == 2) {
                    return this.d_point1 ? points[0] : points[1];
                }
                assert (points.length >= 4);
                return this.d_point1 ? points[2] : points[3];
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                Point3d[] boundary = this.d_geom.getBoundary();
                if (this.d_edge1 || boundary.length == 2) {
                    return new LineConstraint(boundary[0], Util3D.vectorN(boundary[0], boundary[1]));
                }
                assert (boundary.length >= 4);
                return new LineConstraint(boundary[2], Util3D.vectorN(boundary[2], boundary[3]));
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(EgressRoom.class, GeomType.FACE_EDGE));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public Object modify(Point3d snappedPos) throws ManipException {
                int ix1;
                LineSeg edge2;
                LineSeg edge1;
                Point3d[] doorPoints = this.d_geom.getBoundary();
                if (this.d_edge1) {
                    edge1 = this.d_geom.d_attachedEdge1;
                    edge2 = this.d_geom.d_attachedEdge2;
                    ix1 = 0;
                } else {
                    edge1 = this.d_geom.d_attachedEdge2;
                    edge2 = this.d_geom.d_attachedEdge1;
                    ix1 = 2;
                }
                double width1 = doorPoints[ix1 % doorPoints.length].distance(doorPoints[(ix1 + 1) % doorPoints.length]);
                double width2 = doorPoints[(ix1 + 2) % doorPoints.length].distance(doorPoints[(ix1 + 3) % doorPoints.length]);
                snappedPos = Inter3D.nearestPointOnLine(edge1.p1, edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false), snappedPos);
                if (doorPoints.length == 2) {
                    double[] ts;
                    double minEdgeT = 0.0;
                    double maxEdgeT = 1.0;
                    for (double t : ts = new double[]{Util3D.tOnLineSeg(edge1.p1, edge1.p2, edge2.p1), Util3D.tOnLineSeg(edge1.p1, edge1.p2, edge2.p2)}) {
                        if (t > maxEdgeT) {
                            maxEdgeT = t;
                            continue;
                        }
                        if (!(t < minEdgeT)) continue;
                        minEdgeT = t;
                    }
                    LineSeg edge = new LineSeg(edge1.evaluate(minEdgeT), edge1.evaluate(maxEdgeT));
                    double t1 = Inter3D.nearestTOnLine(edge.p1, edge.getTangent(0.0, ICurve.Orient.POSITIVE, false), snappedPos);
                    double widthMult = this.d_point1 ? 1.0 : -1.0;
                    double t2 = t1 + width1 / edge.length() * widthMult;
                    double[] e1Ts = Geometry.getEdgeSegment(edge, t1, t2, 0.0, 1.0, 0.0, true);
                    if (e1Ts == null) {
                        throw new ManipException();
                    }
                    StrutUtil.StrutParam doorParams = StrutUtil.toStrutParam(edge, e1Ts);
                    doorPoints = StrutUtil.calcStrutBoundary(edge, doorParams);
                    DoorGeom door = new DoorGeom(this.d_geom.d_room1, this.d_geom.d_room2, edge, edge, doorPoints, this.d_geom.d_dirVec, this.d_geom.d_allowManip);
                    if (door.getBoundary() == null) {
                        throw new ManipException();
                    }
                    this.d_geom = door;
                } else {
                    Vector3d e1dir = edge1.getTangent(0.0, ICurve.Orient.POSITIVE, false);
                    double t1 = Util3D.tOnLine(edge1.p1, e1dir, snappedPos);
                    double widthMult = this.d_point1 ? -1.0 : 1.0;
                    double t2 = t1 + width1 / edge1.length() * widthMult;
                    double[] e1Ts = Geometry.getEdgeSegment(edge1, t1, t2, 0.0, 1.0, 0.0, true);
                    if (e1Ts == null) {
                        throw new ManipException();
                    }
                    doorPoints = StrutUtil.calcStrutBoundary(edge1, edge2, (t1 + t2) * 0.5, width1, width2);
                    if (doorPoints == null) {
                        throw new ManipException();
                    }
                    DoorGeom door = new DoorGeom(this.d_geom.d_room1, this.d_geom.d_room2, edge1, edge2, doorPoints, this.d_geom.d_dirVec, this.d_geom.d_allowManip);
                    if (!this.d_edge1) {
                        door = door.reverseDoor();
                    }
                    if (door == null || door.getBoundary() == null) {
                        throw new ManipException();
                    }
                    this.d_geom = door;
                }
                return this.d_geom;
            }

            @Override
            public Object end() {
                return this.d_geom;
            }
        }

        protected static class RoomHandle
        implements IHandle {
            private final boolean d_edge1;
            private final DoorGeom d_origGeom;
            private DoorGeom d_geom;

            public RoomHandle(DoorGeom geom, boolean edge1) {
                this.d_origGeom = this.d_geom = geom;
                this.d_edge1 = edge1;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof RoomHandle)) {
                    return false;
                }
                RoomHandle rh = (RoomHandle)obj;
                if (rh.d_origGeom.isThin() == this.d_origGeom.isThin()) {
                    return this.d_edge1 == rh.d_edge1;
                }
                return true;
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_TWO_PASS, new DefaultFilter(EgressRoom.class, GeomType.FACE_EDGE));
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.getLocation()));
            }

            protected Point3d getLocation() {
                Point3d[] boundary = this.d_geom.getBoundary();
                if (this.d_edge1 || boundary.length == 2) {
                    return Util3D.getMidPoint(boundary[0], boundary[1]);
                }
                assert (boundary.length >= 4);
                return Util3D.getMidPoint(boundary[2], boundary[3]);
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return null;
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public Object modify(Point3d newLoc) throws ManipException {
                IEgressOccupiable conn2;
                LineSeg edge2;
                Point3d[] doorPoints = this.d_origGeom.getBoundary();
                if (this.d_edge1) {
                    edge2 = this.d_origGeom.d_attachedEdge2;
                    conn2 = this.d_origGeom.d_room2;
                } else {
                    edge2 = this.d_origGeom.d_attachedEdge1;
                    conn2 = this.d_origGeom.d_room1;
                }
                int p1ix = this.d_edge1 ? 0 : 2;
                Point3d e1p1 = doorPoints[(p1ix + 0) % doorPoints.length];
                Point3d e1p2 = doorPoints[(p1ix + 1) % doorPoints.length];
                Point3d e2p1 = doorPoints[(p1ix + 2) % doorPoints.length];
                Point3d e2p2 = doorPoints[(p1ix + 3) % doorPoints.length];
                double maxEdgeAngle = DEF_MAX_EDGE_ANGLE.getValue(SI.RADIAN);
                MerlinData md = MerlinApp.getApp().getData();
                md.beginRead();
                try {
                    Collection doorLocs = EgressDoor.findDoorLocs(MerlinApp.getApp().getData(), newLoc, 1.0E-6, 0, maxEdgeAngle);
                    if (doorLocs.isEmpty()) {
                        throw new ManipException();
                    }
                    double maxWidth = Math.max(e1p1.distance(e1p2), e2p1.distance(e2p2));
                    Vector3d e2dir = edge2.getTangent(0.0, ICurve.Orient.POSITIVE, false);
                    double t1e2 = Inter3D.nearestTOnLine(edge2.p1, e2dir, e2p1);
                    double t2e2 = Inter3D.nearestTOnLine(edge2.p1, e2dir, e2p2);
                    for (DoorLoc doorLoc : doorLocs) {
                        DoorSearchResult door = EgressDoor.findBoundaryDoor(conn2, edge2, t1e2, t2e2, doorLoc.room, doorLoc.edge, maxWidth, maxEdgeAngle);
                        if (door == null) continue;
                        DoorGeom dg = door.dg;
                        if (this.d_edge1) {
                            dg = dg.reverseDoor();
                        }
                        if (dg == null || dg.getBoundary() == null) {
                            throw new ManipException();
                        }
                        DoorGeom doorGeom = this.d_geom = (dg = dg.setDirection(this.d_origGeom.d_dirVec));
                        return doorGeom;
                    }
                    throw new ManipException();
                }
                finally {
                    md.endRead();
                }
            }

            @Override
            public Object end() {
                return this.d_geom;
            }
        }
    }

    public static class DoorSearchResult {
        public final DoorGeom dg;
        public final boolean isExit;

        public DoorSearchResult(DoorGeom dg, boolean isExit) {
            this.dg = dg;
            this.isExit = isExit;
        }

        public EgressDoor toDoor(String name, boolean forceAsExit) {
            IEgressOccupiable comp2 = this.isExit ? null : this.dg.d_room2;
            return new EgressDoor(name, forceAsExit, this.dg.d_room1, comp2, this.dg);
        }
    }

    public static class SearchResult {
        public final boolean internal;
        public final EgressDoor door;

        public SearchResult(boolean internal, EgressDoor door) {
            this.internal = internal;
            this.door = door;
        }
    }

    private static class DoorLoc {
        public final IEgressOccupiable room;
        public final LineSeg edge;
        public final double edget;

        public DoorLoc(IEgressOccupiable room, LineSeg edge, double edget) {
            this.room = room;
            this.edge = edge;
            this.edget = edget;
        }
    }

    private static class DoorDist
    implements Comparable<DoorDist> {
        private final double d_dist;
        private final LineSeg d_edge;
        private final boolean d_dirPos;

        public DoorDist(double dist, LineSeg edge) {
            this.d_dist = dist;
            this.d_edge = edge;
            Vector3d dir = this.d_edge.getTangent(0.0, ICurve.Orient.POSITIVE, false);
            double dot = dir.dot(s_xDir);
            if (dot == 0.0 && (dot = dir.dot(s_yDir)) == 0.0) {
                dot = dir.dot(s_zDir);
            }
            this.d_dirPos = dot > 0.0;
        }

        @Override
        public int compareTo(DoorDist o) {
            int comp = theUtil.compare(this.d_dist, o.d_dist, 1.0E-6);
            if (comp != 0) {
                return comp;
            }
            comp = Double.compare(o.d_edge.lengthSq(), this.d_edge.lengthSq());
            if (comp != 0) {
                return comp;
            }
            if (this.d_dirPos != o.d_dirPos) {
                return this.d_dirPos ? -1 : 1;
            }
            return 0;
        }
    }

    private static class ThickDoorBoundaryComparator
    implements Comparator<DoorSearchResult> {
        public final Point3d[] originalBoundary;

        public ThickDoorBoundaryComparator(Point3d[] originalBoundary) {
            this.originalBoundary = originalBoundary;
        }

        @Override
        public int compare(DoorSearchResult o1, DoorSearchResult o2) {
            boolean o2MatchThin;
            boolean originalThin = this.originalBoundary.length == 2;
            boolean o1MatchThin = originalThin == o1.dg.isThin();
            boolean bl = o2MatchThin = originalThin == o2.dg.isThin();
            if (o1MatchThin != o2MatchThin) {
                return o1MatchThin ? -1 : 1;
            }
            return Double.compare(this.getError(o1), this.getError(o2));
        }

        private double getError(DoorSearchResult result) {
            Point3d[] boundary = result.dg.d_boundary;
            assert (this.originalBoundary.length == boundary.length);
            if (result.dg.isThin()) {
                return Math.min(boundary[0].distance(this.originalBoundary[0]) + boundary[1].distance(this.originalBoundary[1]), boundary[1].distance(this.originalBoundary[0]) + boundary[0].distance(this.originalBoundary[1]));
            }
            double error1 = 0.0;
            for (int m = 0; m < 4; ++m) {
                error1 += boundary[m].distance(this.originalBoundary[m]);
            }
            double error2 = 0.0;
            for (int m = 0; m < 4; ++m) {
                error2 += boundary[m].distance(this.originalBoundary[(m + 2) % 4]);
            }
            return Math.min(error1, error2);
        }
    }
}

