/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.material.Material;
import merlin.data.value.ConstVariant;
import merlin.data.value.IVariant;
import merlin.geom.IMerlinDispProps;
import merlin.geom.IMerlinGeomSrc;
import merlin.io.inferno.IInfernoComp;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.Sets;

public class EgressBlockage
extends NamedMerlinObj
implements Serializable,
IRestorable,
ICompElement,
IMerlinGeomSrc,
IInfernoComp {
    static final long serialVersionUID = 1L;
    public static final Object SPEED_FACTOR = "EgressBlockage.SPEED_FACTOR";
    public static final Object TEXTURE = "EgressBlockage.TEXTURE";
    public static final Object STATE = "EgressBlockage.STATE";
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, MerlinData.VISIBILITY, SPEED_FACTOR, STATE, TEXTURE);
    private transient EgressRoom d_room;
    private int d_faceId;
    private double d_speedFactor;
    private IVariant<Boolean> d_state;
    private Material d_texture;

    public EgressBlockage(EgressRoom room, String name, int faceId) {
        super(name);
        this.d_room = room;
        this.d_faceId = faceId;
        this.d_speedFactor = 0.0;
        this.d_state = new ConstVariant<Boolean>(false);
        this.d_texture = null;
    }

    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (EgressRoom)ois.readObject();
    }

    public void setRoom(EgressRoom room) {
        this.d_room = room;
        this.changedEvt(new Object[0]);
    }

    public EgressRoom getRoom() {
        return this.d_room;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof EgressBlockage)) {
            return;
        }
        EgressBlockage blockage = (EgressBlockage)obj;
        this.d_faceId = blockage.d_faceId;
        this.d_state = blockage.d_state;
        this.d_room = blockage.d_room;
        this.d_speedFactor = blockage.d_speedFactor;
        this.d_texture = blockage.d_texture;
        this.changedEvt(this, new Object[0]);
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    public Material getTexture() {
        return this.d_texture;
    }

    public void setTexture(Material texture) {
        if (this.d_texture == texture) {
            return;
        }
        this.d_texture = texture;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean isVisible() {
        return this.d_room != null ? this.d_room.isVisible() : true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_room != null) {
            this.d_room.setVisible(visible);
        }
    }

    public int getFaceId() {
        return this.d_faceId;
    }

    public void setFaceId(int faceId) {
        this.d_faceId = faceId;
        this.changedEvt(new Object[0]);
    }

    public double getSpeedFactor() {
        return this.d_speedFactor;
    }

    public void setSpeedFactor(double factor) {
        if (this.d_speedFactor != factor) {
            this.d_speedFactor = factor;
            this.changedEvt(new Object[0]);
        }
    }

    public void setState(IVariant<Boolean> state) {
        if (state.equals(this.getState())) {
            return;
        }
        this.d_state = state;
        this.changedEvt(new Object[0]);
    }

    public IVariant<Boolean> getState() {
        return this.d_state;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == SPEED_FACTOR) {
            return this.getSpeedFactor();
        }
        if (property == STATE) {
            return this.getState();
        }
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == TEXTURE) {
            return this.getTexture();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == SPEED_FACTOR) {
            this.setSpeedFactor((Double)value);
        } else if (property == STATE) {
            this.setState((IVariant)value);
        } else if (property == NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == TEXTURE) {
            this.setTexture((Material)value);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (!(props instanceof IMerlinDispProps) || this.d_room == null) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps mprops = (IMerlinDispProps)props;
        int options = 4;
        IGeom geom = this.getGeom(options);
        int numFaces = geom.getNumPrims(1);
        int numEdges = geom.getNumPrims(2);
        PropsBuilder dprops = new PropsBuilder();
        dprops.add(mprops.getFaceProps(this.d_room, IMerlinDispProps.EgressType.ROOM, this.d_room.getColor(), this.d_room.getOpacity()), numFaces);
        dprops.add(mprops.getEdgeProps(this.d_room, IMerlinDispProps.EgressType.BLOCKAGE, null, this.d_room.getOpacity()), numEdges);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), dprops.finalizeProps());
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBlockageGeom());
    }

    public IGeom getBlockageGeom() {
        int options = 1;
        return this.getGeom(options);
    }

    @Override
    public void getInfernoGeom(List<InfernoGeom> geoms) {
        geoms.add(new InfernoGeom(this, InfernoType.REMOVABLE, this.getBlockageGeom()));
    }

    protected IGeom getGeom(int options) {
        if (this.d_room == null) {
            return EmptyGeom.INSTANCE;
        }
        Model model = this.d_room.getModel();
        Predicate<Face> faceFilter = new Predicate<Face>(){

            @Override
            public boolean test(Face o) {
                return o.partOfGroup(EgressBlockage.this.d_faceId);
            }
        };
        Predicate<Edge> edgeFilter = new Predicate<Edge>(){

            @Override
            public boolean test(Edge o) {
                if (o.partOfGroup(1)) {
                    return false;
                }
                int fCount = 0;
                for (Face face : o.faces) {
                    if (!face.partOfGroup(EgressBlockage.this.d_faceId)) continue;
                    ++fCount;
                }
                return fCount == 1;
            }
        };
        return new EgressModelGeom(model, this.d_room.getInUseEdgeFilter(), faceFilter, edgeFilter, options);
    }
}

